package com.digiwin.mobile.mobileuibot.portal.model;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.ApplicationColumnReq;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.MobilePortalInfoContentResp;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 门户信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ApiRequsetPortal extends ApiRequest {

    /**
     * 用户最新选择的移动门户类型（0：V1门户、1：新门户）
     */
    private Integer portalType;


    /**
     *  页面类型（0：门户布局；1：自定义页面布局）
     */
    private Integer pageType;


    /**
     * 用户保存的金刚区
     */
    private MobilePortalInfoContentResp mobilePortalInfoContentResp;


    /**
     * 自定义应用栏目
     */
    private ApplicationColumnReq applicationColumnReq;


    /**
     * 自定义栏目id
     */
    private List<Long> columnIds;

    /**
     * 应用主键id
     */
    private String applicationPrimaryId;

    /**
     * 自定义应用id
     */
    private String customApplicationId;

    /**
     * 待获取全部路径的url
     */
    private String callBackUrl;

    /**
     * 自定义应用id列表
     */
    private List<Long> customApplicationIdList;

    /**
     * 是否需要查询全部的数据，true：查询所有分类，false：需要根据用户已选的分类过滤
     */
    private Boolean isAll;
}
