package com.digiwin.mobile.mobileuibot.portal.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.model.UsePortalTypeResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;

import java.util.List;
import java.util.Map;

public interface PortalService {

    /**
     * 预览门户获得相应的actio
     * @param apiRequest
     * @param conditon
     * @return
     */
    Action buildQrCodePrePortalAction(ApiRequest apiRequest, Map<String, Object> conditon);


    /**
     * 查询用户移动门户列表
     * @param apiRequsetPortal
     * @return
     */
    List<MobilePortalInfoItemResp> selectUserPortal(ApiRequsetPortal apiRequsetPortal);

    /**
     * 查询用户选择门户类型接口
     * @param apiRequsetPortal
     * @return
     */
    UsePortalTypeResp getUserPortalType(ApiRequsetPortal apiRequsetPortal);

    /**
     * 记录用户选择门户类型接口
     * @param apiRequsetPortal
     * @return
     */
    Boolean addPortalType(ApiRequsetPortal apiRequsetPortal);

    /**
     * 记录门户使用
     * @param apiRequsetPortal
     */
    Boolean addUserRecord(ApiRequsetPortal apiRequsetPortal);

    /**
     * 检查是否拥有权限
     * @param apiRequsetPortal
     * @return
     */
    JSONObject check(ApiRequsetPortal apiRequsetPortal);

//    /**
//     * 校验自定义金刚区保存参数
//     * @param contentResp
//     * @return
//     */
//    String checkParam(MobilePortalInfoContentResp contentResp);

    /**
     * 保存自定义金刚区
     * @param mobilePortalId
     * @param contentResp
     * @param apiRequsetPortal
     */
    JSONObject saveCustomDistrict(Long mobilePortalId, MobilePortalInfoContentResp contentResp, ApiRequsetPortal apiRequsetPortal);

    /**
     * 查询自定义金刚区
     * @param mobilePortalId
     * @param contentId
     * @return
     */
    MobilePortalInfoContentResp getCustomDistrict(Long mobilePortalId, Long contentId,ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义分类应用
     * @param apiRequsetPortal
     * @return
     */
    List<MobileClassificatonResp> getClassificationList(ApiRequsetPortal apiRequsetPortal);

    /**
     * 保存自定义栏目
     * @param apiRequsetPortal
     */
    JSONObject saveApplicationColumn(ApiRequsetPortal apiRequsetPortal);

    /**
     * 保存自定义栏目  默认门户
     * @param apiRequsetPortal
     */
    JSONObject saveApplicationColumnNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义栏目
     * @param apiRequsetPortal
     * @return
     */
    List<ApplicationColumnReq> getApplicationColumnList(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义栏目  默认门户
     * @param apiRequsetPortal
     * @return
     */
    List<ApplicationColumnReq> getApplicationColumnListNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义应用栏目详细信息
     * @param apiRequsetPortal
     * @return
     */
    MobileAppColumnResp getApplicationColumnDetail(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取自定义应用栏目详细信息 -- 默认门户
     * @param apiRequsetPortal
     * @return
     */
    MobileAppColumnResp getApplicationColumnDetailNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 设置栏目的顺序
     * @param apiRequsetPortal
     */
    JSONObject setColumnOrder(ApiRequsetPortal apiRequsetPortal);

    /**
     * 设置栏目的顺序 -- 默认门户
     * @param apiRequsetPortal
     */
    JSONObject setColumnOrderNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 删除栏目
     * @param apiRequsetPortal
     */
    JSONObject delColumn(ApiRequsetPortal apiRequsetPortal);

    /**
     * 删除栏目 -- 默认门户
     * @param apiRequsetPortal
     */
    JSONObject delColumnNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 更新栏目状态
     * @param apiRequsetPortal
     */
    JSONObject updateColumnStatus(ApiRequsetPortal apiRequsetPortal);

    /**
     * 更新栏目状态 -- 默认门户
     * @param apiRequsetPortal
     */
    JSONObject updateColumnStatusNew(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取拼接完全部的SSO路径
     * @param apiRequsetPortal
     * @return
     */
    MobileFullBackResp getFullCallBackUrl(ApiRequsetPortal apiRequsetPortal);

    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param apiRequsetPortal 请求参数
     * @return 返回
     */
    List<ValidMobileAppAuthResp> validUserAppAuth(ApiRequsetPortal apiRequsetPortal);

    /**
     * 获取作业池  默认门户
     * @return
     */
    List<AppResp> getClassificationListNew(ApiRequest apiRequest);

    List<AppResp> getReportList(ApiRequest apiRequest);

    List<AppResp> getLaunchableProjectList(ApiRequest apiRequest);
}
