package com.digiwin.mobile.mobileuibot.portal.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.module.AppModuleCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.UiBotModelBuildDashboardV2Strategy;
import com.digiwin.mobile.mobileuibot.dashboard.service.DashBoardService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.portal.model.UsePortalTypeResp;
import com.digiwin.mobile.mobileuibot.portal.service.PortalService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserAuthResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.recommend.rule.RecommendRuleService;
import com.digiwin.mobile.mobileuibot.recommend.rule.params.PurchasedGoodsEnableModule;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service("potalService")
public class PortalServiceImpl implements PortalService {
    //预览
    private final  String PREVIEW_RENDER_PAGE = "INDEX_PORTAL";

    @Autowired
    private DigiwinSemcProxyService semcProxyService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private DigiwinAudcProxyService audcProxyService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;

    @Autowired
    private RecommendRuleService recommendRuleService;

    @Autowired
    private DashBoardService dashBoardService;

    @Autowired
    private UiBotModelBuildDashboardV2Strategy uiBotModelBuildDashboardV2Strategy;

    /**
     * 生成预览的aciton
     * @param apiRequest
     * @param conditon
     * @return
     */
    @Override
    public Action buildQrCodePrePortalAction(ApiRequest apiRequest, Map<String, Object> conditon) {
        Action<Object> result = new Action<>();
        result.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        Map<String,Object> map = new HashMap<>();
        result.setRawData(map);
        if(!conditon.containsKey("d")||ObjectUtils.isEmpty(conditon.get("d")))
        {
            return result;
        }
       Map<String,Object> data =  JSONObject.parseObject(JsonUtil.javaObjectToJsonString(conditon.get("d")));
        if(!data.containsKey("id")||ObjectUtils.isEmpty(data.get("id")))
        {
            return result;
        }
        Long id = MapUtils.getLong(data,"id",null);
        result.setJumpPageId(PREVIEW_RENDER_PAGE);
        map.put("id",id);
        MobilePortalPreview previewPortal = semcProxyService.getPreviewPortal(apiRequest, id);
        map.put("portalTypeSource",previewPortal.getPortalTypeSource());
        map.put("versionDefault",previewPortal.getVersionDefault());
        //1：扫码
        map.put("scene",1);
        //"pageType": 1,//预览页面类型（新增字段） 0或空-预览门户 1-预览二级页
        Integer pageType = MapUtils.getInteger(data,"pageType",0);
        map.put("pageType",pageType);
        result.setRawData(map);
        return result;
    }

    @Override
    public List<MobilePortalInfoItemResp> selectUserPortal(ApiRequsetPortal apiRequsetPortal) {
        List<MobilePortalInfoItemResp> respList = new ArrayList<>();
        List<MobilePortalInfoItemResp> mobilePortalInfoItemResps = semcProxyService.selectUserPortal(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken());
        if(!CollectionUtils.isEmpty(mobilePortalInfoItemResps)){
            respList =mobilePortalInfoItemResps;
            respList.forEach(x->x.setName(localeService.getLanguageValue(apiRequsetPortal.getLocale(),x.getName())));
        }
        respList.forEach(x -> x.setVersionDefault(1));
        return respList;
    }

    @Override
    public UsePortalTypeResp getUserPortalType(ApiRequsetPortal apiRequsetPortal) {
        UsePortalTypeResp result = new UsePortalTypeResp();
        UsePortalTypeResp  usePortalTypeResp  = semcProxyService.getUserPortalType(apiRequsetPortal.getLocale(), apiRequsetPortal.getIamUserToken());
        if(!ObjectUtils.isEmpty(usePortalTypeResp))
        {
            result = usePortalTypeResp;
        }

        return result;
    }

    @Override
    public Boolean addPortalType(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.addPortalType(apiRequsetPortal.getLocale(),
                apiRequsetPortal.getIamUserToken(),apiRequsetPortal.getPortalType(),apiRequsetPortal.getDataId());
    }

    @Override
    public Boolean addUserRecord(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.addUserRecord(apiRequsetPortal.getLocale(),
                apiRequsetPortal.getIamUserToken(),apiRequsetPortal.getDataId());
    }

    @Override
    public JSONObject check(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.checkPortalInfo(apiRequsetPortal.getLocale(),apiRequsetPortal.getIamUserToken(),
                apiRequsetPortal.getDataId(),apiRequsetPortal.getPageType());
    }

//    @Override
//    public String checkParam(MobilePortalInfoContentResp contentResp) {
//        String error ="";
//        if(ObjectUtils.isEmpty(contentResp.getContentId())){
//           return error = "组件id必须传入";
//        }
//        if(!PortalConstans.PreComponentEnum.PRE_HONG_KIND_DISTRIC.getValue().equals(contentResp.getContentType()) ||
//           !PortalConstans.DistrictCustomTypeEnum.USER_TYPE.getValue().equals(contentResp.getCustomType()) ){
//           return error ="只可编辑自定义金刚区";
//        }
//        List<MobileBallResp> ballList = contentResp.getBallList();
//        if(CollectionUtils.isEmpty(ballList)){
//            return error ="自定义应用不可为空";
//        }
//        for (MobileBallResp ballResp : ballList) {
//            if(!StringUtils.hasText(ballResp.getBallName()))
//            {
//                return error = "应用名称不可为空";
//            }
//            if(!PortalConstans.JumpTypeEnum.SSO_CONFIGURATION.getValue().equals(ballResp.getJumpType())){
//                return error = "只可配置自定义应用";
//            }
//            if(!StringUtils.hasText(ballResp.getJumpTarget())){
//                return error = "请配置跳转路径";
//            }
//            if(ObjectUtils.isEmpty(ballResp.getCustomApplicationId())){
//                return error = "自定义应用id不能为空";
//            }
//            if(ObjectUtils.isEmpty(ballResp.getContentIcon())){
//                return error = "自定义icon不能为空";
//            }
//        }
//        return error;
//    }

    @Override
    public JSONObject saveCustomDistrict(Long mobilePortalId, MobilePortalInfoContentResp contentResp, ApiRequsetPortal apiRequsetPortal) {
       return semcProxyService.saveCustomDistrict(mobilePortalId,contentResp,apiRequsetPortal);
    }

    @Override
    public MobilePortalInfoContentResp getCustomDistrict(Long mobilePortalId, Long contentId, ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.getCustomDistrict(mobilePortalId,contentId,apiRequsetPortal);
    }

    @Override
    public List<MobileClassificatonResp> getClassificationList(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.getClassificationList(apiRequsetPortal);
    }

    @Override
    public JSONObject saveApplicationColumn(ApiRequsetPortal apiRequsetPortal) {
       return semcProxyService.saveApplicationColumn(apiRequsetPortal);
    }

    @Override
    public JSONObject saveApplicationColumnNew(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.saveApplicationColumnNew(apiRequsetPortal);
    }

    @Override
    public List<ApplicationColumnReq> getApplicationColumnList(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.getApplicationColumnList(apiRequsetPortal);
    }

    @Override
    public List<ApplicationColumnReq> getApplicationColumnListNew(ApiRequsetPortal apiRequsetPortal){
        // 从入口来源数据（查询已经加到栏目的数据）
        List<ApplicationColumnReq> list = semcProxyService.getApplicationColumnListNew(apiRequsetPortal);
        if (CollectionUtils.isEmpty(list)){
            return Collections.emptyList();
        }
        //请求semc接口获取移动应用作业信息
        apiRequsetPortal.setIsAll(true);
        List<MobileClassificatonResp> classificatonRespList = semcProxyService.getClassificationList(apiRequsetPortal);
        List<Long> semcList = new ArrayList();
        Map<String,MobileDatasourceInfoResp> mapSemc = new HashMap();
        if (!CollectionUtils.isEmpty(classificatonRespList)){
            for (MobileClassificatonResp mobileClassificatonResp : classificatonRespList){
                List<MobileDatasourceInfoResp> mobileCustomAppList = mobileClassificatonResp.getMobileCustomAppList();
                if (!CollectionUtils.isEmpty(mobileCustomAppList)){
                    List<Long> longStream = mobileCustomAppList.stream().map(e -> e.getId()).collect(Collectors.toList());
                    semcList.addAll(longStream);
                    for (MobileDatasourceInfoResp mobileDatasourceInfoResp : mobileCustomAppList){
                        mapSemc.put(String.valueOf(mobileDatasourceInfoResp.getId()),mobileDatasourceInfoResp);
                    }
                }
            }
        }
        List<String> semcStringList = new ArrayList<>();
        for (Long id : semcList){
            semcStringList.add(String.valueOf(id));
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map next = iterator.next();
                Integer source = MapUtils.getInteger(next,"source",null);
                if (source == 0){
                    if(!semcStringList.contains(MapUtils.getString(next,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }

        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 0){
                    MobileDatasourceInfoResp mobileDatasourceInfoResp = mapSemc.get(MapUtils.getString(map,"id",null));
                    map.put("icon",mobileDatasourceInfoResp.getIcon());
                    map.put("name",mobileDatasourceInfoResp.getName());
                    map.put("moduleId",String.valueOf(mobileDatasourceInfoResp.getClassificationId()));
                }
            }
        }

        //报表区域
        List<AppResp> appRespList = getReportList(apiRequsetPortal);
        List<String> collect = new ArrayList<>();
        for (AppResp appResp : appRespList){
            List collectnew = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(collectnew)){
                collect.addAll(collectnew);
            }
        }
        Map<String,AppRespSampl> mapReport = new HashMap();
        for (AppResp appResp : appRespList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapReport.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 1){
                    if(!collect.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 1){
                    Set<String> strings = mapReport.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon",mapReport.get(code).getIcon());
                            map.put("name",mapReport.get(code).getName());
                            map.put("moduleId",String.valueOf(mapReport.get(code).getModuleId()));
                        }
                    }
                }
            }
        }
        //  手动发起项目
        List<AppResp> projectList = getLaunchableProjectList(apiRequsetPortal);
        List<String> projectIds = new ArrayList<>();
        for (AppResp appResp : projectList){
            List projectIdsnew = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(projectIdsnew)){
                projectIds.addAll(projectIdsnew);
            }
        }
        Map<String,AppRespSampl> mapProject = new HashMap();
        for (AppResp appResp : projectList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapProject.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 2){
                    if(!projectIds.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 2){
                    Set<String> strings = mapProject.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapProject.get(code).getIcon());
                            map.put("name", mapProject.get(code).getName());
                            map.put("moduleId", mapProject.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //数据录入
        List<AppResp> dataList = getDataEntryList(apiRequsetPortal);
        List<String> dataIds = new ArrayList<>();
        for (AppResp appResp : dataList){
            List dataIdList = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dataIdList)){
                dataIds.addAll(dataIdList);
            }
        }
        Map<String,AppRespSampl> mapData = new HashMap();
        for (AppResp appResp : dataList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapData.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 3){
                    if(!dataIds.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 3){
                    Set<String> strings = mapData.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapData.get(code).getIcon());
                            map.put("name", mapData.get(code).getName());
                            map.put("moduleId", mapData.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //移动配置的作业
        boolean hasReportModule = false;
        if (!CollectionUtils.isEmpty(appRespList)){
            hasReportModule = true;
        }
        List<AppResp> mobileConfigList =  getIntelligentEnterAppList(apiRequsetPortal,hasReportModule);
        List<String> ids = new ArrayList<>();
        for (AppResp appResp : mobileConfigList){
            List idsnew  = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(idsnew)){
                ids.addAll(idsnew);
            }
        }
        Map<String,AppRespSampl> mapMobileConfig = new HashMap();
        for (AppResp appResp : mobileConfigList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapMobileConfig.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 4){
                    if(!ids.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 4){
                    Set<String> strings = mapMobileConfig.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapMobileConfig.get(code).getIcon());
                            map.put("name", mapMobileConfig.get(code).getName());
                            map.put("moduleId", mapMobileConfig.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //绿色智机
        List<AppResp> smartMapList = getSmartMachine(apiRequsetPortal);
        List<String> idlvse = new ArrayList<>();
        for (AppResp appResp : smartMapList){
            List idlvsenew = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(idlvsenew)){
                idlvse.addAll(idlvsenew);
            }
        }
        Map<String,AppRespSampl> mapSmart = new HashMap();
        for (AppResp appResp : smartMapList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapSmart.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 5){
                    if(!idlvse.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 5){
                    Set<String> strings = mapSmart.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapSmart.get(code).getIcon());
                            map.put("name", mapSmart.get(code).getName());
                            map.put("moduleId", mapSmart.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        return list;
    }

    @Override
    public MobileAppColumnResp getApplicationColumnDetail(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.getApplicationColumnDetail(apiRequsetPortal);
    }

    @Override
    public MobileAppColumnResp getApplicationColumnDetailNew(ApiRequsetPortal apiRequsetPortal) {
        List<ApplicationColumnReq> listExist = semcProxyService.getApplicationColumnListNew(apiRequsetPortal);
        List<ApplicationColumnReq> collectExist = listExist.stream().filter(e -> e.getId().equals(apiRequsetPortal.getApplicationColumnReq().getId())).collect(Collectors.toList());
        ApplicationColumnReq applicationColumnReqEixst = collectExist.get(0);
        List<ApplicationColumnReq> listNew = new ArrayList<>();
        listNew.add(applicationColumnReqEixst);
        //请求semc接口获取移动应用作业信息
        //请求semc接口获取移动应用作业信息
        apiRequsetPortal.setIsAll(true);
        List<MobileClassificatonResp> classificatonRespList = semcProxyService.getClassificationList(apiRequsetPortal);
        List<Long> semcList = new ArrayList();
        Map<String,MobileDatasourceInfoResp> mapSemc = new HashMap();
        if (!CollectionUtils.isEmpty(classificatonRespList)){
            for (MobileClassificatonResp mobileClassificatonResp : classificatonRespList){
                List<MobileDatasourceInfoResp> mobileCustomAppList = mobileClassificatonResp.getMobileCustomAppList();
                if (!CollectionUtils.isEmpty(mobileCustomAppList)){
                    List<Long> longStream = mobileCustomAppList.stream().map(e -> e.getId()).collect(Collectors.toList());
                    semcList.addAll(longStream);
                    for (MobileDatasourceInfoResp mobileDatasourceInfoResp : mobileCustomAppList){
                        mapSemc.put(String.valueOf(mobileDatasourceInfoResp.getId()),mobileDatasourceInfoResp);
                    }
                }
            }
        }
        List<String> semcStringList = new ArrayList<>();
        for (Long id : semcList){
            semcStringList.add(String.valueOf(id));
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                //Integer source = MapUtils.getInteger(iterator.next(),"source",null);
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 0){
                    if(!semcStringList.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }

        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 0){
                    MobileDatasourceInfoResp mobileDatasourceInfoResp = mapSemc.get(MapUtils.getString(map,"id",null));
                    map.put("icon",mobileDatasourceInfoResp.getIcon());
                    map.put("name",mobileDatasourceInfoResp.getName());
                    map.put("moduleId",String.valueOf(mobileDatasourceInfoResp.getClassificationId()));
                }
            }
        }

        //报表区域
        List<AppResp> appRespList = getReportList(apiRequsetPortal);
        List<String> collect = new ArrayList<>();
        for (AppResp appResp : appRespList){
            List collectnew = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(collectnew)){
                collect.addAll(collectnew);
            }
        }
        Map<String,AppRespSampl> mapReport = new HashMap();
        for (AppResp appResp : appRespList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapReport.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 1){
                    if(!collect.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 1){
                    Set<String> strings = mapReport.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapReport.get(code).getIcon());
                            map.put("name", mapReport.get(code).getName());
                            map.put("moduleId", mapReport.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //  手动发起项目
        List<AppResp> projectList = getLaunchableProjectList(apiRequsetPortal);
        List<String> projectIds = new ArrayList<>();
        for (AppResp appResp : projectList){
            List projectIdss = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(projectIdss)){
                projectIds.addAll(projectIdss);
            }
        }
        Map<String,AppRespSampl> mapProject = new HashMap();
        for (AppResp appResp : projectList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapProject.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 2){
                    if(!projectIds.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 2){
                    Set<String> strings = mapProject.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapProject.get(code).getIcon());
                            map.put("name", mapProject.get(code).getName());
                            map.put("moduleId", mapProject.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //数据录入
        List<AppResp> dataList = getDataEntryList(apiRequsetPortal);
        List<String> dataIds = new ArrayList<>();
        for (AppResp appResp : dataList){
            List dataIdList = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(dataIdList)){
                dataIds.addAll(dataIdList);
            }
        }
        Map<String,AppRespSampl> mapData = new HashMap();
        for (AppResp appResp : dataList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapData.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 3){
                    if(!dataIds.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 3){
                    Set<String> strings = mapData.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapData.get(code).getIcon());
                            map.put("name", mapData.get(code).getName());
                            map.put("moduleId", mapData.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //移动配置的作业
        boolean hasReportModule = false;
        if (!CollectionUtils.isEmpty(appRespList)){
            hasReportModule = true;
        }
        List<AppResp> mobileConfigList =  getIntelligentEnterAppList(apiRequsetPortal,hasReportModule);
        List<String> ids = new ArrayList<>();
        for (AppResp appResp : mobileConfigList){
            List yidong  = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(yidong)){
                ids.addAll(yidong);
            }
        }
        Map<String,AppRespSampl> mapMobileConfig = new HashMap();
        for (AppResp appResp : mobileConfigList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapMobileConfig.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 4){
                    if(!ids.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 4){
                    Set<String> strings = mapMobileConfig.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapMobileConfig.get(code).getIcon());
                            map.put("name", mapMobileConfig.get(code).getName());
                            map.put("moduleId", mapMobileConfig.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        //绿色智机
        List<AppResp> smartMapList = getSmartMachine(apiRequsetPortal);
        List<String> idlvse = new ArrayList<>();
        for (AppResp appResp : smartMapList){
            List mms = appResp.getAppRespSamplList().stream().map(e -> e.getId()).collect(Collectors.toList());
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(mms)){
                idlvse.addAll(mms);
            }
        }
        Map<String,AppRespSampl> mapSmart = new HashMap();
        for (AppResp appResp : smartMapList){
            for (AppRespSampl appRespSampl : appResp.getAppRespSamplList()){
                mapSmart.put(appRespSampl.getId(),appRespSampl);
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> customApplication = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = customApplication.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 5){
                    if(!idlvse.contains(MapUtils.getString(map,"id",null))){
                        iterator.remove();
                    }
                }
            }
        }
        for (ApplicationColumnReq applicationColumnReq : listNew){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map map = iterator.next();
                Integer source = MapUtils.getInteger(map,"source",null);
                if (source == 5){
                    Set<String> strings = mapSmart.keySet();
                    for (String code : strings) {
                        if (code.equals(MapUtils.getString(map,"id",null))) {
                            map.put("icon", mapSmart.get(code).getIcon());
                            map.put("name", mapSmart.get(code).getName());
                            map.put("moduleId", mapSmart.get(code).getModuleId());
                        }
                    }
                }
            }
        }
        MobileAppColumnResp mobileAppColumnResp = new MobileAppColumnResp();
        ApplicationColumnReq applicationColumnReq = listNew.get(0);
        mobileAppColumnResp.setId(applicationColumnReq.getId());
        mobileAppColumnResp.setIsNameShow(applicationColumnReq.getIsNameShow());
        mobileAppColumnResp.setOrderId(applicationColumnReq.getOrderId());
        mobileAppColumnResp.setName(applicationColumnReq.getName());
        mobileAppColumnResp.setCustomApplicationId(applicationColumnReq.getCustomApplicationId());
        mobileAppColumnResp.setParentId(applicationColumnReq.getParentId());
        mobileAppColumnResp.setStatus(applicationColumnReq.getStatus());
        mobileAppColumnResp.setTenantId(applicationColumnReq.getTenantId());
        mobileAppColumnResp.setIdAndSources(applicationColumnReq.getIdAndSources());
        return mobileAppColumnResp;
    }

    @Override
    public JSONObject setColumnOrder(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.setColumnOrder(apiRequsetPortal);
    }

    @Override
    public JSONObject setColumnOrderNew(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.setColumnOrderNew(apiRequsetPortal);
    }

    @Override
    public JSONObject delColumn(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.delColumn(apiRequsetPortal);
    }

    @Override
    public JSONObject delColumnNew(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.delColumnNew(apiRequsetPortal);
    }

    @Override
    public JSONObject updateColumnStatus(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.updateColumnStatus(apiRequsetPortal);
    }

    @Override
    public JSONObject updateColumnStatusNew(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.updateColumnStatusNew(apiRequsetPortal);
    }

    @Override
    public MobileFullBackResp getFullCallBackUrl(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.getFullCallBackUrl(apiRequsetPortal);
    }

    /**
     * 校验当前用户是否有自定义应用的权限
     *
     * @param apiRequsetPortal 请求参数
     * @return 返回
     */
    @Override
    public List<ValidMobileAppAuthResp> validUserAppAuth(ApiRequsetPortal apiRequsetPortal) {
        return semcProxyService.validUserAppAuth(apiRequsetPortal);
    }

    /**
     * 0:移动自定义作业 1：数智驱动应用的作业 2：移动配置的作业 3：工业互联的作业
     * @param apiRequest
     * @return
     */
    @Override
    public List<AppResp> getClassificationListNew(ApiRequest apiRequest) {
        //请求semc接口获取移动应用作业信息
        ApiRequsetPortal apiRequsetPortal = new ApiRequsetPortal();
        apiRequsetPortal.setIsAll(true);
        apiRequsetPortal.setLocale(apiRequest.getLocale());
        apiRequsetPortal.setIamUserToken(apiRequest.getIamUserToken());
        List<AppResp> classificationListSemc = getClassificationListSemc(apiRequsetPortal);
        // 查询报表
        List<AppResp> reportList = getReportList(apiRequest);
        boolean hasReportModule = false;
        if (!CollectionUtils.isEmpty(reportList)){
            hasReportModule = true;
        }
        //  手动发起项目
        List<AppResp> projectList = getLaunchableProjectList(apiRequest);
        //数据录入
        List<AppResp> dataEntryList = getDataEntryList(apiRequest);
        //移动配置的作业
        List<AppResp> mobileList = getIntelligentEnterAppList(apiRequest,hasReportModule);
        //绿色智机
        List<AppResp> smartList = getSmartMachine(apiRequest);
        if (!CollectionUtils.isEmpty(reportList)) {
            classificationListSemc.addAll(reportList);
        }
        if (!CollectionUtils.isEmpty(projectList)) {
            classificationListSemc.addAll(projectList);
        }
        if (!CollectionUtils.isEmpty(dataEntryList)) {
            classificationListSemc.addAll(dataEntryList);
        }
        if (!CollectionUtils.isEmpty(mobileList)) {
            classificationListSemc.addAll(mobileList);
        }
        if (!CollectionUtils.isEmpty(smartList)) {
            classificationListSemc.addAll(smartList);
        }
        // 从入口来源数据（查询已经加到栏目的数据）
        List<ApplicationColumnReq> list = semcProxyService.getApplicationColumnListNew(apiRequsetPortal);
        for (ApplicationColumnReq applicationColumnReq : list){
            List<Map> idAndSources = applicationColumnReq.getIdAndSources();
            Iterator<Map> iterator = idAndSources.iterator();
            while (iterator.hasNext()){
                Map next = iterator.next();
                Integer source = MapUtils.getInteger(next, "source", null);
                String moduleId = MapUtils.getString(next, "moduleId", null);
                String id = MapUtils.getString(next, "id", null);
                for (AppResp appResp : classificationListSemc){
                    List<AppRespSampl> appRespSamplList = appResp.getAppRespSamplList();
                    Iterator<AppRespSampl> iterator1 = appRespSamplList.iterator();
                    while (iterator1.hasNext()){
                        AppRespSampl next1 = iterator1.next();
                        if (Objects.equals(source,next1.getSource()) && Objects.equals(moduleId,next1.getModuleId()) && Objects.equals(id,next1.getId())){
                            //iterator1.remove();
                            next1.setIsAdd(1);
                        }
                    }
                }
            }
        }
        Iterator<AppResp> iterator = classificationListSemc.iterator();
        while (iterator.hasNext()){
            AppResp next = iterator.next();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(next.getAppRespSamplList())){
                iterator.remove();
            }
        }
        return classificationListSemc;
    }

    @Override
    public List<AppResp> getLaunchableProjectList(ApiRequest apiRequest) {
        List<AppModuleItem> startProjectAppModuleItemList = this.getStartProjectAppModuleItemList(apiRequest);
        List<AppResp> lis = new ArrayList();
        if (CollectionUtils.isEmpty(startProjectAppModuleItemList)){
            return Collections.emptyList();
        }
        List<AppRespSampl> appRespSamplList = new ArrayList<>();
        AppResp appResp = new AppResp();
        appResp.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.START_PROJECT.getName()));
        appResp.setModuleId(AppModuleCodeEnum.START_PROJECT.getCode());
        for (AppModuleItem appModuleItem : startProjectAppModuleItemList){
            AppRespSampl appRespSampl = new AppRespSampl();
            appRespSampl.setId(appModuleItem.getId());
            appRespSampl.setIcon(null);
            appRespSampl.setSource(2);
            appRespSampl.setName(appModuleItem.getName());
            appRespSampl.setModuleId(AppModuleCodeEnum.START_PROJECT.getCode());
            appRespSamplList.add(appRespSampl);
            appResp.setAppRespSamplList(appRespSamplList);
        }
        lis.add(appResp);
        return lis;
    }

    private List<AppResp> getClassificationListSemc(ApiRequsetPortal apiRequsetPortal) {
        List<MobileClassificatonResp> classificatonRespList = semcProxyService.getClassificationList(apiRequsetPortal);
        List<AppResp> lis = new ArrayList();
        if (CollectionUtils.isEmpty(classificatonRespList)) {
            return Collections.emptyList();
        }else {
            for (MobileClassificatonResp classificatonResp : classificatonRespList) {
                //如果分类下作业为空，则不组装
                if (CollectionUtils.isEmpty(classificatonResp.getMobileCustomAppList())) {
                    continue;
                }
                List<AppRespSampl> appRespSamplList = new ArrayList<>();
                for (MobileDatasourceInfoResp customApp : classificatonResp.getMobileCustomAppList()) {
                    Long id = customApp.getId();
                    String icon = customApp.getIcon();
                    String name = customApp.getName();
                    AppRespSampl appRespSampl = new AppRespSampl();
                    appRespSampl.setId(String.valueOf(id));
                    appRespSampl.setIcon(icon);
                    appRespSampl.setName(name);
                    appRespSampl.setModuleId(String.valueOf(classificatonResp.getId()));
                    appRespSampl.setSource(0);
                    appRespSamplList.add(appRespSampl);
                }
                AppResp appResp = new AppResp();
                appResp.setTitle(classificatonResp.getClassificationName());
                appResp.setModuleId(String.valueOf(classificatonResp.getId()));
                appResp.setAppRespSamplList(appRespSamplList);
                lis.add(appResp);
            }
        }
        return lis;
    }
    @Override
    public List<AppResp> getReportList(ApiRequest apiRequest) {
        List<AppResp> appRespList = new ArrayList<>();
        //拿到所有报表
        List<DigiwinAtmcTmData> tmDataList = audcProxyService.getTmDataList(apiRequest.getClientId(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());

        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            AppResp appResp = new AppResp();
            appResp.setTitle(digiwinAtmcTmData.getAppName());
            appResp.setModuleId(digiwinAtmcTmData.getAppCode());
            if (!CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
                List<AppRespSampl> appRespSamplList = new ArrayList<>();
                for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                    AppositionData appositionData = new AppositionData();
                    if (dataReport.isAllow()) {
                        appositionData.setComponentType(Button.COMPONENT_TYPE);
                        //M2需求-过滤ABI报表
                        //if (ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) {
                        //    appositionData.setData(BottomButtonDigiwinAthena.createABIReportButton(
                        //            dataReport.getName(), dataReport, dataReport.getCode()));
                        //} else
                        if (ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) {
                            AppRespSampl appRespSampl = new AppRespSampl();
                            appRespSampl.setId(Optional.ofNullable(dataReport.getResCode()).filter(StrUtil::isNotEmpty).orElse(dataReport.getCode()));
                            appRespSampl.setIcon(null);
                            appRespSampl.setName(dataReport.getName());
                            appRespSampl.setModuleId(digiwinAtmcTmData.getAppCode());
                            appRespSampl.setSource(1);
                            appRespSampl.setCategory(dataReport.getCategory());
                            appRespSamplList.add(appRespSampl);
                            }
                        } else {
                            continue;
                        }
                }
                appResp.setAppRespSamplList(appRespSamplList);
            }
            appRespList.add(appResp);
        }
        return appRespList;
    }

    private List<AppResp> getSmartMachine(ApiRequest apiRequest) {
        List<AppResp> lis = new ArrayList<>();
        //查询用户模组作业
        List<TopicPresetResp> topicPresetRespList = semcProxyService.queryAllJob(new ArrayList<>(), apiRequest.getLocale(), apiRequest.getIamUserToken());
        if (CollectionUtils.isEmpty(topicPresetRespList)) {
            return Collections.emptyList();
        }
        for (TopicPresetResp topicPresetResp : topicPresetRespList){
            AppResp appResp = new AppResp();
            appResp.setTitle(topicPresetResp.getModuleName());
            appResp.setModuleId(topicPresetResp.getModuleId());
            List<AppRespSampl> appRespSamplList = new ArrayList<>();
            for (TopicPresetJobResp topicPresetJobResp : topicPresetResp.getTopicpList()){
                AppRespSampl appRespSampl = new AppRespSampl();
                appRespSampl.setModuleId(topicPresetResp.getModuleId());
                appRespSampl.setName(topicPresetJobResp.getTopicPresetName());
                appRespSampl.setSource(5);
                appRespSampl.setIcon(topicPresetJobResp.getTopicPresetIcon());
                appRespSampl.setId(topicPresetJobResp.getCaseId());
                appRespSamplList.add(appRespSampl);
            }
            appResp.setAppRespSamplList(appRespSamplList);
            lis.add(appResp);
        }
        return lis;
    }

    private List<AppResp> getDataEntryList(ApiRequest apiRequest) {
        List<AppResp> lis = new ArrayList();
        List<DigiwinAtmcTmData> basicDataList =
                audcProxyService.getBasicDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty(basicDataList)) {
            return Collections.emptyList();
        }
        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        // 获取type为数据录入的数据
        List<String> tmActivityIdList = activityFilterService
                .findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), apiRequest.getTenantId(), tenantVersion)
                .stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tmActivityIdList)) {
            return Collections.emptyList();
        }
        for (DigiwinAtmcTmData digiwinAtmcTmData : basicDataList){
            AppResp appResp = new AppResp();
            List<AppRespSampl> appRespSamplList = new ArrayList<>();
            appResp.setTitle(digiwinAtmcTmData.getAppName());
            appResp.setModuleId(digiwinAtmcTmData.getAppCode());
            for (DigiwinAtmcTmDataReport digiwinAtmcTmDataReport : digiwinAtmcTmData.getBaseItemDtoList()){
                AppRespSampl appRespSampl = new AppRespSampl();
                if (digiwinAtmcTmDataReport.isAllow() && tmActivityIdList.contains(digiwinAtmcTmDataReport.getCode())){
                    appRespSampl.setModuleId(digiwinAtmcTmData.getAppCode());
                    appRespSampl.setName(digiwinAtmcTmDataReport.getName());
                    appRespSampl.setSource(3);
                    appRespSampl.setIcon(digiwinAtmcTmDataReport.getIcon());
                    appRespSampl.setId(digiwinAtmcTmDataReport.getCode());
                    appRespSamplList.add(appRespSampl);
                }
            }
            appResp.setAppRespSamplList(appRespSamplList);
            lis.add(appResp);
        }
        return lis;
    }

    /**
     * 获取移动配置的作业
     */
    private List<AppResp> getIntelligentEnterAppList(ApiRequest apiRequest,boolean hasReportModule) {
        List<AppModuleItem> intelligentEnterAppModuleItemList = uiBotModelBuildDashboardV2Strategy.getIntelligentEnterAppModuleItemList(apiRequest, hasReportModule);


        List<AppResp> lis = new ArrayList();
        if (CollectionUtils.isEmpty(intelligentEnterAppModuleItemList)){
            return Collections.emptyList();
        }
        List<AppRespSampl> appRespSamplList = new ArrayList<>();
        AppResp appResp = new AppResp();
        appResp.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.INTELLIGENT_ENTER.getName()));
        appResp.setModuleId(AppModuleCodeEnum.INTELLIGENT_ENTER.getCode());
        for (AppModuleItem appModuleItem : intelligentEnterAppModuleItemList){
            AppRespSampl appRespSampl = new AppRespSampl();
            appRespSampl.setId(appModuleItem.getId());
            appRespSampl.setIcon(appModuleItem.getImageUrl());
            appRespSampl.setSource(4);
            appRespSampl.setName(appModuleItem.getName());
            appRespSampl.setModuleId(AppModuleCodeEnum.INTELLIGENT_ENTER.getCode());
            appRespSamplList.add(appRespSampl);
            appResp.setAppRespSamplList(appRespSamplList);
        }
        lis.add(appResp);
        return lis;
    }

    /**
     * 判断作业id是否匹配
     *
     * @param userId
     * @param pgrrGoodsCode
     * @param iamUserToken
     * @param module
     * @return
     */
    private boolean isMatchWorkId(String userId, String pgrrGoodsCode, String iamUserToken, PurchasedGoodsEnableModule module) {
        Map<String, Object> params = new HashMap<>(2);
        params.put("userId", userId);
        params.put("target", "drn:iam:app:" + pgrrGoodsCode);
        DigiwinIamUserAuthInfo userPermission = digiwinIamProxyService.getUserPermissionFunctional(iamUserToken, params);
        Boolean isMatchWorkId = false;

        Optional optional = Optional.ofNullable(userPermission)
                .map(DigiwinIamUserAuthInfo::getResult)
                .map(DigiwinIamUserAuthResult::getPermissions);
        if (optional.isPresent()) {
            if (userPermission != null && userPermission.getResult() != null) {
                isMatchWorkId = userPermission.getResult().getPermissions().
                        stream().anyMatch(e -> e.getId().equals(module.getWorkId())
                        && "allow".equalsIgnoreCase(e.getEffect()));
            }

        }
        return isMatchWorkId;
    }

    private List<AppModuleItem> getStartProjectAppModuleItemList(ApiRequest apiRequest) {
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String locale = apiRequest.getLocale();

        List<LaunchableProject> accessibleLaunchableProjectList =
                this.projectService.getLaunchableProjectList(iamUserToken, tenantId, locale);
        if (CollectionUtils.isEmpty(accessibleLaunchableProjectList)) {
            return Collections.emptyList();
        }
        return accessibleLaunchableProjectList.stream()
                .map(project -> {
                    AppModuleItem appModuleItem = new AppModuleItem();
                    appModuleItem.setId(project.getCode());
                    //处理智慧检料名字
                    if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(project.getCode())) {
                        appModuleItem.setName(project.getName().substring(0, 4));
                    } else {
                        appModuleItem.setName(project.getName());
                    }
                    Action<Map<String, Object>> action = new Action<>();
                    // 发起项目设计器跳转需要的信息
                    if (BooleanUtils.isTrue(project.getIsDesigner())) {
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                        action.setJumpPageTitle(project.getName());
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("project_introduce", project.getDesc());
                        rawData.put("project_name", project.getName());
                        rawData.put("dataId", project.getCreateSuffix());
                        action.setRawData(rawData);
                    } else {
                        if ("scan_freightage_start".equalsIgnoreCase(project.getCode())) {
                            Action rawDataAction = new Action();
                            rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                            rawDataAction.setJumpPageTitle(project.getName());
                            rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            rawDataAction.setDataId(project.getCreateSuffix());
                            Map<String, Object> rawData = new HashMap<>(2);
                            rawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_ASN_CODE);
                            rawData.put("action", rawDataAction);
                            action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                            action.setRawData(rawData);
                        } else {
                            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                            action.setJumpPageTitle(project.getName());
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            action.setDataId(project.getCreateSuffix());
                        }
                    }

                    appModuleItem.setAction(action);
//                    //处理智慧检料图标
//                    if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(project.getCode())) {
//                        appModuleItem.setImage("IMAGE_" + ProjectConstant.LAUNCH_EXCLUDED_PROJECT_TM_ACTIVITY_ID);
//                    } else {
//                        appModuleItem.setImage("IMAGE_" + project.getCreateSuffix());
//                    }
                    appModuleItem.setBgColor("#EEF1FF");
                    return appModuleItem;
                }).collect(Collectors.toList());
    }
}
