package com.digiwin.mobile.mobileuibot.printer;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommand;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommandByImage;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestTemplate;
import com.digiwin.mobile.mobileuibot.printer.response.CommandVO;
import com.digiwin.mobile.mobileuibot.printer.response.PrintTemplateVO;
import com.digiwin.mobile.mobileuibot.printer.service.PrinterService;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>功能描述：打印机相关API</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PrinterController.java
 * @Author: wangjwc
 * @Date: created at 2024/9/18 18:14
 */
@RestController
@RequestMapping("/mobile/v1/printer")
public class PrinterController {

    @Autowired
    private PrinterService printerService;

    /**
     * 获取打印机指令
     */
    @PostMapping(value = "/command")
    public ApiResponse<CommandVO> getCommand(@RequestBody ApiRequestCommand request) throws Exception {
        CommandVO command = new CommandVO();
        if (BooleanUtils.isTrue(request.getRawData().getBoolean("isNewVersion"))) {
            command = printerService.getCommand2(request);
        } else {
            command = printerService.getCommand(request);
        }
        if (ObjectUtils.isEmpty(command.getCommands()) ||
                ObjectUtils.isEmpty(command.getPdfUrl())) {
            return ApiResponse.buildError().setData(command);
        }
        return ApiResponse.buildOK().setData(command);
    }

    /**
     * 通过图片获取打印机指令
     */
    @PostMapping(value = "/commandByImage")
    public ApiResponse<CommandVO> getCommandByImage(@RequestBody ApiRequestCommandByImage request) throws Exception {
        return ApiResponse.buildOK().setData(printerService.getCommandByImage(request));
    }

    /**
     * 打印模板列表
     */
    @PostMapping(value = "/template/list")
    public ApiResponse<List<PrintTemplateVO>> templateList(@RequestBody ApiRequestTemplate request) {
        return ApiResponse.buildOK().setData(printerService.templateList(request));
    }
}
