package com.digiwin.mobile.mobileuibot.printer.factory;

import com.digiwin.mobile.mobileuibot.printer.model.ReportDetail;

import java.util.List;

/**
 * <p>功能描述：打印机指令构造器接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PrinterCommandBuilder.java
 * @Author: wangjwc
 * @Date: created at 2024/9/18 17:41
 */
public interface PrinterCommandBuilder {

    /**
     * 获取打印机类型
     */
    String getPrinterType();

    /**
     * 获取文件路径
     */
    ReportDetail getReportFilePaths(ReportDetail report, String pdfUrl);

    /**
     * 获取打印机指令
     */
    List<String> buildPrintCommand(List<String> imagePaths) throws Exception;
}
