package com.digiwin.mobile.mobileuibot.printer.factory;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * <p>功能描述：打印指令生成工厂类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PrinterCommandFactory.java
 * @Author: wangjwc
 * @Date: created at 2024/9/18 18:15
 */
@Component
public class PrinterCommandFactory implements InitializingBean {

    /**
     * 保存所有 PrinterCommandBuilder 的实现类
     */
    private final Map<String, Class<? extends PrinterCommandBuilder>> builderMap = new ConcurrentHashMap<>();

    @Autowired
    private List<PrinterCommandBuilder> printerCommandBuilderList;

    /**
     * 根据打印机指令类型获取接口实现
     */
    public Class<? extends PrinterCommandBuilder> getBuilder(String printerType) {
        return StringUtils.isEmpty(printerType) ? null : builderMap.get(printerType);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册所有 PrinterCommandBuilder 的实现类
        for (PrinterCommandBuilder builder : printerCommandBuilderList) {
            builderMap.put(builder.getPrinterType(), builder.getClass());
        }
    }
}
