package com.digiwin.mobile.mobileuibot.printer.model;

import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：abi报表导出参数类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AbiReportExport.java
 * @Author: wangjwc
 * @Date: created at 2024/9/25 9:34
 */
@Data
public abstract class AbiReportExport implements Serializable {
    private static final long serialVersionUID = -1228611631207279098L;
    /**
     * 分析表资源id
     */
    private String resid;
    /**
     * 导出类型（file/basecode）
     */
    private String exttype = "file";
    /**
     * 导出的文件类型（excel/pdf/csv/img）
     */
    private String filetype = "pdf";
    /**
     * 计算参数串，例：@param1=1;@param2=2
     * 如：calcnow=true;refresh=true;showmenu=false;@hashKey=746215181619200;@token=06afeae8-d2ea-4d11-b215-a71223cdf4d3;@routerKey=DCP;showparams=true;@domainName=https://athena-test.digiwincloud.com.cn;lang=zh_CN;@ReportKey=DCP
     */
    private String calcparams;
    /**
     * 导出文件名，例：采购凭证（2023-07-11）
     */
    private String filename;
    /**
     * 导出范围，0：导出当前页；1：导出所有页
     */
    private String exportrange = "1";
}
