package com.digiwin.mobile.mobileuibot.printer.model;

import lombok.Data;

import java.awt.image.BufferedImage;
import java.io.Serializable;

/**
 * @author wjw
 */
@Data
public class CommandRequired implements Serializable {
    private static final long serialVersionUID = 7085754027018420464L;

    private byte[] bytes;
    private int copy;

    // cpcl属性
    private String height;
    private String width;

    // tspl属性
    private BufferedImage bitmap;

    // esc/pos属性
    private String bmpFilesPath;

    public CommandRequired(byte[] bytes, int copy) {
        this.bytes = bytes;
        this.copy = copy;
    }


    public CommandRequired(String height, String width, byte[] bytes, int copy) {
        this.height = height;
        this.width = width;
        this.bytes = bytes;
        this.copy = copy;
    }

    public CommandRequired(BufferedImage bitmap, String height, String width, int copy) {
        this.bitmap = bitmap;
        this.height = height;
        this.width = width;
        this.copy = copy;
    }

    public  CommandRequired(BufferedImage bitmap, int copy, String bmpFilesPath) {
        this.bitmap = bitmap;
        this.copy = copy;
        this.bmpFilesPath = bmpFilesPath;
    }
}
