package com.digiwin.mobile.mobileuibot.printer.response;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPrintTemplate;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActionParameterMapping;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：打印模板VO类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PrintTemplateVO.java
 * @Author: wangjwc
 * @Date: created at 2024/12/9 16:37
 */
@Data
@Accessors(chain = true)
public class PrintTemplateVO implements Serializable {
    private static final long serialVersionUID = -2748323665884052234L;

    // 唯一标识
    private String uniqueId;
    // 模板关系类型   SYSTEM/TENANT_COPY/SYSTEM_EDIT
    private String type;
    // 租户id
    private String tenantId;
    // 作业code(项目/任务/基础资料)
    private String activityId;
    /**
     * 作业类型： 任务 BUSINESS_PERFORM  项目 BUSINESS_CHARGE   基础资料  DATA_ENTRY_PERFORM
     * @see com.digiwin.mobile.mobileuibot.printer.enums.PrinterTemplatePatternEnum
     */
    private String pattern;
    // 模板code
    private String code;
    // 模板id
    private String templateId;
    // 版本
    private String version;
    // 模板语系  "zh_TW": "繁中","zh_CN": "简中","en_US": "英文"
    private String locale;
    // 模板名称
    private String name;
    /**
     * API 入参 参数转换设定
     */
    private List<PcUiBotActionParameterMapping> actionParams;

    /**
     * 语系名称
     */
    private String localeName;

    public static PrintTemplateVO convert(DigiwinAtmcPrintTemplate template) {
        return new PrintTemplateVO()
                .setUniqueId(template.getUniqueId())
                .setType(template.getType())
                .setTenantId(template.getTenantId())
                .setActivityId(template.getActivityId())
                .setPattern(template.getPattern())
                .setCode(template.getCode())
                .setTemplateId(template.getTemplateId())
                .setVersion(template.getVersion())
                .setLocale(template.getLocale())
                .setName(template.getName())
                .setActionParams(template.getActionParams())
                .setLocaleName(buildLocaleName(template.getLocale()));
    }

    private static String buildLocaleName(String locale) {
        Map<String, Object> map = new HashMap<>(3);
        map.put("zh_CN", "简中");
        map.put("zh_TW", "繁中");
        map.put("en_US", "英文");
        return (String) map.get(locale);

    }


}
