package com.digiwin.mobile.mobileuibot.printer.service;

import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommand;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommandByImage;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestTemplate;
import com.digiwin.mobile.mobileuibot.printer.response.CommandVO;
import com.digiwin.mobile.mobileuibot.printer.response.PrintTemplateVO;

import java.util.List;

/**
 * <p>功能描述：打印机服务接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PrinterService.java
 * @Author: wangjwc
 * @Date: created at 2024/9/19 10:18
 */
public interface PrinterService {

    /**
     * 获取打印机指令
     */
    CommandVO getCommand(ApiRequestCommand request) throws Exception;

    CommandVO getCommand2(ApiRequestCommand request) throws Exception;

    /**
     * 通过图片获取打印机指令
     */
    CommandVO getCommandByImage(ApiRequestCommandByImage request) throws Exception;

    /**
     * 打印模板列表
     */
    List<PrintTemplateVO> templateList(ApiRequestTemplate request);
}
