package com.digiwin.mobile.mobileuibot.printer.service.impl;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotMultipleDataSourceService;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportAsyncExport;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportSyncExport;
import com.digiwin.mobile.mobileuibot.printer.request.ApiRequestCommand;
import com.digiwin.mobile.mobileuibot.printer.response.PrintTemplateVO;
import com.digiwin.mobile.mobileuibot.printer.service.AbiReportService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPrintAbiData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.bi.model.DigiwinBiUrl;
import com.digiwin.mobile.mobileuibot.proxy.bi.service.DigiwinBiProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.DigiwinEspCallbackManager;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ConditionPageService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.MessageFormat;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

/**
 * <p>功能描述：ABI报表服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AbiReportServiceImpl.java
 * @Author: wangjwc
 * @Date: created at 2024/9/24 10:24
 */
@Component
@Slf4j
public class AbiReportServiceImpl implements AbiReportService {

    @Autowired
    private ConditionPageService conditionPageService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinBiProxyService digiwinBiProxyService;
    @Autowired
    private UiBotMultipleDataSourceService uiBotMultipleDataSourceService;


    @Override
    public String getExportPdfUrl(ApiRequestCommand apiRequest, UiBotModel uiBotModel) {
        // 页面配置：通过报表code获取resid 与 查询action
        if (uiBotModel == null) {
            return null;
        }
        // 调用atmc，传递action和data，存储Redis，返回hashCode
        String hashCode = this.buildAbiHashCode(apiRequest, uiBotModel);
        log.info("hashCode: {}", hashCode);
        if (hashCode == null) {
            return null;
        }
        String resid = Optional.ofNullable(uiBotModel.getRawUiBotPageData()).map(g -> g.get("STATEMENT__resid")).map(StringUtil::valueOf).orElse(null);
        log.info("resid: {}", resid);
        if (StringUtils.isEmpty(resid)) {
            return null;
        }

        String application = uiBotModel.getExecuteContext().getString("application");
        String activityName = Optional.ofNullable(uiBotModel.getRawUiBotPageData()).map(g -> g.get("UIBOT__activityName")).map(StringUtil::valueOf).orElse("");
        // 调用esp异步导出
        return this.abiExportPdf(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                resid, hashCode, application, activityName);
//        return "https://ksc-test.apps.digiwincloud.com.cn/restful/standard/KSC/file/download/a3714333-a7dd-47bf-b12a-ecb523a5acb3.pdf";
    }

    @Override
    public UiBotModel getUibotModel(ApiRequestCommand request) {
        UiBotModel uiBotModel = this.buildPageConfig(request);
        return uiBotModel;
    }

    private UiBotModel buildPageConfig(ApiRequestCommand apiRequest) {
        String dataId = apiRequest.getDataId();
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), dataId);
        executeContext.appendPageInfo(PcUiBotActivityConstants.CONDITION_DETAIL, null, dataId, PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        return conditionPageService.createConditionTemplateForm(apiRequest, executeContext);
    }

    //构建Hashcode
    private String buildAbiHashCode(ApiRequestCommand apiRequest, UiBotModel uiBotModel) {
        if (uiBotModel == null || CollectionUtils.isEmpty(uiBotModel.getActions())) {
            return null;
        }
        Map<String, Object> params = new HashMap<>(2);
        params.put("action", uiBotModel.getActions().get(0));
        params.put("data", this.buildAbiData(apiRequest, uiBotModel));

        return digiwinAtmcProxyService.getAbiDataCache(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params);
    }

    private Map<String, Object> buildAbiData(ApiRequestCommand apiRequest, UiBotModel uiBotModel) {
        Map<String, Object> result = new HashMap<>();
        // 构建数据
        Map<String, Object> map = buildRequestParamter(apiRequest);
        if (ObjectUtils.isEmpty(map)) {
            return result;
        }
        result.putAll(map);
        return result;
    }

    private Map<String, Object> buildRequestParamter(ApiRequestCommand apiRequest) {
        Map<String, Object> data = (Map<String, Object>) apiRequest.getRawData().get("data");
        String mainDataSourceName = Optional.ofNullable(apiRequest.getRawData().getJSONObject("executeContext")).map(r -> r.getString("mainDataSourceName")).orElse(null);
        List<Map<String, Object>> sourceData = new ArrayList<>();
        Object o = data.get(mainDataSourceName);
        if (o instanceof List) {
            sourceData = (List<Map<String, Object>>) o;
        } else {
            return new HashMap<>();
        }

        List<HashMap<String, Object>> actionParams = (List<HashMap<String, Object>>) apiRequest.getRawData().get("actionParams");
        if (ObjectUtils.isEmpty(data)) {
            return new HashMap<>();
        }
        List<Map<String, Object>> transformedData = new ArrayList<>();
        Map<String, Object> realMap = new HashMap();
        String rootSchema = "";
        // 遍历数据源并进行转换
        for (Map<String, Object> item : sourceData) {
            Map<String, Object> transformedItem = new HashMap<>();
            for (Map<String, Object> param : actionParams) {
                String[] key = ((String) param.get("name")).split("\\.");
                String targetKey = key[key.length - 1];
                if (key.length > 1) {
                    rootSchema = key[0];
                }
                String[] value = ((String) param.get("value")).split("\\.");
                String sourceKey = value[value.length - 1];
                Object ob = item.get(sourceKey);
                if (ObjectUtils.isNotEmpty(param.get("typeConverter"))) {
                    try {
                        if ("stringToBooleanConverter".equals(param.get("typeConverter"))) {
                            ob = new DefaultConversionService().convert(ob.toString(), Boolean.TYPE);
                        } else if ("stringToNumberConverter".equals(param.get("typeConverter"))) {
                            ob = new DefaultConversionService().convert(ob.toString(), Integer.TYPE);
                        }
                    } catch (Exception e) {
                        log.error("转换参数失败", e);
                    }
                }
                transformedItem.put(targetKey, ob);
            }
            transformedData.add(transformedItem);
        }
        if (ObjectUtils.isEmpty(rootSchema)) {
            realMap.put(mainDataSourceName, transformedData);
        } else {
            realMap.put(rootSchema, transformedData);
        }
        return realMap;
    }

    private String abiExportPdf(String iamUserToken, String tenantId, String locale,
                                String resid, String hashCode, String application, String activityName) {
        AbiReportSyncExport export = new AbiReportSyncExport();
        export.setResid(resid);
        export.setExttype("file");
        export.setFiletype("pdf");
        export.setCalcparams(this.getCalcParams(iamUserToken, tenantId, locale, application, hashCode));
        export.setFilename(activityName);
        export.setExportrange("1");
        export.setIszip(false);
        export.setPdfDataExport(true);
        export.setPdfAutoPageSize(true);
        //先修改为同步导出，异步导出保留
        return getExportAbiUrlSync(iamUserToken, tenantId, locale, application, export);
//        AbiReportAsyncExport export = new AbiReportAsyncExport();
//        export.setResid(resid);
//        export.setExttype("file");
//        export.setFiletype("pdf");
//        export.setCalcparams(this.getCalcParams(apiRequest, uiBotModel, hashCode));
//        export.setFilename(Optional.ofNullable(uiBotModel.getRawUiBotPageData()).map(g -> g.get("UIBOT__activityName")).map(StringUtil::valueOf).orElse(""));
//        export.setExportrange("1");
//        export.setIszip("false");
//        export.setPdfDataExport("true");
//        export.setPdfAutoPageSize("true");
//        return getExportAbiUrlFasync(apiRequest, export);
    }

    private String getCalcParams(String iamUserToken, String tenantId, String locale, String application, String hashCode) {
        String template = "calcnow=true;refresh=true;showmenu=false;" +
                "@hashKey={0};@token={1};@routerKey={2};showparams=true;" +
                "@domainName={3};lang={4};@ReportKey={5}";
        // 替换占位符
        return MessageFormat.format(template, hashCode, iamUserToken, tenantId,
                AppContext.getApiUrlSetting().getMuiUrl(), locale, application);
    }

    /**
     * 异步导出接口
     *
     * @param apiRequest
     * @param export
     * @return
     */
    private String getExportAbiUrlFasync(ApiRequest apiRequest, AbiReportAsyncExport export) {
        //拿到reqId
        Map<String, Object> exportData = digiwinEspProxyService.getExportAbiUrlFasync(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), export);
        String reqId = (String) exportData.get("digi-reqid");
        CompletableFuture<String> future = new CompletableFuture<>();
        DigiwinEspCallbackManager.registerCallback(reqId, data -> {
            if (!future.isDone()) {
                Map<String, Object> urlMap = JsonUtil.jsonStringToObject(data, Map.class);
                if (ObjectUtils.isNotEmpty(urlMap)) {
                    if (urlMap.get("url") instanceof String) {
                        future.complete((String) urlMap.get("url"));
                    } else {
                        future.complete("");
                    }
                } else {
                    future.complete("");
                }
            }
        });
        try {
            //TODO: 优化：App前端和后端之间还是使用同步阻塞方式获取URL,后期需改为异步
            return future.get();
        } catch (InterruptedException e) {
            throw new RuntimeException("InterruptedException while waiting for URL", e);
        } catch (ExecutionException e) {
            throw new RuntimeException("Error while waiting for URL", e);
        }
    }

    /**
     * 同步导出接口
     *
     * @param apiRequest
     * @param export
     * @return
     */
    private String getExportAbiUrlSync(String iamUserToken, String tenantId, String locale, String application, AbiReportSyncExport export) {
        DigiwinBiUrl abiUrlResp = digiwinBiProxyService.getExportAbiUrlSync(
                iamUserToken, tenantId, locale, application, export);
        if (ObjectUtils.isEmpty(abiUrlResp)) {
            return null;
        }
        if (ObjectUtils.isEmpty(abiUrlResp.getData())) {
            return null;
        }
        return abiUrlResp.getData().getDownloadUrl();
    }

    @Override
    public String getExportPdfUrl(ApiRequestCommand request) {
        PrintTemplateVO printTemplate = request.getPrintTemplate();
        PcUiBotSubmitAction submitAction = JsonUtil.objectToJavaObject(request.getRawData().get("action"), PcUiBotSubmitAction.class);
        if (submitAction == null || printTemplate == null) {
            return null;
        }
        submitAction.setActionParams(printTemplate.getActionParams());
        submitAction.setBusinessConfig(new PcUiBotBusinessConfig().setBusinessId(printTemplate.getTemplateId()).setActivityId(printTemplate.getCode()));
        // 获取hashCode、resid
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("mobileplatform",
                                request.getLocale(), request.getIamUserToken(),
                                request.getTenantId()))
                        .bodyPayloadMap("action", submitAction)
                        .bodyPayloadMap("data", request.getRawData().get("data"))
                        .build();
        DigiwinAtmcPrintAbiData printAbiData = digiwinAtmcProxyService.getPrintAbiData(athenaApiRequest);
        if (printAbiData == null) {
            return null;
        }
        String hashCode = printAbiData.getHashCode();
        String resid = printAbiData.getResId();
        log.info("hashCode: {}, resid: {}", hashCode, resid);
        if (StringUtils.isEmpty(hashCode) || StringUtils.isEmpty(resid)) {
            return null;
        }

        String application = submitAction.getExecuteContext().getApplication();
        String activityName = printTemplate.getName();
        String locale = Optional.ofNullable(printTemplate.getLocale()).orElse(request.getLocale());
        // 调用esp异步导出
        return this.abiExportPdf(request.getIamUserToken(), request.getTenantId(), locale,
                resid, hashCode, application, activityName);
    }
}
