package com.digiwin.mobile.mobileuibot.project;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardProgress;
import com.digiwin.mobile.mobileuibot.core.component.list.card.PageFilterCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mysql.service.UserProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.filter.ProjectFilterService;
import com.digiwin.mobile.mobileuibot.project.model.GroupRecordRequest;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.project.service.impl.ProjectServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPersonnelStructure;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinEmp;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：项目领域相关API</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectController
 * @Author: Zaregoto
 * @Date: 2021/4/29 11:07
 */
@RestController
@RequestMapping("/mobile/v1/project")
public class ProjectController {
    private static final Logger logger = LoggerFactory.getLogger(ProjectController.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private ProjectFilterService projectFilterService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private UserProjectFilterService userProjectFilterService;

    @Autowired
    private LocaleService localeService;

    // mark by mowj 20220916 注释掉不再使用的，通知消息页中原有的项目助理卡片的摘要信息
/*    @RequestMapping(value = "/task/abnormalreason/list", method = RequestMethod.GET)
    public ApiResponse<List<TaskAbnormalReason>> listTaskAbnormalReason(
            @RequestParam(name = "iamUserToken") String iamUserToken,
            @RequestParam(name = "locale") String locale,
            @RequestParam(name = "projectId") String projectId,
            @RequestParam(name = "tmActivityId") String tmActivityId) {
        DigiwinAtmcProjectCheckTaskResult checkTaskResult = this.digiwinAtmcProxyService
                .getDigiwinAtmcProjectTaskCheckResult(locale, iamUserToken, projectId, tmActivityId);
        TaskAbnormalReason taskAbnormalReason = this.projectService.getTaskAbnormalReason(locale, checkTaskResult);
        logger.error("iamUserToken:{},locale:{},projectId:{},tmActivityId：{}, result json: {}",
                iamUserToken, locale, projectId, tmActivityId, JsonUtil.javaObjectToJsonString(taskAbnormalReason));
        return ApiResponse.buildOK().setData(taskAbnormalReason);
    }*/

    /**
     * 获取项目完成率、逾期率，并根据数据结果判断动态返回一个Action给APP端。这样可以通过数据操作点击行为
     *
     * @param iamUserToken
     * @param locale
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/progress/list")
    public ApiResponse<CardProgress> listProgressRate(
            @RequestParam(name = "iamUserToken") String iamUserToken,
            @RequestParam(name = "tenantId") String tenantId,
            @RequestParam(name = "locale") String locale,
            @RequestParam(name = "projectId") String projectId,
            @RequestParam(name = "isShare") Boolean isShare,
            @RequestParam(name = "pccProjectTypeIsNew") Boolean pccProjectTypeIsNew,
            String type,
            Boolean isException
    ) {
        boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData || modelTypeShow) {
            return ApiResponse.buildOK().setData(this.doMockData(projectId));
        }
        if (ProjectServiceImpl.KSC_APP_CODE.equalsIgnoreCase(type)) {
            CardProgress cardProgress = projectService.getKscProjectProgress(locale, iamUserToken,
                    tenantId, projectId, isShare, isException);
            return ApiResponse.buildOK().setData(cardProgress);
        } else {
            CardProgress cardProgress = this.projectService.getPccProjectProgress(locale, iamUserToken, tenantId, projectId, isShare, pccProjectTypeIsNew);
            return ApiResponse.buildOK().setData(cardProgress);
        }
    }

    @PostMapping(value = "/search")
    public ApiResponse<Map> projectSearch(HttpServletRequest request) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String locale = (String) params.get("locale");
        String tenantId = (String) params.get("tenantId");
        String queryParam = (String) params.get("queryParam");
        String clientId = (String) params.get("clientId");
        String userId = (String) params.get("userId");
        String pageFilterCode = StringUtil.valueOf(params.get("pageFilterCode"));
        List<String> ids = new ArrayList<>();
        if (PageFilterCodeEnum.TEAM_PROJECTS.getValue().equals(pageFilterCode)) {
            // 团队项目搜索
            userProjectFilterService.modifyByQueryParam(userId, tenantId, pageFilterCode, queryParam);
            // 团队项目中的团队成员树结构及相关信息
            DigiwinAtmcPersonnelStructure personnelStructure = digiwinAtmcProxyService.getPersonnelStructure(iamUserToken, tenantId, locale);
            List<DigiwinEmp> defaultSelectEmpList = Optional.ofNullable(personnelStructure).map(DigiwinAtmcPersonnelStructure::getAllChildrenDigiwinEmp).orElse(new ArrayList<>());
            if (!CollectionUtils.isEmpty(defaultSelectEmpList)) {
                ids = this.digiwinAtmcProxyService.teamProjectSearch(queryParam, defaultSelectEmpList, iamUserToken, tenantId, locale, clientId);
            }
        } else {
            // 我的项目搜索
            ids = this.digiwinAtmcProxyService.projectSearch(queryParam, iamUserToken, tenantId, locale, clientId);
        }
        Map<String, Object> map = new HashMap<>(1);
        map.put("idList", ids);
        return ApiResponse.buildOK().setData(map);
    }

    /**
     * 根据项目ID，查询在移动端被隐藏的项目卡列表
     *
     * @param clientId
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param appCode      要查询的应用编码（如PCC、PCM、DCP这种）
     * @return
     */
    @RequestMapping(value = "/hidden/list", method = RequestMethod.GET)
    public ApiResponse<List<DigiwinAtmcProject>> listProjectHiddenInApp(
            @RequestParam(name = "clientId") String clientId,
            @RequestParam(name = "locale") String locale,
            @RequestParam(name = "iamUserToken") String iamUserToken,
            @RequestParam(name = "tenantId") String tenantId,
            @RequestParam(name = "appCode") String appCode) {

        List<DigiwinAtmcProject> hiddenProjectList = null;
        try {
            List<DigiwinAtmcProject> supportedProjectList = this.digiwinAtmcProxyService
                    .listMyProject(clientId, locale, iamUserToken, tenantId)
                    .stream()
                    .filter(project -> projectFilterService.isSupportedProjectByDigiwinAtmcProject(project, tenantId))
                    .collect(Collectors.toList());
            if ("PCC".equals(appCode)) {
                supportedProjectList = supportedProjectList.stream().filter(
                        project -> projectFilterService.isCenterConsoleProject(project, tenantId)).collect(Collectors.toList());
                hiddenProjectList = supportedProjectList.stream().filter(
                        project -> {
                            if (CollectionUtils.isEmpty(project.getTasks())) {
                                return true;
                            } else {
                                return false;
                            }
                        }
                ).collect(Collectors.toList());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        return CollectionUtils.isEmpty(hiddenProjectList) ? ApiResponse.buildOK().setData(Collections.emptyList()) :
                ApiResponse.buildOK().setData(hiddenProjectList);
    }

    private List<ProgressRate> doMockData(String projectId) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        if ("442382885552192".equals(projectId)) {
            data = FileUtil.readText("static/appstore-use/project-progress-list-442382885552192.json");
        } else {
            data = FileUtil.readText("static/appstore-use/project-progress-list-general.json");
        }
        List<ProgressRate> progressRateList =
                JsonUtil.jsonStringToObject(data, new TypeReference<List<ProgressRate>>() {
                });
        return progressRateList;
    }

    /**
     * 保存分组记录
     */
    @PostMapping(value = "/groupRecord")
    public ApiResponse<Action<Map<String, Object>>> groupRecord(@RequestBody GroupRecordRequest apiRequest) {
        try {
            if (PageFilterCodeEnum.isExist(apiRequest.getPageFilterCode()) && apiRequest.getGroupFilter() != null) {
                userProjectFilterService.modifyByGroupFilter(apiRequest.getUserId(), apiRequest.getTenantId(),
                        apiRequest.getPageFilterCode(), JsonUtil.javaObjectToJsonString(apiRequest.getGroupFilter()));
            }
        } catch (Exception e) {
            logger.error("projectController.groupRecord error ", e);
        }
        Action<Map<String, Object>> action = new Action<>();
        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
        action.setToastMsg(localeService.getLanguageValue(apiRequest.getLocale(), "保存成功"));
        return ApiResponse.buildOK().setData(action);
    }
}
