package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.common.context.AppEnvTypeEnum;
import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 移动项目卡过滤mongo表实例
 *
 * @author zhangjj
 * @date 2022/7/29 11:11
 */
@Document(collection = "projectFilter")
@Data
public class ProjectFilter implements Serializable {
    private static final long serialVersionUID = -7574870147042138041L;

    //    @Field(value = "_id")
    @Id
    private String id;
    /**
     * 公司id
     * 1000代表鼎捷软件
     */
    private String companyId;
    /**
     * 系统id,如：athena
     */
    private String systemId;
    /**
     * 租户id
     * 无值时表示配置在所有租户下有效。
     */
    private String tenantId;
    /**
     * 业务
     */
    private String appCode;

    private ProjectFilterContent content;

    /**
     * 配置是否有效
     */
    private Boolean valid;
    /**
     * 不同环境配置
     */
    private List<EnvScope> envScopes;
    /**
     * 创建时间
     */
    private String createTime;
    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 根据当前启动的环境类型，判断当前页面过滤设置是否生效。
     *
     * @param appEnvType
     * @return true-生效，false-不生效
     */
    public Boolean validWithAppEnvType(final String appEnvType) {
        // 如果没有配置页面可使用的环境，则表示不知道在哪个环境可使用，故直接返回false，表示不匹配
        if (this.getEnvScopes() == null || this.getEnvScopes().isEmpty()) {
            return false;
        }
        Boolean result = false;
        for (EnvScope envScope : this.getEnvScopes()) {
            String type = envScope.getType();
            Boolean valid = envScope.getValid();
            if (appEnvType.equals(type)) {
                result = valid;
                break;
            }
        }
        return result;
    }

    /**
     * 没值时给对应字段设置默认值
     */
    public void setDefault() {
        if (this.getValid() == null) {
            this.setValid(true);
        }
        if (this.getCompanyId() == null) {
            this.setCompanyId("1000");
        }
        if (this.getSystemId() == null) {
            this.setSystemId("athena");
        }
        if (this.getEnvScopes() == null) {
            List<EnvScope> envScopeList = new ArrayList<>();
            EnvScope developScope = new EnvScope();
            developScope.setType(AppEnvTypeEnum.DEVELOP.getEnvType());
            developScope.setValid(true);
            envScopeList.add(developScope);
            EnvScope prodScope = new EnvScope();
            prodScope.setType(AppEnvTypeEnum.PRODUCTION.getEnvType());
            prodScope.setValid(true);
            envScopeList.add(prodScope);
            EnvScope testScope = new EnvScope();
            testScope.setType(AppEnvTypeEnum.TEST.getEnvType());
            testScope.setValid(true);
            envScopeList.add(testScope);
            this.setEnvScopes(envScopeList);
        }
    }
}
