package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目过滤openapi接口
 *
 * @author zhangjj
 * @date 2022/7/29 15:28
 */
@RestController
@RequestMapping("/mobile/v1/openapi")
public class ProjectFilterController {

    @Autowired
    private ProjectFilterRepository projectFilterRepository;

    @Resource(name = "systemCacheManager")
    private CaffeineCacheManager systemCacheManager;

//    @Autowired
//    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    /**
     * 批量新增/更新项目过滤配置
     *
     * @param appCode
     * @param map
     * @return
     */
    @PostMapping(value = "/apps/{appCode}/project/addfilters")
    public ApiResponse addOrUpdateProjectFilterList(
            @PathVariable(value = "appCode") String appCode,
            @RequestBody Map<String, List<ProjectFilter>> map) {
        if (map == null || map.get("filters") == null) {
            return ApiResponse.buildError("filters can not be empty!");
        }
        List<ProjectFilter> projectFilterList = map.get("filters");
        if (CollectionUtils.isEmpty(projectFilterList)) {
            return ApiResponse.buildError("filters can not be empty!");
        }
        for (ProjectFilter projectFilter : projectFilterList) {
            projectFilter.setAppCode(appCode);
            projectFilter.setDefault();
        }
        List<ProjectFilter> filterList = projectFilterRepository.upsertAll(projectFilterList);
        Map result = new HashMap();
        result.put("filters", filterList);
        //清除下缓存
        invalidateCache();
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 查询项目过滤配置
     *
     * @param appCode
     * @return
     */
    @GetMapping(value = "/apps/{appCode}/project/getfilters")
    public ApiResponse getProjectFilterList(
            @PathVariable(value = "appCode") String appCode,
            @RequestParam(required = false) String tenantId) {
        List<ProjectFilter> filterList = projectFilterRepository.listProjectFilter(appCode, tenantId);
        Map result = new HashMap();
        result.put("filters", filterList);
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 删除项目过滤配置
     *
     * @param appCode
     * @param projectFilter
     * @return
     */
    @PostMapping(value = "/apps/{appCode}/project/deletefilters")
    public ApiResponse deleteProjectFilter(
            @PathVariable(value = "appCode") String appCode,
            @RequestBody(required = false) ProjectFilter projectFilter) {
        String tmTaskId = null;
        String tenantId = null;
        if (projectFilter != null) {
            tenantId = projectFilter.getTenantId();
            if (projectFilter.getContent() != null) {
                tmTaskId = projectFilter.getContent().getTmTaskId();
            }
        }
        List<ProjectFilter> filterList
                = projectFilterRepository.deleteProjectFilter(appCode, tenantId, tmTaskId);
        Map result = new HashMap();
        result.put("filters", filterList);
        //清除下缓存
        invalidateCache();
        return ApiResponse.buildOK().setData(filterList);
    }


    /**
     * 清除项目过滤缓存
     */
    private void invalidateCache() {
        Cache cache = systemCacheManager.getCache("projectFilterList");
        if (cache != null) {
            cache.invalidate();
        }
    }

//    /**
//     * 查询 移动设计态 设计的DSL
//     *
//     * @param config
//     * @return
//     */
//    @PostMapping(value = "/desiginer/dsl/select")
//    public Map<String, Object> selectOneDsl(@RequestBody MobileDesignerConfig config) {
//        Map<String, Object> result = new HashMap<>();
//        result.put("code", 0);
//        result.put("data", mobileDesignerConfigRepository.selectOneDsl(config.getTmActivityId(), config.getType()));
//        return result;
//    }
//
//    /**
//     * 设计器 插入或更新 移动设计态 设计的DSL
//     *
//     * @param config
//     * @return
//     */
//    @PostMapping(value = "/desiginer/dsl/save")
//    public Map<String, Object> saveDsl(@RequestBody MobileDesignerConfig config) {
//        Map<String, Object> result = new HashMap<>();
//        if (config == null || config.getTmActivityId() == null || config.getData() == null) {
//            result.put("code", -1);
//            result.put("msg", "tmActivityId and data can not be empty!");
//            return result;
//        }
//        mobileDesignerConfigRepository.saveDsl(config);
//        result.put("code", 0);
//        return result;
//    }
//
//    /**
//     * 删除 移动设计态 设计的DSL
//     *
//     * @param tmActivityId 任务id
//     * @return
//     */
//    @GetMapping(value = "/desiginer/dsl/delete/{tmActivityId}")
//    public Map<String, Object> deleteDsl(
//            @PathVariable(value = "tmActivityId") String tmActivityId) {
//        Map<String, Object> result = new HashMap<>();
//        result.put("code", 0);
//        result.put("data", mobileDesignerConfigRepository.deleteDsl(tmActivityId));
//        return result;
//    }
//
//
//    /**
//     * 查询 移动设计态 设计的规则
//     *
//     * @param ruleId
//     * @return
//     */
//    @GetMapping(value = "/desiginer/rule/select/{ruleId}")
//    public Map<String, Object> selectOneRule(@PathVariable(value = "ruleId") String ruleId) {
//        String tmActivityId = ruleId.substring(0, ruleId.lastIndexOf("_"));
//        Map<String, Object> result = new HashMap<>();
//        result.put("code", 0);
//        MobileDesignerConfig config = mobileDesignerConfigRepository.selectOneRule(tmActivityId, ruleId);
//        if (config != null && !CollectionUtils.isEmpty(config.getRules())) {
//            result.put("data", config.getRules().get(0));
//        }
//        return result;
//    }
//
//    /**
//     * 查询 移动设计态 设计的规则
//     *
//     * @param code
//     * @return
//     */
//    @GetMapping(value = "/desiginer/rule/selectAll")
//    public Map<String, Object> selectAllRule(@RequestParam(name = "code") String code) {
//        Map<String, Object> result = new HashMap<>();
//        result.put("code", 0);
//        Map<String, Object> data = new HashMap<>();
//        data.put("rule", Optional
//                .ofNullable(mobileDesignerConfigRepository
//                        .selectAllRule(new MobileDesignerConfig().setTmActivityId(code)))
//                .map(MobileDesignerConfig::getRules)
//                .orElse(Lists.newArrayList()));
//        result.put("data", data);
//        return result;
//    }
//
//    /**
//     * 设计器 插入或更新 移动设计态 设计的规则
//     *
//     * @param rule
//     * @return
//     */
//    @PostMapping(value = "/desiginer/rule/save")
//    public Map<String, Object> saveRule(@RequestBody JSONObject rule) {
//        Map<String, Object> result = new HashMap<>();
//        if (rule == null || !StringUtils.hasLength(rule.getString("taskCode"))) {
//            result.put("code", -1);
//            result.put("msg", "taskCode can not be empty!");
//            return result;
//        }
//        MobileDesignerConfig config = new MobileDesignerConfig()
//                .setTmActivityId(rule.getString("taskCode"))
//                .setRules(Lists.newArrayList(rule));
//        result.put("code", 0);
//        mobileDesignerConfigRepository.saveRule(config);
//        result.put("data", rule);
//        return result;
//    }
//
//    /**
//     * 删除 移动设计态 设计的规则
//     *
//     * @param ruleId 规则id
//     * @return
//     */
//    @GetMapping(value = "/desiginer/rule/delete/{ruleId}")
//    public Map<String, Object> deleteRule(@PathVariable(value = "ruleId") String ruleId) {
//        String tmActivityId = ruleId.substring(0, ruleId.lastIndexOf("_"));
//        Map<String, Object> result = new HashMap<>();
//        result.put("code", 0);
//        mobileDesignerConfigRepository.deleteRule(tmActivityId, ruleId);
//        result.put("data", "Delete successfully");
//        return result;
//    }

}
