package com.digiwin.mobile.mobileuibot.project.filter;

import java.util.List;

/**
 * 项目过滤DB交互
 *
 * @author zhangjj
 * @date 2022/7/29 15:11
 */
public interface ProjectFilterRepository {
    /**
     * 获取所有项目过滤配置
     *
     * @return
     */
    List<ProjectFilter> listProjectFilter();

    /**
     * 批量更新/新增，返回最终对象List
     *
     * @param projectFilterList
     * @return
     */
    List<ProjectFilter> upsertAll(List<ProjectFilter> projectFilterList);

    /**
     * 写入，有则更新，无则新增，返回最终对象
     *
     * @param projectFilter
     * @return
     */
    ProjectFilter upsert(ProjectFilter projectFilter);

    /**
     * 按appCode、tenantId查找项目过滤列表
     *
     * @param appCode  必填
     * @param tenantId 无值时查询appCode下所有
     * @return
     */
    List<ProjectFilter> listProjectFilter(String appCode, String tenantId);

    /**
     * 删除项目过滤配置
     *
     * @param appCode  必填
     * @param tenantId
     * @param tmTaskId
     * @return
     */
    List<ProjectFilter> deleteProjectFilter(String appCode, String tenantId, String tmTaskId);
}
