package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;

/**
 * 项目过滤service
 *
 * @author zhangjj
 * @date 2022/7/29 11:38
 */
public interface ProjectFilterService {

    /**
     * 判断是否为项目中控台类型，且未结束项目
     *
     * @param digiwinAtmcProject
     * @return
     */
    boolean isCenterConsoleProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId);

    /**
     * 判断是否为体系云管家类型，且未结束项目
     *
     * @param digiwinAtmcProject
     * @param tenantId
     * @return
     */
    boolean isSystemCloudHouseKeeper(DigiwinAtmcProject digiwinAtmcProject, String tenantId);

    /**
     * 判断是否为设计变更类型项目
     * Deprecated by mowj on 20230119 因设计变更应用的项目在2022年上半年左右已确认不支持，故作为不支持打开详情的项目即可
     *
     * @param digiwinAtmcProject
     * @return
     */
    @Deprecated
    boolean isECNProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId);

    /**
     * 判断是否为标准项目（鼎华的应用使用过的项目）
     *
     * @param digiwinAtmcProject
     * @return
     */
    boolean isStandardProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId);

    /**
     * 根据鼎捷ATMC的项目，判断出是否支持在移动端呈现
     *
     * @param digiwinAtmcProject
     * @return
     */
    boolean isSupportedProjectByDigiwinAtmcProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId);

}
