package com.digiwin.mobile.mobileuibot.project.filter;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangjj
 * @date 2022/7/29 11:38
 */
@Service
public class ProjectFilterServiceImpl implements ProjectFilterService {

    @Autowired
    private ProjectFilterRepository projectFilterRepository;

    private List<ProjectFilter> findProjectFilter(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List<ProjectFilter> projectFilterList = projectFilterRepository.listProjectFilter();
        return projectFilterList.stream().filter(projectFilter ->
                projectFilter.getContent().getTmTaskId().equalsIgnoreCase(digiwinAtmcProject.getTmTaskId())
                        && (!StringUtils.hasLength(projectFilter.getTenantId()) || tenantId.equalsIgnoreCase(projectFilter.getTenantId()))).collect(Collectors.toList());
    }

    @Override
    public boolean isCenterConsoleProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List<ProjectFilter> projectFilterList = findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.CENTER_CONSOLE.getValue()
                .equalsIgnoreCase(projectFilter.getContent().getType())
                && (digiwinAtmcProject.getSubProjectCount() == null || !digiwinAtmcProject.getSubProjectCount().equals(digiwinAtmcProject.getSubProjectFinishedCount())));
    }

    @Override
    public boolean isSystemCloudHouseKeeper(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List<ProjectFilter> projectFilterList = findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.CLOUD_HOUSE_KEEPER.getValue()
                .equalsIgnoreCase(projectFilter.getContent().getType()));
    }

    @Override
    public boolean isECNProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List<ProjectFilter> projectFilterList = findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.TASK_PROCESS_ECN.getValue()
                .equalsIgnoreCase(projectFilter.getContent().getType()));
    }

    @Override
    public boolean isStandardProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        List<ProjectFilter> projectFilterList = findProjectFilter(digiwinAtmcProject, tenantId);
        return projectFilterList.stream().anyMatch(projectFilter -> ProjectFilterTypeEnum.STANDARD_PROJECT.getValue()
                .equalsIgnoreCase(projectFilter.getContent().getType()));
    }

    @Override
    public boolean isSupportedProjectByDigiwinAtmcProject(DigiwinAtmcProject digiwinAtmcProject, String tenantId) {
        return isCenterConsoleProject(digiwinAtmcProject, tenantId)
                || isStandardProject(digiwinAtmcProject, tenantId)
                || isSystemCloudHouseKeeper(digiwinAtmcProject, tenantId)
                ;
    }
}
