package com.digiwin.mobile.mobileuibot.project.model;

import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 可发起项目--项目的model
 *
 * @author zhangjj
 * @date 2021/10/28 0028 15:21
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LaunchableProject implements Serializable {

    private static final long serialVersionUID = -8990841321502362576L;

    /**
     * 项目名称
     */
    private String name;

    /**
     * 项目code
     */
    private String code;

    /**
     * 获取创建项目字段时需要的url后缀
     */
    private String createSuffix;

    /**
     * 是否是设计器配置的发起项目
     */
    private Boolean isDesigner;

    /**
     * 项目介绍
     */
    private String desc;

    /**
     * 根据鼎捷Athena的项目编码，判断是否是移动支持发起的项目
     *
     * @return
     */
    public boolean isSupportedLaunchableProject() {
        return "valuationInformationMaintenance_mainproject".equals(this.getCode())
                || "task_question_answer_mainline".equals(this.getCode())
                || "excluded_return_mainproject".equals(this.getCode())
//                || "transport_start".equals(this.getCode())
                || "manual_freightage_start".equalsIgnoreCase(this.getCode())
                || "scan_freightage_start".equalsIgnoreCase(this.getCode())
                //添加手动发起项目权限：智慧检料发起
                || ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equalsIgnoreCase(this.getCode())
                ;
    }
}
