package com.digiwin.mobile.mobileuibot.project.model.projectcc;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.math.MathUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRate;
import com.digiwin.mobile.mobileuibot.core.component.progress.ProgressRateTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.progressbar.ProgressBar;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>功能描述：项目任务项</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectCCTaskItem
 * @Author: Zaregoto
 * @Date: 2021/7/6 0:17
 */
public class ProjectCCTaskItem implements Serializable {
    private static final long serialVersionUID = 4132892584440067404L;

    public static Logger logger = LoggerFactory.getLogger(ProjectCCTaskItem.class);

    private String title;
    private ProjectCCTaskItemPreTitle preTitle;
    private ProgressRate progressRate;
    private List<ProjectCCTaskItemDescription> descList;
    private Integer type;
    private Button detail;
    private NextCrumbs nextCrumbs;

    public ProjectCCTaskItem() {
        this.descList = new ArrayList<>();
    }

    public static ProjectCCTaskItem create(
            String locale, PccProjectTaskInfo currentProjectTaskInfo,
            List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo) {
        return ProjectCCTaskItem.create(locale, currentProjectTaskInfo, allProjectTaskInfoList, isCrumbs, iamUserToken, projectNo, true);
    }

    public static ProjectCCTaskItem createKsc(
            String locale, PccProjectTaskInfo currentProjectTaskInfo,
            List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo) {
        return ProjectCCTaskItem.createKscItem(locale, currentProjectTaskInfo, allProjectTaskInfoList, isCrumbs, iamUserToken, projectNo, true);
    }


    public static ProjectCCTaskItem createKscItem(
            String locale, PccProjectTaskInfo currentProjectTaskInfo,
            List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo, boolean isCreateInfo) {
        List<PccProjectTaskInfo> nextLevelProjectTaskInfoList =
                currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();

        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(
                TaskStringUtil.getTaskDateDistanceText(
                        currentProjectTaskInfo.getPlanStartDate(),
                        currentProjectTaskInfo.getPlanFinishDate())
        );
        long workPeriod = currentProjectTaskInfo.getWorkPeriodInDay();
        String workPeriodUnit = LocaleUtil.getMobileTextByKey(locale, "天");
        String rightText = LocaleUtil.getMobileTextWithUnit(locale,
                "",
                String.valueOf(workPeriod),
                workPeriodUnit,
                false,
                LocaleUtil.getMobileTextByKey(locale, "工期"));
        preTitle.setRight(rightText);
        projectCCTaskItem.setPreTitle(preTitle);

        projectCCTaskItem.setTitle(currentProjectTaskInfo.getTaskName());

        projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(
                currentProjectTaskInfo, nextLevelProjectTaskInfoList));

        int type;
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            type = currentProjectTaskInfo.isOverdue() ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        } else {
            type = nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        }
        projectCCTaskItem.setType(type);

        ProjectCCTaskItemDescription description = new ProjectCCTaskItemDescription();
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            // 无下级任务
            description.setIconData(59021);
            description.setText(currentProjectTaskInfo.getLiablePersonName());
//            EocPersonInfo eocPersonInfo = new EocPersonInfo();
//            eocPersonInfo.setEocId(currentProjectTaskInfo.getLiablePersonCode());
//            eocPersonInfo.setName(currentProjectTaskInfo.getLiablePersonName());

            //体系云负责人换执行人
            List<Map<String, Object>> taskMemberInfo = currentProjectTaskInfo.getTaskMemberInfo();
            List<EocPersonInfo> eocPersonInfoList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(taskMemberInfo)) {
                eocPersonInfoList = taskMemberInfo.stream().map(item -> {
                    EocPersonInfo eocPersonInfo = new EocPersonInfo();
                    eocPersonInfo.setEocId(MapUtils.getString(item, "executor_no"));
                    eocPersonInfo.setName(MapUtils.getString(item, "executor_name"));
                    return eocPersonInfo;
                }).collect(Collectors.toList());
            }
            description.setPersonInfoList(eocPersonInfoList);
            LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
            description.setPersonLabel(localeService.getLanguageValue(locale, "执行人"));
            // TODO 2021.07.07 没有下级任务时，展示一个打开通知提醒的弹窗。因本次通知提醒的后端接口还未开发，故不支持
//            description.setButtonList();
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                long overduePeriod;
                if (StringUtils.hasLength(currentProjectTaskInfo.getActualFinishDate())) {
                    overduePeriod = DateTimeUtil.getDatePeriod(currentProjectTaskInfo.getPlanFinishDate(), currentProjectTaskInfo.getActualFinishDate());
                } else {
                    overduePeriod = currentProjectTaskInfo.getOverduePeriodInDay() - 1;
                }
                String text = LocaleUtil.getMobileTextWithUnit(locale,
                        LocaleUtil.getMobileTextByKey(locale, "逾期"),
                        String.valueOf(overduePeriod),
                        LocaleUtil.getMobileTextByKey(locale, "天"),
                        false,
                        "");
                description.addLabel(Label.create(
                        text,
                        LabelTypeEnum.OVERDUE.getType()
                ));
            }
            //详情按钮
            if (isCreateInfo) {
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("taskInfo", currentProjectTaskInfo);
                projectCCTaskItem.setDetail(new Button(
                        "",
                        LocaleUtil.getMobileTextByKey(locale, "详情") + ">",
                        new Action(
                                currentProjectTaskInfo.getTaskNo(),
                                PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_TAIL_TASK_DETAIL.toString(),
                                "",
                                ActionTypeEnum.OPEN_NEW_PAGE.getValue(),
                                apiRawData
                        ))
                );
            }
        } else {
            // 有下级任务
            description.setIconData(59022);
            long nextLevelProjectTaskInfoCompleteCount =
                    nextLevelProjectTaskInfoList.stream()
                            .filter(PccProjectTaskInfo::isDone)
                            .count();
            int nextLevelProjectTaskInfoCount = nextLevelProjectTaskInfoList.size();
            description.setText(String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoCount));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                //添加标签-存在逾期任务
                description.addLabel(Label.create(
                        LocaleUtil.getMobileTextByKey(locale, "存在逾期任务"),
                        LabelTypeEnum.OVERDUE.getType()
                ));
            }
            if (isCrumbs) {
                //回调这边暂时没做塞入人员信息 todo 20220125
                List<ProjectCCTaskItem> itemList =
                        nextLevelProjectTaskInfoList.stream()
                                .map(digiwinAtdmProjectTaskInfo ->
                                        ProjectCCTaskItem.createKsc(locale, digiwinAtdmProjectTaskInfo, allProjectTaskInfoList, true, iamUserToken, projectNo))
                                .collect(Collectors.toList());
                NextCrumbs nextCrumbs = new NextCrumbs();
                nextCrumbs.setButtonName(LocaleUtil.getMobileTextByKey(locale, "详情") + ">");
                nextCrumbs.setChildren(itemList);
                projectCCTaskItem.setNextCrumbs(nextCrumbs);
            } else {
                //详情按钮
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("data", allProjectTaskInfoList);
                apiRawData.put("projectNo", projectNo);
                projectCCTaskItem.setDetail(new Button(
                        "",
                        LocaleUtil.getMobileTextByKey(locale, "详情") + ">",
                        new Action(
                                currentProjectTaskInfo.getTaskNo(),
                                PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_NEXT_LEVEL_TASK_LIST.toString(),
                                "",
                                ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(),
                                apiRawData
                        ))
                );
            }

        }
        projectCCTaskItem.addProjectCCPhaseItemDescription(description);

        return projectCCTaskItem;
    }

    public static ProjectCCTaskItem create(
            String locale, PccProjectTaskInfo currentProjectTaskInfo,
            List<PccProjectTaskInfo> allProjectTaskInfoList, boolean isCrumbs, String iamUserToken, String projectNo, boolean isCreateInfo) {
        List<PccProjectTaskInfo> nextLevelProjectTaskInfoList =
                currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();

        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(
                TaskStringUtil.getTaskDateDistanceText(
                        currentProjectTaskInfo.getPlanStartDate(),
                        currentProjectTaskInfo.getPlanFinishDate())
        );

        String workloadQty = Objects.isNull(currentProjectTaskInfo.getWorkloadQty()) ? "0" :
                new BigDecimal(String.valueOf(currentProjectTaskInfo.getWorkloadQty())).stripTrailingZeros().toPlainString();
        String workPeriodUnit = LocaleUtil.getMobileTextByKey(locale, "天");
        String rightText = LocaleUtil.getMobileTextWithUnit(locale,
                "",
                String.valueOf(workloadQty),
                workPeriodUnit,
                false,
                LocaleUtil.getMobileTextByKey(locale, "工期"));
        preTitle.setRight(rightText);
        projectCCTaskItem.setPreTitle(preTitle);

        projectCCTaskItem.setTitle(currentProjectTaskInfo.getTaskName());

        projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(
                currentProjectTaskInfo, nextLevelProjectTaskInfoList));

        int type;
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            type = currentProjectTaskInfo.isOverdue() ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        } else {
            type = nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        }
        projectCCTaskItem.setType(type);

        ProjectCCTaskItemDescription description = new ProjectCCTaskItemDescription();
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            // 无下级任务
            description.setIconData(59021);
            description.setText(currentProjectTaskInfo.getLiablePersonName());
            EocPersonInfo eocPersonInfo = new EocPersonInfo();
            eocPersonInfo.setEocId(currentProjectTaskInfo.getLiablePersonCode());
            eocPersonInfo.setName(currentProjectTaskInfo.getLiablePersonName());
            description.setPersonInfo(eocPersonInfo);
            LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
            description.setPersonLabel(localeService.getLanguageValue(locale, "责任人"));
            // TODO 2021.07.07 没有下级任务时，展示一个打开通知提醒的弹窗。因本次通知提醒的后端接口还未开发，故不支持
//            description.setButtonList();
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                long overduePeriod = currentProjectTaskInfo.getOverduePeriodInDay();
                //pc web逻辑不包括当日，所以在减去1天
                long overdueDay = overduePeriod - 1;
                String text = LocaleUtil.getMobileTextWithUnit(locale,
                        LocaleUtil.getMobileTextByKey(locale, "逾期"),
                        String.valueOf(overdueDay),
                        LocaleUtil.getMobileTextByKey(locale, "天"),
                        false,
                        "");
                description.addLabel(Label.create(
                        text,
                        LabelTypeEnum.OVERDUE.getType()
                ));
            }
            //详情按钮
            if (isCreateInfo) {
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("taskInfo", currentProjectTaskInfo);
                projectCCTaskItem.setDetail(new Button(
                        "",
                        LocaleUtil.getMobileTextByKey(locale, "详情") + ">",
                        new Action(
                                currentProjectTaskInfo.getTaskNo(),
                                PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_TAIL_TASK_DETAIL.toString(),
                                "",
                                ActionTypeEnum.OPEN_NEW_PAGE.getValue(),
                                apiRawData
                        ))
                );
            }
        } else {
            // 有下级任务
            description.setIconData(59022);
            long nextLevelProjectTaskInfoCompleteCount =
                    nextLevelProjectTaskInfoList.stream()
                            .filter(PccProjectTaskInfo::isDone)
                            .count();
            int nextLevelProjectTaskInfoCount = nextLevelProjectTaskInfoList.size();
            description.setText(String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoCount));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                //添加标签-存在逾期任务
                description.addLabel(Label.create(
                        LocaleUtil.getMobileTextByKey(locale, "存在逾期任务"),
                        LabelTypeEnum.OVERDUE.getType()
                ));
            }
            if (isCrumbs) {
                //回调这边暂时没做塞入人员信息 todo 20220125
                List<ProjectCCTaskItem> itemList =
                        nextLevelProjectTaskInfoList.stream()
                                .map(digiwinAtdmProjectTaskInfo ->
                                        ProjectCCTaskItem.create(locale, digiwinAtdmProjectTaskInfo, allProjectTaskInfoList, true, iamUserToken, projectNo))
                                .collect(Collectors.toList());
                NextCrumbs nextCrumbs = new NextCrumbs();
                nextCrumbs.setButtonName(LocaleUtil.getMobileTextByKey(locale, "详情") + ">");
                nextCrumbs.setChildren(itemList);
                projectCCTaskItem.setNextCrumbs(nextCrumbs);
            } else {
                //详情按钮
                ApiRawData apiRawData = new ApiRawData();
                apiRawData.put("data", allProjectTaskInfoList);
                apiRawData.put("projectNo", projectNo);
                projectCCTaskItem.setDetail(new Button(
                        "",
                        LocaleUtil.getMobileTextByKey(locale, "详情") + ">",
                        new Action(
                                currentProjectTaskInfo.getTaskNo(),
                                PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_NEXT_LEVEL_TASK_LIST.toString(),
                                "",
                                ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue(),
                                apiRawData
                        ))
                );
            }

        }
        projectCCTaskItem.addProjectCCPhaseItemDescription(description);

        return projectCCTaskItem;
    }

    /**
     * 项目计划头部信息渲染（目前只用于尾阶头部渲染）
     */
    public static ProjectCCTaskItem createPccPlan(String locale, PccProjectTaskInfo currentProjectTaskInfo,
                                                  List<PccProjectTaskInfo> allProjectTaskInfoList) {
        List<PccProjectTaskInfo> nextLevelProjectTaskInfoList =
                currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();

        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(
                TaskStringUtil.getTaskDateDistanceText(
                        currentProjectTaskInfo.getPlanStartDate(),
                        currentProjectTaskInfo.getPlanFinishDate())
        );
        int workloadQty = DateTimeUtil.getWorkingDaysBetweenDates(currentProjectTaskInfo.getPlanStartDate(),
                currentProjectTaskInfo.getPlanFinishDate());
        String workPeriodUnit = LocaleUtil.getMobileTextByKey(locale, "天");
        String rightText = LocaleUtil.getMobileTextWithUnit(locale,
                "",
                String.valueOf(workloadQty),
                workPeriodUnit,
                false,
                LocaleUtil.getMobileTextByKey(locale, "工期"));
        preTitle.setRight(rightText);
        projectCCTaskItem.setPreTitle(preTitle);

        projectCCTaskItem.setTitle(currentProjectTaskInfo.getTaskName());

        int type;
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            type = currentProjectTaskInfo.isOverdue() ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        } else {
            type = nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        }
        projectCCTaskItem.setType(type);

        ProjectCCTaskItemDescription description = new ProjectCCTaskItemDescription();
        if (CollectionUtils.isEmpty(nextLevelProjectTaskInfoList)) {
            // 无下级任务
            description.setIconData(59021);
            description.setText(currentProjectTaskInfo.getLiablePersonName());
            EocPersonInfo eocPersonInfo = new EocPersonInfo();
            eocPersonInfo.setEocId(currentProjectTaskInfo.getLiablePersonCode());
            eocPersonInfo.setName(currentProjectTaskInfo.getLiablePersonName());
            description.setPersonInfo(eocPersonInfo);
            LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
            description.setPersonLabel(localeService.getLanguageValue(locale, "责任人"));
            projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(
                    currentProjectTaskInfo, nextLevelProjectTaskInfoList));
        } else {
            projectCCTaskItem.setProgressRate(projectCCTaskItem.calculateProgressRate(
                    currentProjectTaskInfo, nextLevelProjectTaskInfoList));

            // 有下级任务
            description.setIconData(59022);
            long nextLevelProjectTaskInfoCompleteCount =
                    nextLevelProjectTaskInfoList.stream()
                            .filter(PccProjectTaskInfo::isDone)
                            .count();
            int nextLevelProjectTaskInfoCount = nextLevelProjectTaskInfoList.size();
            description.setText(String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoCount));
            if (type == ProgressRateTypeEnum.EXCEPTION.getType()) {
                //添加标签-存在逾期任务
                description.addLabel(Label.create(
                        LocaleUtil.getMobileTextByKey(locale, "存在逾期任务"),
                        LabelTypeEnum.OVERDUE.getType()
                ));
            }
        }
        projectCCTaskItem.addProjectCCPhaseItemDescription(description);
        return projectCCTaskItem;
    }

    /**
     * 项目计划和项目中控台阶段页签内的卡片列表信息渲染以及查看更多下钻页面的列表渲染
     * mainPageId 主页面标识，用于区分是体系云项目进行中还是未开始页面，未开始才可以编辑
     */
    public static Card createProjectCard(ApiRequest apiRequest, PccProjectTaskInfo currentProjectTaskInfo,
                                         List<PccProjectTaskInfo> allProjectTaskInfoList, String projectNo,
                                         String mainPageId, boolean isPcc, boolean isPccPlan, boolean isCriticalPath, Boolean isPccTask) {
        String locale = apiRequest.getLocale();
        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
        List<PccProjectTaskInfo> nextLevelProjectTaskInfoList =
                currentProjectTaskInfo.filterNextLevelProjectTaskInfo(allProjectTaskInfoList);
        ProjectCCTaskItem projectCCTaskItem = new ProjectCCTaskItem();

        ProjectCCTaskItemPreTitle preTitle = new ProjectCCTaskItemPreTitle();
        preTitle.setLeft(
                TaskStringUtil.getTaskDateDistanceText(
                        currentProjectTaskInfo.getPlanStartDate(),
                        currentProjectTaskInfo.getPlanFinishDate())
        );

        Card card = new Card();
        card.setTitle(currentProjectTaskInfo.getTaskName());
        card.setStyle(3);

        boolean isOverdue = false;

        // 无下级任务
        if (CollectionUtils.isEmpty(nextLevelProjectTaskInfoList)) {
            card.setSubTitle(localeService.getLanguageValue(locale, "详情"));
            if (isCriticalPath) {
                card.setTitleBgColor("#605CE5");
                card.setTitleColor("#FFFFFF");
                card.setSubTitleColor("#FFFFFF");
            } else {
                card.setTitleBgColor("#F0E8FD");
            }

            if (currentProjectTaskInfo.isOverdue()) {
                isOverdue = true;
                long overduePeriod = currentProjectTaskInfo.getOverduePeriodInDay() - 1;
                String tagContent = String.format(localeService.getLanguageValue(locale, "逾期%s天"), overduePeriod);
                card.setTags(Collections.singletonList(Tag.createWarningTag(tagContent)));
            }

            ApiRawData apiRawData = new ApiRawData();
            apiRawData.put("taskInfo", currentProjectTaskInfo);
            apiRawData.put("isPccPlan", isPccPlan);
            card.setSubTitleAction(new Action(
                    currentProjectTaskInfo.getTaskNo(),
                    isPcc ? PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CC_TAIL_TASK_DETAIL.name() :
                            PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_TAIL_TASK_DETAIL.name(),
                    "",
                    ActionTypeEnum.OPEN_NEW_PAGE.getValue(),
                    apiRawData
            ));

        } else {
            card.setSubTitle(localeService.getLanguageValue(locale, "查看更多>"));
            boolean isFirstOrder = Objects.equals(currentProjectTaskInfo.getTaskNo(), currentProjectTaskInfo.getUpperLevelTaskNo());

            // 首阶标题背景色展示蓝色，中阶展示亮蓝色
            card.setTitleBgColor(isFirstOrder ? "#DAE1FF" : "#E3F2FF");
            //改造后默认深蓝色
            if (isCriticalPath) {
                card.setTitleBgColor("#605CE5");
                card.setTitleColor("#FFFFFF");
                card.setSubTitleColor("#FFFFFF");
            }
            // 项目计划不展示逾期标签
            if (!isPccPlan && nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue)) {
                isOverdue = true;
                String tagContent = localeService.getLanguageValue(locale, "存在逾期任务");
                card.setTags(Collections.singletonList(Tag.createWarningTag(tagContent)));
            }

            ApiRawData apiRawData = new ApiRawData();
            apiRawData.put("data", allProjectTaskInfoList);
            apiRawData.put("projectNo", projectNo);
            apiRawData.put("isPcc", isPcc);
            apiRawData.put("mainPageId", mainPageId);
            apiRawData.put("isPccPlan", isPccPlan);
            apiRawData.put("currentProjectTaskInfo", currentProjectTaskInfo);

            if (Objects.isNull(apiRequest.getRawData())) {
                apiRawData.put("bread_crumb_chain", Collections.singletonList(currentProjectTaskInfo));
            } else {
                List<PccProjectTaskInfo> breadCrubChain = (List<PccProjectTaskInfo>) MapUtil.getOrDefault(apiRequest.getRawData(), "bread_crumb_chain", new LinkedList<>());
                breadCrubChain.add(currentProjectTaskInfo);
                apiRawData.put("bread_crumb_chain", breadCrubChain);
            }

            Action action = new Action();

            if (isFirstOrder || isCriticalPath || isPccTask) {
                action.setRawData(apiRawData);
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_NEXT_LEVEL_PROJECT_LIST.toString());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            } else {
                BreadCrumbNode breadCrumbNode = new BreadCrumbNode();
                breadCrumbNode.setTitle(currentProjectTaskInfo.getTaskName());
                breadCrumbNode.setRequestUrl("/mobile/v1/proxy/get/project/breadCrumb/data");
                breadCrumbNode.setRawData(apiRawData);
                action.setCrumbItem(breadCrumbNode);
                action.setType(ActionTypeEnum.REFRESH_LOCAL.getValue());
            }
            card.setSubTitleAction(action);
        }

        List<CardContent> contentList = new LinkedList<>();

        String workloadQty = Objects.isNull(currentProjectTaskInfo.getWorkloadQty()) ? "0" :
                new BigDecimal(String.valueOf(currentProjectTaskInfo.getWorkloadQty())).stripTrailingZeros().toPlainString();

        // 项目计划展示负责人，体系云展示执行人
        if (isPccPlan) {
            List<CardContent> multiValueContentList = new ArrayList<>(2);
            multiValueContentList.add(new CardContent(localeService.getLanguageValue(locale, "负责人"), currentProjectTaskInfo.getLiablePersonName()));

            multiValueContentList.add(new CardContent(localeService.getLanguageValue(locale, "任务工期"),
                    workloadQty + localeService.getLanguageValue(locale, "天")));
            contentList.add(CardContent.createMultiValue(multiValueContentList, "  "));
        } else {
            List<Map<String, Object>> taskMemberInfo = currentProjectTaskInfo.getTaskMemberInfo();
            String executorName = "";
            if (!CollectionUtils.isEmpty(taskMemberInfo)) {
                executorName = taskMemberInfo.stream().map(item -> MapUtils.getString(item, "executor_name")).collect(Collectors.joining("; "));
            }
            contentList.add(new CardContent(localeService.getLanguageValue(locale, "执行人"), executorName));
            contentList.add(new CardContent(localeService.getLanguageValue(locale, "任务工期"),
                    workloadQty + localeService.getLanguageValue(locale, "天")));
        }

        contentList.add(new CardContent(localeService.getLanguageValue(locale, "时间范围"),
                String.format("%s-%s", currentProjectTaskInfo.getPlanStartDate().replaceAll("-", "."),
                        currentProjectTaskInfo.getPlanFinishDate().replaceAll("-", "."))));

        // 体系云未启动项目 不展示进度条和任务进程
        if ((!Objects.equals(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString(), mainPageId)) || isCriticalPath || isPccTask) {
            ProgressRate progressRate = projectCCTaskItem.calculateProgressRate(currentProjectTaskInfo, nextLevelProjectTaskInfoList);
            ProgressBar progressBar = new ProgressBar();
            progressBar.setTitle(localeService.getLanguageValue(locale, "整体进度"));
            progressBar.setMinValue(new BigDecimal(0));
            progressBar.setMaxValue(new BigDecimal(100));
            progressBar.setDefaultValue(new BigDecimal(String.valueOf(progressRate.getRate())).multiply(new BigDecimal(100)));

            // 逾期进度条显示橙色，否则显示蓝色
            if (isOverdue) {
                progressBar.setActiveColor1("FFC084");
                progressBar.setActiveColor2("FF8160");
            } else {
                progressBar.setActiveColor1("91BAFF");
                progressBar.setActiveColor2("5465FF");
            }
            CardContent progressBarCardContent = new CardContent();
            progressBarCardContent.setProgressBar(progressBar);
            contentList.add(progressBarCardContent);

            // 有下一阶任务展示才展示任务进程
            if (!CollectionUtils.isEmpty(nextLevelProjectTaskInfoList)) {
                long nextLevelProjectTaskInfoCompleteCount =
                        nextLevelProjectTaskInfoList.stream()
                                .filter(PccProjectTaskInfo::isDone)
                                .count();
                String taskProcess = String.format("%d/%d", nextLevelProjectTaskInfoCompleteCount, nextLevelProjectTaskInfoList.size());
                contentList.add(new CardContent(localeService.getLanguageValue(locale, "任务进程"), taskProcess));
            }
        }
        card.setContent(contentList);

        if (PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString().equalsIgnoreCase(mainPageId)) {
            Action editAction = new Action();
            editAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_TASK.toString());
            editAction.setJumpPageTitle(localeService.getLanguageValue(locale, "编辑任务"));
            editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("currentProjectTaskInfo", currentProjectTaskInfo);
            rawData.put("fromPageId", apiRequest.getPageId());
            editAction.setRawData(rawData);
            card.setCardAction(editAction);
        }
        return card;
    }

    /**
     * 计算阶段任务的进度
     * 1，若阶段存在下阶任务，等于=下阶任务进度之和/下阶任务数*100%
     * ex：阶段1共包含2个二级任务，二阶任务1进度：20%；二阶任务2进度40%
     * 计算得出：阶段1的进度=（0.2+0.4)/2=0.3=30%
     * 2，若阶段不存在下阶任务，
     * 则任务本身作为阶段显示，进度显示任务本身的进度
     *
     * @param currentProjectTaskInfo       当前任务
     * @param nextLevelProjectTaskInfoList 当前任务所有下一级任务
     * @return 任务进度组件对象
     */
    private ProgressRate calculateProgressRate(
            PccProjectTaskInfo currentProjectTaskInfo,
            List<PccProjectTaskInfo> nextLevelProjectTaskInfoList) {
        ProgressRate progressRate = new ProgressRate();

        double rate;
        int type;
        if (nextLevelProjectTaskInfoList.isEmpty()) {
            rate = MathUtil.getDecimalPoint(currentProjectTaskInfo.getCompleteRate(), 2);
            type = currentProjectTaskInfo.isOverdue() ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        } else {
            rate = MathUtil.getDecimalPoint(
                    nextLevelProjectTaskInfoList.stream()
                            .mapToDouble(PccProjectTaskInfo::getCompleteRate)
                            .average().orElse(0.0),
                    2
            );
            type = nextLevelProjectTaskInfoList.stream().anyMatch(PccProjectTaskInfo::isOverdue) ?
                    ProgressRateTypeEnum.EXCEPTION.getType() : ProgressRateTypeEnum.NORMAL.getType();
        }
        progressRate.setRate(rate);
        progressRate.setName(String.format("%.0f", rate * 100.0) + "%");
        progressRate.setType(type);

        return progressRate;
    }

    public void addProjectCCPhaseItemDescription(ProjectCCTaskItemDescription description) {
        if (null != description) {
            this.descList.add(description);
        }
    }


    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ProjectCCTaskItemPreTitle getPreTitle() {
        return preTitle;
    }

    public void setPreTitle(ProjectCCTaskItemPreTitle preTitle) {
        this.preTitle = preTitle;
    }

    public ProgressRate getProgressRate() {
        return progressRate;
    }

    public void setProgressRate(ProgressRate progressRate) {
        this.progressRate = progressRate;
    }

    public List<ProjectCCTaskItemDescription> getDescList() {
        return descList;
    }

    public void setDescList(List<ProjectCCTaskItemDescription> descList) {
        this.descList = descList;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Button getDetail() {
        return detail;
    }

    public void setDetail(Button detail) {
        this.detail = detail;
    }

    public NextCrumbs getNextCrumbs() {
        return nextCrumbs;
    }

    public void setNextCrumbs(NextCrumbs nextCrumbs) {
        this.nextCrumbs = nextCrumbs;
    }
}

