package com.digiwin.mobile.mobileuibot.project.model.projectcc;

import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonInfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectCCPhaseItemDescription
 * @Author: Zaregoto
 * @Date: 2021/7/6 0:27
 */
class ProjectCCTaskItemDescription implements Serializable {
    private static final long serialVersionUID = -8519914602962904799L;

    private Integer iconData;
    private String text;
    private List<Button> buttonList;
    private List<Label> labelList;
    private EocPersonInfo personInfo;

    private List<EocPersonInfo> personInfoList;

    private String personLabel;

    public ProjectCCTaskItemDescription() {
        this.buttonList = new ArrayList<>();
        this.labelList = new ArrayList<>();
    }

    public void addButton(Button button) {
        if (null != button) {
            this.buttonList.add(button);
        }
    }

    public void addLabel(Label label) {
        if (null != label) {
            this.labelList.add(label);
        }
    }

    public Integer getIconData() {
        return iconData;
    }

    public void setIconData(Integer iconData) {
        this.iconData = iconData;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<Button> getButtonList() {
        return buttonList;
    }

    public void setButtonList(List<Button> buttonList) {
        this.buttonList = buttonList;
    }

    public List<Label> getLabelList() {
        return labelList;
    }

    public void setLabelList(List<Label> labelList) {
        this.labelList = labelList;
    }

    public EocPersonInfo getPersonInfo() {
        return personInfo;
    }

    public void setPersonInfo(EocPersonInfo personInfo) {
        this.personInfo = personInfo;
    }

    public List<EocPersonInfo> getPersonInfoList() {
        return personInfoList;
    }

    public void setPersonInfoList(List<EocPersonInfo> personInfoList) {
        this.personInfoList = personInfoList;
    }

    public String getPersonLabel() {
        return personLabel;
    }

    public void setPersonLabel(String personLabel) {
        this.personLabel = personLabel;
    }
}
