package com.digiwin.mobile.mobileuibot.project.service;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppFunctionTouchable;
import com.digiwin.mobile.mobileuibot.core.component.list.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardProgress;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.model.TaskAbnormalReason;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProject;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectCheckTaskResult;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectService
 * @Author: Zaregoto
 * @Date: 2021/4/29 11:26
 */
public interface ProjectService {

    TaskAbnormalReason getTaskAbnormalReason(String locale,
                                             DigiwinAtmcProjectCheckTaskResult digiwinAtmcProjectCheckTaskResult);

    /**
     * 获取项目卡列表-CARD_LIST组件
     *
     * @param apiRequest
     * @param needSearchAndFilter 是否需要搜索、筛选功能
     * @return
     */
    CardList getCardList(ApiRequest apiRequest, boolean needSearchAndFilter);

    /**
     * 获取Athena任务中心的项目卡列表
     *
     * @param apiRequest
     * @return
     */
    List<CardCategory> getProjectList(ApiRequest apiRequest);

    /**
     * 获取可发起项目列表(调用kg后鉴权得到）
     *
     * @param iamUserToken
     * @param locale
     * @return
     */
    List<LaunchableProject> getLaunchableProjectList(String iamUserToken, String tenantId, String locale);

    /**
     * 获取可发起项目列表(返回应用入口列表)
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<AppFunctionTouchable> getLaunchableProjectAppList(String iamUserToken, String tenantId, String locale);

    /**
     * 获取单个项目中控台项目的进度数据
     * <p>
     * <b>若修改访方法名，需要同步修改缓存相关com.digiwin.mobile.mobileuibot.CacheKeyGenerator#generateKey的逻辑</b>
     *
     * @param locale
     * @param iamUserToken
     * @param projectId
     * @param isShare
     * @param pccProjectTypeIsNew
     * @return
     */
    CardProgress getPccProjectProgress(String locale, String iamUserToken, String tenantId, String projectId, Boolean isShare, Boolean pccProjectTypeIsNew);

    /**
     * 获取单个体系云管家项目的进度数据
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param projectId
     * @param isShare
     * @param isException
     * @return
     */
    CardProgress getKscProjectProgress(String locale, String iamUserToken, String tenantId,
                                       String projectId, Boolean isShare, Boolean isException);

    /**
     * 辅助方法：将项目卡片详情转为PCC项目进度数据
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param projectId
     * @param isShare
     * @param tmActivityId
     * @return
     */
    CardProgress transCardDetailToKscProjectProgress(String locale, String iamUserToken, String tenantId,
                                                     String projectId, Boolean isShare, String tmActivityId,
                                                     Boolean isException);

    /**
     * 辅助方法：将项目卡片详情转为PCC项目进度数据
     *
     * @param locale
     * @param iamUserToken
     * @param tenantId
     * @param projectId
     * @param isShare
     * @param tmActivityId
     * @param tmTaskId
     * @return
     */
    CardProgress transCardDetailToPccProjectProgress(String locale, String iamUserToken, String tenantId,
                                                     String projectId, Boolean isShare, String tmActivityId, String tmTaskId);

    /**
     * 项目名称(简体：首字首字母升序，繁体：首字笔画升序)->查阅状态(未读优先)->项目时间(按结束时间升序)
     *
     * @param cardList
     * @param locale
     * @return
     */
    List<Card> sortCardList(List<Card> cardList, String locale);

    /**
     * 处理项目中控台类型项目（包含旧：使用流程引擎，新：使用任务引擎）
     */
    Card handleCenterConsoleProject(DigiwinAtmcProject project, String iamUserToken, String tenantId, String locale, boolean isTeamProject);

    /**
     * 处理标准项目（鼎华的应用使用过的项目）
     */
    Card handleStandardProject(DigiwinAtmcProject project, String iamUserToken, String tenantId, String locale, boolean isTeamProject);

    /**
     * 处理体系云管家
     */
    Card handleSystemCloudKeeperProject(DigiwinAtmcProject project, String iamUserToken, String tenantId, String locale, boolean isTeamProject);

    /**
     * 处理当前不支持的项目
     */
    Card handleCurrentlyNotSupportedProject(DigiwinAtmcProject project, String iamUserToken, String tenantId, String locale, boolean isTeamProject);

    /**
     * 是否是指定的体系云租户
     */
    boolean validIsMatchTenantId(String tenantId);

    /**
     * 按创建时间降序
     */
    List<Card> sortCardListByCreateTime(List<Card> cardList);
}