package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：APP发起项目详情页(模型驱动手动发起项目(tmActivityId=StartNode_*******))</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectCreateDetailBuildBizDataEntryDrivenStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/12/16 11:14
 */
@Slf4j
@Component
public class ProjectCreateDetailBuildBizDataEntryDrivenStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PageSettingService pageSettingService;

    public UiBotModel buildUibotModel(ApiRequest apiRequest) {
        PageSetting pageSetting = this.pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE_DATA_ENTRY_DRIVEN_DETAIL.name());
        UiBotModel pageModel = pageSetting.getPageModel();
        UiBotPageData pageData = pageModel.getPageData();
        for (UiBotLayout layout : pageModel.getLayout()) {
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomGroup.class);
                    CustomGroupContent content = customGroup.getContent();
                    UiBotPageData customPageData = new UiBotPageData();
                    for (UiBotLayout childLayout : content.getLayout()) {
                        if (InputMultiText.COMPONENT_TYPE.equalsIgnoreCase(childLayout.getType())) {
                            customPageData.put(childLayout.getSchema(), InputMultiText.create(localeService.getLanguageValue(apiRequest.getLocale(), "项目介绍"), apiRequest.getRawData().getString(childLayout.getSchema()), false, false, apiRequest.getLocale()));
                        }
                    }
                    content.setPageData(customPageData);
//                    pageData.put(layout.getSchema(), customGroup);
                    break;
                case Empty.COMPONENT_TYPE:
                    pageData.put(layout.getSchema(), Empty.create(localeService.getLanguageValue(apiRequest.getLocale(), "移动端未支持，请至PC端操作"), true));
                    break;
                default:
                    // 什么都不做
                    break;
            }
        }
        return pageModel;
    }
}
