package com.digiwin.mobile.mobileuibot.project.strategy;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectDetailBuildStrategyFactory
 * @Author: Zaregoto
 * @Date: 2021/6/29 21:30
 */
@Component("projectDetailBuildStrategyFactory")
public class ProjectDetailBuildStrategyFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, ProjectDetailBuildStrategy> PROJECTDETAIL_BUILD_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public ProjectDetailBuildStrategy get(String key) {
        return PROJECTDETAIL_BUILD_MAP.get(key);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 ProjectDetailBuildStrategy 注册到 PROJECTDETAIL_BUILD_MAP
        this.appContext.getBeansOfType(ProjectDetailBuildStrategy.class).values().forEach(
                strategy -> PROJECTDETAIL_BUILD_MAP.put(strategy.getProjectDetailType(), strategy));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        this.appContext = applicationContext;
    }
}
