package com.digiwin.mobile.mobileuibot.project.strategy;

import cn.hutool.core.collection.CollUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarDate;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.InputWindowSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleConditionOperatorTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.rule.relation.*;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.PersonnelDutyResp;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.UiBotFieldOption;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.*;


/**
 * 发起项目 页面创建策略类
 *
 * @author zhangjj
 * @date 2021/11/1 0001 9:59
 */
@Component("uiBotModelBuildProjectCreateStrategy")
public class UiBotModelBuildProjectCreateStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildProjectCreateStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private RuleService ruleService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        //录入页面卡片化设置
        if (uiBotModel != null) {
            uiBotModel.setCustomGroup();
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService
                .getProjectTemplateShowByType(apiRequest.getDataId(), apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(), apiRequest.getLocale());
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();

        String dataId = apiRequest.getDataId();
        UiBotPageData appUiBotPageData = pageSetting.getPageModel().getPageData();
        List<UiBotLayout> appUiBotLayoutList = pageSetting.getPageModel().getLayout();

        List<UiBotLayout> newUiBotLayoutList = new ArrayList<>();
        for (UiBotLayout layout : appUiBotLayoutList) {
            if ("${COMPONENT_TYPE}".equalsIgnoreCase(layout.getType())) {
                Optional<UiBotLayout> layoutOptional = pcUiBotModel.getLayout().stream().filter(uiBotLayout ->
                        "FORM_LIST".equalsIgnoreCase(uiBotLayout.getType())
                ).findFirst();
                if (!layoutOptional.isPresent() && !"manual_freightage_start".equalsIgnoreCase(dataId)
                        && !"scan_freightage_start".equalsIgnoreCase(dataId)) {
                    return UiBotModel.emptyUiBotModel();
                }
                if ("itemInformation_create".equals(dataId)) {
                    itemInformationCreateBody(layoutOptional, pcUiBotModel, appUiBotPageData, newUiBotLayoutList, apiRequest, locale, tenantId);
                } else if ("athena_questionAnswer_create".equals(dataId)) {
                    questionAnswerCreateBody(layoutOptional, pcUiBotModel, appUiBotPageData, newUiBotLayoutList, apiRequest, locale);
                } else if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_TM_ACTIVITY_ID.equals(dataId)) {
                    //智慧检料发起
                    Optional<UiBotLayout> optional = pcUiBotModel.getLayout().stream().filter(uiBotLayout ->
                            "ATHENA_TABLE".equalsIgnoreCase(uiBotLayout.getType())
                    ).findFirst();
                    intelligentMaterialInspectionProject(optional, pcUiBotModel, appUiBotPageData, newUiBotLayoutList, apiRequest, locale);
                } else if ("LaunchExcludedProject".equals(dataId)) {
                    launchExcludedProject(layoutOptional, pcUiBotModel, appUiBotPageData, newUiBotLayoutList, apiRequest, locale);
                    pageSetting.getPageModel().setShowMore(true);
                } else if ("transport_change_start".equalsIgnoreCase(dataId)) {
                    receiptScheduleChangeCreateBody(layoutOptional, pcUiBotModel, appUiBotPageData, newUiBotLayoutList, apiRequest, locale);
                } else if ("manual_freightage_start".equalsIgnoreCase(dataId)) {
                    freightageStartCreateBody(appUiBotPageData, newUiBotLayoutList, apiRequest, locale);
                } else if ("scan_freightage_start".equalsIgnoreCase(dataId)) {
                    scanStartCreateBody(appUiBotPageData, newUiBotLayoutList, apiRequest, locale);
                }
            } else if (BottomButtonDigiwinAthena.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                List<UiBotAction> actionList = pcUiBotModel.getActions();
                if (actionList != null && actionList.size() > 0) {
                    newUiBotLayoutList.add(layout);
                    BottomButtonList bottomButtonList = new BottomButtonList();
                    actionList.stream().forEach(uiBotAction -> {
                        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
                        //设置IsCheckButton属性值
                        BottomButtonDigiwinAthena.setIsCheckButtonMethod(uiBotAction, buttonDigiwinAthena);
                        buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
                        buttonDigiwinAthena.setName(uiBotAction.getTitle());
                        Action<Map<String, Object>> action = new Action();
                        action.setType(ActionTypeEnum.CALL_API_OPEN_SUCCESS_PAGE.getValue());
                        action.setSuccessMsg(LocaleUtil.getMobileTextByKey(locale, "项目创建成功"));
                        Map<String, Object> map = new HashMap<>(2);
                        map.put("action", uiBotAction);
                        map.put("data", pcUiBotModel.getPageData());
                        action.setRawData(map);
                        buttonDigiwinAthena.setAction(action);
                        bottomButtonList.add(buttonDigiwinAthena);
                    });
                    appUiBotPageData.put(layout.getSchema(), bottomButtonList);
                }
            } else {
                newUiBotLayoutList.add(layout);
            }
        }
        pageSetting.getPageModel().setLayout(newUiBotLayoutList);

        return pageSetting.getPageModel();
    }

    private void scanStartCreateBody(UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList,
                                     ApiRequest apiRequest, String locale) {
        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> data = new HashMap<>(4);
        data.put("source_no", rawData.get("source_no"));
        String deliveryAddressId = "";
        String receiptAddressId = "";
        if (rawData.get("delivery_address_id") != null && rawData.get("receipt_address_id") != null
                && StringUtils.hasLength((String) rawData.get("delivery_address_id"))
                && StringUtils.hasLength((String) rawData.get("receipt_address_id"))
        ) {
            //物流信息
            UiBotLayout customGroupLogistics = new UiBotLayout();
            customGroupLogistics.setType(CustomGroup.COMPONENT_TYPE);
            customGroupLogistics.setSchema("logistics");
            newUiBotLayoutList.add(customGroupLogistics);
            deliveryAddressId = (String) rawData.get("delivery_address_id");
            receiptAddressId = (String) rawData.get("receipt_address_id");
            appUiBotPageData.put("logistics", CustomGroup.buildLogisticsGroup(locale,
                    digiwinEspProxyService.getUserAddress(apiRequest.getIamUserToken(),
                            apiRequest.getTenantId(), apiRequest.getLocale(), deliveryAddressId),
                    digiwinEspProxyService.getUserAddress(apiRequest.getIamUserToken(),
                            apiRequest.getTenantId(), apiRequest.getLocale(), receiptAddressId),
                    false));
        }
        data.put("delivery_address_id", deliveryAddressId);
        data.put("receipt_address_id", receiptAddressId);

        String planArrivalDate = "";
        if (rawData.get("plan_arrival_date") != null && StringUtils.hasLength((String) rawData.get("plan_arrival_date"))) {
            //预计送货日期
            UiBotLayout customGroupPlanArrivalDate = new UiBotLayout();
            customGroupPlanArrivalDate.setType(CustomGroup.COMPONENT_TYPE);
            customGroupPlanArrivalDate.setSchema("planArrivalDate");
            newUiBotLayoutList.add(customGroupPlanArrivalDate);
            appUiBotPageData.put("planArrivalDate", new CustomGroup().buildAppointmentDeliveryDate(locale, new UiBotLayout("planArrivalDate", Field.COMPONENT_TYPE),
                    localeService.getLanguageValue(locale, "预计送货日期"), true, (String) rawData.get("plan_arrival_date")));
            planArrivalDate = (String) rawData.get("plan_arrival_date");
        }
        data.put("plan_arrival_date", planArrivalDate);

        //货物清单列表
        UiBotLayout cargoInformationLayout = new UiBotLayout();
        cargoInformationLayout.setType(ZtbViewList.COMPONENT_TYPE);
        cargoInformationLayout.setSchema("cargoInformation");
        newUiBotLayoutList.add(cargoInformationLayout);
        ZtbViewList ztbViewList = new ZtbViewList();
        ztbViewList.setTitle(localeService.getLanguageValue(locale, "货物清单"));
        ztbViewList.setSchema("cargoInformation");
        appUiBotPageData.put("cargoInformation", ZtbViewList.create(ztbViewList, (List<Map<String, Object>>) rawData.get("delivery_detail"),
                localeService, locale));

        //录入按钮
        UiBotLayout button = new UiBotLayout();
        button.setSchema("button");
        button.setType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
        newUiBotLayoutList.add(button);
        BottomButtonList bottomButtonList = new BottomButtonList();
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonDigiwinAthena.setName(localeService.getLanguageValue(locale, "提交"));
        Action<Map<String, Object>> action = new Action();
        action.setType(ActionTypeEnum.CALL_API_OPEN_SUCCESS_PAGE.getValue());
        action.setSuccessMsg(LocaleUtil.getMobileTextByKey(locale, "项目创建成功"));
        Map<String, Object> actionRawData = new HashMap<>(3);
        actionRawData.put("biz_id", "ZTB");
        actionRawData.put("page_id", PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE);
        actionRawData.put("dataId", "scan_freightage_start");
        actionRawData.put("data", data);
        action.setRawData(actionRawData);
        buttonDigiwinAthena.setAction(action);
        bottomButtonList.add(buttonDigiwinAthena);
        appUiBotPageData.put("button", bottomButtonList);
    }

    private void freightageStartCreateBody(UiBotPageData appUiBotPageData,
                                           List<UiBotLayout> newUiBotLayoutList,
                                           ApiRequest apiRequest, String locale) {
        //物流信息
        UiBotLayout customGroupLogistics = new UiBotLayout();
        customGroupLogistics.setType(CustomGroup.COMPONENT_TYPE);
        customGroupLogistics.setSchema("logistics");
        newUiBotLayoutList.add(customGroupLogistics);
        appUiBotPageData.put("logistics", CustomGroup.buildEmptyLogisticsGroup(localeService, locale, true));

        //预计送货日期
        UiBotLayout customGroupPlanArrivalDate = new UiBotLayout();
        customGroupPlanArrivalDate.setType(CustomGroup.COMPONENT_TYPE);
        customGroupPlanArrivalDate.setSchema("planArrivalDate");
        newUiBotLayoutList.add(customGroupPlanArrivalDate);
        appUiBotPageData.put("planArrivalDate", CustomGroup.buildEmptyAppointmentDeliveryDate(locale,
                localeService.getLanguageValue(locale, "预计送货日期")));

        //标准录入组件
        UiBotLayout customGroupInputStandardEntry = new UiBotLayout();
        customGroupInputStandardEntry.setType(CustomGroup.COMPONENT_TYPE);
        customGroupInputStandardEntry.setSchema("delivery_detail_list");
        newUiBotLayoutList.add(customGroupInputStandardEntry);
        appUiBotPageData.put("delivery_detail_list", CustomGroup.buildEmptyInputZtbCargoInfoEntry(locale, localeService));

        //录入按钮
        UiBotLayout button = new UiBotLayout();
        button.setSchema("button");
        button.setType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
        newUiBotLayoutList.add(button);
        BottomButtonList bottomButtonList = new BottomButtonList();
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
        buttonDigiwinAthena.setName(localeService.getLanguageValue(locale, "提交"));
        Action<Map<String, Object>> action = new Action();
        action.setType(ActionTypeEnum.CALL_API_OPEN_SUCCESS_PAGE.getValue());
        action.setSuccessMsg(LocaleUtil.getMobileTextByKey(locale, "项目创建成功"));
        Map<String, Object> rawData = new HashMap<>(3);
        rawData.put("biz_id", "ZTB");
        rawData.put("page_id", PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE);
        rawData.put("dataId", "manual_freightage_start");
        action.setRawData(rawData);
        buttonDigiwinAthena.setAction(action);
        bottomButtonList.add(buttonDigiwinAthena);
        appUiBotPageData.put("button", bottomButtonList);
    }

    /**
     * 收货排程更改的创建
     *
     * @param layoutOptional
     * @param pcUiBotModel
     * @param appUiBotPageData
     * @param newUiBotLayoutList
     * @param apiRequest
     * @param locale
     */
    private void receiptScheduleChangeCreateBody(Optional<UiBotLayout> layoutOptional, UiBotModel pcUiBotModel, UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList, ApiRequest apiRequest, String locale) {
        if (layoutOptional.isPresent()) {
            UiBotLayout uiBotLayout = layoutOptional.get();
            List<UiBotLayout> groupFieldLayoutList = uiBotLayout.getGroup();
            if (groupFieldLayoutList != null) {
                for (UiBotLayout groupFieldLayout : groupFieldLayoutList) {
                    if (PcLayoutEnum.FORM_LIST.getValue().equalsIgnoreCase(groupFieldLayout.getType())) {
                        if (groupFieldLayout.getGroup() != null && groupFieldLayout.getGroup().size() > 0) {
                            CustomGroup customGroup = new CustomGroup();
                            customGroup.setName("");
                            CustomGroupContent content = getReceiptScheduleChangeCustomGroupContent(groupFieldLayout.getGroup(), pcUiBotModel, apiRequest, appUiBotPageData, newUiBotLayoutList);
                            customGroup.setContent(content);
                            if (!CollectionUtils.isEmpty(customGroup.getContent().getLayout())) {
                                appUiBotPageData.put(groupFieldLayout.getId(), customGroup);
                                newUiBotLayoutList.add(new UiBotLayout(groupFieldLayout.getId(), CustomGroup.COMPONENT_TYPE, "body"));
                            }
                        }
                    }
                }
            }
        }
    }

    private CustomGroupContent getReceiptScheduleChangeCustomGroupContent(List<UiBotLayout> pcUiBotFieldLayoutList, UiBotModel pcUiBotModel, ApiRequest apiRequest, UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList) {
        CustomGroupContent content = new CustomGroupContent();
        if (pcUiBotFieldLayoutList == null || pcUiBotFieldLayoutList.isEmpty()) {
            return content;
        }
        for (UiBotLayout uiBotLayout : pcUiBotFieldLayoutList) {
            UiBotLayout layout = new UiBotLayout();
            if (PcModuleEnum.OPERATION_EDITOR.getValue().equals(uiBotLayout.getType())) {
                layout.setType(InputWindowSingleSelect.COMPONENT_TYPE);
                layout.setSchema(uiBotLayout.getSchema());
                //由于接口没有给headerName
                appUiBotPageData.put(uiBotLayout.getSchema(), InputWindowSingleSelect.create(uiBotLayout, true,
                        AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                        pcUiBotModel, true,
                        (Map<String, Object>) pcUiBotModel.getPageData().get(pcUiBotModel.getLayout().get(0).getSchema()), apiRequest));
            }
            newUiBotLayoutList.add(layout);
        }
        return content;
    }

    private void intelligentMaterialInspectionProject(Optional<UiBotLayout> layoutOptional, UiBotModel pcUiBotModel, UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList, ApiRequest apiRequest, String locale) {
        if (layoutOptional.isPresent()) {
            UiBotLayout uiBotLayout = layoutOptional.get();
            List<UiBotTableColumnDefinition> columnDefs = uiBotLayout.getColumnDefs();
            List<UiBotTableColumn> columnList = new ArrayList<>();
            if (CollUtil.isNotEmpty(columnDefs)) {
                columnDefs.forEach(columns -> columnList.add(columns.getColumns().get(0)));
                CustomGroup customGroup = new CustomGroup();
                customGroup.setName("");
                CustomGroupContent content = new CustomGroupContent();
                List<UiBotLayout> layoutList = new ArrayList<>();
                UiBotPageData pageData = new UiBotPageData();
                content.setLayout(layoutList);
                content.setPageData(pageData);
                for (UiBotTableColumn column : columnList) {
                    if (column.getType().equals("OPERATION_EDITOR")) {
                        uiBotLayout.setSchema(column.getSchema());
                        uiBotLayout.setLabel(column.getHeaderName());
                        Map<String, Object> data = new HashMap<>(1);
                        data.put("pcUiBotModel", pcUiBotModel);
                        InputWindowMultiSelect inputWindowMultiSelect =
                                InputWindowMultiSelect.create(
                                        uiBotLayout,
                                        true,
                                        AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                        pcUiBotModel,
                                        true,
                                        (Map<String, Object>) pcUiBotModel.getPageData().get(pcUiBotModel.getLayout().get(0).getSchema()), apiRequest, locale);
                        pageData.put(uiBotLayout.getSchema(), inputWindowMultiSelect);
                        layoutList.add(new UiBotLayout(uiBotLayout.getSchema(), InputWindowMultiSelect.COMPONENT_TYPE, "body"));
                        break;
                    }
                }
                customGroup.setContent(content);
                if (!CollectionUtils.isEmpty(customGroup.getContent().getLayout())) {
                    appUiBotPageData.put(uiBotLayout.getSchema(), customGroup);
                    newUiBotLayoutList.add(new UiBotLayout(uiBotLayout.getSchema(), CustomGroup.COMPONENT_TYPE, "body"));
                }
            }
        }
    }

    private void launchExcludedProject(Optional<UiBotLayout> layoutOptional, UiBotModel pcUiBotModel, UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList, ApiRequest apiRequest, String locale) {
        if (layoutOptional.isPresent()) {
            UiBotLayout uiBotLayout = layoutOptional.get();
            List<Rule> mobileRuleList = ruleService.findByRulePath(uiBotLayout.getSchema());
            List<UiBotLayout> groupFieldLayoutList = uiBotLayout.getGroup();
            if (groupFieldLayoutList != null) {
                CustomGroup customGroup = new CustomGroup();
                customGroup.setName("");
                CustomGroupContent content = getLaunchExcludedProjectCustomGroupContent(
                        groupFieldLayoutList, pcUiBotModel.getExecuteContext(), apiRequest,
                        locale, mobileRuleList, (Map<String, Object>) pcUiBotModel.getPageData().get(uiBotLayout.getSchema()));
                customGroup.setContent(content);
                if (!CollectionUtils.isEmpty(customGroup.getContent().getLayout())) {
                    appUiBotPageData.put(uiBotLayout.getSchema(), customGroup);
                    newUiBotLayoutList.add(new UiBotLayout(uiBotLayout.getSchema(), CustomGroup.COMPONENT_TYPE, "body"));
                }
            }
        }
    }

    private CustomGroupContent getLaunchExcludedProjectCustomGroupContent(List<UiBotLayout> groupFieldLayoutList,
                                                                          UiBotExecuteContext executeContext, ApiRequest apiRequest, String locale,
                                                                          List<Rule> mobileRuleList, Map<String, Object> pcPageData) {

        CustomGroupContent content = new CustomGroupContent();
        if (groupFieldLayoutList == null || groupFieldLayoutList.isEmpty()) {
            return content;
        }

        List<PersonnelDutyResp> list = new ArrayList<>();
//        List<Map<String, Object>> personnelInfoGet = new ArrayList<>();
        // 是否为部门主管
        Boolean deptDirector = false;
        //班组信息
//        List<Map<String, Object>> teamInfos = new ArrayList<>();

        List<UiBotLayout> layoutList = new ArrayList<>();
        UiBotPageData pageData = new UiBotPageData();
        content.setLayout(layoutList);
        content.setPageData(pageData);
//        Map<String, Object> headerParams = new HashMap<>(2);
        List<ActionSubmitParam> submitParams = apiRequest.getSubmitParam();
        // 是否清空班组默认值
        boolean isClearTeam = false;
        for (UiBotLayout groupFieldLayout : groupFieldLayoutList) {
            String schema = groupFieldLayout.getSchema();
            String title = groupFieldLayout.getHeaderName();
            switch (groupFieldLayout.getType()) {
                //雲端營運據點
                case "EOC_SELECT":
                    //公司别
                    List<Map<String, Object>> companys = digiwinEocProxyService.getCompany(apiRequest.getIamUserToken());
                    //工厂别
                    List<Map<String, Object>> factorys = digiwinEocProxyService.getFactory(apiRequest.getIamUserToken());
                    List<String> schemas = groupFieldLayout.getSchemas();
                    String secondSchema = "";
                    for (String s : schemas) {
                        if (!s.equals(schema)) {
                            secondSchema = s;
                        }
                    }
                    InputCascade inputCascade = InputCascade.create(companys, factorys, schema, secondSchema,
                            title, 2, InputCascadeTypeEnum.PARSE.getValue(),
                            InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue(), locale);
                    if (!CollectionUtils.isEmpty(submitParams)) {
                        Optional<ActionSubmitParam> param = submitParams.stream().filter(actionSubmitParam -> schema.equals(actionSubmitParam.getSchema())).findFirst();
                        if (param.isPresent()) {
                            List<InputCascade.DefaultSelect> selectList = JsonUtil.objectToJavaObject(param.get().getParams(),
                                    new TypeReference<List<InputCascade.DefaultSelect>>() {
                                    });
                            if (!CollectionUtils.isEmpty(selectList)) {
                                inputCascade.setDefaultSelect(selectList.get(0).setChild(selectList.get(1)));
                            }
//                            headerParams.put("eoc_company_id", selectList.get(0).getId());
//                            headerParams.put("eoc_site_id", selectList.get(0).getChild().getId());
//                            teamInfos = digiwinEspProxyService.getCurrentTeamInfo(apiRequest.getIamUserToken(),
//                                    apiRequest.getTenantId(), apiRequest.getLocale(), headerParams);
                        }
                    }
                    String selectParentId = Optional.ofNullable(inputCascade.getDefaultSelect()).map(InputCascade.DefaultSelect::getId).orElse("");
                    String selectChildId = Optional.ofNullable(inputCascade.getDefaultSelect()).map(InputCascade.DefaultSelect::getChild).map(InputCascade.DefaultSelect::getId).orElse("");
                    list = digiwinEspProxyService
                            .personnelDutyGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                                    selectParentId, selectChildId);
                    deptDirector = digiwinEspProxyService.isDeptDirector(list);

                    // 判断是否切换不同据点，设置清空班组默认数据
                    Boolean isConverEoc = Optional.ofNullable(apiRequest.getRawData().getBoolean("isConverEoc")).orElse(false);
                    if (isConverEoc) {
                        String level1 = apiRequest.getRawData().getString("level_1");
                        String level2 = apiRequest.getRawData().getString("level_2");
                        if (!selectParentId.equals(level1)
                                || !selectChildId.equals(level2)) {
                            isClearTeam = true;
                        }
                    }

                    // 改变据点 刷新页面
                    Action<Map<String, Object>> submitAction = new Action<>();
                    submitAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.toString());
                    submitAction.setJumpPageTitle("");
                    submitAction.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                    Map<String, Object> map = new HashMap<>();
                    map.put("isConverEoc", true);
                    map.put("level_1", selectParentId);
                    map.put("level_2", selectChildId);
                    submitAction.setRawData(map);
                    inputCascade.setSubmitAction(submitAction);
                    inputCascade.setIsSubmit(true);
                    pageData.put(schema, inputCascade);
                    layoutList.add(new UiBotLayout(schema, InputCascade.COMPONENT_TYPE));
                    break;
                case "OPERATION_EDITOR":
                    if (Objects.equals("except_name", schema)) {
                        // 除外原因名稱
                        pageData.put(schema, InputWindowSingleSelect.create(groupFieldLayout, true,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                locale, executeContext, false, null, schema, null));
                        layoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE));
                        break;
                    }
                    if (Objects.equals("team_name", schema)) {
                        //班组名称
                        String otherschema = "";
                        for (String s : groupFieldLayout.getRelationSchemas()) {
                            if (!s.equals(schema)) {
                                otherschema = s;
                            }
                        }
                        InputWindowSingleSelect select = null;
                        if (!CollectionUtils.isEmpty(submitParams)) {
                            Optional<ActionSubmitParam> teamNameParam = submitParams.stream().filter(actionSubmitParam -> schema.equals(actionSubmitParam.getSchema())).findFirst();
                            if (teamNameParam.isPresent()) {
                                select = JsonUtil.objectToJavaObject(teamNameParam.get().getParams(), InputWindowSingleSelect.class);
//                                Map<String, Object> params = new HashMap<>(2);
//                                params.put("has_team_info", true);
//                                List<Map<String, Object>> personnelList = new ArrayList<>(1);
//                                Map<String, Object> personner = new HashMap<>(1);
//                                personner.put(otherschema, select.getSelectId());
//                                personnelList.add(personner);
//                                params.put("team_personnel_list", personnelList);
//                                personnelInfoGet = digiwinEspProxyService.teamPersonnelInfoGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), params, headerParams);
                            }
                        }
                        // 主管可编辑
                        if (deptDirector) {
                            String selectId = "";
                            String showValue = "";
                            if (!isClearTeam && select != null) {
                                selectId = select.getSelectId();
                                showValue = select.getTitle();
                            }
                            Map<String, Object> rawData = new HashMap<>(16);
                            InputWindowSingleSelect windowSingleSelect = InputWindowSingleSelect.create(groupFieldLayout, false,
                                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                            locale, executeContext, true, null, schema, null)
                                    .setDefaultSelectId(selectId)
                                    .setDefaultShowValue(showValue);
                            if (select != null && !CollectionUtils.isEmpty(select.getDetail())) {
                                windowSingleSelect.setDetail(select.getDetail());
                            } else {
                                Map<String, Object> detail = new HashMap<>(2);
                                detail.put(schema, showValue);
                                detail.put(otherschema, selectId);
                                windowSingleSelect.setDetail(detail);
                            }
                            rawData.putAll(Optional.ofNullable(windowSingleSelect.getRawData()).orElse(new HashMap<>(2)));
                            pageData.put(schema, windowSingleSelect.setRawData(rawData));
                            layoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE));

                            break;
                        } else {
                            String value = "";
                            String hideValue = "";
//                            if (!CollectionUtils.isEmpty(teamInfos)) {
//                                value = (String) teamInfos.get(0).get(schema);
//                                hideValue = (String) teamInfos.get(0).get(otherschema);
//                            }
                            Field field = Field.create(title, value);
                            field.setHideValue(hideValue);
                            pageData.put(schema, field);
                            layoutList.add(new UiBotLayout(schema, Field.COMPONENT_TYPE));
                            break;
                        }
                    }
                    if (Objects.equals("reporter_name", schema)) {
                        // 人员名称
                        if (deptDirector) {
                            Map<String, Object> rawData = new HashMap<>(16);
//                            String selectId;
//                            String showValue;
//                            if (CollectionUtils.isEmpty(personnelInfoGet)) {
//                                selectId = list.get(0).getPersonnelNo();
//                                showValue = list.get(0).getPersonnelName();
//                            } else {
//                                selectId = (String) personnelInfoGet.get(0).get("team_personnel_no");
//                                showValue = (String) personnelInfoGet.get(0).get("team_personnel_name");
//                            }
                            InputWindowSingleSelect windowSingleSelect = InputWindowSingleSelect.create(groupFieldLayout, true,
                                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                            locale, executeContext, true, null, schema, null)
                                    .setDefaultSelectId(list.get(0).getPersonnelNo())
                                    .setDefaultShowValue(list.get(0).getPersonnelName());
                            String otherschema = "";
                            for (String s : groupFieldLayout.getRelationSchemas()) {
                                if (!s.equals(schema)) {
                                    otherschema = s;
                                }
                            }
                            Map<String, Object> detail = new HashMap<>(2);
                            detail.put(schema, list.get(0).getPersonnelName());
                            detail.put(otherschema, list.get(0).getPersonnelNo());
                            windowSingleSelect.setDetail(detail);
                            rawData.putAll(Optional.ofNullable(windowSingleSelect.getRawData()).orElse(new HashMap<>()));
                            pageData.put(schema, windowSingleSelect.setRawData(rawData));
                            layoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE));
                            break;
                        }
                        Field field = Field.create(title, list.get(0).getPersonnelName());
                        field.setHideValue(list.get(0).getPersonnelNo());
                        pageData.put(schema, field);
                        layoutList.add(new UiBotLayout(schema, Field.COMPONENT_TYPE));
                        break;
                    }
                    break;
                case "SELECT":
                    if (Objects.equals("except_property", schema)) {
                        //性质
                        SingleSelectList singleSelectList = new SingleSelectList();
                        singleSelectList.setStyle(SingleSelectListTypeEnum.BOTTOM_OPTION.getValue());
                        singleSelectList.setTitle(groupFieldLayout.getHeaderName());
                        singleSelectList.setRequired(true);
                        List<SingleSelectListOption> optionList = new ArrayList<>();
                        if (CollectionUtils.isEmpty(groupFieldLayout.getOptions())) {
                            break;
                        }
                        for (UiBotFieldOption option : groupFieldLayout.getOptions()) {
                            String value = String.valueOf(option.getValue());
                            SingleSelectListOption optionOption = new SingleSelectListOption();
                            if ("2".equalsIgnoreCase(value)) {
                                optionOption.setSelected(true);
                            }
                            optionOption.setId(String.valueOf(option.getValue()));
                            optionOption.setText(option.getTitle());
                            optionList.add(optionOption);
                        }
                        singleSelectList.setOptionList(optionList);
                        pageData.put(schema, singleSelectList);
                        layoutList.add(new UiBotLayout(schema, SingleSelectList.COMPONENT_TYPE));
                    }
                    break;
                // 日期
                case "DATEPICKER":
                    String maxDay = "";
                    String minDay = this.getMinDay(deptDirector, apiRequest);
                    pageData.put(schema, InputDateTimePicker.create(groupFieldLayout, true, locale, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType(), maxDay, minDay, mobileRuleList));
                    layoutList.add(new UiBotLayout(schema, InputDateTimePicker.COMPONENT_TYPE));
                    break;
                // 时间范围
                case "TIME_RANGE":
                    pageData.put("time_start", InputDateTimePicker.create("time_start", true, locale, InputDateTimePickerTypeEnum.HOUR_MINUTE.getType(), groupFieldLayout.getHeaderName() + "-" + LocaleUtil.getMobileTextByKey(locale, "计划开始")));
                    pageData.put("time_end", InputDateTimePicker.create("time_end", true, locale, InputDateTimePickerTypeEnum.HOUR_MINUTE.getType(), groupFieldLayout.getHeaderName() + "-" + LocaleUtil.getMobileTextByKey(locale, "计划结束")));
                    layoutList.add(new UiBotLayout("time_start", InputDateTimePicker.COMPONENT_TYPE));
                    layoutList.add(new UiBotLayout("time_end", InputDateTimePicker.COMPONENT_TYPE));
                    break;
                default:
                    break;
            }
        }
        //TODO 由于目前web端还没有做备注的字段，所以移动先写死，后面web端做好了在移位置
        layoutList.add(new UiBotLayout("remark", InputMultiText.COMPONENT_TYPE));
        pageData.put("remark", InputMultiText.create("remark",
                localeService.getLanguageValue(locale, "备注"), "", true, false,
                false, locale, 255));
        return content;
    }

    /**
     * 除外回报 获取最小时间日期
     * —般员工： 可挥日期能量:系统日期(含堂天)以後
     * 主管： 依制燮数.工畤捕填缓街日般定，判断除外回报可神填的日期愿間
     * 1.若楼制夔敷.工时神填缓衡日=0， 表示不允件跨月浦填除外回鞑﹐则可遐挥日期鲍圉:常月1虢(含1虢)以後
     * 2.若橙制燮数.工陡捕填缓街日= 99 , 表示不卡控,则可H挥日期笔量:1900/01/01
     * 3.若系统日期.日<=数.工陡浦填缓街日， 则可挥日期鲍凰:上固月1虢(含1虢堂天)以俊；反之﹐则可遐挥日期鲍凰:堂月1虢(含1虢誉天)以後睾例:
     * 例缓冲日：5
     * 系统日期→开始可选范围
     * 2023/01/30 → 2023/01/01~未来
     * <p>
     * 2023/01/05 → 2022/12/01~未来
     * <p>
     * 2023/02/01 → 2023/01/01~未来
     *
     * @param deptDirector 是否主管
     * @param apiRequest
     * @return 主管:yyyy-MM-dd  一般员工:yyyy-MM-dd HH:mm
     */
    private String getMinDay(Boolean deptDirector, ApiRequest apiRequest) {
        String time = " 00:00";
        if (!deptDirector) {
            // 一般员工，只能选系统日之后的日期
            return DateTimeUtil.getTodayByPattern("yyyy-MM-dd") + time;
        }
        final Integer bufferDay = this.getBufferDay(apiRequest);
        if (bufferDay == 0) {
            return DateTimeUtil.firstDayOfPreviousMonth("yyyy-MM-dd", 0) + time;
        }
        if (bufferDay - 99 == 0) {
            return "1900-01-01" + time;
        }
        int day = LocalDate.now().getDayOfMonth();
        if (day - bufferDay <= 0) {
            return DateTimeUtil.firstDayOfPreviousMonth("yyyy-MM-dd", 1) + time;
        }
        return DateTimeUtil.firstDayOfPreviousMonth("yyyy-MM-dd", 0) + time;
    }

    /**
     * 除外回报 获取缓冲日
     *
     * @param apiRequest
     */
    private Integer getBufferDay(ApiRequest apiRequest) {
        Map<String, Object> mechanismParamValueMap = digiwinKnowledgeMapsProxyService
                .getMechanismParamValue(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                        apiRequest.getLocale(), KnowledgeMapsConstant.APC_SKIP_FILL_BUFFER_DAYS);
        if (null == mechanismParamValueMap) {
            return 0;
        }
        Object bufferDays = mechanismParamValueMap.get(KnowledgeMapsConstant.APC_SKIP_FILL_BUFFER_DAYS);
        if (null == bufferDays) {
            return 0;
        }
        BigDecimal bigDecimal = new BigDecimal(bufferDays.toString());
        return bigDecimal.intValue();
    }


    /**
     * 问题快反表单数据
     *
     * @param layoutOptional
     * @param pcUiBotModel
     * @param appUiBotPageData
     * @param newUiBotLayoutList
     * @param apiRequest
     * @param locale
     */
    private void questionAnswerCreateBody(Optional<UiBotLayout> layoutOptional, UiBotModel pcUiBotModel, UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList, ApiRequest apiRequest, String locale) {
        List<UiBotRule> uiBotRuleList = pcUiBotModel.getRules();
//        List<UiBotField> uiBotFieldList = layoutOptional.get().decomposeFieldsWithPcFormList(null);
        if (layoutOptional.isPresent()) {
            UiBotLayout uiBotLayout = layoutOptional.get();
            List<UiBotLayout> groupFieldLayoutList = uiBotLayout.getGroup();
            if (groupFieldLayoutList != null) {
                //获取交付设计器集成参数
                Map<String, Object> deliveryDesignerMap = digiwinKnowledgeMapsProxyService.getDeliveryDesignerMap(apiRequest.getIamUserToken(), apiRequest.getTenantId());
                for (UiBotLayout groupFieldLayout : groupFieldLayoutList) {
                    if ("FORM_LIST".equalsIgnoreCase(groupFieldLayout.getType())) {
                        if (groupFieldLayout.getGroup() != null && groupFieldLayout.getGroup().size() > 0) {
                            CustomGroup customGroup = new CustomGroup();
                            customGroup.setName(groupFieldLayout.getTitle());
                            CustomGroupContent content = getCustomGroupContent(groupFieldLayout.getGroup(), uiBotRuleList, locale, pcUiBotModel.getExecuteContext(), deliveryDesignerMap);
                            customGroup.setContent(content);
                            if (!CollectionUtils.isEmpty(customGroup.getContent().getLayout())) {
                                appUiBotPageData.put(groupFieldLayout.getId(), customGroup);
                                newUiBotLayoutList.add(new UiBotLayout(groupFieldLayout.getId(), CustomGroup.COMPONENT_TYPE, "body"));
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 问题快反pc组件转为CustomGroupContent
     *
     * @param pcUiBotFieldLayoutList
     * @return
     */
    private CustomGroupContent getCustomGroupContent(List<UiBotLayout> pcUiBotFieldLayoutList, List<UiBotRule> ruleList
            , String locale, UiBotExecuteContext executeContext, Map<String, Object> deliveryDesignerMap) {

        String integrationParameterList = String.valueOf(deliveryDesignerMap.get("Integration_parameters"));
        //项目集成消息标识
        String projectInfoRequired = String.valueOf(deliveryDesignerMap.get("project_info_required"));
        //项目人员权限选择
        String projectPersonnelRequired = String.valueOf(deliveryDesignerMap.get("project_personnel_authority"));
        //设备名称是否隐藏选择
        String deviceNameHiddenRequired = String.valueOf(deliveryDesignerMap.get("device_name_hidden"));
        //现场处理说明是否必填
        String fieldHandlingInstructionsRequired = String.valueOf(deliveryDesignerMap.get("field_handling_instructions_required"));
        //供应商是否控制仅外部可维护 Y:开启 N:不开启
        String supplierControlsExternalMaintenance = String.valueOf(deliveryDesignerMap.get("supplier_controls_external_maintenance"));
        //供应商来源 : ERP,鼎捷云
        String supplierSource = String.valueOf(deliveryDesignerMap.get("supplier_source"));

        CustomGroupContent content = new CustomGroupContent();
        if (pcUiBotFieldLayoutList == null || pcUiBotFieldLayoutList.isEmpty()) {
            return content;
        }
        List<UiBotLayout> layoutList = new ArrayList<>();
        UiBotPageData pageData = new UiBotPageData();
        content.setLayout(layoutList);
        content.setPageData(pageData);
        for (UiBotLayout uibotFieldLayout : pcUiBotFieldLayoutList) {

            Optional<UiBotRule> ruleOptional = ruleList.stream().filter(uiBotRule -> uibotFieldLayout.getSchema().equalsIgnoreCase(uiBotRule.getSchema())).findFirst();
            UiBotRule uiBotRule = ruleOptional.isPresent() ? ruleOptional.get() : null;
            String schema = uibotFieldLayout.getSchema();
            switch (uibotFieldLayout.getType()) {
                case "SELECT":
                    ButtonSingleSelect buttonSingleSelect = ButtonSingleSelect.create(uibotFieldLayout, ruleList);
                    //问题归属默认选中第一个选项
                    if ("question_attribution_no".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        buttonSingleSelect.setFirstDefaultOption();
                    }
                    //重要性、紧急度初始不可编辑，设置enable为false
                    if ("important".equalsIgnoreCase(uibotFieldLayout.getSchema())
                            || "urgency".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        buttonSingleSelect.setEnable(false);
                    }
                    customRelationRule(buttonSingleSelect);
                    pageData.put(schema, buttonSingleSelect);
                    layoutList.add(new UiBotLayout(schema, ButtonSingleSelect.COMPONENT_TYPE));
                    break;
                case "OPERATION_EDITOR":
                    InputWindowSingleSelect windowSingleSelect =
                            InputWindowSingleSelect.create(uibotFieldLayout, uiBotRule,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema,
                                    locale, executeContext);
                    if ("question_source_name".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        Map<String, Object> rawData = windowSingleSelect.getRawData();
                        if (CollectionUtils.isEmpty(rawData)) {
                            rawData = new HashMap<>(2);
                        }
                        rawData.put("isQuestion", true);
                        rawData.put("type", "question_source_name");
                        windowSingleSelect.setRawData(rawData);
                    }
                    //问题分类、发生阶段、初始不可编辑，设置enable为false
                    if ("question_classification_name".equalsIgnoreCase(uibotFieldLayout.getSchema())
                            || "occur_stage_name".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        windowSingleSelect.setEnable(false);
                    }
                    //问题提出人默认选中当前用户
                    if ("question_proposer_name".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        windowSingleSelect.setDefaultSelectId("${CURRENT_EOC_ID}");
                    }
                    //问题来源
                    if ("question_attribution_name".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        Map<String, Object> rawData = windowSingleSelect.getRawData();
                        if (CollectionUtils.isEmpty(rawData)) {
                            rawData = new HashMap<>(1);
                        }
                        rawData.put("supplierControlsExternalMaintenance", supplierControlsExternalMaintenance);
                        windowSingleSelect.setRawData(rawData);
                    }

                    //供应商
                    if ("supplier".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        Map<String, Object> rawData = windowSingleSelect.getRawData();
                        if (CollectionUtils.isEmpty(rawData)) {
                            rawData = new HashMap<>(2);
                        }
                        rawData.put("type", "supplier");
                        rawData.put("isQuestion", true);
                        rawData.put("supplierSource", supplierSource);
                        windowSingleSelect.setRequired(false);
                        windowSingleSelect.setIsVagueSearch(true);
                        windowSingleSelect.setMaxTitleNum(5);
                        windowSingleSelect.setMaxSubtitleNum(5);
                        if ("Y".equalsIgnoreCase(supplierControlsExternalMaintenance)) {
                            //此处设为false，由问题来源开窗单选联动规则控制
                            windowSingleSelect.setIsEdit(false);
                            windowSingleSelect.setEnable(false);
                        }
                        //「交付设计器.供应商是否控制仅外部可维护」=不开启,供应商不受问题来源取值限制，始终支持开窗和手输
                        if ("N".equalsIgnoreCase(supplierControlsExternalMaintenance)) {
                            windowSingleSelect.setPlaceholder(LocaleUtil.getMobileTextByKey(locale, "请输入选择"));
                            windowSingleSelect.setIsEdit(true);
                        }
                    }

                    customRelationRule(windowSingleSelect);
                    pageData.put(schema, windowSingleSelect);
                    layoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE));
                    break;
                case "LABEL":
                    //提出人部门组件，使用单行录入但不可编辑
                    InputSingleText singleText = InputSingleText.create(uibotFieldLayout, uiBotRule, locale);
                    singleText.setEnable(false);
                    pageData.put(schema, singleText);
                    layoutList.add(new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE));
                    break;
                case "DATEPICKER":
                    InputCalendar inputCalendar = InputCalendar.create(uibotFieldLayout, uiBotRule, locale);
                    // 发生时间、预期关闭时间客制处理
                    //发生时间默认选择当天,可选范围为当天以及当天以前
                    if ("happen_date".equalsIgnoreCase(schema)) {
                        inputCalendar.setMaxDateSelectable(InputCalendarDate.createToday());
                        List<InputCalendarDate> calendarDateList = new ArrayList<>();
                        calendarDateList.add(InputCalendarDate.createToday());
                        inputCalendar.setDateValueList(calendarDateList);
                        // 发生时间 联动 期望关闭时间 为三天后
                        RelationRule relationRule = new RelationRule();
                        inputCalendar.setRelationRule(relationRule);
                        CommonRule commonRule = new CommonRule();
                        relationRule.addCommonRule(commonRule);
                        commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        commonRule.setTargetSchema("expect_solve_date");
                        String durationSchema = "hidden_days";
                        commonRule.setAddOperator(new AddOperator()
                                .setStartSchema(schema)
                                .setDurationSchema(durationSchema)
                                .setDurationType(1)
                                .setTargetSchema("expect_solve_date"));
                        // 三天后时间
                        InputNumeric inputNumeric = InputNumeric.create(3, 3, "3",
                                "", InputNumericTypeEnum.INTEGER.getValue(), null, true);
                        inputNumeric.setHidden(true);
                        pageData.put(durationSchema, inputNumeric);
                        layoutList.add(new UiBotLayout(durationSchema, InputNumeric.COMPONENT_TYPE));
                    }
                    //期望关闭时间为三天后，可选范围为当天以及当天之后
                    if ("expect_solve_date".equalsIgnoreCase(schema)) {
                        inputCalendar.setMinDateSelectable(InputCalendarDate.createToday());
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis(System.currentTimeMillis() + 3 * 24 * 60 * 60 * 1000);
                        InputCalendarDate calendarDate = InputCalendarDate.create(
                                calendar.get(Calendar.YEAR) + "",
                                calendar.get(Calendar.MONTH) + 1 + "",
                                calendar.get(Calendar.DATE) + "");
                        List<InputCalendarDate> calendarDateList = new ArrayList<>();
                        calendarDateList.add(calendarDate);
                        inputCalendar.setDateValueList(calendarDateList);
                    }
                    pageData.put(schema, inputCalendar);
                    layoutList.add(new UiBotLayout(schema, InputCalendar.COMPONENT_TYPE));
                    break;
                case "CUST_INPUT_LENGTH":
                    InputMultiText multiText = InputMultiText.create(uibotFieldLayout, uiBotRule, locale, false, fieldHandlingInstructionsRequired);
                    pageData.put(schema, multiText);
                    layoutList.add(new UiBotLayout(schema, InputMultiText.COMPONENT_TYPE));
                    break;
                case "CUST-UPLOAD-IMGS":
                    Picture picture = Picture.create(uibotFieldLayout, uiBotRule);
                    AttachmentRawDataDigiwinAthena rawData = picture.getRawData();
                    rawData.setDisableAam(true);
                    rawData.setBuckets(DigiwinDmcConfig.FRC_BUCKET);
                    pageData.put(schema, picture);
                    layoutList.add(new UiBotLayout(schema, Picture.COMPONENT_TYPE));
                    break;
                case "FORM_UPLOAD":
                    Attachment<AttachmentRawDataDigiwinAthena> attachment = Attachment.create(uibotFieldLayout, uiBotRule, DigiwinDmcConfig.FRC_BUCKET);
                    pageData.put(schema, attachment);
                    layoutList.add(new UiBotLayout(schema, Attachment.COMPONENT_TYPE));
                    break;
                case "INPUT":
                    InputSingleText inputSingleText = InputSingleText.create(uibotFieldLayout, ruleList, locale);
                    // 提出人部门
                    if ("proposer_department_name".equals(schema)) {
                        inputSingleText.setEnable(false);
                        inputSingleText.setPlaceholder("");
                    }
                    pageData.put(schema, inputSingleText);
                    layoutList.add(new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE));
                    break;
                case "CUST_FRC_GENERAL_WINDOW_STANDARD":
                    Boolean required = null;
                    Boolean enable = null;
                    // 项目名称 project_name、项目阶段 project_stage_name
                    if (validationMethod(locale, integrationParameterList, projectInfoRequired,
                            deviceNameHiddenRequired, layoutList, pageData, uibotFieldLayout, schema))
                        break;
                    /**
                     * project_info_required 项目应用集成时项目信息是否必填 1:必填 2：非必填
                     * project_personnel_authority 项目人员权限是否开启 Y:开启 N:不开启
                     * device_name_hidden 设备是否隐藏 Y：隐藏 N：不隐藏
                     */
                    if (integrationParameterList.contains("PMS") || integrationParameterList.contains("PCC")) {
                        required = "1".equals(projectInfoRequired);
                        enable = true;
                    }
                    InputWindowSingleSelect projectWindowSingleSelect =
                            InputWindowSingleSelect.create(uibotFieldLayout, required, enable,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema,
                                    locale, executeContext, true, true, 5, 3);
                    if (integrationParameterList.contains("PMS") || integrationParameterList.contains("PCC")) {
                        if ("project_name".equals(uibotFieldLayout.getSchema())) {
                            // 开窗可选择的数据，展示当前登录用户执行或参与的项目
                            Map<String, Object> data = projectWindowSingleSelect.getRawData();
                            if (CollectionUtils.isEmpty(data)) {
                                data = new HashMap<>(4);
                            }
                            data.put("equipment_source", integrationParameterList);
                            data.put("isProject", true);
                            data.put("projectPersonnelRequired", projectPersonnelRequired);
                            data.put("deviceNameHiddenRequired", deviceNameHiddenRequired);
                            data.put("type", "project_name");
                            projectWindowSingleSelect.setRawData(data);
                            RelationRule relationRule = new RelationRule();
                            List<CommonRule> projectRuleList = relationRule.getRuleList();
                            projectRuleList.add(buildCommonRule(
                                    CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType(),
                                    "equipment_name"));
                            projectRuleList.add(buildCommonRule(
                                    CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType(),
                                    "project_stage_name"));
                            projectWindowSingleSelect.setRelationRule(relationRule);
                        } else if ("project_stage_name".equals(uibotFieldLayout.getSchema())) {
                            Map<String, Object> data = projectWindowSingleSelect.getRawData();
                            if (CollectionUtils.isEmpty(data)) {
                                data = new HashMap<>(3);
                            }
                            data.put("project_source", integrationParameterList);
                            data.put("isProject", true);
                            data.put("type", "project_stage_name");
                            projectWindowSingleSelect.setRawData(data);
                        }
                    }
                    if (integrationParameterList.contains("PCC")) {
                        //设备名称根据项目名称自动带出，可编辑
                        if ("N".equals(deviceNameHiddenRequired)) {
                            equipmentRelationRule(projectWindowSingleSelect);
                        }
                    }

                    pageData.put(schema, projectWindowSingleSelect);
                    layoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE));
                    break;
                case "CUST_FRC_TASKCARD_DEVICE_NAME":
                    //设备名称 equipment_name
                    if (validationMethod(locale, integrationParameterList, projectInfoRequired, deviceNameHiddenRequired, layoutList, pageData, uibotFieldLayout, schema))
                        break;
                    if (integrationParameterList.contains("PMS") || integrationParameterList.contains("PCC")) {
                        Boolean eqRequired = false;
                        Boolean eqEnable = true;
                        if ("1".equals(projectInfoRequired) && "N".equalsIgnoreCase(deviceNameHiddenRequired)) {
                            eqRequired = true;
                        }
                        if ("Y".equalsIgnoreCase(deviceNameHiddenRequired)) {
                            eqEnable = false;
                        }
                        InputWindowSingleSelect pmsWindowSingleSelect =
                                InputWindowSingleSelect.create(uibotFieldLayout, eqRequired, eqEnable,
                                        AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list?componentSchema=" + schema,
                                        locale, executeContext);
                        Map<String, Object> pmsRawData = new HashMap<>(3);
                        pmsRawData.put("equipment_source", integrationParameterList);
                        pmsRawData.put("isProject", true);
                        pmsRawData.put("type", "equipment_name");
                        pmsWindowSingleSelect.setRawData(pmsRawData);
                        pageData.put(schema, pmsWindowSingleSelect);
                        layoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE));
                        break;
                    }
                    break;
                case "CUSTOM_FRC_PROCESSING_TIME_NUMBER_INPUT":
                    //异常工时 abnormal_work_hours
                    InputNumeric abnormalInputSingleText = InputNumeric.create(99999, 0, uibotFieldLayout.getHeaderName(),
                            InputNumericTypeEnum.INTEGER.getValue(), false, true, locale, ruleList, schema, localeService);
                    pageData.put(schema, abnormalInputSingleText);
                    layoutList.add(new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE));
                    break;
                case "CUST_FRC_NOTICE":
                    if ("feedback_notice_person_info".equalsIgnoreCase(uibotFieldLayout.getSchema())) {
                        Map<String, Object> inputWindowMultiSelectRawData = new HashMap<>();
                        inputWindowMultiSelectRawData.put("type", "feedbackNoticePersonInfo");
                        inputWindowMultiSelectRawData.put("isQuestion", true);

                        UiBotLayout uiBotLayout = new UiBotLayout();
                        uiBotLayout.setSchema("feedback_notice_person_info");
                        uiBotLayout.setLabel("反馈通知人");
                        InputWindowMultiSelect inputWindowMultiSelect = InputWindowMultiSelect.create(uiBotLayout,
                                AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                inputWindowMultiSelectRawData, locale, 1, InputWindowSelectStyleEnum.BG_STYLE_WHITE.getValue(),
                                false, false, localeService, true
                        );

                        buildfeedbackNoticePersonInfoRule(inputWindowMultiSelect);

                        pageData.put(uiBotLayout.getSchema(), inputWindowMultiSelect);
                        layoutList.add(new UiBotLayout(uiBotLayout.getSchema(), InputWindowMultiSelect.COMPONENT_TYPE));

                        InputMultiText inputMultiText = InputMultiText.create("feedback_notice_illustrate", "反馈通知说明", "", true, false, false, locale, 1000);
                        pageData.put("feedback_notice_illustrate", inputMultiText);
                        layoutList.add(new UiBotLayout("feedback_notice_illustrate", InputMultiText.COMPONENT_TYPE));
                    }
                    break;
                default:
                    logger.debug("问题快反未支持{}类型组件", uibotFieldLayout.getType());
                    break;
            }

        }
        return content;
    }

    private CommonRule buildCommonRule(Integer type, String schema) {
        CommonRule rule = new CommonRule();
        rule.setCondition(type);
        rule.setTargetSchema(schema);
        rule.setTargetText("");
        rule.setTargetSelectId("");
        return rule;
    }

    private void buildfeedbackNoticePersonInfoRule(InputWindowMultiSelect inputWindowMultiSelect) {
        List<RelationRuleText> relationRuleTextList = new ArrayList<>();
        RelationRuleText isEmptyRelationRuleText = new RelationRuleText();
        isEmptyRelationRuleText.setCondition("");
        isEmptyRelationRuleText.setConditionOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
        isEmptyRelationRuleText.setTargetEnable(true);
        isEmptyRelationRuleText.setTargetSchema("feedback_notice_illustrate");
        isEmptyRelationRuleText.setTargetHidden(false);
        isEmptyRelationRuleText.setTargetRequired(false);
        relationRuleTextList.add(isEmptyRelationRuleText);

        RelationRuleText notEmptyRelationRuleText = new RelationRuleText();
        notEmptyRelationRuleText.setCondition("");
        notEmptyRelationRuleText.setConditionOperatorType(RuleConditionOperatorTypeEnum.NOT_EQUALS.getType());
        notEmptyRelationRuleText.setTargetEnable(true);
        notEmptyRelationRuleText.setTargetSchema("feedback_notice_illustrate");
        notEmptyRelationRuleText.setTargetHidden(false);
        notEmptyRelationRuleText.setTargetRequired(true);
        relationRuleTextList.add(notEmptyRelationRuleText);

        RelationRule relationRule = new RelationRule();
        relationRule.setTextRuleList(relationRuleTextList);
        inputWindowMultiSelect.setRelationRule(relationRule);
    }

    private boolean validationMethod(String locale, String integrationParameterList,
                                     String projectInfoRequired, String deviceNameHiddenRequired, List<UiBotLayout> layoutList, UiBotPageData pageData, UiBotLayout uibotFieldLayout, String schema) {
        if ("equipment_name".equals(schema)) {
            Boolean required = false;
            if ("1".equals(projectInfoRequired) && "N".equalsIgnoreCase(deviceNameHiddenRequired)) {
                required = true;
            }
            Boolean enabel = true;
            if ("Y".equalsIgnoreCase(deviceNameHiddenRequired)) {
                enabel = false;
            }
            if (!StringUtils.hasLength(integrationParameterList) || "[]".equals(integrationParameterList)
                    || integrationParameterList.contains("PCC")) {
                InputSingleText projectInputSingleText = InputSingleText.create(uibotFieldLayout.getSchema(), uibotFieldLayout.getHeaderName()
                        , required, enabel, locale, null, false);
                pageData.put(schema, projectInputSingleText);
                layoutList.add(new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE));
                return true;
            }
        } else {
            if ((!integrationParameterList.contains("PMS") && !integrationParameterList.contains("PCC"))) {
                InputSingleText projectInputSingleText = InputSingleText.create(uibotFieldLayout.getSchema(), uibotFieldLayout.getHeaderName()
                        , false, true, locale, null, false);
                pageData.put(schema, projectInputSingleText);
                layoutList.add(new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE));
                return true;
            }
        }
        return false;
    }

    /**
     * 为设备名称客制联动规则：
     * 设备名称根据项目名称自动带出
     *
     * @param inputMobileComponent
     */
    private static void equipmentRelationRule(BaseInputMobileComponent inputMobileComponent) {
        RelationRule relationRule = new RelationRule();
        inputMobileComponent.setRelationRule(relationRule);
        switch (inputMobileComponent.getSchema()) {
            case "project_name":
                CommonRule sourceNameRule1 = new CommonRule();
                relationRule.addCommonRule(sourceNameRule1);
                sourceNameRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                sourceNameRule1.setTargetSchema("equipment_name");
                sourceNameRule1.setTargetSelectId("");
                sourceNameRule1.setTargetEnable(true);
                sourceNameRule1.setTargetHidden(false);

                CommonRule sourceNameRule2 = new CommonRule();
                relationRule.addCommonRule(sourceNameRule2);
                sourceNameRule2.setCondition(CommonRuleCondition.CONDITION_CHANGE_EMPTY.getType());
                sourceNameRule2.setTargetSchema("equipment_name");
                sourceNameRule2.setTargetSelectId("");
                sourceNameRule2.setTargetEnable(false);
                break;
            default:
                logger.debug("问题快反{}组件无需联动", inputMobileComponent.getSchema());
                break;
        }
    }

    /**
     * 为按钮单选组件客制联动规则（问题快反中的"问题归属"栏位）
     *
     * @param inputMobileComponent
     */
    private void customRelationRule(BaseInputMobileComponent inputMobileComponent) {
        RelationRule relationRule = new RelationRule();
        inputMobileComponent.setRelationRule(relationRule);
        switch (inputMobileComponent.getSchema()) {
            case "question_attribution_no":
            case "question_attribution_name":
                //问题归属变动时，问题来源选项清空
                CommonRule attributionNoRule = new CommonRule();
                relationRule.addCommonRule(attributionNoRule);
                attributionNoRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                attributionNoRule.setTargetSchema("question_source_name");
                attributionNoRule.setTargetSelectId("");
                //问题归属变动时，清空问题分类
                CommonRule attributionNameRule = new CommonRule();
                relationRule.addCommonRule(attributionNameRule);
                attributionNameRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                attributionNameRule.setTargetSchema("question_classification_name");
                attributionNameRule.setTargetSelectId("");
                attributionNameRule.setTargetEnable(true);
                attributionNameRule.setTargetHidden(true);
                break;
            case "question_source_name":
                //1、问题来源变化时，清空问题分类已选项，且可用
                CommonRule sourceNameRule1 = new CommonRule();
                relationRule.addCommonRule(sourceNameRule1);
                sourceNameRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                sourceNameRule1.setTargetSchema("question_classification_name");
                sourceNameRule1.setTargetSelectId("");
                sourceNameRule1.setTargetEnable(true);
                sourceNameRule1.setTargetHidden(false);
                //2、问题来源数据清空时，清空问题分类已选项，且不可用
                CommonRule sourceNameRule2 = new CommonRule();
                relationRule.addCommonRule(sourceNameRule2);
                sourceNameRule2.setCondition(CommonRuleCondition.CONDITION_CHANGE_EMPTY.getType());
                sourceNameRule2.setTargetSchema("question_classification_name");
                sourceNameRule2.setTargetSelectId("");
                sourceNameRule2.setTargetEnable(true);
                break;
            case "question_classification_name":
                //1、问题分类变化时，清空发生阶段已选项，且可用
                CommonRule classificationNameRule1 = new CommonRule();
                relationRule.addCommonRule(classificationNameRule1);
                classificationNameRule1.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                classificationNameRule1.setTargetSchema("occur_stage_name");
                classificationNameRule1.setTargetSelectId("");
                classificationNameRule1.setTargetEnable(true);
                classificationNameRule1.setTargetHidden(false);
                //2、问题分类数据清空时，清空发生阶段已选项，且不可用
                CommonRule classificationNameRule2 = new CommonRule();
                relationRule.addCommonRule(classificationNameRule2);
                classificationNameRule2.setCondition(CommonRuleCondition.CONDITION_CHANGE_EMPTY.getType());
                classificationNameRule2.setTargetSchema("occur_stage_name");
                classificationNameRule2.setTargetSelectId("");
                classificationNameRule2.setTargetEnable(false);
                break;
            case "risk_level_name":
                //风险等级变化时，传值给重要性和紧急度 --- 写到选项里
                break;
            case "question_proposer_name":
                //问题提出人变化时，传部门信息给提出人部门 --- 写到选项里
                break;
            default:
                logger.debug("问题快反{}组件无需联动", inputMobileComponent.getSchema());
                break;
        }
    }

    /**
     * 项目备案表单数据
     *
     * @param layoutOptional
     * @param pcUiBotModel
     * @param appUiBotPageData
     * @param newUiBotLayoutList
     * @param apiRequest
     * @param locale
     */
    private void itemInformationCreateBody(Optional<UiBotLayout> layoutOptional, UiBotModel pcUiBotModel, UiBotPageData appUiBotPageData,
                                           List<UiBotLayout> newUiBotLayoutList, ApiRequest apiRequest, String locale, String tenantId) {
        String path = layoutOptional.orElse(new UiBotLayout()).getSchema();
        List<UiBotRule> uiBotRuleList = pcUiBotModel.getRules();
        List<UiBotLayout> uiBotFieldLayoutList = layoutOptional.get().decomposeFieldsWithPcFormList(null);
        //记录上一个是不是只读组件
//        Boolean preRead = null;
        for (UiBotLayout uiBotFieldLayout : uiBotFieldLayoutList) {
            String schema = uiBotFieldLayout.getSchema();
            Optional<UiBotRule> ruleOptional = uiBotRuleList.stream().filter(uiBotRule -> path.equalsIgnoreCase(uiBotRule.getPath())
                    && schema.equalsIgnoreCase(uiBotRule.getSchema())).findFirst();
            UiBotRule uiBotRule = ruleOptional.isPresent() ? ruleOptional.get() : null;
            switch (uiBotFieldLayout.getType()) {
                case "LABEL":
                case "CURRENT_ACCOUNT":
//                    setDivider(preRead, true, appUiBotPageData, newUiBotLayoutList);
//                    preRead = true;
                    String value = "";
                    if ("itemInformation_create".equals(apiRequest.getDataId()) && "project_no".equalsIgnoreCase(schema)) {
                        //todo -项目备案-项目编号客制处理，从接口获取编号
                        value = digiwinAtdmProxyService.getProjectNo(apiRequest.getIamUserToken(), apiRequest.getUserId(), locale, tenantId);
                    }
                    Field field = Field.create(uiBotFieldLayout, value);
                    appUiBotPageData.put(uiBotFieldLayout.getSchema(), field);
                    newUiBotLayoutList.add(new UiBotLayout(schema, Field.COMPONENT_TYPE, "body"));
                    break;
                case "INPUT":
                case "TEXTAREA":
//                    setDivider(preRead, false, appUiBotPageData, newUiBotLayoutList);
//                    preRead = false;
/*                            if (schema.toLowerCase().contains("address")) {
                                //todo-客户地址,转为地理位置组件（客制）
                                InputLocation inputLocation = InputLocation.create(uiBotField, uiBotRule);
                                appUiBotPageData.put(schema, inputLocation);
                                newUiBotLayoutList.add(new UiBotLayout(schema, InputLocation.COMPONENT_TYPE, "body"));
                            } else*/
                    if (schema.toLowerCase().contains("address") || "remark".equalsIgnoreCase(schema)) {
                        //todo-备注，转为多行文本录入组件（客制）
                        InputMultiText inputMultiText = InputMultiText.create(uiBotFieldLayout, uiBotRule, locale, false, null);
                        appUiBotPageData.put(schema, inputMultiText);
                        newUiBotLayoutList.add(new UiBotLayout(schema, InputMultiText.COMPONENT_TYPE, "body"));
                    } else {
                        InputSingleText inputSingleText = InputSingleText.create(uiBotFieldLayout, uiBotRule, locale);
                        appUiBotPageData.put(schema, inputSingleText);
                        newUiBotLayoutList.add(new UiBotLayout(schema, InputSingleText.COMPONENT_TYPE, "body"));
                    }
                    break;
                case "OPERATION_EDITOR":
//                    setDivider(preRead, false, appUiBotPageData, newUiBotLayoutList);
//                    preRead = false;
                    InputWindowSingleSelect inputWindowSingleSelect =
                            InputWindowSingleSelect.create(
                                    uiBotFieldLayout,
                                    uiBotRule,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                    locale, pcUiBotModel.getExecuteContext());
                    appUiBotPageData.put(schema, inputWindowSingleSelect);
                    newUiBotLayoutList.add(new UiBotLayout(schema, InputWindowSingleSelect.COMPONENT_TYPE, "body"));
                    break;
                case "DATEPICKER":
//                    setDivider(preRead, false, appUiBotPageData, newUiBotLayoutList);
//                    preRead = false;
                    InputCalendar inputCalendar = InputCalendar.create(uiBotFieldLayout, uiBotRule, locale);
                    appUiBotPageData.put(schema, inputCalendar);
                    newUiBotLayoutList.add(new UiBotLayout(schema, InputCalendar.COMPONENT_TYPE, "body"));
                    break;
                case "FORM_OPERATION_EDITOR":
//                    setDivider(preRead, false, appUiBotPageData, newUiBotLayoutList);
//                    preRead = false;
                    InputWindowMultiSelect inputWindowMultiSelect =
                            InputWindowMultiSelect.create(
                                    uiBotFieldLayout,
                                    uiBotRule,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                    locale, pcUiBotModel.getExecuteContext());
                    appUiBotPageData.put(schema, inputWindowMultiSelect);
                    newUiBotLayoutList.add(new UiBotLayout(schema, InputWindowMultiSelect.COMPONENT_TYPE, "body"));
                    break;
                case "IMPORTANCE_CHECK":
//                    setDivider(preRead, false, appUiBotPageData, newUiBotLayoutList);
//                    preRead = false;
                    InputSwitch inputSwitch = InputSwitch.create(uiBotFieldLayout, locale);
                    appUiBotPageData.put(schema, inputSwitch);
                    newUiBotLayoutList.add(new UiBotLayout(schema, InputSwitch.COMPONENT_TYPE, "body"));
                    break;
                case "FORM_UPLOAD":
//                    setDivider(preRead, false, appUiBotPageData, newUiBotLayoutList);
//                    preRead = false;
                    Attachment attachment = Attachment.create(uiBotFieldLayout, uiBotRule);
                    appUiBotPageData.put(schema, attachment);
                    newUiBotLayoutList.add(new UiBotLayout(schema, Attachment.COMPONENT_TYPE, "body"));
                    break;
                default:
                    logger.error("未支持类型：" + uiBotFieldLayout.getSchema());
            }
        }
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;
        data = FileUtil.readText(
                "static/appstore-use/project-create-" + apiRequest.getDataId() + ".json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }

    /**
     * 设置分割线组件
     *
     * @param preRead            上一个组件是不是只读(为null表示没有上一个)
     * @param curRead            当前组件是不是只读
     * @param appUiBotPageData
     * @param newUiBotLayoutList
     */
    private void setDivider(Boolean preRead, Boolean curRead, UiBotPageData appUiBotPageData, List<UiBotLayout> newUiBotLayoutList) {
        if (preRead == null) {
            return;
        }
        Divider divider;
        if (!preRead.equals(curRead)) {
            //不同类型，中间为粗的分割线
            divider = new Divider(DividerTypeEnum.BLOCK_DIVIDER.getValue());
        } else if (!preRead) {
            //都是不是只读，用细的分割线
            divider = new Divider(DividerTypeEnum.ELEMENT_DIVIDER.getValue());
        } else {
            return;
        }
        String dividerSchema = divider.returnComponentType() + "_" + divider.getCmptUuid();
        appUiBotPageData.put(dividerSchema, divider);
        newUiBotLayoutList.add(
                new UiBotLayout(dividerSchema, Divider.COMPONENT_TYPE, "body"));
    }

}
