package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.response.KnowledgeMapsActivityDefinition;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.StartProjectPageService;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：移动发起项目DSL构建流程</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelCreateProjectUniversalParsingStrategy.java
 * @Author: xujinc
 * @Date: created at 2023/12/25 13:36
 */
@Slf4j
@Component
public class UiBotModelBuildProjectCreateV2Strategy implements UiBotModelBuildStrategy {

    @Autowired
    private StartProjectPageService startProjectPageService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Autowired
    private ProjectCreateDetailBuildBizDataEntryDrivenStrategy projectCreateDetailBuildBizDataEntryDrivenStrategy;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        apiRequest.setDataId(apiRequest.getRawData().getString("dataId"));
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), apiRequest.getDataId());
        executeContext.appendPageInfo(UiBotDesignerService.PAGECODE_TASK_DETAIL, null, apiRequest.getDataId(), PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        if (this.isMobileConfigExist(executeContext)) {
            // 存在移动界面设计，走DSL模式
            return startProjectPageService.createPresetActivityTemplateForm(apiRequest, executeContext);
        }
        // 未配置移动编辑界面，使用V1方式渲染处理
        return projectCreateDetailBuildBizDataEntryDrivenStrategy.buildUibotModel(apiRequest);
    }

    private boolean isMobileConfigExist(PcUiBotExecuteContext executeContext) {
        // 非模型驱动发起的项目
        PcUiBotTmActivity tmActivity = this.getActivityWithoutTaskId(executeContext);
        if (tmActivity == null) {
            return true;
        }
        PcUiBotTmFormInfo bindForm = tmActivity.getBindForm();
        if (bindForm == null) {
            return true;
        }
        String formCode = bindForm.getFormCode();
        if (!StringUtils.hasLength(formCode)) {
            return true;
        }
        if (TaskStringUtil.isProjectCreateOfModelDriven(formCode)) {
            // 模型驱动发起的项目绑定的是自定义页面，移动现不支持
            return false;
        }
        String tenantVersion = activityFilterService.tenantVersion(executeContext.getAuthoredUser().getToken(), executeContext.getTenantId(), executeContext.getLocale());
        // 模型驱动发起的项目绑定基础资料
        return BooleanUtils.isTrue(activityFilterService.isExsitTmActivityIdOfMobileDesignerConfig(tmActivity.getApplication(), formCode, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), executeContext.getTenantId(), tenantVersion));
    }

    public PcUiBotTmActivity getActivityWithoutTaskId(PcUiBotExecuteContext executeContext) {
        Map<String, String> uriVariables = new HashMap<>();
        uriVariables.put("activityId", executeContext.getTmActivityId());
        uriVariables.put("pageCode", executeContext.getPageCode());
        DigiwinAthenaApiRequest athenaApiRequest =
                DigiwinAthenaApiRequest.builder()
                        .requestHead(new AthenaBasicHttpRequestHead("",
                                executeContext.getLocale(), executeContext.getAuthoredUser().getToken(),
                                executeContext.getTenantId()))
                        .uriVariables(uriVariables)
                        .build();
        KnowledgeMapsActivityDefinition rawActivityDefinition =
                this.digiwinKnowledgeMapsProxyService.getActivityDefinitionWithoutTaskId(athenaApiRequest);
        return JsonUtil.objectToJavaObject(rawActivityDefinition, PcUiBotTmActivity.class);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}