package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.ProjectPageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>功能描述：项目卡里程碑详情页的UiBotModel构建策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildProjectMilestonePageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/11/28 17:44
 */
@Slf4j
@Component
public class UiBotModelBuildProjectMilestonePageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private ProjectPageService projectPageService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String tmActivityId = apiRequest.getRawData().getString("tmActivityId");
        String tmTaskId = apiRequest.getRawData().getString("tmTaskId");

        // 获取用户配置移动DSL的当责者任务
        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        Set<String> tmActivityIds = activityFilterService.findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.PROJECT.getValue(), apiRequest.getTenantId(), tenantVersion)
                .stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toSet());
        if (!tmActivityIds.contains(tmActivityId)) {
            // 不存在该任务当责者，则返回【移动端未支持，请至PC端操作】
            return this.buildNotSupportModel(apiRequest.getLocale());
        }

        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), apiRequest.getDataId());
        executeContext.appendPageInfo(UiBotDesignerService.PAGECODE_PROJECT_DETAIL, tmTaskId, tmActivityId, PcUiBotActivityConstants.CHARGE, false);
        executeContext.setSourceType(apiRequest.getSourceType());
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        UiBotModel uiBotModel = projectPageService.createPage(executeContext, apiRequest.getDataId(), apiRequest);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private UiBotModel buildNotSupportModel(String locale) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        uiBotModel.getRenderData().addWrapperedComponentToBody(new BaseMobileComponentWrapper<>(
                Empty.create(localeService.getLanguageValue(locale, "移动端未支持，请至PC端操作"), true),
                "DW_" + Empty.COMPONENT_TYPE));
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}