package com.digiwin.mobile.mobileuibot.project.strategy;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.milestone.Milestone;
import com.digiwin.mobile.mobileuibot.core.component.milestone.MilestoneNode;
import com.digiwin.mobile.mobileuibot.core.component.milestone.MilestoneNodeContent;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.task.model.MobileProcessStatusEnum;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：项目卡详情页的UiBotModel构建策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildProjectV2PageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2025/2/28 13:59
 */
@Slf4j
@Component
public class UiBotModelBuildProjectV2PageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        Boolean isShare = apiRequest.getRawData().getBoolean("isShare");
        // 可视化看板信息
        DigiwinAtmcEnginePanelInfo enginePanelInfo = this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(apiRequest.getDataId(), "", apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        // 构建导航栏按钮
        this.buildAppbarButtonList(apiRequest, enginePanelInfo, uiBotModel, isShare);
        // 构建标题
        uiBotModel.getRenderData().addWrapperedComponentToBody(this.buildProjectTitleBody(apiRequest, enginePanelInfo));
        // 构建里程碑组件
        uiBotModel.getRenderData().addWrapperedComponentToBody(this.buildMilestoneWrapper(enginePanelInfo, isShare));
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private void buildAppbarButtonList(ApiRequest apiRequest, DigiwinAtmcEnginePanelInfo enginePanelInfo, UiBotModel uiBotModel, Boolean isShare) {
        // 构建导航栏按钮
        List<Button> appbarButtonList = new ArrayList<>();
        if (BooleanUtils.isNotTrue(isShare)) {
            // 非分享项目卡，添加转派、转派记录按钮、添加至他人Athena按钮
            Map<String, Object> reassign = enginePanelInfo.getReassign();
            if (null != reassign && Boolean.TRUE.equals(reassign.get("reAssignAble"))) {
                // 转派按钮
                Map<String, Object> reassignRawData = JsonUtil.objectToJavaObject(enginePanelInfo.getReassign(), new TypeReference<Map<String, Object>>() {
                });
                reassignRawData.put("appCode", enginePanelInfo.getTask().getAppCode());
                reassignRawData.put("projectDetail", enginePanelInfo.getTask());
                uiBotModel.setReassignButton(Button.createApprovalReassign(apiRequest.getDataId() + "",
                        reassignRawData,
                        apiRequest.getLocale(), "PROJECT", 58926));

                if (reassign.get("reassignSize") != null && (Integer) reassign.get("reassignSize") > 0) {
                    // 转派记录按钮
                    appbarButtonList.add(Button.createReassignReport(apiRequest.getDataId() + "",
                            apiRequest.getLocale(), "PROJECT", 58926));
                }
            }
            // 添加至他人Athena
            Map<String, Object> othersRawData = JsonUtil.objectToJavaObject(enginePanelInfo.getReassign(), new TypeReference<Map<String, Object>>() {
            });
            othersRawData.put("appCode", enginePanelInfo.getTask().getAppCode());
            appbarButtonList.add(Button.createProjectShareWithOthers(apiRequest.getDataId(),
                    othersRawData,
                    apiRequest.getLocale(), localeService));
        }
        uiBotModel.setAppbarButtonList(appbarButtonList);
    }

    public BaseMobileComponentWrapper<BaseMobileComponent> buildProjectTitleBody(ApiRequest apiRequest, DigiwinAtmcEnginePanelInfo enginePanelInfo) {
        // 构建
        if (enginePanelInfo == null || enginePanelInfo.getTask() == null) {
            return new BaseMobileComponentWrapper<>(TitleBody.createEmpty(), "DW_" + TitleBody.COMPONENT_TYPE);
        }
        TitleBody titleBody = this.buildProjectTitle(enginePanelInfo.getTask(), apiRequest);
        // 构建标题的 desc
        this.buildProjectTitleDesc(apiRequest, titleBody, enginePanelInfo.getTask());
        return new BaseMobileComponentWrapper<>(titleBody, "DW_" + titleBody.returnComponentType());
    }

    public TitleBody buildProjectTitle(DigiwinAtmcPanelTask panelTask, ApiRequest apiRequest) {
        List<Tag> tags = new ArrayList<>();
        PageDesc pageDesc = new PageDesc();
        pageDesc.setTitle(panelTask.getName());
        return TitleBody.create(DateTimeUtil.getMonthDateOfTime(panelTask.getEndTime())
                + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "需完成")
                + " " + panelTask.getName(), pageDesc, tags);
    }

    private void buildProjectTitleDesc(ApiRequest apiRequest, TitleBody titleBody, DigiwinAtmcPanelTask panelTask) {
        if (null == titleBody.getContent()) {
            titleBody.setContent(new TitleContent());
        }
        if (titleBody.getContent().getDesc() == null) {
            titleBody.getContent().setDesc(new PageDesc());
        }
        PageDesc desc = titleBody.getContent().getDesc();
        desc.addContent(0xe78a, ProjectStringUtil.getProjectDateDistanceString(apiRequest.getLocale(), panelTask), PageDescContentTypeEnum.NORMAL.getValue());
        desc.addContent(0xe78a, ProjectStringUtil.getProjectSourceInfoString(apiRequest.getLocale(), panelTask), PageDescContentTypeEnum.NORMAL.getValue());
        desc.addContent(0xe78a, ProjectStringUtil.getProjectInitiatorInfoString(apiRequest.getLocale(), panelTask), PageDescContentTypeEnum.NORMAL.getValue());

        Map<String, DigiwinAtmcPanelSource> sourcesByMainTaskId = this.digiwinAtmcProxyService.getSourcesByMainTaskId(apiRequest.getDataId(), "", apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (!CollectionUtils.isEmpty(sourcesByMainTaskId)) {
            sourcesByMainTaskId.forEach((k, v) -> desc.addContent(0xe78a, localeService.getLanguageValue(apiRequest.getLocale(), "发起时间：") + v.getStartTime(), PageDescContentTypeEnum.NORMAL.getValue()));
        }
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildMilestoneWrapper(DigiwinAtmcEnginePanelInfo enginePanelInfo, Boolean isShare) {
        if (enginePanelInfo.getRoute() == null
                || enginePanelInfo.getRoute().getSelectRoute() == null
                || CollectionUtils.isEmpty(enginePanelInfo.getRoute().getSelectRoute().getActivities())) {
            // 无里程碑，返回空wrapper
            return UiBotRenderData.createEmptyWrapper();
        }
        Milestone milestone = new Milestone();
        milestone.setNodeList(this.buildNodeList(isShare, enginePanelInfo));
        return new BaseMobileComponentWrapper<>(milestone, "DW_" + Milestone.COMPONENT_TYPE);
    }

    private List<MilestoneNode> buildNodeList(Boolean isShare, DigiwinAtmcEnginePanelInfo enginePanelInfo) {
        String tmTaskId = enginePanelInfo.getTask().getTmTaskId();
        Long projectId = enginePanelInfo.getTask().getId();

        List<MilestoneNode> nodeList = new ArrayList<>();
        enginePanelInfo.getRoute().getSelectRoute().getActivities()
                .forEach(activity -> {
                    MilestoneNode node = new MilestoneNode();
                    node.setName(activity.getName());

                    List<DigiwinAtmcEngineTaskCode> taskCodes = activity.getTaskCodes();
                    if (CollectionUtils.isEmpty(taskCodes)) {
                        // 没有任务，返回空数组
                        node.setDefaultSelect(false);
                        node.setStatus(MobileProcessStatusEnum.COMPLETED.getStatus());
                        node.setContentList(new ArrayList<>());
                        nodeList.add(node);
                        return;
                    }

                    // 存在任务
                    DigiwinAtmcEngineTaskCode taskCode = taskCodes.get(0);
                    if (DigiwinAtmcActivityStateEnum.DOING.getState().equals(taskCode.getState())) {
                        // 进行中
                        node.setDefaultSelect(true);
                        node.setStatus(MobileProcessStatusEnum.IN_PROGRESS.getStatus());
                    } else if (DigiwinAtmcActivityStateEnum.DONE.getState().equals(taskCode.getState())) {
                        // 已完成
                        node.setDefaultSelect(false);
                        node.setStatus(MobileProcessStatusEnum.COMPLETED.getStatus());
                    } else {
                        // 未开始
                        node.setDefaultSelect(false);
                        node.setStatus(MobileProcessStatusEnum.NO_START.getStatus());
                    }
                    // 构建内容列表
                    node.setContentList(this.buildContentList(taskCodes, isShare, tmTaskId, projectId + ""));
                    nodeList.add(node);
                });
        if (nodeList.stream().allMatch(node -> BooleanUtils.isNotTrue(node.getDefaultSelect()))) {
            nodeList.get(0).setDefaultSelect(true);
        }
        return nodeList;
    }

    private List<MilestoneNodeContent> buildContentList(List<DigiwinAtmcEngineTaskCode> taskCodes, Boolean isShare, String tmTaskId, String projectId) {
        List<MilestoneNodeContent> contentList = new ArrayList<>();
        taskCodes.forEach(taskCode -> {
            MilestoneNodeContent content = new MilestoneNodeContent();
            content.setName(taskCode.getName());

            Map<String, Object> rawData = new HashMap<>();
//            rawData.put("tmPattern", taskCode.getTmPattern());
//            rawData.put("tmCategory", taskCode.getTmCategory());
            rawData.put("tmTaskId", tmTaskId);
            rawData.put("tmActivityId", taskCode.getId());
//            rawData.put("isShare", isShare);
            content.setAction(this.buildContentAction(projectId, rawData));
            contentList.add(content);
        });
        return contentList;
    }

    private Action<Map<String, Object>> buildContentAction(String dataId, Map<String, Object> rawData) {
        Action<Map<String, Object>> action = new Action<>();
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
        action.setDataId(dataId);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_MILESTONE_PAGE.name());
        action.setRawData(rawData);
        return action;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}