package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumb;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * @author wuyang
 * @desc 项目中控台-下一阶页面（非尾阶）
 */
@Component("projectDetailBuildProjectNextLevelListStrategy")
public class ProjectDetailBuildProjectNextLevelListStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(ProjectDetailBuildProjectNextLevelListStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) {
        StopWatch stopWatch = new StopWatch("Build Project Cc Next Level List");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map<String, Object> rawData = apiRequest.getRawData();

        String mainPageId = MapUtils.getString(rawData, "mainPageId");
        Boolean isPcc = MapUtils.getBooleanValue(rawData, "isPcc");
        Boolean isPccPlan = MapUtils.getBooleanValue(rawData, "isPccPlan");
        PccProjectTaskInfo currentProjectTaskInfo = JsonUtil.objectToJavaObject(rawData.get("currentProjectTaskInfo"), PccProjectTaskInfo.class);
        String currentTaskNo = currentProjectTaskInfo.getTaskNo();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case BreadCrumb.COMPONENT_TYPE:
                    BreadCrumb breadCrumb = new BreadCrumb();
                    List<PccProjectTaskInfo> breadCrubChain = JsonUtil.objectToJavaObject(rawData.get("bread_crumb_chain"), new TypeReference<List<PccProjectTaskInfo>>() {
                    });

                    if (!CollectionUtils.isEmpty(breadCrubChain)) {
                        AtomicInteger index = new AtomicInteger(1);
                        List<BreadCrumbNode> breadCrumbNodeList = breadCrubChain.stream().map(item -> {
                            Map<String, Object> breadCrumbRawData = JsonUtil.objectToJavaObject(rawData, Map.class);
                            breadCrumbRawData.put("currentProjectTaskInfo", item);
                            List<PccProjectTaskInfo> currentBreadCrubChain = breadCrubChain.stream().limit(index.getAndIncrement()).collect(Collectors.toList());
                            breadCrumbRawData.put("bread_crumb_chain", currentBreadCrubChain);
                            return new BreadCrumbNode(item.getTaskName(),
                                    breadCrumbRawData, "", "/mobile/v1/proxy/get/project/breadCrumb/data");
                        }).collect(Collectors.toList());
                        breadCrumb.setData(breadCrumbNodeList);
                    }
                    pageData.put(schema, breadCrumb);
                    break;
                case ZtbViewList.COMPONENT_TYPE:
                    List<PccProjectTaskInfo> allProjectTaskInfoList = JsonUtil.objectToJavaObject(rawData.get("data"), new TypeReference<List<PccProjectTaskInfo>>() {
                    });
                    List<PccProjectTaskInfo> processedTaskList = allProjectTaskInfoList
                            .stream()
                            // 排除自己
                            .filter(projectTaskInfo ->
                                    !projectTaskInfo.getTaskNo().equalsIgnoreCase(currentTaskNo))
                            // 获取下级任务
                            .filter(projectTaskInfo -> projectTaskInfo.getUpperLevelTaskNo().equalsIgnoreCase(currentTaskNo))
                            // 筛选出第一级的任务，并按业务逻辑(sequence)正序排序
                            .sorted(Comparator.comparingInt(PccProjectTaskInfo::getSequence))
                            .collect(Collectors.toList());

                    ZtbViewList ztbViewList = new ZtbViewList();
                    ztbViewList.setData(processedTaskList.stream().map(
                            projectTaskInfo -> ProjectCCTaskItem.createProjectCard(apiRequest, projectTaskInfo,
                                    allProjectTaskInfoList, MapUtils.getString(rawData, "projectNo"), mainPageId, isPcc, isPccPlan, false, false)).collect(Collectors.toList()));
                    pageData.put(schema, ztbViewList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttonList = JsonUtil.objectToJavaObject(pageData.get(schema), new TypeReference<List<BottomButtonDigiwinAthena>>() {
                    });
                    buttonList.forEach(item -> item.setName(localeService.getLanguageValue(apiRequest.getLocale(), item.getName())));
                    pageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

}
