package com.digiwin.mobile.mobileuibot.project.strategy.custom;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequestSubmit;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitResult;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldLabelStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.FileMaxSize;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumericTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：体系云管家的项目详情过程备忘录详情和编辑页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy
 * @Author: xujinc
 * @Date: 2024/12/18
 */
@Component("projectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy")
public class ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ProjectDetailBuildSystemCloudHouseKeeperProcessRemarkStrategy.class);

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("SystemCloudHouseKeeper Process Remark Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        stopWatch.start("Build SystemCloudHouseKeeper Process Remark Page Model...");

        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();

        Map<String, Object> projectInfoMap = (Map<String, Object>) MapUtil.getOrDefault(rawData, "project_info", Collections.emptyMap());
        String projectNo = MapUtils.getString(projectInfoMap, "projectNo");

        //过程备忘录数据
        List<Map<String, Object>> bmdPiscProMemoList = getBmdPiscProMemo(apiRequest, projectNo);

        //任务数据
        List<Map<String, Object>> bmPiscAttachmentJoinRelationList = getBmPiscAttachmentJoinRelation(apiRequest, projectNo);
        Map<String, Map<String, Object>> bmPiscAttachmentJoinRelationListMapByTaskNo = bmPiscAttachmentJoinRelationList.stream().collect(Collectors.toMap(item -> MapUtils.getString(item, "task_no"), item -> item, (v1, v2) -> v1));

        boolean isEdit = MapUtils.getBooleanValue(rawData, "isEdit", false);

        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        List<UiBotLayout> newUiBotLayouts = new ArrayList<>();
        UiBotPageData newPageData = new UiBotPageData();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    for (Map<String, Object> bmdPiscProMemo : bmdPiscProMemoList) {
                        //备忘录主键
                        String memorandumId = MapUtils.getString(bmdPiscProMemo, "memorandum_id");

                        //归属任务编号
                        String belongTaskNo = MapUtils.getString(bmdPiscProMemo, "belong_task_no");

                        //根据过程备忘录的归属编号获取对应任务里的need_issue_task_card字段判断是否必填
                        //need_issue_task_card=false则过程方案必填
                        //编辑页过程方案必填，详情页不必填
                        boolean isRequired = false;
                        Map<String, Object> bmPiscAttachmentJoinRelationMapByTaskNo = bmPiscAttachmentJoinRelationListMapByTaskNo.get(belongTaskNo);
                        if (!CollectionUtils.isEmpty(bmPiscAttachmentJoinRelationMapByTaskNo) && isEdit) {
                            isRequired = !MapUtils.getBooleanValue(bmPiscAttachmentJoinRelationMapByTaskNo, "need_issue_task_card", true);
                        }

                        UiBotLayout copyCustomGroupLayout = JsonUtil.objectToJavaObject(layout, UiBotLayout.class);
                        copyCustomGroupLayout.setSchema(UUIDUtil.getUuid());
                        newUiBotLayouts.add(copyCustomGroupLayout);

                        CustomGroup customGroup = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), CustomGroup.class);
                        CustomGroupContent customGroupContent = customGroup.getContent();
                        UiBotPageData customGroupUiBotPageData = customGroupContent.getPageData();
                        List<UiBotLayout> customGroupUiBotLayoutList = customGroupContent.getLayout();
                        for (UiBotLayout customGroupUiBotLayout : customGroupUiBotLayoutList) {
                            String customGroupSchema = customGroupUiBotLayout.getSchema();
                            String label = localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel());
                            switch (customGroupUiBotLayout.getType()) {
                                case Field.COMPONENT_TYPE:
                                    //过程方案，动态根据input_mode展示对应组件
                                    buildDyncamicComponent(bmdPiscProMemo, customGroupUiBotLayout, customGroupUiBotPageData,
                                            customGroupSchema, label, locale, isRequired, isEdit);
                                    break;
                                case InputSingleText.COMPONENT_TYPE:
                                    String value = MapUtils.getString(bmdPiscProMemo, customGroupSchema);
                                    customGroupUiBotLayout.setSchema(memorandumId + "_concat_" + customGroupSchema);
                                    if (BooleanUtils.isFalse(isEdit) && StringUtils.isEmpty(value)) {
                                        Field field = Field.createLabelLeftValueRightField(label, "-");
                                        customGroupUiBotLayout.setType(Field.COMPONENT_TYPE);
                                        customGroupUiBotPageData.put(customGroupUiBotLayout.getSchema(), field);
                                    } else {
                                        InputSingleText inputSingleText = InputSingleText.create(customGroupSchema, label,
                                                false, isEdit, locale, value, false);
                                        inputSingleText.setMaxLength(100);
                                        customGroupUiBotPageData.put(customGroupUiBotLayout.getSchema(), inputSingleText);
                                    }
                                    break;
                            }
                        }
                        newPageData.put(copyCustomGroupLayout.getSchema(), customGroup);
                    }
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    newUiBotLayouts.add(layout);
                    List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>();
                    buttonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));

                    //编辑页才有确定按钮
                    if (BooleanUtils.isTrue(isEdit)) {
                        Action buttonAction = new Action();
                        buttonAction.setType(ActionTypeEnum.CALL_API.getValue());
                        Map<String, Object> actionRawData = new HashMap<>();
                        actionRawData.put("bmdPiscProMemoList", bmdPiscProMemoList);
                        buttonAction.setRawData(actionRawData);

                        BottomButtonDigiwinAthena saveButton = new BottomButtonDigiwinAthena();
                        saveButton.setName(localeService.getLanguageValue(locale, "确定"));
                        saveButton.setAction(buttonAction);
                        buttonList.add(saveButton);
                    }

                    newPageData.put(schema, buttonList);
                    break;
                default:
                    break;
            }
        }
        uiBotModel.setLayout(newUiBotLayouts);
        uiBotModel.setPageData(newPageData);
        stopWatch.stop();
        return uiBotModel;
    }

    private void buildDyncamicComponent(Map<String, Object> bmdPiscProMemo, UiBotLayout customGroupUiBotLayout, UiBotPageData customGroupUiBotPageData,
                                        String customGroupSchema, String label, String locale, boolean isRequired, boolean isEdit) {
        //备忘录主键
        String memorandumId = MapUtils.getString(bmdPiscProMemo, "memorandum_id");

        //过程方案默认值
        String processPlan = MapUtils.getString(bmdPiscProMemo, "process_plan");
        String inputMode = MapUtils.getString(bmdPiscProMemo, "input_mode");

        //过程方案，动态根据input_mode展示对应组件
        //在过程备忘录详情页面，除了附件走Attachment组件控制不可编辑，其他由Field组件控制不可编辑
        if (Objects.equals("process_plan", customGroupSchema) &&
                (BooleanUtils.isTrue(isEdit) || Objects.equals(inputMode, "7"))) {
            //schema变换为备忘录主键，方便提交处理
            customGroupSchema = memorandumId + "_concat_" + customGroupSchema;
            customGroupUiBotLayout.setSchema(customGroupSchema);

            switch (inputMode) {
                case "7":
                    //附件
                    if (isEdit || StringUtils.isNotEmpty(processPlan)) {
                        Attachment attachment = new Attachment();
                        attachment.setRawData(new AttachmentRawDataDigiwinAthena());
                        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
                        attachment.setTitle(label);
                        attachment.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
                        attachment.setType(isEdit ? AttachmentTypeEnum.READ_AND_WRITE.getValue()
                                : AttachmentTypeEnum.READ_ONLY.getValue());
                        Long maxSize = 1024 * 1024 * 50L;
                        attachment.setFileMaxSize(new FileMaxSize(maxSize, maxSize, maxSize, maxSize));
                        attachment.setLimit(1);

                        List<FileInfo> fileInfoList = digiwinDmcProxyService.getFileInfoByIds(DigiwinDmcConfig.SCH_BUCKET, Collections.singletonList(processPlan));
                        if (!CollectionUtils.isEmpty(fileInfoList)) {
                            String finalProcessPlan = processPlan;
                            List<AttachmentFile> attachmentFileList = fileInfoList.stream().map(item -> {
                                AttachmentFile attachmentFile = new AttachmentFile();
                                attachmentFile.setFileName(item.getFileName());
                                attachmentFile.setFileId(finalProcessPlan);
                                attachmentFile.setFileExtension(item.getExtension());
                                return attachmentFile;
                            }).collect(Collectors.toList());
                            attachment.setFileList(attachmentFileList);
                        }

                        AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
                        attachmentRawDataDigiwinAthena.setBuckets(DigiwinDmcConfig.SCH_BUCKET);
                        attachment.setRawData(attachmentRawDataDigiwinAthena);

                        attachment.setRequired(isRequired);
                        customGroupUiBotLayout.setType(Attachment.COMPONENT_TYPE);
                        customGroupUiBotPageData.put(customGroupSchema, attachment);
                    } else {
                        processPlan = StringUtils.isNotEmpty(processPlan) ? processPlan : "-";
                        Field field = Field.createLabelLeftValueRightField(label, processPlan);
                        customGroupUiBotPageData.put(customGroupSchema, field);
                    }
                    break;
                case "6":
                    //日期时间选择框
                    InputDateTimePicker inputDatePicker = InputDateTimePicker.create(customGroupSchema, label, processPlan, locale, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE_HOUR_MINUTE.getType());
                    inputDatePicker.setRequired(isRequired);
                    customGroupUiBotLayout.setType(InputDateTimePicker.COMPONENT_TYPE);
                    customGroupUiBotPageData.put(customGroupSchema, inputDatePicker);
                    break;
                case "5":
                    //日期选择框
                    InputDateTimePicker inputDateTimePicker = InputDateTimePicker.create(customGroupSchema, label, processPlan, locale, InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType());
                    inputDateTimePicker.setRequired(isRequired);
                    customGroupUiBotLayout.setType(InputDateTimePicker.COMPONENT_TYPE);
                    customGroupUiBotPageData.put(customGroupSchema, inputDateTimePicker);
                    break;
                case "4":
                    //单选下拉框
                    String singleOptionalValue = MapUtils.getString(bmdPiscProMemo, "optional_value");
                    List<SingleSelectListOption> singleOptionList = new ArrayList<>();
                    if (StringUtils.isNotEmpty(singleOptionalValue)) {
                        String finalProcessPlan1 = processPlan;
                        singleOptionList = Arrays.asList(StringUtils.splitByWholeSeparator(singleOptionalValue, ",")).stream()
                                .map(item -> {
                                    SingleSelectListOption singleSelectListOption = SingleSelectListOption.create(item, item, true);
                                    singleSelectListOption.setSelected(Objects.equals(item, finalProcessPlan1));
                                    return singleSelectListOption;
                                })
                                .collect(Collectors.toList());
                    }
                    SingleSelectList singleSelectList = SingleSelectList.createSingleSelectList(singleOptionList, label, processPlan,
                            processPlan, locale, isRequired, true);
                    customGroupUiBotLayout.setType(SingleSelectList.COMPONENT_TYPE);
                    customGroupUiBotPageData.put(customGroupSchema, singleSelectList);
                    break;
                case "3":
                    //多选下拉框
                    String multiOptionalValue = MapUtils.getString(bmdPiscProMemo, "optional_value");
                    List<String> valueList;
                    if (StringUtils.isNotEmpty(processPlan)) {
                        valueList = Arrays.asList(StringUtils.splitByWholeSeparator(processPlan, ","));
                    } else {
                        valueList = new ArrayList<>();
                    }
                    List<SingleSelectListOption> multiOptionList = new ArrayList<>();
                    if (StringUtils.isNotEmpty(multiOptionalValue)) {
                        multiOptionList = Arrays.asList(StringUtils.splitByWholeSeparator(multiOptionalValue, ",")).stream()
                                .map(item -> {
                                    SingleSelectListOption singleSelectListOption = SingleSelectListOption.create(item, item, true);
                                    singleSelectListOption.setSelected(valueList.contains(item));
                                    return singleSelectListOption;
                                })
                                .collect(Collectors.toList());
                    }
                    SingleSelectList multiSingleSelectList = SingleSelectList.createMultiSelectList(multiOptionList, label, valueList,
                            valueList, locale, isRequired, true);
                    customGroupUiBotLayout.setType(SingleSelectList.COMPONENT_TYPE);
                    customGroupUiBotPageData.put(customGroupSchema, multiSingleSelectList);
                    break;
                case "2":
                    //数值输入框
                    InputNumeric inputNumeric = InputNumeric.create(99999999, 0, processPlan, label,
                            InputNumericTypeEnum.INTEGER_ALLOW_NEGATIVE.getValue(), isRequired, "");
                    inputNumeric.setPlaceholder(localeService.getLanguageValue(locale, "请输入"));
                    customGroupUiBotLayout.setType(InputNumeric.COMPONENT_TYPE);
                    customGroupUiBotPageData.put(customGroupSchema, inputNumeric);
                    break;
                case "1":
                    //文本输入框
                    InputSingleText inputSingleText = InputSingleText.create(customGroupSchema, label,
                            isRequired, true, locale, processPlan, false);
                    inputSingleText.setMaxLength(100);
                    customGroupUiBotLayout.setType(InputSingleText.COMPONENT_TYPE);
                    customGroupUiBotPageData.put(customGroupSchema, inputSingleText);
                    break;
                default:
                    break;
            }
        } else {
            String value = MapUtils.getString(bmdPiscProMemo, customGroupSchema);
            value = StringUtils.isNotEmpty(value) ? value : "-";
            Field field = Field.createLabelLeftValueRightField(label, value);

            if (Objects.equals(customGroupSchema, "belong_task_name")) {
                field.setLabelStyleType(FieldLabelStyleTypeEnum.LABEL_BLACK.getValue());
            }

            customGroupUiBotLayout.setSchema(memorandumId + "_concat_" + customGroupSchema);
            customGroupUiBotPageData.put(customGroupUiBotLayout.getSchema(), field);
        }
    }


    private List<Map<String, Object>> getBmPiscAttachmentJoinRelation(ApiRequest apiRequest, String projectNo) {
        Map<String, Object> taskInfoMap = new HashMap<>(3);
        taskInfoMap.put("project_no", projectNo);
        taskInfoMap.put("task_property", "1");

        Map<String, Object> parameterMap = new HashMap<>(2);
        parameterMap.put("query_condition", "ALL");
        parameterMap.put("task_info", Collections.singletonList(taskInfoMap));

        Map<String, Object> requestMap = new HashMap<>(2);
        requestMap.put("actionId", "bm.pisc.attachment.join.relation.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService
                .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);

        if (resp.getStatus() == 200 && StringUtils.isEmpty(resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse())
                    .map(e -> (List<Map<String, Object>>) e.get("task_info"))
                    .orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> getBmdPiscProMemo(ApiRequest apiRequest, String projectNo) {
        Map<String, Object> projectProcessMemorandumInfoMap = new HashMap<>(2);
        projectProcessMemorandumInfoMap.put("project_no", projectNo);
        projectProcessMemorandumInfoMap.put("memorandum_property", 1);

        Map<String, Object> parameterMap = new HashMap<>(2);
        parameterMap.put("project_process_memorandum_info", Collections.singletonList(projectProcessMemorandumInfoMap));

        Map<String, Object> requestMap = new HashMap<>(2);
        requestMap.put("actionId", "bmd.pisc.pro.memo.get");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService.handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestMap);

        if (resp.getStatus() == 200 && StringUtils.isEmpty(resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse()).map(e -> (List<Map<String, Object>>) e.get("project_process_memorandum_info")).orElse(Collections.emptyList());
        } else {
            return Collections.emptyList();
        }
    }

    /**
     * 提交
     *
     * @param apiRequestSubmit
     * @return
     */
    public ActionSubmitResult submit(ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        Map<String, Object> rawData = apiRequestSubmit.getRawData().getInnerMap();

        List<Map<String, Object>> bmdPiscProMemoList = (List<Map<String, Object>>) MapUtil.getOrDefault(rawData, "bmdPiscProMemoList", Collections.emptyList());

        if (CollectionUtils.isEmpty(apiRequestSubmit.getSubmitParams())) {
            throw new ServiceException(localeService.getLanguageValue(locale, "提交参数不能为空"));
        }

        Map<String, List<ActionSubmitParam>> actionSubmitParamListMapByMemorandumId = apiRequestSubmit.getSubmitParams().stream()
                .collect(Collectors.groupingBy(e -> StringUtils.splitByWholeSeparator(e.getSchema(), "_concat_")[0]));

        for (Map<String, Object> bmdPiscProMemo : bmdPiscProMemoList) {
            String memorandumId = MapUtils.getString(bmdPiscProMemo, "memorandum_id");
            List<ActionSubmitParam> actionSubmitParamListByMemorandumId = actionSubmitParamListMapByMemorandumId.get(memorandumId);
            if (CollectionUtils.isEmpty(actionSubmitParamListByMemorandumId)) {
                continue;
            }
            for (ActionSubmitParam actionSubmitParam : actionSubmitParamListByMemorandumId) {
                String schema = StringUtils.splitByWholeSeparator(actionSubmitParam.getSchema(), "_concat_")[1];
                switch (actionSubmitParam.getType()) {
                    case Attachment.COMPONENT_TYPE:
                        Attachment attachment = (Attachment) actionSubmitParam.getParams();
                        List<AttachmentFile> fileList = attachment.getFileList();
                        boolean isDelete = fileList.stream().allMatch(e -> Objects.equals("DELETE", e.getStatus()));
                        if (isDelete) {
                            bmdPiscProMemo.put(schema, "");
                        } else {
                            String fileId = fileList.stream().filter(e -> Objects.equals("NEW", e.getStatus())).findFirst().orElse(new AttachmentFile()).getFileId();
                            bmdPiscProMemo.put(schema, fileId);
                        }
                        break;
                    case InputDateTimePicker.COMPONENT_TYPE:
                        InputDateTimePicker picker = (InputDateTimePicker) actionSubmitParam.getParams();
                        if (picker.getDatetimeValue() != null) {
                            String value = InputDateTime.getDateTypeDateStringByType(picker.getDatetimeValue(), picker.getType());
                            bmdPiscProMemo.put(schema, value);
                        }
                        break;
                    case InputSingleText.COMPONENT_TYPE:
                        InputSingleText inputSingleText = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputSingleText.class);
                        bmdPiscProMemo.put(schema, inputSingleText.getText());
                        break;
                    case InputNumeric.COMPONENT_TYPE:
                        InputNumeric inputNumeric = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputNumeric.class);
                        bmdPiscProMemo.put(schema, inputNumeric.getText());
                        break;
                    case SingleSelectList.COMPONENT_TYPE:
                        SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), SingleSelectList.class);
                        if (singleSelectList.getType() == 2) {
                            String value = CollectionUtils.isEmpty(singleSelectList.getSelectIdList()) ? ""
                                    : StringUtils.join(singleSelectList.getSelectIdList(),",");
                            bmdPiscProMemo.put(schema, value);
                        } else {
                            bmdPiscProMemo.put(schema, singleSelectList.getSelectId());
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        Map<String, Object> parameterMap = new HashMap<>(1);
        parameterMap.put("project_process_memorandum_info", bmdPiscProMemoList);

        Map<String, Object> requestMap = new HashMap<>(2);
        requestMap.put("actionId", "bmd.pisc.pro.memo.update");
        requestMap.put("parameter", parameterMap);
        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService.handleByActionId(locale, apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(), "", requestMap);

        if (resp.getStatus() != 200 || StringUtils.isNotEmpty(resp.getErrorMessage())) {
            throw new ServiceException(resp.getErrorMessage());
        } else {
            List<Map<String, Object>> projectInfoList = Optional.ofNullable(resp.getResponse()).map(e -> (List<Map<String, Object>>) MapUtil.getOrDefault(e, "error_info", Collections.emptyList())).orElse(Collections.emptyList());
            String errorMsg = projectInfoList.stream().filter(e -> StringUtils.isNotEmpty(MapUtils.getString(e, "error_msg"))).findFirst().map(e -> MapUtils.getString(e, "error_msg")).orElse("");
            if (StringUtils.isNotEmpty(errorMsg)) {
                throw new ServiceException(errorMsg);
            }

            Action action = new Action<>();
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.name());
            action.setSuccessMsg(localeService.getLanguageValue(locale, "添加成功"));
            return ActionSubmitResult.create(true, action);
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
