package com.digiwin.mobile.mobileuibot.projectplan.strategy;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：PCC项目计划详情基础信息页</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildPccProjectPlanBasicDetailStrategy
 * @Author: xujinc
 * @Date: 2024/7/22 10:23
 */
@Slf4j
@Component("uiBotModelBuildPccProjectPlanBasicDetailStrategy")
public class UiBotModelBuildPccProjectPlanBasicDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildPccProjectPlanBasicDetailStrategy.class);

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private LocaleService localeService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Pcc Project Plan Basic Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    @SneakyThrows
    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String locale = apiRequest.getLocale();

        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();
        Map<String, Object> projectInfoMap = (Map<String, Object>) MapUtil.getOrDefault(rawData, "project_info", Collections.emptyMap());

        if (CollectionUtils.isEmpty(projectInfoMap)) {
            return UiBotModel.emptyUiBotModel();
        }

        List<Map<String, Object>> shippingInfoList = getShippingInfoList(apiRequest, MapUtils.getString(projectInfoMap, "project_no"));
        if (!CollectionUtils.isEmpty(shippingInfoList)) {
            projectInfoMap.putAll(shippingInfoList.get(0));
        }


        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case Retractable.COMPONENT_TYPE:
                    Retractable retractable = JsonUtil.objectToJavaObject(pageData.get(schema), Retractable.class);
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(retractable.getContent().get(0).getData(), CustomGroup.class);
                    List<UiBotLayout> customGroupLayoutList = customGroup.getContent().getLayout();
                    UiBotPageData customGroupPageData = customGroup.getContent().getPageData();
                    for (UiBotLayout customGroupLayout : customGroupLayoutList) {
                        String customGroupSchema = customGroupLayout.getSchema();
                        switch (customGroupLayout.getType()) {
                            case Field.COMPONENT_TYPE:
                                String fieldName = localeService.getLanguageValue(locale, customGroupLayout.getLabel());
                                String fieldValue;
                                // 项目类型
                                if ("project_type_name".equalsIgnoreCase(customGroupSchema)) {
                                    String projectTypeName = MapUtils.getString(projectInfoMap, "project_type_name");
                                    String projectTypeNo = MapUtils.getString(projectInfoMap, "project_type_no");
                                    fieldValue = (Objects.isNull(projectTypeName) ? "" : projectTypeName)
                                            + (Objects.isNull(projectTypeNo) ? "" : projectTypeNo);
                                }
                                // 是否发起预算任务，是否是预算编制
                                else if ("wbs_first_budget".equalsIgnoreCase(customGroupSchema)
                                        || "budget_planning".equalsIgnoreCase(customGroupSchema)) {
                                    boolean isTrue = MapUtils.getBooleanValue(projectInfoMap, customGroupSchema);
                                    fieldValue = localeService.getLanguageValue(locale, isTrue ? "是" : "否");
                                } else {
                                    fieldValue = MapUtils.getString(projectInfoMap, customGroupSchema);
                                    // 项目性质
                                    if ("project_property".equalsIgnoreCase(customGroupSchema)) {
                                        fieldValue = localeService.getLanguageValue(locale,
                                                "20".equals(fieldValue) ? "正式" : "10".equals(fieldValue) ? "潜在" : "");
                                    }
                                    // 管控方式
                                    if ("control_type".equalsIgnoreCase(customGroupSchema)) {
                                        fieldValue = "20".equals(fieldValue) ? "WARNING" : "10".equals(fieldValue) ? "ERROR" : "";
                                    }
                                }
                                Field field = Field.createLabelLeftValueRightField(fieldName, fieldValue);
                                customGroupPageData.put(customGroupSchema, field);
                                break;
                            case InputMultiText.COMPONENT_TYPE:
                                String inputMultiTextName = localeService.getLanguageValue(locale, customGroupLayout.getLabel());
                                String inputMultiTextValue = MapUtils.getString(projectInfoMap, customGroupSchema);
                                InputMultiText inputMultiText = InputMultiText.create(inputMultiTextName, inputMultiTextValue, false,
                                        true, locale);
                                customGroupPageData.put(customGroupSchema, inputMultiText);
                                break;
                            case Attachment.COMPONENT_TYPE:
                                Attachment<AttachmentRawData> attachment = new Attachment<>();
                                attachment.setTitle(localeService.getLanguageValue(locale, customGroupLayout.getLabel()));
                                attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                                attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                                attachment.setRawData(new AttachmentRawDataDigiwinAthena());

                                Map<String, Object> attachmentMap = (Map<String, Object>) MapUtil.getOrDefault(projectInfoMap, "attachment", Collections.emptyMap());
                                if (!CollectionUtils.isEmpty(attachmentMap)) {
                                    List<Map<String, Object>> dataList = (List<Map<String, Object>>) MapUtil.getOrDefault(attachmentMap, "data", Collections.emptyList());
                                    if (!CollectionUtils.isEmpty(dataList)) {
                                        List<AttachmentFile> fileList = dataList.stream().map(data -> {
                                            AttachmentFile file = new AttachmentFile();
                                            file.setFileId(MapUtils.getString(data, "id"));
                                            file.setFileSize((long) MapUtils.getDoubleValue(data, "size", 0.0));
                                            file.setUploader(MapUtils.getString(data, "upload_user_name"));
                                            file.setFileName(MapUtils.getString(data, "name"));
                                            String createDate = Objects.isNull(data.get("create_date")) ? "" : String.valueOf(data.get("create_date"));
                                            if (StringUtils.hasLength(createDate)) {
                                                createDate = createDate.replaceAll("/", "-");
                                            }
                                            file.setUploadTime(createDate);
                                            file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String) data.get("name")));
                                            file.setShareUrl(AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/Athena/preview/" + file.getFileId());
                                            return file;
                                        }).collect(Collectors.toList());
                                        attachment.setFileList(fileList);
                                    }
                                }
                                customGroupPageData.put(customGroupSchema, attachment);
                                break;
                        }
                    }
                    retractable.setContent(Collections.singletonList(new BaseMobileComponentWrapper<>(customGroup, CustomGroup.COMPONENT_TYPE)));
                    pageData.put(schema, retractable);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    buttons.forEach(item -> item.setName(localeService.getLanguageValue(locale, item.getName())));
                    pageData.put(schema, buttons);
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 返回一个获取项目下属任务详情的可执行任务
     *
     * @param locale
     * @param iamUserToken
     * @param pccProjectInfo
     * @param digiwinAtdmProxyService
     * @return
     */
    private PccApiDataWrapper<PccProjectTaskInfo> buildGetProjectTaskInfoCallable(String locale, String iamUserToken,
                                                                                  PccProjectInfo pccProjectInfo, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {

        // 获取项目详情
        Map<String, Object> bodyPayloadMap = new HashMap<>(4);
        String actionId = "task.info.get";
        bodyPayloadMap.put("actionId", actionId);

        Map<String, Object> projectInfoMap = new HashMap<>();
        projectInfoMap.put("project_no", pccProjectInfo.getProjectNo());
        projectInfoMap.put("task_property", "1");
        projectInfoMap.put("control_mode", "1");
        projectInfoMap.put("get_key_info", "3");

        Map<String, Object> parameter = new HashMap<>(1);
        parameter.put("project_info", Collections.singletonList(projectInfoMap));
        bodyPayloadMap.put("parameter", parameter);

        return digiwinAtdmProxyService.dataQueryByActionProjectTaskInfo(locale, iamUserToken,
                JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
    }

    /**
     * 取得项目分批出货信息
     *
     * @param apiRequest
     * @param projectNo
     * @return List
     */
    private List<Map<String, Object>> getShippingInfoList(ApiRequest apiRequest, String projectNo) {

        Map<String, Object> projectInfoMap = new HashMap<>(1);
        projectInfoMap.put("project_no", projectNo);
        Map<String, Object> parameterMap = new HashMap<>(2);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));
        parameterMap.put("query_mode", "1");

        Map<String, Object> requestParamMap = new HashMap<>(2);
        requestParamMap.put("actionId", "project.batch.shipment.info.get");
        requestParamMap.put("parameter", parameterMap);

        DigiwinAthenaApiResponse<JSONObject> employeeInfo = digiwinAtdmProxyService
                .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestParamMap);
        List<Map<String, Object>> shippingInfoList = Optional.ofNullable(employeeInfo).map(DigiwinAthenaApiResponse::getResponse)
                .map(e -> (Map<String, Object>) MapUtil.getOrDefault(e, "project_info", Collections.emptyMap()))
                .map(e -> (List<Map<String, Object>>) MapUtil.getOrDefault(e, "shipping_info", Collections.emptyList()))
                .orElse(Collections.emptyList());
        return shippingInfoList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}