package com.digiwin.mobile.mobileuibot.projectplan.strategy;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroupAlignEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabsBuilder;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccApiDataWrapper;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>功能描述：PCC项目计划详情页</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildPccProjectPlanDetailStrategy
 * @Author: xujinc
 * @Date: 2024/7/22 10:23
 */
@Slf4j
@Component("uiBotModelBuildPccProjectPlanDetailStrategy")
public class UiBotModelBuildPccProjectPlanDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildPccProjectPlanDetailStrategy.class);

    @Autowired
    private CustomTabsBuilder customTabsBuilder;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private LocaleService localeService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build Pcc Project Plan Detail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    @SneakyThrows
    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        String locale = apiRequest.getLocale();
        String tenantId = apiRequest.getTenantId();

        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();
        Map<String, Object> data = (Map<String, Object>) MapUtil.getOrDefault(rawData, "data", Collections.emptyMap());
        String projectNo = MapUtils.getString(data, "project_no");
        if (StringUtils.isEmpty(projectNo)) {
            return UiBotModel.emptyUiBotModel();
        }

        // 获取项目基础信息，从rawData里的data中取项目信息可能不全，需要重新从接口获取
        Map<String, Object> projectInfo = getProjectInfo(apiRequest, projectNo);
        if (CollectionUtils.isEmpty(projectInfo)) {
            return UiBotModel.emptyUiBotModel();
        }

        PccProjectInfo pccProjectInfo = JsonUtil.objectToJavaObject(projectInfo, PccProjectInfo.class);

        // 获取任务详情的可执行任务
        PccApiDataWrapper<PccProjectTaskInfo> pccProjectTaskInfoWrapper = this.buildGetProjectTaskInfoCallable(locale, apiRequest.getIamUserToken(),
                pccProjectInfo, this.digiwinAtdmProxyService, tenantId);
        if (Objects.isNull(pccProjectTaskInfoWrapper) || CollectionUtils.isEmpty(pccProjectTaskInfoWrapper.getProjectInfoList())) {
            return UiBotModel.emptyUiBotModel();
        }

        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case TitleBody.COMPONENT_TYPE:
                    TitleBody titleBody = new TitleBody();
                    TitleContent titleContent = new TitleContent(pccProjectInfo.getProjectNo() + "[" + pccProjectInfo.getProjectName() + "]", new PageDesc());
                    titleBody.setContent(titleContent);

                    List<Tag> tags = new ArrayList<>(2);
                    Tag propertyTag = Tag.createWriteBgdBlueTextTag(ProjectStringUtil.getProjectCCPropertyString(apiRequest.getLocale(), pccProjectInfo.getProjectProperty()), new Action());
                    tags.add(propertyTag);
                    Tag statusTag = Tag.createBlueBgdWriteTextStateTag(ProjectStringUtil.getProjectCCStatusString(apiRequest.getLocale(), pccProjectInfo.getProjectStatus()));
                    tags.add(statusTag);
                    titleBody.setTags(tags);
                    pageData.put(schema, titleBody);
                    break;
                case AutoFill.COMPONENT_TYPE:
                    AutoFillData autoFillData = new AutoFillData();
                    autoFillData.setName(localeService.getLanguageValue(locale, "项目基础信息"));
                    autoFillData.setNameColor("5037DB");
                    autoFillData.setNameSize("28");
                    Action basicDetailAction = new Action();
                    basicDetailAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_BASIC_DETAIL.toString());
                    basicDetailAction.setJumpPageTitle(autoFillData.getName());
                    basicDetailAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                    Map<String, Object> basicDetailRawData = new HashMap<>();
                    basicDetailRawData.put("project_info", projectInfo);
                    basicDetailAction.setRawData(basicDetailRawData);
                    autoFillData.setAction(basicDetailAction);

                    AutoFill autoFill = new AutoFill();
                    autoFill.setData(Collections.singletonList(autoFillData));
                    autoFill.setAlign(ButtonGroupAlignEnum.CENTER.getValue());
                    pageData.put(schema, autoFill);
                    break;
                case Divider.COMPONENT_TYPE:
                    Divider divider = Divider.create(DividerTypeEnum.BLOCK_DIVIDER);
                    pageData.put(schema, divider);
                    break;
                case CustomTabs.COMPONENT_TYPE:
                    List<PccProjectTaskInfo> pccProjectTaskInfo = pccProjectTaskInfoWrapper.getProjectInfoList();
                    CustomTabs customTabs = this.customTabsBuilder.build(apiRequest, pageSetting,
                            UiBotModel.emptyUiBotModel(), CustomTabs.class,
                            layout, pccProjectTaskInfo, pccProjectInfo.getProjectNo(),
                            apiRequest.getTenantId());
                    pageData.put(schema, customTabs);
                    break;
            }
        }
        return uiBotModel;
    }

    /**
     * 返回一个获取项目下属任务详情的可执行任务
     *
     * @param locale
     * @param iamUserToken
     * @param pccProjectInfo
     * @param digiwinAtdmProxyService
     * @return
     */
    private PccApiDataWrapper<PccProjectTaskInfo> buildGetProjectTaskInfoCallable(String locale, String iamUserToken,
                                                                                  PccProjectInfo pccProjectInfo, DigiwinAtdmProxyService digiwinAtdmProxyService, String tenantId) {

        // 获取项目详情
        Map<String, Object> bodyPayloadMap = new HashMap<>(4);
        String actionId = "task.info.get";
        bodyPayloadMap.put("actionId", actionId);

        Map<String, Object> projectInfoMap = new HashMap<>();
        projectInfoMap.put("project_no", pccProjectInfo.getProjectNo());
        projectInfoMap.put("task_property", "1");
        projectInfoMap.put("control_mode", "1");
//        projectInfoMap.put("get_key_info", "3");

        Map<String, Object> parameter = new HashMap<>(1);
        parameter.put("project_info", Collections.singletonList(projectInfoMap));
        bodyPayloadMap.put("parameter", parameter);

        return digiwinAtdmProxyService.dataQueryByActionProjectTaskInfo(locale, iamUserToken,
                JsonUtil.javaObjectToJsonString(bodyPayloadMap), tenantId);
    }

    private Map<String, Object> getProjectInfo(ApiRequest apiRequest, String projectNo) {

        Map<String, Object> projectInfoMap = new HashMap<>(1);
        projectInfoMap.put("project_no", projectNo);
        Map<String, Object> parameterMap = new HashMap<>(2);
        parameterMap.put("project_info", Collections.singletonList(projectInfoMap));

        Map<String, Object> requestParamMap = new HashMap<>(2);
        requestParamMap.put("actionId", "project.common.info.get");
        requestParamMap.put("parameter", parameterMap);

        DigiwinAthenaApiResponse<JSONObject> employeeInfo = digiwinAtdmProxyService
                .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", requestParamMap);
        Map<String, Object> projectInfo = Optional.ofNullable(employeeInfo).map(DigiwinAthenaApiResponse::getResponse)
                .map(e -> (List<Map<String, Object>>) MapUtil.getOrDefault(e, "project_info", Collections.emptyList()))
                .map(e -> e.get(0))
                .orElse(Collections.emptyMap());
        return projectInfo;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}