package com.digiwin.mobile.mobileuibot.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.scan.standard.InputScan;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.BackFillsParseUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.*;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Constants;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Model;
import com.digiwin.mobile.mobileuibot.mock.v2.MockV2Service;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.MPersonCard;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.service.DigiwhaleProxyServie;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperationOpenWindowDefine;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * <p>功能描述：设计器接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DataEntryController.java
 * @Author: wangjwc
 * @Date: created at 2023/11/16 13:17
 */
@Slf4j
@RestController
@RequestMapping(value = "/data/entry")
public class DataEntryController {

    @Autowired
    private InputWindowSingleItemBuilder inputWindowSingleItemBuilder;

    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;

    @Autowired
    private MockV2Service mockV2Service;

    @Autowired
    private DigiwhaleProxyServie digiwhaleProxyServie;

    /**
     * 开窗单选/多选接口
     *
     * @param requestData 请求入参
     * @return
     */
    @PostMapping(value = "/window/data/list")
    public ApiResponse<InputWindowSingleResponseData> getWindowData(
            @RequestBody InputWindowSingleRequestData requestData, HttpServletRequest request) {
        Map<String, Object> rawData = requestData.getRawData();
        if (CollectionUtils.isEmpty(requestData.getRawData())) {
            // 开窗组件未配置API时，直接返回
            return ApiResponse.buildOK().setData(InputWindowSingleResponseData.empty());
        }
        // S15发布临时解决，后面等app发布后删除
        this.resetRequestData(requestData);

        //多档(进度回报):mockV2模拟数据
        String tmActivityId = null;
        if (!ObjectUtils.isEmpty(rawData.get("executeContext"))) {
            Map executeContext = JsonUtil.objectToJavaObject(rawData.get("executeContext"), Map.class);
            if (ObjectUtils.isNotEmpty(executeContext.get("tmActivityId"))) {
                tmActivityId = String.valueOf(executeContext.get("tmActivityId"));
                if (tmActivityId.contains(MockV2Constants.MULTI_SPEED_TM_ACTIVITY_ID)) {
                    String schema = String.valueOf(rawData.get("schema"));
                    MockV2Model mockV2Model = mockV2Service.getMockV2Model(MockV2Constants.WINDOWING);
                    if (ObjectUtils.isNotEmpty(mockV2Model)) {
                        InputWindowSingleResponseData responseData = mockV2Model.getWindowingData().get(schema);
                        responseData.getList().forEach(a -> a.setId(a.getTitle()));
                        return ApiResponse.buildOK().setData(responseData);
                    }
                }
            }
        }

        // 往rawData里传入parameter
        this.handleRawData(requestData.getSubmitParams(), requestData, tmActivityId);

        // 处理分页相关参数和搜索相关参数
        this.handlePageInfoAndSearchInfo(requestData);

        //将allAction的searchInfos放在searchInfo里
        this.buildSearchInfo(requestData, tmActivityId);

        // 处理分页排序相关参数
        this.handlePagingSortInfo(requestData);

        InputWindowSingleResponseData result = this.inputWindowSingleItemBuilder.buildInputWindowData(requestData);
        // 针对不分页情况，精确搜索需要后端过滤
        this.handleFilterResultData(requestData, result);
        if (!CollectionUtils.isEmpty(result.getList())) {
            // 根据backFill对获取到的数据detail调整
            List<Map<String, Object>> buttons = new ArrayList<>();
            if (rawData.get("buttons") != null) {
                buttons = (List<Map<String, Object>>) rawData.get("buttons");
            }
            this.handleBackFill(result.getList(), buttons, rawData);
        }
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 处理排序相关参数，分页下走接口排序，不分页走后端排序
     */
    private void handlePagingSortInfo(InputWindowSingleRequestData requestData) {
        // 是否开启分页
        Boolean useHasNext = requestData.getRawData().getBoolean("useHasNext");
        if (BooleanUtils.isNotTrue(useHasNext)) {
            return;
        }
        // 开启分页的情况下走接口排序
        List<PcUiBotTmOperationOpenWindowDefine.SortInfo> mobileSortInfo = JsonUtil.objectToJavaObject(requestData.getRawData().get("mobileSortInfo"), new TypeReference<List<PcUiBotTmOperationOpenWindowDefine.SortInfo>>() {
        });
        if (CollectionUtils.isEmpty(mobileSortInfo)) {
            return;
        }
        requestData.getRawData().put("sortInfo", mobileSortInfo.stream().map(item -> {
            Map<String, Object> sortItem = new HashMap<>();
            sortItem.put("sort_field", item.getSortField());
            sortItem.put("sort_type", item.getSortType());
            sortItem.put("sort_seq", StringUtil.valueOf(item.getSortSeq()));
            return sortItem;
        }).collect(Collectors.toList()));
    }

    private void resetRequestData(InputWindowSingleRequestData requestData) {
        Map<String, Object> rawData = requestData.getRawData();
        Map<String, Object> executeContext = (Map<String, Object>) rawData.get("executeContext");
        if (CollectionUtils.isEmpty(executeContext)) {
            return;
        }
        Map<String, Object> authoredUser = (Map<String, Object>) executeContext.get("authoredUser");
        if (CollectionUtils.isEmpty(authoredUser)) {
            return;
        }
        Object token = authoredUser.get("token");
        Object tenantId = authoredUser.get("tenantId");
        if (token == null || tenantId == null) {
            return;
        }
        requestData.setIamUserToken(token.toString());
        requestData.setTenantId(tenantId.toString());
        AppRequestContext.getContextEntity().setIamUserToken(token.toString());
        AppRequestContext.getContextEntity().setTenantId(tenantId.toString());
    }

    /**
     * 将allAction的searchInfos放在searchInfo里
     */
    private void buildSearchInfo(InputWindowSingleRequestData requestData, String tmActivityId) {
        Map<String, Object> dataSourceSet = (Map<String, Object>) requestData.getRawData().get("dataSourceSet");
        if (CollectionUtils.isEmpty(dataSourceSet)) {
            return;
        }

        PcUiBotDataSourceSetDTO pcUiBotDataSourceSetDTO = JsonUtil.objectToJavaObject(dataSourceSet, PcUiBotDataSourceSetDTO.class);
        List<PcUiBotDataSourceDTO> pcUiBotDataSourceDTOList = Optional.ofNullable(pcUiBotDataSourceSetDTO)
                .map(PcUiBotDataSourceSetDTO::getDataSourceList).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(pcUiBotDataSourceDTOList)) {
            return;
        }

        // 从searchInfos获取为搜索条件的数据
        List<PcUiBotActionSearchInfoMapping> searchInfos = Optional.ofNullable(pcUiBotDataSourceDTOList.get(0).getAction())
                .map(PcUiBotQueryAction::getSearchInfos).orElse(Collections.emptyList()).stream()
                .filter(e -> StringUtils.hasLength(e.getSearchOperator())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(searchInfos)) {
            return;
        }

        // 如果searchInfo已有值，需要将Action里的searchInfos构建合并到一起
        List<Map<String, Object>> searchInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(requestData.getRawData(), "searchInfo", Lists.newArrayList());
        AtomicInteger i = new AtomicInteger(searchInfoList.size());
        List<Map<String, Object>> searchInfoItemList = searchInfos.stream()
                .filter(e -> StringUtils.hasLength(e.getSearchOperator()))
                .map(e -> {
                    Map<String, Object> searchInfoItem = new HashMap<>();
                    searchInfoItem.put("order", i.get() + 1);
                    searchInfoItem.put("search_field", e.getSearchField());
                    searchInfoItem.put("search_operator", e.getSearchOperator());
                    if (Objects.nonNull(e.getSearchValue())) {
                        if (e.getSearchValue() instanceof List) {
                            searchInfoItem.put("search_value", e.getSearchValue());
                        } else {
                            searchInfoItem.put("search_value", Collections.singletonList(e.getSearchValue()));
                        }
                    }
                    searchInfoItem.put("data_type", e.getDataType());
                    i.addAndGet(1);
                    return searchInfoItem;
                }).collect(Collectors.toList());
        searchInfoList.addAll(searchInfoItemList);
        requestData.getRawData().put("searchInfo", searchInfoList);
    }

    /**
     * 处理分页相关参数和搜索相关参数
     *
     * @param requestData 请求入参
     */
    private void handlePageInfoAndSearchInfo(InputWindowSingleRequestData requestData) {
        // 是否开启分页
        Boolean useHasNext = requestData.getRawData().getBoolean("useHasNext");
        if (BooleanUtils.isNotTrue(useHasNext)) {
            return;
        }
        // 开启分页的情况下需要调用应用接口查询：根据请求参数ids是否有值，来判断 1、走模糊搜索；2、走前端异步构建默认值数据精确匹配数据
        if (CollectionUtils.isEmpty(requestData.getIds())) {
            // 1、走模糊搜索
            this.buildFuzzySearchPageInfoAndSearchInfo(requestData, useHasNext);
        } else {
            // 2、走前端异步构建默认值数据精确匹配数据
            this.buildPrecisionSearchPageInfoAndSearchInfo(requestData, useHasNext);
        }
    }

    /**
     * 分页情况下，构建模糊搜索的条件
     *
     * @param requestData 请求参数
     * @param useHasNext  是否分页
     */
    private void buildFuzzySearchPageInfoAndSearchInfo(InputWindowSingleRequestData requestData, Boolean useHasNext) {
        // 构建分页配置
        Map<String, Object> pageInfo = new HashMap<>();
        pageInfo.put("hasNext", useHasNext);
        pageInfo.put("pageNo", Optional.ofNullable(requestData.getPageNum()).orElse(1));
        pageInfo.put("pageSize", Optional.ofNullable(requestData.getPageSize()).orElse(50));
        requestData.getRawData().put("pageInfo", pageInfo);

        // 构建搜索配置
        List<Map<String, Object>> searchInfos = new ArrayList<>();
        String queryCondition = requestData.getQueryCondition();
        List<String> roleAttention = (List<String>) requestData.getRawData().get("roleAttention");
        if (StringUtils.hasLength(queryCondition) && !CollectionUtils.isEmpty(roleAttention)) {
            boolean multi = roleAttention.size() > 1;
            for (int i = 0; i < roleAttention.size(); i++) {
                Map<String, Object> search = new HashMap<>();
                if (multi) {
                    if (i == 0) {
                        search.put("bracket", "(");
                        search.put("logic", "OR");
                    } else if (i == roleAttention.size() - 1) {
                        search.put("bracket", ")");
                    } else {
                        search.put("logic", "OR");
                    }
                }
                search.put("order", i + 1);
                search.put("search_field", roleAttention.get(i));
                search.put("search_operator", "like");
                search.put("search_value", Lists.newArrayList(queryCondition));
                searchInfos.add(search);
            }
        }
        requestData.getRawData().put("searchInfo", searchInfos);

        // 构建参数中的搜索配置
        Map<String, Object> parameter = new HashMap<>();
        if (requestData.getRawData().get("parameter") != null) {
            parameter = (Map<String, Object>) requestData.getRawData().get("parameter");
        }
        parameter.put("page_no", Optional.ofNullable(requestData.getPageNum()).orElse(1));
        parameter.put("page_size", Optional.ofNullable(requestData.getPageSize()).orElse(50));
        parameter.put("search_info", searchInfos);
        parameter.put("use_has_next", useHasNext);
        requestData.getRawData().put("parameter", parameter);
    }

    /**
     * 分页情况下，构建精确匹配的条件
     *
     * @param requestData 请求参数
     * @param useHasNext  是否分页
     */
    private void buildPrecisionSearchPageInfoAndSearchInfo(InputWindowSingleRequestData requestData, Boolean useHasNext) {
        // 构建分页配置
        Map<String, Object> pageInfo = new HashMap<>();
        pageInfo.put("hasNext", useHasNext);
        pageInfo.put("pageNo", 1);
        pageInfo.put("pageSize", 20);
        requestData.getRawData().put("pageInfo", pageInfo);

        // 构建搜索配置
        List<Map<String, Object>> searchInfos = new ArrayList<>();
        List<String> dataKeys = (List<String>) requestData.getRawData().get("dataKeys");
        if (!CollectionUtils.isEmpty(dataKeys)) {
            List<String> ids = requestData.getIds();
            boolean multi = ids.size() > 1;
            int order = 1;
            for (int i = 0; i < ids.size(); i++) {
                String[] splitList = ids.get(i).split(PcUiBotConstants.WINDOW_ID_SEPERATOR);
                for (int j = 0; j < splitList.length; j++) {
                    Map<String, Object> search = new HashMap<>();
                    if (multi) {
                        if (j == 0) {
                            search.put("bracket", "(");
                            search.put("logic", "AND");
                        } else if (j == splitList.length - 1) {
                            search.put("bracket", ")");
                            if (i != ids.size() - 1) {
                                search.put("logic", "OR");
                            }
                        } else {
                            search.put("logic", "AND");
                        }
                    } else {
                        if (j != splitList.length - 1) {
                            search.put("logic", "AND");
                        }
                    }
                    search.put("order", order++);
                    search.put("search_field", dataKeys.get(j));
                    search.put("search_operator", "equal");
                    search.put("search_value", Lists.newArrayList(splitList[j]));
                    searchInfos.add(search);
                }
            }
        }
        requestData.getRawData().put("searchInfo", searchInfos);

        // 构建参数中的搜索配置
        Map<String, Object> parameter = new HashMap<>();
        if (requestData.getRawData().get("parameter") != null) {
            parameter = (Map<String, Object>) requestData.getRawData().get("parameter");
        }
        parameter.put("page_no", 1);
        parameter.put("page_size", 20);
        parameter.put("search_info", searchInfos);
        parameter.put("use_has_next", useHasNext);
        requestData.getRawData().put("parameter", parameter);
    }

    /**
     * 针对不分页情况，精确搜索需要后端过滤
     *
     * @param requestData 请求参数
     * @param result      应用返回结果
     */
    private void handleFilterResultData(InputWindowSingleRequestData requestData, InputWindowSingleResponseData result) {
        if (CollectionUtils.isEmpty(result.getList())) {
            return;
        }
        // 是否开启分页
        Boolean useHasNext = requestData.getRawData().getBoolean("useHasNext");
        if (BooleanUtils.isTrue(useHasNext)) {
            return;
        }
        // 不开启分页的情况下需要后端过滤：根据请求参数ids是否有值，来判断 1、走模糊搜索-前端搜索；2、走前端异步构建默认值数据精确匹配数据
        if (CollectionUtils.isEmpty(requestData.getIds())) {
            return;
        }
        List<String> dataKeys = (List<String>) requestData.getRawData().get("dataKeys");
        List<String> ids = requestData.getIds();
        if (CollectionUtils.isEmpty(dataKeys)) {
            // 不分页的情况下，dataKeys为空时，可能需要直接筛选ids
            List<InputWindowSingleItem> newList = result.getList().stream().filter(item -> ids.contains(item.getId())).collect(Collectors.toList());
            result.setList(newList);
            result.setTotal(newList.size());
            return;
        }
        List<InputWindowSingleItem> newList = result.getList().stream()
                .filter(item -> {
                    Map<String, Object> detail = item.getDetail();
                    StringBuilder sb = new StringBuilder();
                    dataKeys.forEach(dataKey -> sb.append(StringUtil.valueOf(detail.get(dataKey))).append(PcUiBotConstants.WINDOW_ID_SEPERATOR));
                    return ids.contains(sb.substring(0, sb.length() - PcUiBotConstants.WINDOW_ID_SEPERATOR.length()).trim());
                })
                .collect(Collectors.toList());
        result.setList(newList);
        result.setTotal(newList.size());
    }

    /**
     * 往rawData里传入parameter
     *
     * @param submitParams 页面的提交参数
     * @param submitParams requestData
     * @param tmActivityId tmActivityId
     */
    private void handleRawData(List<ActionSubmitParam> submitParams, InputWindowSingleRequestData requestData, String tmActivityId) {
        if (submitParams == null || submitParams.isEmpty()) {
            return;
        }
        Map<String, Object> parameter = new HashMap<>();
        Map<String, Object> rawData = requestData.getRawData();
        if (rawData.get("parameter") != null) {
            parameter = (Map<String, Object>) rawData.get("parameter");
        }
        rawData.put("parameter", parameter);
        Map<String, Object> finalParameter = parameter;

        // 特殊处理
        specialHandle(rawData, requestData, finalParameter, tmActivityId);

        submitParams.forEach(submitParam -> {
            String type = submitParam.getType();
            if (ButtonSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type) || InputSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                Object selectId = this.componentParamAnalyzerFactory.get(submitParam.getType()).analyzeSubmitParam(submitParam.getParams());
                finalParameter.put(submitParam.getSchema(), selectId);
            } else if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) submitParam.getParams();
                if (inputWindowSingleSelect.getDetail() != null) {
                    Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                    finalParameter.putAll(detail);
                }
            } else if (InputCascade.COMPONENT_TYPE.equals(type)) {
                // InputCascade组件 V2版 提交时，传递的是InputCascade对象
                InputCascade inputCascade = JsonUtil.objectToJavaObject(submitParam.getParams(), InputCascade.class);
                if (inputCascade != null && !CollectionUtils.isEmpty(inputCascade.getData())) {
                    inputCascade.getData().forEach(inputCascadeData -> finalParameter.put(inputCascadeData.getSchema(), inputCascadeData.getId()));
                }
            } else if (InputSwitch.COMPONENT_TYPE.equals(type)) {
                InputSwitch inputSwitch = (InputSwitch) submitParam.getParams();
                if (inputSwitch != null) {
                    finalParameter.put(submitParam.getSchema(), Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0) == 1);
                }
            } else if (InputScan.COMPONENT_TYPE.equals(type)) {
                Object value = this.componentParamAnalyzerFactory.get(type).analyzeSubmitParam(submitParam.getParams());
                finalParameter.put(submitParam.getSchema(), value);
            } else if (InputSingleText.COMPONENT_TYPE.equals(type)) {
                if (isAsa(rawData)) {
                    InputSingleText inputSingleText = (InputSingleText) submitParam.getParams();
                    finalParameter.put(submitParam.getSchema(), inputSingleText.getText());
                }
            } else if (InputDateTimePicker.COMPONENT_TYPE.equals(type)) {
                if (isAsa(rawData)) {
                    InputDateTimePicker inputDateTimePicker = (InputDateTimePicker) submitParam.getParams();
                    if (Objects.nonNull(inputDateTimePicker.getDatetimeValue())) {
                        finalParameter.put(submitParam.getSchema(), InputDateTime.getDateTypeDateStringByType(inputDateTimePicker.getDatetimeValue(), inputDateTimePicker.getType()));
                    }
                }
            } else if (InputCalendar.COMPONENT_TYPE.equals(type)) {
                InputCalendar inputCalendar = (InputCalendar) submitParam.getParams();
                if (Objects.nonNull(inputCalendar) && StringUtils.hasLength(inputCalendar.getInputText())) {
                    finalParameter.put(submitParam.getSchema(), DateTimeUtil.getInputCalendarDateUseDefaultPattern(inputCalendar.getInputText()));
                }
            }
        });
    }

    private void specialHandle(Map<String, Object> rawData, InputWindowSingleRequestData requestData, Map<String, Object> finalParameter, String tmActivityId) {
        if ("questionIdentify".equalsIgnoreCase(tmActivityId)) {
            if ("project_stage_no".equalsIgnoreCase(String.valueOf(rawData.get("schema")))) {
                List<Map<String, Object>> submitParamList = (List<Map<String, Object>>) MapUtil.getOrDefault(rawData, "submitParam", Collections.emptyList());
                Map<String, Object> projectNoSubmitParam = submitParamList.stream().filter(e -> "project_no".equalsIgnoreCase(MapUtils.getString(e, "schema"))).findFirst().orElse(new HashMap<>());
                InputWindowSingleSelect inputWindowSingleSelect = JsonUtil.objectToJavaObject(projectNoSubmitParam.get("params"), InputWindowSingleSelect.class);
                if (Objects.nonNull(inputWindowSingleSelect)) {
                    finalParameter.put("project_no", inputWindowSingleSelect.getSelectId());
                    finalParameter.put("project_name", inputWindowSingleSelect.getTitle());
                }
            }

            if ("project_no".equalsIgnoreCase(String.valueOf(rawData.get("schema")))) {
                PcUiBotDataSourceSetDTO pcUiBotDataSourceSetDTO = JsonUtil.objectToJavaObject(rawData.get("dataSourceSet"), PcUiBotDataSourceSetDTO.class);
                List<PcUiBotDataSourceDTO> pcUiBotDataSourceDTOList = Optional.ofNullable(pcUiBotDataSourceSetDTO)
                        .map(PcUiBotDataSourceSetDTO::getDataSourceList).orElse(Collections.emptyList());
                if (!CollectionUtils.isEmpty(pcUiBotDataSourceDTOList)) {
                    PcUiBotQueryAction pcUiBotQueryAction = pcUiBotDataSourceDTOList.get(0).getAction();
                    if (pcUiBotQueryAction.getActionParams().stream().anyMatch(e -> "liable_person_id".equals(e.getValue()))) {
                        finalParameter.put("liable_person_id", requestData.getUserId());
                        MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId("userId=" + requestData.getUserId());
                        if (!Objects.isNull(personCard)) {
                            finalParameter.put("liable_person_name", personCard.getpName());
                        }
                    }
                }
            }
        }
    }


    /**
     * 构建开窗回填数据(根据backFill对获取到的数据detail调整)
     *
     * @param itemList 开窗数据
     * @param buttons  设计器配置的回填配置
     */
    private void handleBackFill(List<InputWindowSingleItem> itemList, List<Map<String, Object>> buttons, Map<String, Object> rawData) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        Map<String, Object> backFills = BackFillsParseUtil.getBackFillMap2(buttons);
        if (backFills.isEmpty()) {
            return;
        }

        Boolean isApplyToArray = (Boolean) MapUtil.getOrDefault(rawData, "applyToArray", false);
        String applyToField = (String) MapUtil.getOrDefault(rawData, "applyToField", "");
        Set<String> keys = backFills.keySet();
        itemList.forEach(item -> {
            Map<String, Object> detail = item.getDetail();
            Map<String, Object> replaceDetails = new HashMap<>();
            keys.forEach(key -> {
                Object value = detail.get(backFills.get(key));
                if (Objects.isNull(value)) {
                    // 可能配置的回显值是常量值，就直接使用
                    value = handle(String.valueOf(backFills.get(key)));
                }
                replaceDetails.put(key, value);
            });
            detail.clear();
            // 如果配置支持集合字段，需要将配置的所有回显字段放在指定集合名称的集合里
            if (BooleanUtils.isTrue(isApplyToArray)) {
                detail.put(applyToField, Collections.singletonList(replaceDetails));
            }
            detail.putAll(replaceDetails);
        });
    }

    /**
     * 常量值字符串和int值判断
     */
    private static Object handle(String str) {
        if (!StringUtils.hasLength(str)) {
            return null;
        }
        String replaceStr = str.replaceAll("'", "").replaceAll("\\\\", "").replaceAll("\"", "");
        if (org.apache.commons.lang3.StringUtils.isNumeric(replaceStr)) {
            if (str.contains("'") || str.contains("\"")) {
                return replaceStr;
            }
            return Integer.parseInt(replaceStr);
        } else {
            return null;
        }
    }

    /**
     * 是否为asa设计器项目判断
     */
    private boolean isAsa(Map<String, Object> rawData) {
        boolean result = false;
        try {
            Object o = rawData.get("executeContext");
            if (Objects.nonNull(o)) {
                JSONObject executeContext = (JSONObject) JSON.toJSON(o);
                JSONObject projectData = executeContext.getJSONObject("projectData");
                if (Objects.nonNull(projectData)) {
                    JSONObject projectBpmData = projectData.getJSONObject("projectBpmData");
                    if (projectBpmData.containsKey("sourceType")) {
                        result = projectBpmData.getString("sourceType").equals("asa");
                    }
                }
            }
        } catch (Exception e) {

        }
        return result;
    }
}
