package com.digiwin.mobile.mobileuibot.proxy;

import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import lombok.*;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜API请求类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAthenaApiRequest
 * @Author: zaregoto
 * @Date: 2023/2/14 03:37
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAthenaApiRequest implements Serializable {

    private static final long serialVersionUID = -705915848771356971L;

    /**
     * 请求头
     */
    @NotNull
    private AthenaBasicHttpRequestHead requestHead;

    /**
     * URL参数，通常在GET请求中使用
     */
    @Singular("uriVariables")
    private Map<String, String> uriVariables;

    /**
     * BODY参数，通常在POST请求中使用
     */
    @Singular("bodyPayloadMap")
    private Map<String, Object> bodyPayloadMap;
}