package com.digiwin.mobile.mobileuibot.proxy;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：鼎捷雅典娜API响应类。注意：单独提供了DigiwinAthenaApiResponseJsonDeserializer来完成反序列化</p>
 * <p>因为雅典娜平台返回的response属性在异常时，可能会返回空字符串，而在调用时已用指定具体java类型，此时会导致反序列化报错异常，故提供此处理器单独解析</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAthenaApiResponse
 * @Author: Zaregoto
 * @Date: 2021/4/21 1:14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinAthenaApiResponse<T> implements Serializable {
    private static final long serialVersionUID = 6217160114197374344L;

    private Long duration;
    private Integer status;
    private String statusDescription;
    // 异常情况下，返回的是字符串或null
    private T response;
    private String errorMessage;
    private String code;
    // 异常情况下，返回的是Map或者字符串
    private Object debugInfo;
    private String description;
    private String errorCode;

    private String traceId;
}