package com.digiwin.mobile.mobileuibot.proxy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nls.client.AccessToken;
import com.digiwin.mobile.mobileuibot.api.*;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppEnvDeployAreaEnum;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtils;
import com.digiwin.mobile.mobileuibot.common.crypto.digest.DigestUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.digest.SecureAESUtil;
import com.digiwin.mobile.mobileuibot.common.crypto.rsa.RSAUtils;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.image.ImageUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.common.utils.ApiConverUtils;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.config.mqtt.service.MQTTService;
import com.digiwin.mobile.mobileuibot.config.request.RequestWrapper;
import com.digiwin.mobile.mobileuibot.config.request.mock.MockInterceptor;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.core.CommonRawDataParentType;
import com.digiwin.mobile.mobileuibot.core.UiBotServiceImpl;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.action.*;
import com.digiwin.mobile.mobileuibot.core.component.address.Address;
import com.digiwin.mobile.mobileuibot.core.component.basic.CommonConditions;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumb;
import com.digiwin.mobile.mobileuibot.core.component.breadcrumb.BreadCrumbNode;
import com.digiwin.mobile.mobileuibot.core.component.briefingexpress.BriefingExpressData;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeData;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.*;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.BackFillsParseUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.*;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListData;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListDataList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbUnloadingItemList;
import com.digiwin.mobile.mobileuibot.core.component.processnode.ProcessNode;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchField;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.title.teamtitle.TeamTitle;
import com.digiwin.mobile.mobileuibot.core.component.title.teamtitle.TeamTitleDetail;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleConditionOperatorTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.CommonRuleCondition;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRule;
import com.digiwin.mobile.mobileuibot.core.rule.relation.RelationRuleText;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.BottomWindowInfoTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotMultipleDataSourceService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotComponentDataQueryService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.experience.model.ExperienceRoleIdEnum;
import com.digiwin.mobile.mobileuibot.file.FileService;
import com.digiwin.mobile.mobileuibot.gptai.GptAiModel;
import com.digiwin.mobile.mobileuibot.gptai.GptAiService;
import com.digiwin.mobile.mobileuibot.gptai.dto.GptAiResultDTO;
import com.digiwin.mobile.mobileuibot.gptai.enums.GptAiTypeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.login.LoginFromEnum;
import com.digiwin.mobile.mobileuibot.login.LoginService;
import com.digiwin.mobile.mobileuibot.mock.MockService;
import com.digiwin.mobile.mobileuibot.mock.enums.EnableEnum;
import com.digiwin.mobile.mobileuibot.model.db1.Mock;
import com.digiwin.mobile.mobileuibot.model.db1.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.mysql.service.PersonalConfigurationService;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaMobileNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.enums.AthenaPcNotificationCategoryEnum;
import com.digiwin.mobile.mobileuibot.notification.util.ConvertDataUtils;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.operation.*;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.project.strategy.custom.ProjectDetailBuildProjectNextLevelListStrategy;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.DigiwinAdtReportData;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacCurrentUserApp;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.*;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.service.DigiwhaleProxyServie;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.DigiwinEmcResponse;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.EmcVerificationCodeSceneEnum;
import com.digiwin.mobile.mobileuibot.proxy.emc.service.DigiwinEmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.*;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamAnalyzedToken;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamResult;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamTokenRefreshTenant;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.constant.KnowledgeMapsConstant;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.model.*;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.File;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrCardResponse;
import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import com.digiwin.mobile.mobileuibot.proxy.ocr.service.OcrService;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.QueryActionCreateService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.push.fcm.model.FcmMobileUserVo;
import com.digiwin.mobile.mobileuibot.push.fcm.service.FcmService;
import com.digiwin.mobile.mobileuibot.push.jpush.model.Notification;
import com.digiwin.mobile.mobileuibot.rabbitmq.service.PushService;
import com.digiwin.mobile.mobileuibot.sso.SsoController;
import com.digiwin.mobile.mobileuibot.sso.dto.ThirdPartyLoginFreeQueryDTO;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.ReconciliationProgressReasonEnum;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.UiBotModelBuildApcTeamDispatchDetailStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.experimentaloptimizationdetection.TaskDetailBuildDetectionDataDetailStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.manualtask.TaskDetailBuildReplaceReportTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.test.TestController;
import com.fasterxml.jackson.core.type.TypeReference;
import io.micrometer.core.instrument.util.StringUtils;
import io.netty.util.internal.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum.*;


/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ProxyClass
 * @Author: Zaregoto
 * @Date: 2021/4/20 0:55
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1/proxy")
public class ProxyController {

    public static final String ERROR_CODE = "-1";
    public static final String SUCCESS_CODE = "200";
    /**
     * 卡片识别类型--身份证
     */
    private static final String CARD_IDENTIFICATION_IDCARD = "1";

    /**
     * 卡片识别类型--银行卡
     */
    private static final String CARD_IDENTIFICATION_BANKCARD = "0";

    /**
     * 登录类型--手机验证码登录
     */
    private static final String LOGIN_TYPE_MOBILE = "mobilephone";
    /**
     * 登录类型--普通账号登录(鼎捷云账号)
     */
    private static final String LOGIN_TYPE_ACCOUNT = "account";

    /**
     * 登录类型--授权登录
     */
    private static final String LOGIN_TYPE_PROXY = "proxy";

    /**
     * 登录类型--line一键登录
     */
    private static final String LOGIN_TYPE_ONCE = "onceLine";

    /**
     * 登录类型--企业用户账号登录
     */
    private static final String LOGIN_TYPE_FIRM_ACCOUNT = "firmAccount";
    /**
     * 登录类型--AD账号登录后缀1
     */
    public static final String LOGIN_TYPE_AD_SUFFIX_ONE = "@digiwin.com";
    /**
     * 登录类型--AD账号登录后缀2
     */
    private static final String LOGIN_TYPE_AD_SUFFIX_TWO = "@digiwin.biz";
    /**
     * 登录类型--刷卡登录类型1
     */
    private static final String CARD_ONE = "rfid";
    /**
     * 登录类型--刷卡登录类型2
     */
    private static final String CARD_TWO = "easycard";
    /**
     * 手机登录的版本号
     */
    public static final String CLIENT_AGENT_MOBILE = "mobileplatform";

    public static final String SECRET_KEY = "550F743242C486791EDBDEDEE3498BAA";

    private static final String TYPE_PROJECT = "project";
    private static final String TYPE_BACKLOG = "backlog";

    private static final String ABI_STATEMENT_RESID = "STATEMENT__resid";
    private static final String SELECT_TAG = "hashCode";

    private static final String CN_PROD_PACKAGE_NAME = "com.digiwin.athena.atn.alibaba";

    private static final String TW_PROD_PACKAGE_NAME = "com.digiwin.athena.atn.azure";

    private static final String DEV_PACKAGE_NAME = "com.digiwin.enterprise.athena.atn";

    private static final String MQ_LINE_LOGOUT_DEFAULT_TOPIC = "athenamobile/line/logout";

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinAimProxyService digiwinAimProxyService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private InputWindowSingleItemBuilder inputWindowSingleItemBuilder;

    @Autowired
    private DigiwhaleProxyServie digiwhaleProxyServie;

    @Autowired
    private FileService fileService;

    @Autowired
    private OcrService ocrService;

    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private ActionService actionService;

    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private CustomTaskConfigService customTaskConfigService;

    @Autowired
    private TaskFilterService taskFilterService;

    @Autowired
    private PersonalConfigurationService personalConfigurationService;

    @Autowired
    private DigiwinEmcProxyService digiwinEmcProxyService;

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private SysEnvConfig config;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;
    @Autowired
    private PushService pushService;

    @Autowired
    private FcmService fcmService;

    @Autowired
    private GptAiService gptAiService;

    @Autowired
    private TaskDetailBuildDetectionDataDetailStrategy taskDetailBuildDetectionDataDetailStrategy;

    @Autowired
    private TaskDetailBuildReplaceReportTaskDetailStrategy taskDetailBuildReplaceReportTaskDetailStrategy;

    @Autowired
    private ProjectDetailBuildProjectNextLevelListStrategy projectDetailBuildProjectNextLevelListStrategy;

    @Autowired
    private UiBotModelBuildApcTeamDispatchDetailStrategy uiBotModelBuildApcTeamDispatchDetailStrategy;

    @Autowired
    private DigiwinAdtProxyService digiwinAdtProxyService;

    @Autowired
    private DigiwinSemcProxyService semcProxyService;

    @Autowired
    private LoginService loginService;

    @Resource
    private UiBotDesignerRenderService renderService;

    @Resource
    private UiBotComponentDataQueryService uiBotComponentDataQueryService;

    @Autowired
    private UiBotServiceImpl uiBotServiceImpl;

    @Autowired
    private MockService mockService;

    @Autowired
    private DigiwinExperienceProxyService digiwinExperienceProxyService;
    @Autowired
    private UiBotMultipleDataSourceService uiBotMultipleDataSourceService;

    @Autowired
    private QueryActionCreateService queryActionCreateService;

    @Autowired
    private MQTTService mqttService;

    @Autowired
    private ActivityFilterService activityFilterService;

    /**
     * 获取 应用相关配置
     * 登录、切换租户时调用一次
     *
     * @param apiRequest
     * @return
     */
    @PostMapping(value = "/application/config")
    public ApiResponse<Map<String, Object>> applicationConfigGet(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> resultData = new HashMap<>();
        // 在途宝应用+ 司机 角色
        resultData.put("isZtbDriver", false);

//        try {
//            // 是否 在途宝应用
//            if (digiwinCacProxyService.useModuleByTenantIdAndUserId(apiRequest.getTenantId(), apiRequest.getUserId(),
//                    "srm-loading", "srm-loading", apiRequest.getIamUserToken())) {
//                // 是否“司机”角色
//                if (digiwinEspProxyService.driverRoleValid(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
//                        apiRequest.getLocale(), apiRequest.getUserId())) {
//                    resultData.put("isZtbDriver", true);
//                }
//            }
//        } catch (Exception e) {
//            log.error("ProxyController[applicationConfigGet] error: ", e);
//        }
        return ApiResponse.buildOK().setData(resultData);
    }

    @RequestMapping(value = "/refreshtenant", method = RequestMethod.POST)
    public ApiResponse<ProxyRefreshTenant> refreshTenant(
            @RequestParam(name = "tenantSid", required = false) String tenantSid,
            @RequestParam(name = "tenantId", required = false) String tenantId,
            @RequestParam(name = "iamUserToken") String iamUserToken) {
        if (StringUtils.isBlank(tenantSid) && StringUtils.isBlank(tenantId)) {
            return ApiResponse.buildError("TenantSid and tenantId cannot be null at the same time!");
        }
        ProxyRefreshTenant proxyRefreshTenant = ProxyRefreshTenant.create(
                this.digiwinIamProxyService.tokenRefreshTenant(tenantId, tenantSid, iamUserToken));
        if (!iamUserToken.equals(proxyRefreshTenant.getUserToken())) {
            // token不一致，则注销掉原token
            this.digiwinIamProxyService.logout(iamUserToken);
        }

        EocPerson eocPersonInfo = digiwinEocProxyService.getEocInfo(proxyRefreshTenant.getAuthoredUser().getUserId(), proxyRefreshTenant.getUserToken());
        proxyRefreshTenant.setEoc(eocPersonInfo);

        return ApiResponse.buildOK().setData(proxyRefreshTenant);
    }

    @RequestMapping(value = "/tenant", method = RequestMethod.GET)
    public ApiResponse<List<ProxyTenant>> listTenant(
            @RequestParam(name = "iamUserToken") String iamUserToken) {
        List<ProxyTenant> proxyTenants =
                ProxyTenant.create(this.digiwinIamProxyService.listUserTenantsInAthena(iamUserToken));
        if (proxyTenants != null) {
            return ApiResponse.buildOK().setData(proxyTenants);
        } else {
            return ApiResponse.buildError().setData(null);
        }
    }

    @RequestMapping(value = "/message/read", method = RequestMethod.POST)
    public ApiResponse<ProxyMessageRead> messageRead(@RequestParam(name = "locale") String locale,
                                                     @RequestParam(name = "iamUserToken") String iamUserToken,
                                                     @RequestParam(name = "categoryId") String categoryId) {
        List<String> aimMessageSubtypeCategories = new ArrayList<>();
        if (categoryId.equals(AthenaMobileNotificationCategoryEnum.MOBILE_MY_TODO.toString())) {

        } else if (categoryId.equals(
                AthenaMobileNotificationCategoryEnum.MOBILE_PROJECT_ASSISTANT.toString())) {
            aimMessageSubtypeCategories.add(
                    AthenaPcNotificationCategoryEnum.ATHENA_REMIND.toString());
            aimMessageSubtypeCategories.add(
                    AthenaPcNotificationCategoryEnum.EXCEPTION_OR_OVERDUE.toString());
        } else if (categoryId.equals(
                AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString())) {
            aimMessageSubtypeCategories.add(
                    AthenaPcNotificationCategoryEnum.PROXY_REMIND.toString());
        } else if (categoryId.startsWith(
                AthenaMobileNotificationCategoryEnum.MOBILE_INTERNAL_PERSONAL.toString())) {
            aimMessageSubtypeCategories.add(
                    AthenaPcNotificationCategoryEnum.INTERNAL_REMIND.toString());
        } else if (categoryId.equals(
                AthenaMobileNotificationCategoryEnum.MOBILE_SYSTEM.toString())) {
            aimMessageSubtypeCategories.add(AthenaPcNotificationCategoryEnum.OTHER.toString());
            aimMessageSubtypeCategories.add(
                    AthenaPcNotificationCategoryEnum.EMAIL_SEND_FAILED.toString());
        } else {

        }
        Long readCount = 0L;
        for (String aimMessageSubtypeCategory : aimMessageSubtypeCategories) {
            ProxyMessageRead proxyMessageRead = ProxyMessageRead.create(
                    this.digiwinAimProxyService.setMessageCategoryRead(locale, iamUserToken,
                            aimMessageSubtypeCategory));
            readCount += proxyMessageRead.getReadCount();
        }
        // 无任何消息时，Athena助手分类会有我们手工创建的一条欢迎消息，需要在点击后去除角标的数字1，故返回1给App端
        if (categoryId.equals(
                AthenaMobileNotificationCategoryEnum.MOBILE_ATHENA_ASSISTANT.toString())
                && readCount == 0L) {
            readCount = 1L;
        }
        return ApiResponse.buildOK().setData(ProxyMessageRead.create(readCount));
    }

    /**
     * 批量将消息标记为已读
     *
     * @return
     */
    @RequestMapping(value = "/batch/message/read", method = RequestMethod.POST)
    public ApiResponse<ProxyMessageRead> batchMessageRead(@RequestBody ProxyMessageReadRequest readRequest) throws IOException {
        Long readCount = this.digiwinAimProxyService.batchMessageRead(readRequest.getLocale(),
                readRequest.getIamUserToken(), readRequest.getGidList());
        return ApiResponse.buildOK().setData(ProxyMessageRead.create(readCount));
    }

    @RequestMapping(value = "/task/importance", method = RequestMethod.POST)
    public ApiResponse<DigiwinAtmcBacklogImportanceSetResult> setTaskImportance(
            @RequestParam(name = "dataId") String dataId,
            @RequestParam(name = "iamUserToken") String iamUserToken,
            @RequestParam(name = "tenantId") String tenantId,
            @RequestParam(name = "importance") String importance,
            @RequestParam(name = "locale") String locale) {
        DigiwinAtmcBacklogImportanceSetResult result =
                this.digiwinAtmcProxyService.setDigiwinAtmcBacklogImportance(locale, iamUserToken, tenantId,
                        dataId, importance);
        if (null != result && result.getStatus().equals(HttpStatus.OK.value())) {
            return ApiResponse.buildOK().setData(null);
        } else {
            return ApiResponse.buildError().setData(null);
        }
    }

    /**
     * 获取多功能列表组件数据
     *
     * @param apiRequest
     * @return
     */
    @RequestMapping(value = "/get/multipleChoiceData", method = RequestMethod.POST)
    public ApiResponse<MultiFunctionListData> getMultipleChoiceData(
            @RequestBody ApiRequest apiRequest) {
        MultiFunctionListData multiFunctionListData = new MultiFunctionListData();
        if (apiRequest.getRawData() != null && !apiRequest.getRawData().isEmpty()) {
            Map<String, Object> rawData = apiRequest.getRawData();
            multiFunctionListData.setTotal((Integer) rawData.get("reassignSize"));
            List<DigiwinAtmcReassignUser> reassignUserList = this.digiwinAtmcProxyService.getEligibleUserList(String.valueOf(rawData.get("appCode")), apiRequest.getIamUserToken(),
                    apiRequest.getLocale(), apiRequest.getTenantId());
            List<EocPerson> list = JSON.parseArray(JSON.toJSONString(reassignUserList), EocPerson.class);
            if (list != null && !list.isEmpty()) {
                List<MultiFunctionListDataList> dataList = new ArrayList<>(list.size());
                //过滤当前登录人
                List<EocPerson> collect = list.stream().filter(user -> !user.getUserId().equalsIgnoreCase(apiRequest.getUserId())).collect(Collectors.toList());
                for (EocPerson eocPerson : collect) {
                    MultiFunctionListDataList data = new MultiFunctionListDataList();
                    List<Field> fields = new ArrayList<>();
                    //构造名称
                    Field nameField = new Field();
                    nameField.setLabel(localeService.getLanguageValue(apiRequest.getLocale(), "工号"));
                    nameField.setValue(eocPerson.getUserId());
                    fields.add(nameField);
                    //部门
                    Field deptField = new Field();
                    deptField.setLabel(localeService.getLanguageValue(apiRequest.getLocale(), "部门"));
                    deptField.setValue(StringUtils.isEmpty(eocPerson.getDeptName()) ? "-" : eocPerson.getDeptName());
                    fields.add(deptField);

                    data.setTitle(eocPerson.getName() == null ? eocPerson.getUserName() : eocPerson.getName());
                    data.setDataId(eocPerson.getUserId());
                    data.setDetail(eocPerson);
                    data.setContent(fields);
                    dataList.add(data);
                }
                multiFunctionListData.setDataList(dataList);
            }
        }
        return ApiResponse.buildOK().setData(multiFunctionListData);
    }

    /**
     * 底部弹窗的接口
     *
     * @param apiRequest
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/get/reportCheck", method = RequestMethod.POST)
    public ApiResponse<MultiFunctionListData> getReportCheck(
            @RequestBody ApiRequest apiRequest) throws IOException {
        MultiFunctionListData multiFunctionListData = new MultiFunctionListData();
        if (null == apiRequest.getRawData()) {
            return ApiResponse.buildOK().setData(multiFunctionListData);
        }
        ApiRawData rawData = apiRequest.getRawData();
        BottomWindowInfoTypeEnum bottomWindowInfoTypeEnum = BottomWindowInfoTypeEnum.exist(rawData.getString("type"));
        if (null == bottomWindowInfoTypeEnum) {
            return ApiResponse.buildOK().setData(multiFunctionListData);
        }
        String businessKey = bottomWindowInfoTypeEnum.name();
        List<Map<String, Object>> datas = JsonUtil.objectToJavaObject(rawData.get(businessKey),
                new TypeReference<List<Map<String, Object>>>() {
                });
        multiFunctionListData.setTotal(datas.size());
        apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BOTTOM_WINDOW_INFO.name());
        multiFunctionListData.setDataList(buildMultiFunctionListDataList(apiRequest, businessKey, datas));
//        switch (bottomWindowInfoTypeEnum) {
//            case CHECK_IN_NOT_CHECK_OUT_DATA:
//                // 已上线未下线资料
//
//                break;
//            case WORK_HOURS_OVERLAP_DATA:
//                // 工时重叠资料
//                break;
//            case EXCEPT_WORK_HOURS_OVERLAP_DATA:
//                // 除外工时重叠资料
//                break;
//            case EXCEPT_RETURN_WORK_HOURS_OVERLAP_DATA:
//                // 除外回报，工时重叠资料
//                break;
//            case EXCEPT_RETURN_CHECK_IN_DATA:
//                // 除外回报，有在线工时
//                break;
//            default:
//                break;
//        }
        return ApiResponse.buildOK().setData(multiFunctionListData);
    }

    /**
     * 构建 多功能类别的数据列表
     *
     * @param apiRequest
     * @param businessKey
     * @param datas
     * @return
     */
    private List<MultiFunctionListDataList>
    buildMultiFunctionListDataList(ApiRequest apiRequest, String businessKey, List<Map<String, Object>> datas) {
        List<MultiFunctionListDataList> dataList = new ArrayList<>(datas.size());
        // 获取栏位标记的tag mongodb中path是小写，需要转换
        List<ColumnTag> columnTags = columnTagService
                .listColumnTagsByPathAndPageId(businessKey, apiRequest.getPageId());
        // "移动重要"
        List<ColumnTag> importantTags = columnTags.stream().filter(
                        tag -> ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode()
                                .equalsIgnoreCase(tag.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        // "移动次要"
        List<ColumnTag> profileTags = columnTags.stream().filter(
                        tag -> ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()
                                .equalsIgnoreCase(tag.getTagDefinition().getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());
        datas.forEach(map -> {
            MultiFunctionListDataList data = new MultiFunctionListDataList();
            data.setType(1);
            List<Field> fields = new ArrayList<>();
            importantTags.forEach(tag -> {
                Object value = map.get(tag.getSchema());
                fields.add(Field.createFieldOfOtherScene("", value == null ? "" : value.toString()));
            });
            profileTags.forEach(tag -> {
                Object value = map.get(tag.getSchema());
                fields.add(Field.createFieldOfOtherScene(
                        localeService.getLanguageValue(apiRequest.getLocale(), tag.getLabel()),
                        value == null ? "" : value.toString()));
            });
            data.setDataId(UUIDUtil.getUuid());
            data.setDetail(map);
            data.setContent(fields);
            dataList.add(data);
        });
        return dataList;
    }

    /**
     * 获取人员列表（开窗组件，场景有获取任务转派人员、获取签核任务加签人员……等）
     *
     * @param requestData
     * @return
     */
    @RequestMapping(value = "/person/list", method = RequestMethod.POST)
    public ApiResponse<InputWindowSingleResponseData> getPersonList(
            @RequestBody InputWindowSingleRequestData requestData, HttpServletRequest request) {
        if (CollectionUtils.isEmpty(requestData.getRawData())) {
            return ApiResponse.buildOK();
        }
        Map<String, Object> rawData = requestData.getRawData();
        EocPersonResponse eocPersonResponse = new EocPersonResponse();
        boolean reAssignAble = rawData.get("reAssignAble") != null ? (Boolean) rawData.get("reAssignAble") : false;
        Integer reassignSize = rawData.get("reassignSize") != null ? (Integer) rawData.get("reassignSize") : 0;
        DigiwinAtmcBacklogDetail backlogDetail = rawData.get("backlogDetail") != null ?
                JsonUtil.objectToJavaObject(rawData.get("backlogDetail"), DigiwinAtmcBacklogDetail.class) : null;
        DigiwinAtmcPanelTask projectDetail = rawData.get("projectDetail") != null ?
                JsonUtil.objectToJavaObject(rawData.get("projectDetail"), DigiwinAtmcPanelTask.class) : null;
        if (reAssignAble && backlogDetail != null) {
            List<DigiwinAtmcReassignUser> batchReassignUsers = this.digiwinAtmcProxyService
                    .batchGetTaskReassignUsers(backlogDetail, requestData.getIamUserToken(),
                            requestData.getLocale(), requestData.getTenantId());
            eocPersonResponse.setTotal(reassignSize);
            List<EocPerson> list = JSON.parseArray(JSON.toJSONString(batchReassignUsers), EocPerson.class);
            eocPersonResponse.setList(list);
        } else if (reAssignAble && projectDetail != null) {
            List<DigiwinAtmcReassignUser> batchReassignUsers = this.digiwinAtmcProxyService
                    .batchGetProjectReassignUsers(projectDetail, requestData.getIamUserToken(),
                            requestData.getLocale(), requestData.getTenantId());
            eocPersonResponse.setTotal(batchReassignUsers.size());
            List<EocPerson> list = JSON.parseArray(JSON.toJSONString(batchReassignUsers), EocPerson.class);
            eocPersonResponse.setList(list);
        } else if ("performers".equalsIgnoreCase(request.getParameter("componentSchema"))
                // 数据转派按钮走此逻辑；任务卡转派按钮componentSchema=newPerformerId走最上面if逻辑
                || "newPerformerId".equalsIgnoreCase(request.getParameter("componentSchema"))) {
            Map data = JsonUtil.objectToJavaObject(rawData.get("data"), Map.class);
            List<DigiwinAtmcReassignUser> reassignUserList = this.digiwinAtmcProxyService.getEligibleUserList(String.valueOf(data.get("appCode")), requestData.getIamUserToken(),
                    requestData.getLocale(), requestData.getTenantId());
            List<EocPerson> list = JSON.parseArray(JSON.toJSONString(reassignUserList), EocPerson.class);
            eocPersonResponse.setList(list);
        }
        if (CollectionUtils.isEmpty(eocPersonResponse.getList())) {
            // 兜底 防止根据新接口获取不到数据时，走之前接口获取
            eocPersonResponse = digiwinEocProxyService.getPersonList(requestData.getIamUserToken(),
                    9999, 1, requestData.getQueryCondition());
        }
        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        responseData.setTotal(eocPersonResponse.getTotal());
        responseData.setSearchType(2);
        List<InputWindowSingleItem> list = new ArrayList<>();
        List<EocPerson> eocPersonList = eocPersonResponse.getList();
        Predicate<EocPerson> predicate = eocPerson -> Objects.nonNull(eocPerson)
                && Objects.nonNull(eocPerson.getUserId());
        if ("performers".equalsIgnoreCase(request.getParameter("componentSchema"))
                // 数据转派按钮走此逻辑
                || "newPerformerId".equalsIgnoreCase(request.getParameter("componentSchema"))) {
            // 签核任务，加签，选择签核人，当前登录人不可选择，但是前端暂未实现不可选择功能，故快速做法后端过滤当前 登录人
            predicate = eocPerson -> Objects.nonNull(eocPerson)
                    && Objects.nonNull(eocPerson.getUserId())
                    && !requestData.getUserId().equals(eocPerson.getUserId());
        }
        eocPersonList.stream().filter(predicate).forEach(eocPerson -> {
            InputWindowSingleItem item = new InputWindowSingleItem();
            item.setId(eocPerson.getUserId());
            item.setTitle(buildTitleByEocPerson(eocPerson));
            item.setSubtitle(buildSubTitleByEcoperson(eocPerson));
            item.setShowImage(true);
            List<String> contentList = new ArrayList<>();
            if (StringUtils.isNotBlank(eocPerson.getDeptName())) {
                contentList.add(eocPerson.getDeptName());
            }
            if (StringUtils.isNotBlank(eocPerson.getEmail())) {
                contentList.add(eocPerson.getEmail());
            }
            item.setContent(contentList);
            item.setDetail(JsonUtil.objectToJavaObject(eocPerson, Map.class));
            list.add(item);
        });
        responseData.setList(list);
        return ApiResponse.buildOK().setData(responseData);
    }

    private String buildSubTitleByEcoperson(EocPerson eocPerson) {
        if (StringUtils.isEmpty(eocPerson.getId())) {
            if (StringUtils.isEmpty(eocPerson.getUserId())) {
                return "";
            } else {
                return eocPerson.getUserId();
            }
        } else {
            return eocPerson.getId();
        }
    }

    private String buildTitleByEocPerson(EocPerson eocPerson) {
        if (StringUtils.isEmpty(eocPerson.getName())) {
            if (StringUtils.isEmpty(eocPerson.getUserName())) {
                if (StringUtils.isEmpty(eocPerson.getEmpName())) {
                    return null;
                } else {
                    return eocPerson.getEmpName();
                }
            } else {
                return eocPerson.getUserName();
            }
        } else {
            return eocPerson.getName();
        }
    }

    /**
     * 开窗单选/多选通用接口（数据来自pc-uibot）
     *
     * @param requestData
     * @return
     */
    @RequestMapping(value = "/window/data/list", method = RequestMethod.POST)
    public ApiResponse<InputWindowSingleResponseData> getWindowData(
            @RequestBody InputWindowSingleRequestData requestData, HttpServletRequest request) {
        Map<String, Object> rawData = requestData.getRawData();
        if (rawData.get("isZTB") != null && (boolean) rawData.get("isZTB")) {
            InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
            if ("isUserInfo".equalsIgnoreCase((String) rawData.get("type"))) {
                Map<String, String> params = new HashMap<>(2);
                params.put("task_no", (String) rawData.get("taskNo"));
                params.put("transport_no", (String) rawData.get("transportNo"));
                List<ZtbUserInfo> userInfos = digiwinEspProxyService.getUserInfo(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), "", 1, 999, params);
                if (userInfos != null && userInfos.size() > 0) {
                    responseData.setTotal(userInfos.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(userInfos.size());
                    for (ZtbUserInfo userInfo : userInfos) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        singleItem.setId(userInfo.getUserId());
                        singleItem.setTitle(userInfo.getUserName());
                        List<String> content = new ArrayList<>(1);
                        content.add(userInfo.getUserId());
                        singleItem.setContent(content);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                }
            } else if ("isPlatformMessageNo".equalsIgnoreCase((String) rawData.get("type"))) {
                Map<String, Object> params = new HashMap<>(2);
                params.put("delivery_no", rawData.get("delivery_no"));
                List<ActionSubmitParam> submitParams = requestData.getSubmitParams();
                for (ActionSubmitParam submitParam : submitParams) {
                    if (submitParam.getSchema().equalsIgnoreCase("appointment_delivery_date")) {
                        SingleSelectList selectList = (SingleSelectList) submitParam.getParams();
                        params.put(submitParam.getSchema(), selectList.getText());
                    }
                }
                List<UseAppointmentDeliveryPlatform> platforms = digiwinEspProxyService.
                        getAppointmentPlatformInfo(requestData.getIamUserToken(),
                                requestData.getTenantId(), requestData.getLocale(), params);
                if (platforms != null && platforms.size() > 0) {
                    responseData.setTotal(platforms.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(platforms.size());
                    for (UseAppointmentDeliveryPlatform platform : platforms) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        singleItem.setId(platform.getPlatformNo());
                        singleItem.setTitle(platform.getPlatformNo());
                        singleItem.setText(platform.getPlatformNo());
                        singleItem.setDetail(JsonUtil.objectToJavaObject(platform, Map.class));
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                }
            } else if ("isTimeSlot".equalsIgnoreCase((String) rawData.get("type"))) {
                Map<String, Object> params = new HashMap<>(3);
                params.put("delivery_no", rawData.get("delivery_no"));
                List<ActionSubmitParam> submitParams = requestData.getSubmitParams();
                for (ActionSubmitParam submitParam : submitParams) {
                    if (submitParam.getSchema().equalsIgnoreCase("appointment_delivery_date")) {
                        SingleSelectList selectList = (SingleSelectList) submitParam.getParams();
                        params.put(submitParam.getSchema(), selectList.getText());
                    } else if (submitParam.getType().equalsIgnoreCase(InputWindowSingleSelect.COMPONENT_TYPE)) {
                        InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) submitParam.getParams();
                        params.put(submitParam.getSchema(), inputWindowSingleSelect.getSelectId());
                    }
                }
                List<CanAppointmentDeliveryTimeSlot> timeSlots = digiwinEspProxyService.getAppointmentDeliveryTimeSlot(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), params);
                if (timeSlots != null && timeSlots.size() > 0) {
                    responseData.setTotal(timeSlots.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(timeSlots.size());
                    for (CanAppointmentDeliveryTimeSlot timeSlot : timeSlots) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String value = timeSlot.getAppointmentDeliveryTimeStart() + "~" + timeSlot.getAppointmentDeliveryTimeEnd();
                        singleItem.setId(value);
                        singleItem.setTitle(value);
                        singleItem.setText(value);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(itemList);
                }
            } else if ("isAppointmentDeliveryDate".equalsIgnoreCase((String) rawData.get("type"))) {
                List<AppointmentDeliveryDate> deliveryDates = digiwinEspProxyService.getAppointmentDeliveryDate(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(),
                        (String) rawData.get("delivery_no"));
                if (deliveryDates != null && deliveryDates.size() > 0) {
                    responseData.setTotal(deliveryDates.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(deliveryDates.size());
                    for (AppointmentDeliveryDate date : deliveryDates) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String value = date.getAppointmentDeliveryDate();
                        singleItem.setId(value);
                        singleItem.setTitle(value);
                        singleItem.setText(value);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(itemList);
                }
            }
        } else if (rawData.get("isAPC") != null && (Boolean) rawData.get("isAPC")) {
            List<Map<String, Object>> datas;
            InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
            String type = (String) rawData.get("type");
            if ("approver_id".equals(type)) {
                datas = digiwinEspProxyService.getWoOpRequestSupportApproveInfo(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), Collections.emptyMap());
                if (!CollectionUtils.isEmpty(datas)) {
                    responseData.setTotal(datas.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());
                    for (Map<String, Object> date : datas) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String id = (String) date.get("approver_id");
                        String value = (String) date.get("approver_name");
                        singleItem.setShowImage(true);
                        singleItem.setId(id);
                        singleItem.setTitle(value);
                        singleItem.setText(value);
                        singleItem.setDetail(date);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                }
            } else if ("area_name".equalsIgnoreCase(type)) {
                List<ActionSubmitParam> submitParams = requestData.getSubmitParams();
                String layout = "";
                for (ActionSubmitParam submitParam : submitParams) {
                    if (SingleSelectList.COMPONENT_TYPE.equalsIgnoreCase(submitParam.getType()) &&
                            "layout_no".equals(submitParam.getSchema())) {
                        SingleSelectList selectList = (SingleSelectList) submitParam.getParams();
                        layout = selectList.getSelectId();
                    }
                }
                List<Map<String, Object>> params = new ArrayList<>(1);
                Map<String, Object> maps = new HashMap<>(4);
                maps.put("plan_source", rawData.get("plan_source"));
                maps.put("area_no", "");
                maps.put("layout_no", layout);
                maps.put("eoc_company_id", rawData.get("eoc_company_id"));
                maps.put("eoc_site_id", rawData.get("eoc_site_id"));
                params.add(maps);
                //現場資源規劃機制 是否生效呈现不同资料 不为空就是生效
                Object onSiteResourcePlanningMechanism = rawData.get("onSiteResourcePlanningMechanism");
                datas = digiwinEspProxyService.getLayoutAreaWoOpInfo(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), params);

                if (!CollectionUtils.isEmpty(datas)) {
                    responseData.setTotal(datas.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());
                    for (Map<String, Object> data : datas) {
                        if (!layout.equals(data.get("layout_no"))) {
                            continue;
                        }
                        rawData.put("layout_no", String.valueOf(data.get("layout_no")));
                        //获取区域颜色，满和荐
                        List<Map<String, Object>> colorInfoList = null;
                        if (ObjectUtils.isNotEmpty(onSiteResourcePlanningMechanism)) {
                            colorInfoList = digiwinEspProxyService.getDispatchAreaSpaceColorInfo(requestData.getIamUserToken(),
                                    requestData.getTenantId(), requestData.getLocale(), rawData);
                        }

                        List<Map<String, Object>> mapDetails = (List<Map<String, Object>>) data.get("machine_position_map_detail");
                        if (!CollectionUtils.isEmpty(mapDetails)) {

                            List<String> ids = requestData.getIds();
                            if (!CollectionUtils.isEmpty(ids)) {
                                mapDetails = mapDetails.stream().filter(e -> ids.contains(MapUtils.getString(e, "area_no"))).collect(Collectors.toList());
                            }

                            for (Map<String, Object> mapDetail : mapDetails) {
                                InputWindowSingleItem singleItem = new InputWindowSingleItem();
                                String id = (String) mapDetail.get("area_no");
                                String value = (String) mapDetail.get("area_name");
                                if (ObjectUtil.isNotEmpty(onSiteResourcePlanningMechanism)) {
                                    mapDetail.put("rawData", rawData);
                                }
                                singleItem.setSeeMoreButton(Button.createApcWorkShopOnlineSeeMore(requestData.getLocale(), localeService, mapDetail, onSiteResourcePlanningMechanism));
                                singleItem.setShowImage(false);
                                singleItem.setId(id);
                                singleItem.setTitle(value);
                                singleItem.setText(value);
                                singleItem.setDetail(mapDetail);
                                if (CollUtil.isNotEmpty(colorInfoList)) {
                                    for (Map<String, Object> colorMap : colorInfoList) {
                                        if (id.equals(colorMap.get("area_no").toString())) {
                                            //满和荐 不会同时存在应用确认
                                            if ("1".equalsIgnoreCase(String.valueOf(colorMap.get("area_show_recommend")))) {
                                                //1-推荐,0-不推荐
                                                singleItem.setTitleLabel(new InputWindowSingleItemLabel(localeService.getLanguageValue(requestData.getLocale(), "荐"), "#4670F7", "#ffffff"));
                                            }
                                            if ("3".equalsIgnoreCase(String.valueOf(colorMap.get("area_show_color")))) {
                                                //1-绿色;2-蓝色3-橘色(满)
                                                singleItem.setTitleLabel(new InputWindowSingleItemLabel(localeService.getLanguageValue(requestData.getLocale(), "满"), "#fcb2b2", "#ffffff"));
                                            }
                                        }
                                    }
                                }
                                itemList.add(singleItem);
                            }
                        }
                    }

                    //制令上线-区域开窗依「区域名称」排序,简体按拼音，繁体按笔画
                    itemList = itemList.stream().sorted((o1, o2) -> {
                                java.text.Collator collator;
                                if ("zh_CN".equalsIgnoreCase(requestData.getLocale())) {
                                    collator = java.text.Collator.getInstance(Locale.SIMPLIFIED_CHINESE);
                                } else {
                                    collator = java.text.Collator.getInstance(Locale.TRADITIONAL_CHINESE);
                                }
                                return collator.compare(o1.getText(), o2.getText());
                            }
                    ).collect(Collectors.toList());
                    responseData.setList(itemList);
                }
                return ApiResponse.buildOK().setData(responseData);
            } else if ("team_name".equalsIgnoreCase(type)) {
                List<Map<String, Object>> params = new ArrayList<>(1);
                Map<String, Object> maps = new HashMap<>(2);
                maps.put("workstation_no", rawData.get("workstation_no"));
//                maps.put("workstation_name", rawData.get("workstation_name"));
                params.add(maps);
                datas = digiwinEspProxyService.getWorkstationProgressFeedbackInfo(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), params);
                maps.putAll(rawData);
                Map<String, Object> headers = new HashMap<>(2);
                headers.put("eoc_site_id", rawData.get("eoc_site_id"));
                headers.put("eoc_company_id", rawData.get("eoc_company_id"));
                List<Map<String, Object>> teamLists = digiwinEspProxyService.getWoOpWorkstationRecommandTeamInfo(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), params, headers);
                if (!CollectionUtils.isEmpty(datas)) {
                    responseData.setTotal(datas.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());
                    for (Map<String, Object> data : datas) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String id = (String) data.get("team_no");
                        String value = (String) data.get("team_name");
                        singleItem.setSubtitle(id);
                        for (Map<String, Object> teamMap : teamLists) {
                            if (id.equals((String) teamMap.get("team_no"))) {
                                singleItem.setTitleLabel(new InputWindowSingleItemLabel(localeService.getLanguageValue(requestData.getLocale(), "荐"), "#4670F7", "#ffffff"));
                                break;
                            }
                        }
                        singleItem.setShowImage(false);
                        singleItem.setId(id);
                        singleItem.setTitle(value);
                        singleItem.setText(value);
                        singleItem.setDetail(data);
                        itemList.add(singleItem);
                    }
                    List<String> ids = requestData.getIds();
                    if (!CollectionUtils.isEmpty(ids)) {
                        itemList = itemList.stream().filter(e -> ids.contains(e.getId())).collect(Collectors.toList());
                    }
                    responseData.setList(itemList);
                }
                return ApiResponse.buildOK().setData(responseData);
            } else {
                datas = digiwinEspProxyService.getWoOpSupportDemandWindowsInfo(requestData.getIamUserToken(),
                        requestData.getTenantId(), requestData.getLocale(), rawData);
                if (!CollectionUtils.isEmpty(datas)) {
                    responseData.setTotal(datas.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());
                    for (Map<String, Object> data : datas) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String id = (String) data.get("supporter_no");
                        String value = (String) data.get("supporter_name");
                        singleItem.setShowImage(true);
                        singleItem.setId(id);
                        singleItem.setTitle(value);
                        singleItem.setText(value);
                        singleItem.setDetail(data);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                }
                return ApiResponse.buildOK().setData(responseData);
            }
        } else if (rawData.get("isTbds") != null && (Boolean) rawData.get("isTbds")) {
            List<Map<String, Object>> datas;
            InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
            String type = (String) rawData.get("type");
            String idKey;
            String valueKey;
            Boolean showImage = false;
            if ("reject_to_op_seq".equals(type)) {
                // 北斗驳回工艺名称多选
                datas = (List<Map<String, Object>>) rawData.get("mobileOpDatas");
                idKey = "op_seq";
                valueKey = "op_name";
            } else if ("unit_name".equals(type) || "qualified_product_unit_no".equals(type) || "unqualified_product_unit_no".equals(type)) {
                datas = digiwinEspProxyService.getBmUscMeasureUnitList(requestData.getIamUserToken(), requestData.getTenantId(), requestData.getLocale());
                idKey = "unit_no";
                valueKey = "unit_name";
            } else {
                // 北斗驳回执行人多选
                InputWindowSingleSelect rejectToOpSeqParams = (InputWindowSingleSelect) requestData.getSubmitParams().stream().filter(e -> "reject_to_op_seq".equals(e.getSchema())).findFirst().get().getParams();
                datas = (List<Map<String, Object>>) rejectToOpSeqParams.getDetail().get("operator_data");
                idKey = "operator_no";
                valueKey = "operator_name";
                showImage = true;
            }
            if (!CollectionUtils.isEmpty(datas)) {
                responseData.setTotal(datas.size());
                responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());
                for (Map<String, Object> data : datas) {
                    InputWindowSingleItem singleItem = new InputWindowSingleItem();
                    String id = (String) data.get(idKey);
                    String value = (String) data.get(valueKey);
                    singleItem.setShowImage(showImage);
                    singleItem.setId(id);
                    singleItem.setTitle(value);
                    singleItem.setText(value);
                    singleItem.setDetail(data);

                    if ("reject_to_op_seq".equals(type)) {
                        RelationRule relationRule = new RelationRule();
                        CommonRule riskLevelNameRule = new CommonRule();
                        riskLevelNameRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        riskLevelNameRule.setTargetEnable(true);
                        riskLevelNameRule.setTargetHidden(false);
                        riskLevelNameRule.setTargetSchema("operator_data");

                        List<Map<String, Object>> targetSelectList = new ArrayList<>();
                        for (Map<String, Object> operatorData : (List<Map<String, Object>>) data.get("operator_data")) {
                            Map<String, Object> targetSelectMap = new HashMap<>(3);
                            targetSelectMap.put("id", operatorData.get("operator_no"));
                            targetSelectMap.put("value", operatorData.get("operator_name"));
                            targetSelectMap.put("text", operatorData.get("operator_name"));
                            targetSelectMap.put("detail", Collections.emptyMap());
                            targetSelectList.add(targetSelectMap);
                        }
                        riskLevelNameRule.setTargetSelectList(targetSelectList);
                        relationRule.setRuleList(Collections.singletonList(riskLevelNameRule));
                        singleItem.setRelationRule(relationRule);
                    }
                    itemList.add(singleItem);
                }
                responseData.setList(itemList);
            }
            return ApiResponse.buildOK().setData(responseData);
        } else {
            if (rawData.get("isQuestion") != null && (Boolean) rawData.get("isQuestion")) {
                InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
                if (handelSupplier(requestData, rawData, responseData)) {
                    return ApiResponse.buildOK().setData(responseData);
                }

                // 反馈通知人
                if (handleFeedbackNoticePersonInfo(requestData, rawData, responseData)) {
                    return ApiResponse.buildOK().setData(responseData);
                }
            }

            // 体系云未启动项目-选择模板开窗
            if ("isSCHEditPlanTemplateInfo".equals(rawData.get("type"))) {
                return ApiResponse.buildOK().setData(handleSCHEditPlanTemplateInfo(requestData, rawData));
            }

            // 体系云未启动项目-编辑卡片执行人开窗
            if ("isSCHEditTaskQueryEmployee".equals(rawData.get("type"))) {
                return ApiResponse.buildOK().setData(handleSCHEditTaskQueryEmployee(requestData, rawData));
            }

            if (rawData.get("isProject") != null && (Boolean) rawData.get("isProject")) {
                List<Map<String, Object>> datas;
                InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
                if ("project_name".equals(rawData.get("type"))) {
                    String source = (String) rawData.get("equipment_source");
                    if (source.contains("PCC")) {
                        source = "PCC";
                    } else if (source.contains("PMS")) {
                        source = "PMS";
                    }
                    Map<String, Object> body = new HashMap<>(rawData);
                    body.put("userId", requestData.getUserId());
                    body.put("project_source", source);
                    body.put("inquiry_data", requestData.getQueryCondition());
                    datas = digiwinEspProxyService.getProjectInfo(requestData.getIamUserToken(),
                            requestData.getTenantId(), requestData.getLocale(), body);
                    if (!CollectionUtils.isEmpty(datas)) {
                        responseData.setTotal(datas.size());
                        responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                        List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());
                        for (Map<String, Object> data : datas) {
                            InputWindowSingleItem singleItem = new InputWindowSingleItem();
                            String id = (String) data.get("project_no");
                            String value = (String) data.get("project_name");
                            singleItem.setShowImage(false);
                            singleItem.setId(id);
                            singleItem.setTitle(value);
                            singleItem.setText(value);
                            singleItem.setDetail(data);
                            if ("N".equalsIgnoreCase((String) rawData.get("deviceNameHiddenRequired"))) {
                                if (StringUtils.isNotBlank(source) && source.contains("PCC")) {
                                    RelationRule relationRule = new RelationRule();
                                    List<CommonRule> ruleList = relationRule.getRuleList();
                                    CommonRule rule = new CommonRule();
                                    rule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                                    rule.setTargetText(id);
                                    rule.setTargetSchema("equipment_name");
                                    ruleList.add(rule);

                                    CommonRule ruleProjectName = new CommonRule();
                                    ruleProjectName.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                                    ruleProjectName.setTargetText(id);
                                    ruleProjectName.setTargetHidden(false);
                                    ruleProjectName.setTargetSchema("project_stage_name");
                                    ruleProjectName.setTargetSelectId("");
                                    ruleList.add(ruleProjectName);

                                    singleItem.setRelationRule(relationRule);
                                }
                            } else {
                                RelationRule relationRule = new RelationRule();
                                List<CommonRule> ruleList = relationRule.getRuleList();
                                CommonRule rule = new CommonRule();
                                rule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                                rule.setTargetText("");
                                rule.setTargetSelectId("");
                                rule.setTargetHidden(true);
                                rule.setTargetSchema("equipment_name");
                                ruleList.add(rule);

                                CommonRule ruleProjectName = new CommonRule();
                                ruleProjectName.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                                ruleProjectName.setTargetText(id);
                                ruleProjectName.setTargetHidden(false);
                                ruleProjectName.setTargetSchema("project_stage_name");
                                ruleProjectName.setTargetSelectId("");
                                ruleList.add(ruleProjectName);

                                singleItem.setRelationRule(relationRule);
                            }
                            itemList.add(singleItem);
                        }
                        responseData.setList(itemList);
                        return ApiResponse.buildOK().setData(responseData);
                    }
                } else if ("equipment_name".equals(rawData.get("type"))) {
                    String source = (String) rawData.get("equipment_source");
                    if (source.contains("PCC")) {
                        source = "PCC";
                    } else if (source.contains("PMS")) {
                        source = "PMS";
                    }
                    Map<String, Object> params = new HashMap<>(2);
                    for (ActionSubmitParam submitParam : requestData.getSubmitParams()) {
                        if (submitParam.getSchema().equalsIgnoreCase("project_name")) {
                            InputWindowSingleSelect select = (InputWindowSingleSelect) submitParam.getParams();
                            params.put("project_no", select.getSelectId());
                            break;
                        }
                    }
                    params.put("equipment_source", source);
                    List<Map<String, Object>> equipments = digiwinEspProxyService.
                            getEquipmentInfo(requestData.getIamUserToken(),
                                    requestData.getTenantId(), requestData.getLocale(), params);
                    List<InputWindowSingleItem> itemList = new ArrayList<>(equipments.size());
                    if (!CollectionUtils.isEmpty(equipments)) {
                        for (Map<String, Object> equipment : equipments) {
                            InputWindowSingleItem singleItem = new InputWindowSingleItem();
                            String id = (String) equipment.get("equipment_no");
                            String value = (String) equipment.get("equipment_name");
                            singleItem.setShowImage(false);
                            singleItem.setId(id);
                            singleItem.setTitle(value);
                            singleItem.setText(value);
                            singleItem.setDetail(equipment);
                            itemList.add(singleItem);
                        }
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                } else if ("project_stage_name".equals(rawData.get("type"))) {
                    String source = (String) rawData.get("project_source");
                    if (source.contains("PCC")) {
                        source = "PCC";
                    } else if (source.contains("PMS")) {
                        source = "PMS";
                    }
                    Map<String, Object> params = new HashMap<>(3);
                    for (ActionSubmitParam submitParam : requestData.getSubmitParams()) {
                        if (submitParam.getSchema().equalsIgnoreCase("project_name")) {
                            InputWindowSingleSelect select = (InputWindowSingleSelect) submitParam.getParams();
                            Map<String, Object> detail = select.getDetail();
                            params.put("project_no", detail.get("project_no"));
                            params.put("project_status", detail.get("project_status"));
                            break;
                        }
                    }
                    params.put("inquiry_data", requestData.getQueryCondition());
                    params.put("project_source", source);
                    List<Map<String, Object>> equipments = digiwinEspProxyService.
                            getProjectStageThirdPartyInfo(requestData.getIamUserToken(),
                                    requestData.getTenantId(), requestData.getLocale(), params);
                    List<InputWindowSingleItem> itemList = new ArrayList<>(equipments.size());
                    if (!CollectionUtils.isEmpty(equipments)) {
                        for (Map<String, Object> equipment : equipments) {
                            InputWindowSingleItem singleItem = new InputWindowSingleItem();
                            String id = (String) equipment.get("project_stage_no");
                            String value = (String) equipment.get("project_stage_name");
                            singleItem.setShowImage(false);
                            singleItem.setId(id);
                            singleItem.setTitle(value);
                            singleItem.setText(value);
                            singleItem.setDetail(equipment);
                            itemList.add(singleItem);
                        }
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                }
            }

            //进度回报-数量转移按钮 MKP
            if (ObjectUtil.isNotEmpty(rawData.get("isTransferQuantityMkp")) && (Boolean) rawData.get("isTransferQuantityMkp")) {
                List<Map<String, Object>> datas;
                InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
                //后制程
                List<Map<String, Object>> paramList = (List<Map<String, Object>>) rawData.get("paramList");
                datas = digiwinEspProxyService.getOpNextInfo(
                        requestData.getIamUserToken(), requestData.getTenantId(), requestData.getLocale(), paramList);
                responseData.setTotal(datas.size());
                responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                List<InputWindowSingleItem> itemList = new ArrayList<>();
                if (CollUtil.isNotEmpty(datas)) {
                    List<ColumnTag> columnTags = columnTagService.listColumnTagsBymTagId(rawData.get("pageId").toString());
                    List<ColumnTag> opNoList = columnTags.stream()
                            .filter(tag -> tag.getTagDefinition().getCode().equalsIgnoreCase(
                                    ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()))
                            .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                            .collect(Collectors.toList());
                    List<ColumnTag> opNameList = columnTags.stream()
                            .filter(tag -> tag.getTagDefinition().getCode().equalsIgnoreCase(
                                    ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()))
                            .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                            .collect(Collectors.toList());
                    for (Map<String, Object> data : datas) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String opNo = (String) data.get("op_no");
                        String value = (String) data.get("op_name");
                        singleItem.setShowImage(false);
                        singleItem.setId(opNameList.get(0).getSchema());
                        singleItem.setTitle(value);
                        singleItem.setText(LocaleUtil.getMobileTextByDatabaseKey(requestData.getLocale(), opNameList.get(0).getLabel()));
                        singleItem.setDetail(data);
                        List<SmartPreciseSearchField> dataList = new ArrayList<>();
                        SmartPreciseSearchField field = new SmartPreciseSearchField();
                        field.setFieldId(opNoList.get(0).getSchema());
                        String mobileTextByDatabaseKey = LocaleUtil.getMobileTextByDatabaseKey(requestData.getLocale(), opNoList.get(0).getLabel());
                        field.setFieldTitle(mobileTextByDatabaseKey);
                        field.setFieldValue(opNo);
                        dataList.add(field);
                        singleItem.setDataList(dataList);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                }
            }

            //进度回报-进度回报 MKP
            if (ObjectUtil.isNotEmpty(rawData.get("isProgressReturnMkp")) && (Boolean) rawData.get("isProgressReturnMkp")) {
                List<Map<String, Object>> datas;
                InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
                //后制程
                List<Map<String, Object>> paramList = (List<Map<String, Object>>) rawData.get("paramList");
                datas = digiwinEspProxyService.getOpNextInfo(
                        requestData.getIamUserToken(), requestData.getTenantId(), requestData.getLocale(), paramList);
                responseData.setTotal(datas.size());
                responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                List<InputWindowSingleItem> itemList = new ArrayList<>();
                if (CollUtil.isNotEmpty(datas)) {
                    List<ColumnTag> columnTags = columnTagService.listColumnTagsBymTagId(rawData.get("pageId").toString());
                    List<ColumnTag> opNoList = columnTags.stream()
                            .filter(tag -> tag.getTagDefinition().getCode().equalsIgnoreCase(
                                    ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()))
                            .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                            .collect(Collectors.toList());
                    List<ColumnTag> opNameList = columnTags.stream()
                            .filter(tag -> tag.getTagDefinition().getCode().equalsIgnoreCase(
                                    ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()))
                            .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                            .collect(Collectors.toList());
                    for (Map<String, Object> data : datas) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        String opNo = (String) data.get("op_no");
                        String value = (String) data.get("op_name");
                        singleItem.setShowImage(false);
                        singleItem.setId(opNameList.get(0).getSchema());
                        singleItem.setTitle(value);
                        singleItem.setText(LocaleUtil.getMobileTextByDatabaseKey(requestData.getLocale(), opNameList.get(0).getLabel()));
                        singleItem.setDetail(data);
                        List<SmartPreciseSearchField> dataList = new ArrayList<>();
                        SmartPreciseSearchField field = new SmartPreciseSearchField();
                        field.setFieldId(opNoList.get(0).getSchema());
                        String mobileTextByDatabaseKey = LocaleUtil.getMobileTextByDatabaseKey(requestData.getLocale(), opNoList.get(0).getLabel());
                        field.setFieldTitle(mobileTextByDatabaseKey);
                        field.setFieldValue(opNo);
                        dataList.add(field);
                        singleItem.setDataList(dataList);
                        /*
                        当进度选择100%时，增加一个逻辑：联动出现“后制程”栏位(开窗单选，必填）
                        当进度选择<100%，不联动后制程处理 隐藏
                         */
                        RelationRule relationRule = new RelationRule();
                        List<RelationRuleText> textRuleList = new ArrayList<>(1);
                        RelationRuleText relationRuleText = new RelationRuleText();
                        relationRuleText.setCondition(RuleCategoryEnum.RELATION.getCategory());
                        relationRuleText.setCondition("100");
                        relationRuleText.setConditionOperatorType(RuleConditionOperatorTypeEnum.EQUALS.getType());
                        relationRuleText.setTargetSchema("op_name");
                        relationRuleText.setTargetHidden(false);
                        relationRuleText.setTargetRequired(true);
                        RelationRuleText ruleText = new RelationRuleText();
                        ruleText.setCondition(RuleCategoryEnum.RELATION.getCategory());
                        ruleText.setCondition("100");
                        ruleText.setConditionOperatorType(RuleConditionOperatorTypeEnum.NOT_EQUALS.getType());
                        ruleText.setTargetSchema("op_name");
                        ruleText.setTargetHidden(true);
                        ruleText.setTargetRequired(true);
                        textRuleList.add(relationRuleText);
                        textRuleList.add(ruleText);
                        relationRule.setTextRuleList(textRuleList);
                        singleItem.setRelationRule(relationRule);
                        itemList.add(singleItem);
                    }
                    responseData.setList(itemList);
                    return ApiResponse.buildOK().setData(responseData);
                }
            }
            if (ObjectUtil.isNotEmpty(rawData.get("isReconciliationProgress")) && (Boolean) rawData.get("isReconciliationProgress")) {
                List<Map<String, Object>> datas = ReconciliationProgressReasonEnum.getReasonList();
                InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
                if (!CollectionUtils.isEmpty(datas)) {
                    responseData.setTotal(datas.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                    List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());

                    String queryCondition = requestData.getQueryCondition();
                    for (Map<String, Object> data : datas) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        singleItem.setId(String.valueOf(data.get("code")));
                        String desc = localeService.getLanguageValue(requestData.getLocale(), String.valueOf(data.get("desc")));
                        singleItem.setTitle(desc);
                        singleItem.setText(desc);

                        if (StringUtils.isEmpty(queryCondition) || singleItem.getTitle().contains(queryCondition)) {
                            itemList.add(singleItem);
                        }
                    }
                    responseData.setList(itemList);
                }
                return ApiResponse.buildOK().setData(responseData);
            }
            // 试验优测检测数据条目详情-判定结果字段开窗数据
            if (ObjectUtil.isNotEmpty(rawData.get("isDetectionDataDetail")) && (Boolean) rawData.get("isDetectionDataDetail")) {
                List<Map<String, Object>> resultList = (List<Map<String, Object>>) MapUtil.getOrDefault(rawData, "resultList", Collections.emptyList());
                InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
                if (!CollectionUtils.isEmpty(resultList)) {

                    // 如果ids有值，精确匹配，目前用在判定结果的异步显示上
                    List<String> ids = requestData.getIds();
                    if (!CollectionUtils.isEmpty(ids)) {
                        resultList = resultList.stream().filter(e -> ids.contains(e.get("value"))).collect(Collectors.toList());
                    }

                    responseData.setTotal(resultList.size());
                    responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());

                    String queryCondition = requestData.getQueryCondition();
                    List<InputWindowSingleItem> itemList = new ArrayList<>(resultList.size());
                    for (Map<String, Object> result : resultList) {
                        InputWindowSingleItem singleItem = new InputWindowSingleItem();
                        singleItem.setId(String.valueOf(result.get("value")));
                        singleItem.setTitle(String.valueOf(result.get("name")));
                        singleItem.setText(singleItem.getTitle());

                        if (StringUtils.isEmpty(queryCondition) || singleItem.getTitle().contains(queryCondition)) {
                            itemList.add(singleItem);
                        }
                    }
                    responseData.setList(itemList);
                }
                return ApiResponse.buildOK().setData(responseData);
            }
            //往rawData里传入parameter
            handleRawData(rawData, requestData.getSubmitParams());
            handleBusinessUnitRawData(rawData, request);
            UiBotModel uiBotModel = null;
            if (PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString().equalsIgnoreCase(requestData.getPageId())
                    || PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString().equalsIgnoreCase(requestData.getPageId())) {
                Map<String, Object> executeContextMap = (Map<String, Object>) rawData.get("executeContext");
                String proxyToken = (String) executeContextMap.get("proxyToken");
                uiBotModel = digiwinPcUiBotProxyService.actionShowByProxyToken(requestData.getLocale(),
                        requestData.getTenantId(), proxyToken, requestData.getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(requestData.getRawData()));
            } else {
                uiBotModel = digiwinPcUiBotProxyService.actionShow(requestData.getLocale(),
                        requestData.getIamUserToken(),
                        JsonUtil.javaObjectToJsonString(requestData.getRawData()));
            }
            InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
            ApiRequest apiRequest = JsonUtil.jsonStringToObject(((RequestWrapper) request).getBodyString(), ApiRequest.class);
            if (apiRequest == null) {
                apiRequest = ApiRequest.createEmpty();
            }
            String componentSchema = request.getParameter("componentSchema");
            apiRequest.setLinkSchema(componentSchema);
            List<InputWindowSingleItem> itemList =
                    this.inputWindowSingleItemBuilder.build(apiRequest, null, uiBotModel,
                            InputWindowSingleItem.class);

            if (itemList.isEmpty()) {
                return ApiResponse.buildOK().setData(InputWindowSingleResponseData.empty());
            }
            //根据backFill对获取到的数据detail调整
            List buttons = new ArrayList();
            if (rawData.get("buttons") != null) {
                buttons = (List) rawData.get("buttons");
            }
            handleBackFill(itemList, buttons);
            //对问题快反页面中风险等级、问题提出人客制处理，加入联动信息
            if (componentSchema.contains("?")) {
                componentSchema = componentSchema.split("\\?")[0];
            }
            if (StringUtils.isNotBlank(componentSchema) && ("risk_level_name".equalsIgnoreCase(componentSchema)
                    || "question_proposer_name".equalsIgnoreCase(componentSchema)
                    || "question_source_name".equalsIgnoreCase(componentSchema)
                    || "question_classification_name".equalsIgnoreCase(componentSchema)
                    || "occur_stage_name".equalsIgnoreCase(componentSchema)
                    || "question_attribution_name".equalsIgnoreCase(componentSchema)
            )) {
                customHandleItemList(itemList, componentSchema, apiRequest.getLocale(), rawData.get("supplierControlsExternalMaintenance"));
            }

            if (PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL.toString().equalsIgnoreCase(requestData.getPageId())) {
                if (!CollectionUtils.isEmpty(itemList)) {
                    for (InputWindowSingleItem inputWindowSingleItem : itemList) {
                        if (null == inputWindowSingleItem.getDetail()) {
                            continue;
                        }
                        String workProcedureType = String.valueOf(inputWindowSingleItem.getDetail().get("work_procedure_type"));

                        RelationRule relationRule = new RelationRule();
                        List<CommonRule> ruleList = relationRule.getRuleList();
                        CommonRule riskLevelNameRule = new CommonRule();

                        riskLevelNameRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        riskLevelNameRule.setTargetEnable(false);
                        riskLevelNameRule.setTargetHidden(false);
                        riskLevelNameRule.setTargetSchema("work_procedure_type");
                        riskLevelNameRule.setTargetText(workProcedureType);
                        ruleList.add(riskLevelNameRule);
                        inputWindowSingleItem.setRelationRule(relationRule);
                    }
                }

            }

            if (PageSettingIdPresetEnum.MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL.toString().equalsIgnoreCase(requestData.getPageId())) {
                if (!CollectionUtils.isEmpty(itemList)) {
                    for (InputWindowSingleItem inputWindowSingleItem : itemList) {
                        if (null == inputWindowSingleItem.getDetail()) {
                            continue;
                        }
                        String employeeName = String.valueOf(inputWindowSingleItem.getDetail().get("employee_name"));

                        RelationRule relationRule = new RelationRule();
                        List<CommonRule> ruleList = relationRule.getRuleList();
                        CommonRule riskLevelNameRule = new CommonRule();

                        // 显示当前组里的员工姓名， 通过替换员工编号字段名来保存组名后缀不变
                        riskLevelNameRule.setTargetSchema(componentSchema.replace("employee_no", "employee_name"));
                        riskLevelNameRule.setTargetText(employeeName);
                        riskLevelNameRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        riskLevelNameRule.setTargetEnable(false);
                        riskLevelNameRule.setTargetHidden(false);
                        ruleList.add(riskLevelNameRule);
                        inputWindowSingleItem.setRelationRule(relationRule);
                    }
                }

            }

            if (StringUtils.isNotBlank(componentSchema) && "team_name".equalsIgnoreCase(componentSchema)) {
                // 改变班组也需要刷新页面
                Action refreshAction = new Action<>();
                refreshAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.toString());
                refreshAction.setJumpPageTitle("");
                refreshAction.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                itemList.forEach(item -> {
                    item.setSubmitAction(refreshAction);
                });
            }
            List<InputWindowSingleItem> newItemList = new ArrayList<>(itemList.size());
//            if (StringUtils.isNotBlank(componentSchema) && "except_name".equalsIgnoreCase(componentSchema)) {
//                List<ActionSubmitParam> params = requestData.getSubmitParams();
//                String level1 = "";
//                String level2 = "";
//                for (ActionSubmitParam param : params) {
//                    if (InputCascade.COMPONENT_TYPE.equals(param.getType())) {
//                        ArrayList<Map<String, Object>> maps = (ArrayList<Map<String, Object>>) param.getParams();
//                        for (Map<String, Object> map : maps) {
//                            InputCascadeData inputCascadeData = JsonUtil.objectToJavaObject(map, InputCascadeData.class);
//                            if ("eoc_company_id".equals(inputCascadeData.getSchema())) {
//                                level1 = inputCascadeData.getId();
//                            } else if ("eoc_site_id".equals(inputCascadeData.getSchema())) {
//                                level2 = inputCascadeData.getId();
//                            }
//                        }
//                    }
//                }
//                for (InputWindowSingleItem item : itemList) {
//                    Map<String, Object> detail = item.getDetail();
//                    if (level1.equals(detail.get("eoc_company_id")) && level2.equals(detail.get("eoc_site_id"))) {
//                        newItemList.add(item);
//                    }
//                }
//            } else {
            newItemList = itemList;
//            }

            responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
            responseData.setList(newItemList);
            responseData.setTotal(newItemList.size());

            return ApiResponse.buildOK().setData(responseData);
        }
        return ApiResponse.buildOK().setData(InputWindowSingleResponseData.empty());
    }

    /**
     * 处理问题快反 供应商开窗选择数据
     *
     * @param requestData
     * @param rawData
     * @param responseData
     * @return boolean
     * @author yanfeng
     */
    private boolean handelSupplier(InputWindowSingleRequestData requestData, Map<String, Object> rawData, InputWindowSingleResponseData responseData) {
        if ("supplier".equals(rawData.get("type"))) {
            //交付设计器,供应商来源 : ERP,IAM(鼎捷云)
            String supplierSource = String.valueOf(rawData.get("supplierSource"));
            List<Map<String, Object>> datas = digiwinEspProxyService.getInfoSupplierQuestion(requestData.getIamUserToken(),
                    requestData.getTenantId(), requestData.getLocale(), supplierSource);
            responseData.setTotal(datas.size());
            responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
            List<InputWindowSingleItem> itemList = new ArrayList<>(datas.size());

            List<ColumnTag> columnTags = columnTagService
                    .listColumnTagsByPathAndPageId("allActionName", "MOBILE_PROJECT_CREATE");
            // "移动次要"
            List<ColumnTag> profileTags = columnTags.stream().filter(
                            tag -> ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()
                                    .equalsIgnoreCase(tag.getTagDefinition().getCode()))
                    .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());

            String queryCondition = requestData.getQueryCondition();
            for (Map<String, Object> date : datas) {
                InputWindowSingleItem singleItem = new InputWindowSingleItem();
                String id = (String) date.get("supplier_no");
                String value = (String) date.get("supplier");
                singleItem.setShowImage(false);
                singleItem.setId(id);
                singleItem.setText(id);
                singleItem.setTitle(localeService.getLanguageValue(requestData.getLocale(), value));
                singleItem.setDetail(date);
                List<String> content = profileTags
                        .stream()
                        .filter(profileTag -> "supplier_no".equalsIgnoreCase(profileTag.getSchema()))
                        .map(profileTag -> localeService.getLanguageValue(requestData.getLocale(), profileTag.getLabel()) + " " + id)
                        .collect(Collectors.toList());
                singleItem.setContent(content);

                if (StringUtils.isEmpty(queryCondition) || singleItem.getTitle().contains(queryCondition)) {
                    itemList.add(singleItem);
                }
            }
            responseData.setList(itemList);
            return true;
        }
        return false;
    }

    private boolean handleFeedbackNoticePersonInfo(InputWindowSingleRequestData requestData, Map<String, Object> rawData, InputWindowSingleResponseData responseData) {
        if (!"feedbackNoticePersonInfo".equals(rawData.get("type"))) {
            return false;
        }
        Map<String, Object> questionEocDeptUserInfoMap = digiwinEspProxyService.getQuestionEocDeptUserInfo(requestData.getIamUserToken(),
                requestData.getTenantId(), requestData.getLocale(), Collections.emptyMap());
        if (!CollectionUtils.isEmpty(questionEocDeptUserInfoMap)) {
            List<Map<String, Object>> departmentInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(questionEocDeptUserInfoMap, "department_info", Collections.emptyList());
            List<Map<String, Object>> employeeInfoList = departmentInfoList.stream().map(e -> {
                List<Map<String, Object>> employeeInfoListByDepartment = (List<Map<String, Object>>) MapUtil.getOrDefault(e, "employee_info", Collections.emptyList());
                employeeInfoListByDepartment.forEach(item -> item.put("department_name", e.get("department_name")));
                return employeeInfoListByDepartment;
            }).flatMap(List::stream).collect(Collectors.toList());

            String departmentLabel = localeService.getLanguageValue(requestData.getLocale(), "部门名称");
            if (!CollectionUtils.isEmpty(employeeInfoList)) {
                List<InputWindowSingleItem> inputWindowSingleItemList = employeeInfoList.stream().map(employeeInfo -> {
                    InputWindowSingleItem singleItem = new InputWindowSingleItem();
                    String id = String.valueOf(employeeInfo.get("employee_id"));
                    String value = String.valueOf(employeeInfo.get("employee_name"));
                    singleItem.setShowImage(true);
                    singleItem.setId(id);
                    singleItem.setTitle(value);
                    singleItem.setText(value);

                    Map<String, Object> detailMap = new HashMap<>(2);
                    detailMap.put("notice_person_id", id);
                    detailMap.put("notice_person_name", value);
                    singleItem.setDetail(detailMap);
                    String contentList = departmentLabel + ColumnTag.DEFAULT_DISPLAY_SEPERATOR
                            + (Objects.nonNull(employeeInfo.get("department_name"))
                            ? employeeInfo.get("department_name") : "-");
                    singleItem.setContent(Collections.singletonList(contentList));
                    return singleItem;
                }).collect(Collectors.toList());
                responseData.setList(inputWindowSingleItemList);
                responseData.setTotal(inputWindowSingleItemList.size());
                responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
                return true;
            }
        }
        return false;
    }

    private InputWindowSingleResponseData handleSCHEditPlanTemplateInfo(InputWindowSingleRequestData requestData, Map<String, Object> rawData) {
        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        Map<String, Object> requestParam = (Map<String, Object>) MapUtil.getOrDefault(rawData, "requestParam", Collections.emptyMap());
        DigiwinAthenaApiResponse<JSONObject> projectTemplateInfoResp = digiwinAtdmProxyService
                .handleByActionId(requestData.getLocale(), requestData.getIamUserToken(), requestData.getTenantId(), "", requestParam);
        List<Map<String, Object>> projectTemplateInfoList = Optional.ofNullable(projectTemplateInfoResp.getResponse())
                .map(e -> (List<Map<String, Object>>) e.get("project_template_info"))
                .orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(projectTemplateInfoList)) {
            List<InputWindowSingleItem> inputWindowSingleItemList = projectTemplateInfoList.stream().map(projectTemplateInfo -> {
                InputWindowSingleItem singleItem = new InputWindowSingleItem();
                String projectTemplateNo = MapUtils.getString(projectTemplateInfo, "project_template_no");
                String projectTemplateName = MapUtils.getString(projectTemplateInfo, "project_template_name");
                singleItem.setShowImage(true);
                singleItem.setId(projectTemplateNo);
                singleItem.setTitle(projectTemplateName);
                singleItem.setText(projectTemplateName);
                String content = MapUtils.getString(projectTemplateInfo, "project_type_name", "");
                singleItem.setContent(Collections.singletonList(content));
                singleItem.setDetail(projectTemplateInfo);

                CommonRule ruleProjectName = new CommonRule();
                ruleProjectName.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
                ruleProjectName.setTargetHidden(false);
                ruleProjectName.setTargetSchema("plan_rearrange_base_date");
                RelationRule relationRule = new RelationRule();
                relationRule.setRuleList(Collections.singletonList(ruleProjectName));
                singleItem.setRelationRule(relationRule);
                return singleItem;
            }).collect(Collectors.toList());
            responseData.setList(inputWindowSingleItemList);
            responseData.setTotal(inputWindowSingleItemList.size());
            responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        }
        return responseData;
    }

    private InputWindowSingleResponseData handleSCHEditTaskQueryEmployee(InputWindowSingleRequestData requestData, Map<String, Object> rawData) {
        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        Map<String, Object> requestParam = (Map<String, Object>) MapUtil.getOrDefault(rawData, "requestParam", Collections.emptyMap());
        DigiwinAthenaApiResponse<JSONObject> projectTemplateInfoResp = digiwinAtdmProxyService
                .handleByActionId(requestData.getLocale(), requestData.getIamUserToken(), requestData.getTenantId(), "", requestParam);
        List<Map<String, Object>> appAuthEmployeeInfoList = Optional.ofNullable(projectTemplateInfoResp.getResponse())
                .map(e -> (List<Map<String, Object>>) e.get("app_auth_employee_info"))
                .orElse(Collections.emptyList());
        if (!CollectionUtils.isEmpty(appAuthEmployeeInfoList)) {
            List<InputWindowSingleItem> inputWindowSingleItemList = appAuthEmployeeInfoList.stream().map(appAuthEmployeeInfo -> {
                InputWindowSingleItem singleItem = new InputWindowSingleItem();
                String projectTemplateNo = MapUtils.getString(appAuthEmployeeInfo, "employee_no");
                String projectTemplateName = MapUtils.getString(appAuthEmployeeInfo, "employee_name");
                singleItem.setShowImage(true);
                singleItem.setId(projectTemplateNo);
                singleItem.setTitle(projectTemplateName);
                singleItem.setText(projectTemplateName);
                String content = MapUtils.getString(appAuthEmployeeInfo, "department_name", "");
                singleItem.setContent(Collections.singletonList(content));
                singleItem.setDetail(appAuthEmployeeInfo);
                return singleItem;
            }).collect(Collectors.toList());

            List<String> ids = requestData.getIds();
            if (!CollectionUtils.isEmpty(ids)) {
                inputWindowSingleItemList = inputWindowSingleItemList.stream().filter(e -> ids.contains(e.getId())).collect(Collectors.toList());
            }

            responseData.setList(inputWindowSingleItemList);
            responseData.setTotal(inputWindowSingleItemList.size());
            responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        }
        return responseData;
    }

    private void handleBusinessUnitRawData(Map<String, Object> rawData, HttpServletRequest request) {
        try {
            // 除外回报 班组/人员/除外原因 根据据点联动筛选
            if ("team_name".equalsIgnoreCase(request.getParameter("componentSchema"))
                    || "reporter_name".equalsIgnoreCase(request.getParameter("componentSchema"))
                    || "except_name".equalsIgnoreCase(request.getParameter("componentSchema"))) {
                Map<String, Object> parameter = (Map<String, Object>) rawData.get("parameter");
                Map<String, Object> dataSourceSet = (Map<String, Object>) rawData.get("dataSourceSet");
                List<Map<String, Object>> dataSourceList = (List<Map<String, Object>>) dataSourceSet.get("dataSourceList");
                if (ObjectUtils.isNotEmpty(parameter)) {
                    for (Map<String, Object> map : dataSourceList) {
                        Map<String, Object> action = (Map<String, Object>) map.get("action");
                        Map<String, Object> businessUnit = new HashMap<>();
                        businessUnit.put("eoc_company_id", parameter.get("eoc_company_id"));
                        businessUnit.put("eoc_site_id", parameter.get("eoc_site_id"));
                        action.put("businessUnit", businessUnit);
                    }
                }
            }
        } catch (Exception e) {
            log.error("ProxyController[handleBusinessUnitRawData] error: ", e);
        }
    }


    /**
     * 开窗单选查询车辆信息
     *
     * @param requestData
     * @param request
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value = "/window/driver/list")
    public ApiResponse<InputWindowSingleResponseData> driverList(
            @RequestBody InputWindowSingleRequestData requestData, HttpServletRequest request) {
        String locale = requestData.getLocale();
        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        Map<String, Object> params = new HashMap<>(1);
        if (!StringUtil.isNullOrEmpty(requestData.getQueryCondition())) {
            params.put("vehicle_keyword", requestData.getQueryCondition());
        }
        //获取车辆信息列表
        List<Map<String, Object>> driverVehicles = digiwinEspProxyService.getDriverVehicle(requestData.getIamUserToken(), requestData.getTenantId(), requestData.getLocale(), params);
        if (driverVehicles == null || driverVehicles.size() == 0) {
            responseData = InputWindowSingleResponseData.empty();
        } else {
            List<InputWindowSingleItem> singleItems = new ArrayList<>(driverVehicles.size());
            responseData.setTotal(driverVehicles.size());
            responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
            //拿到车辆信息的显示参数
            List<ColumnTag> columnTags = columnTagService.listColumnTagsByPathAndPageId("driver_vehicle", requestData.getPageId());
            // 唯一标识字段tag
            List<ColumnTag> businessTagList = columnTags.stream()
                    .filter(tag -> tag.getPath().equalsIgnoreCase("driver_vehicle") && tag.getTagDefinition().getCode().equalsIgnoreCase(
                            ColumnTagDefinitionCodeEnum.BUSINESS_ID.getCode()))
                    .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                    .collect(Collectors.toList());
            // 标题标识字段tag
            List<ColumnTag> displayTagList = columnTags.stream()
                    .filter(tag -> tag.getPath().equalsIgnoreCase("driver_vehicle") && tag.getTagDefinition().getCode().equalsIgnoreCase(
                            ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()))
                    .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                    .collect(Collectors.toList());
            // 分组字段tag
            List<ColumnTag> groupTagList = columnTags.stream()
                    .filter(tag -> tag.getPath().equalsIgnoreCase("driver_vehicle") && tag.getTagDefinition().getCode().equalsIgnoreCase(
                            ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode()))
                    .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                    .collect(Collectors.toList());
            for (Map<String, Object> driverVehicle : driverVehicles) {
                InputWindowSingleItem item = new InputWindowSingleItem();
                Integer id = (Integer) driverVehicle.get(businessTagList.get(0).getSchema());
                item.setId(String.valueOf(id));
                Action editAction = new Action();
                editAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "更新车辆信息"));
                editAction.setJumpPageId("MOBILE_ZTB_CAR_MESSAGE");
                Map<String, Object> rawData = new HashMap<>(1);
                rawData.put("editId", id);
                editAction.setRawData(rawData);
                editAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                editAction.setScreenShotSwitch(false);
                editAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
                item.setTitle((String) driverVehicle.get(displayTagList.get(0).getSchema()));
                item.setDetail(driverVehicle);
                item.setShowEdit(true);
                item.setShowImage(false);
                item.setSubtitle("");
                item.setEditAction(editAction);
                item.setContent(Collections.emptyList());
                List<SmartPreciseSearchField> fields = new ArrayList<>(groupTagList.size());
                for (ColumnTag tag : groupTagList) {
                    SmartPreciseSearchField field = new SmartPreciseSearchField();
                    field.setFieldTitle(tag.getmLabelText().get(locale));
                    field.setFieldId(tag.getSchema());
                    field.setFieldValue((String) driverVehicle.get(tag.getSchema()));
                    field.setSkip(false);
                    field.setFieldLayoutType(1);
                    field.setSkipConfig(new SkipConfig());
                    fields.add(field);
                }
                item.setDataList(fields);
                singleItems.add(item);
            }
            responseData.setList(singleItems);
        }
        return ApiResponse.buildOK().setData(responseData);
    }

    /**
     * 开窗多选行事历选择执行人
     *
     * @param requestData
     * @param request
     * @return
     */
    @RequestMapping(method = RequestMethod.POST, value = "/window/getTeamMembers")
    public ApiResponse<InputWindowSingleResponseData> getTeamMembers(
            @RequestBody InputWindowSingleRequestData requestData, HttpServletRequest request) {
        List<DigiwinAtmcCalendar> digiwinAtmcCalendars = this.digiwinAtmcProxyService.queryAllTeamMember(requestData.getIamUserToken(), requestData.getLocale());
        if (digiwinAtmcCalendars == null || digiwinAtmcCalendars.size() == 0) {
            return ApiResponse.buildOK().setData(InputWindowSingleResponseData.empty());
        }
        List<ActionSubmitParam> actionSubmitParams = requestData.getSubmitParams();
        String id = "";
        for (ActionSubmitParam actionSubmitParam : actionSubmitParams) {
            if ("teamId".equals(actionSubmitParam.getSchema())) {
                InputSingleSelect inputSingleSelect = (InputSingleSelect) actionSubmitParam.getParams();
                id = inputSingleSelect.getSelectId();
                break;
            }
        }
        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        for (DigiwinAtmcCalendar digiwinAtmcCalendar : digiwinAtmcCalendars) {
            if (String.valueOf(digiwinAtmcCalendar.getId()).equals(id)) {
                List<DigiwinAtmcCalendarTeamMember> teamMembers = digiwinAtmcCalendar.getMembers();
                List<InputWindowSingleItem> itemList = new ArrayList<>(teamMembers.size());
                if (teamMembers == null || teamMembers.size() == 0) {
                    InputWindowSingleItem inputWindowSingleItem = new InputWindowSingleItem();
                    inputWindowSingleItem.setTitle(digiwinAtmcCalendar.getOwnerUserName());
                    inputWindowSingleItem.setId(digiwinAtmcCalendar.getOwnerUserId());
                    inputWindowSingleItem.setShowImage(true);
                    itemList.add(inputWindowSingleItem);
                } else {
                    for (DigiwinAtmcCalendarTeamMember teamMember : teamMembers) {
                        InputWindowSingleItem inputWindowSingleItem = new InputWindowSingleItem();
                        inputWindowSingleItem.setTitle(teamMember.getUserName());
                        inputWindowSingleItem.setId(teamMember.getUserId());
                        Map<String, Object> detail = new HashMap<>(4);
                        detail.put("executorEmpId", teamMember.getEmpId());
                        detail.put("executorEmpName", teamMember.getEmpName());
                        detail.put("executorUserId", teamMember.getUserId());
                        detail.put("executorUserName", teamMember.getUserName());
                        inputWindowSingleItem.setDetail(detail);
                        inputWindowSingleItem.setShowImage(true);
                        itemList.add(inputWindowSingleItem);
                    }
                }
                responseData.setTotal(teamMembers.size());
                responseData.setList(itemList);
                break;
            }
        }
        responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        return ApiResponse.buildOK().setData(responseData);
    }

    /**
     * 根据backFill对获取到的数据key调整
     *
     * @param itemList
     */
    private void handleBackFill(List<InputWindowSingleItem> itemList, List buttons) {
        if (buttons == null || buttons.isEmpty()) {
            return;
        }
        Map<String, String> backFills = BackFillsParseUtil.getBackFillMap(buttons);
        if (backFills.isEmpty()) {
            return;
        }
        Set<String> keys = backFills.keySet();
        itemList.stream().forEach(item -> {
            Map<String, Object> detail = item.getDetail();
            keys.stream().forEach(key -> {
                detail.put(backFills.get(key), detail.get(key));
            });
        });
    }

    /**
     * 对问题快反页面中风险等级、问题提出人客制处理，加入联动信息
     *
     * @param itemList
     * @param componentSchema
     * @param locale
     * @param supplierControlsExternalMaintenance 供应商是否控制仅外部可维护 Y:开启 N:不开启
     * @author yanfeng
     */
    private void customHandleItemList(List<InputWindowSingleItem> itemList, String componentSchema, String locale, Object supplierControlsExternalMaintenance) {
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        if ("risk_level_name".equalsIgnoreCase(componentSchema)) {
            // 风险等级
            for (InputWindowSingleItem item : itemList) {
                RelationRule relationRule = new RelationRule();
                item.setRelationRule(relationRule);
                Map<String, Object> detail = item.getDetail();
                // 风险等级  联动重要性、紧急度
                this.buildRelationRule(detail, relationRule);
            }
        } else if ("question_proposer_name".equalsIgnoreCase(componentSchema)) {
            // 问题提出人
            for (InputWindowSingleItem item : itemList) {
                RelationRule relationRule = new RelationRule();
                item.setRelationRule(relationRule);
                Map<String, Object> detail = item.getDetail();
                // 提出人部门
                String deptName = com.digiwin.mobile.mobileuibot.common.string.StringUtil.valueOf(detail.get("deptName"));
                CommonRule deptNameRule = new CommonRule();
                relationRule.addCommonRule(deptNameRule);
                deptNameRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                deptNameRule.setTargetSchema("proposer_department_name");
                deptNameRule.setTargetText(deptName);
            }
        } else if ("question_source_name".equalsIgnoreCase(componentSchema)
                || "question_classification_name".equalsIgnoreCase(componentSchema)
                || "occur_stage_name".equalsIgnoreCase(componentSchema)
        ) {
            for (InputWindowSingleItem item : itemList) {
                Map<String, Object> detail = item.getDetail();
                item.setTitle((String) detail.get(componentSchema));
                // 问题分类 联动风险等级
                if ("question_classification_name".equalsIgnoreCase(componentSchema)) {
                    item.setId((String) detail.get("question_classification_oid"));
                    RelationRule relationRule = new RelationRule();
                    item.setRelationRule(relationRule);
                    String riskLevelName = com.digiwin.mobile.mobileuibot.common.string.StringUtil.valueOf(detail.get("risk_level_name"));
                    CommonRule riskLevelNameRule = new CommonRule();
                    relationRule.addCommonRule(riskLevelNameRule);
                    riskLevelNameRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                    riskLevelNameRule.setTargetSchema("risk_level_name");
                    riskLevelNameRule.setTargetText(riskLevelName);
                    String riskLevelId = com.digiwin.mobile.mobileuibot.common.string.StringUtil.valueOf(detail.get("risk_level_id"));
                    riskLevelNameRule.setTargetSelectId(riskLevelId);
                    // 风险等级  联动重要性、紧急度
                    this.buildRelationRule(detail, relationRule);
                }
            }
        } else if ("question_attribution_name".equalsIgnoreCase(componentSchema)) {
            for (InputWindowSingleItem item : itemList) {
                /*
                supplierControlsExternalMaintenance
                交付设计器.供应商是否控制仅外部可维护 = 开启:
                    1.问题来源=“外部“，供应商支持开窗选择和手输任意内容
                    2.问题来源 ！=”外部”，供应商不可编辑
                 */
                if ("Y".equalsIgnoreCase(String.valueOf(supplierControlsExternalMaintenance))) {
                    if (localeService.getLanguageValue(locale, "外部").equalsIgnoreCase(item.getTitle())) {
                        RelationRule relationRule = new RelationRule();
                        item.setRelationRule(relationRule);
                        CommonRule commonRule = new CommonRule();
                        relationRule.addCommonRule(commonRule);
                        commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        commonRule.setTargetSchema("supplier");
                        commonRule.setTargetWidowSingleEdit(true);
                        commonRule.setTargetPlaceholder(localeService.getLanguageValue(locale, "请输入选择"));
                        commonRule.setTargetHidden(null);
                        commonRule.setTargetEnable(true);
                    } else {
                        RelationRule relationRule = new RelationRule();
                        item.setRelationRule(relationRule);
                        CommonRule commonRule = new CommonRule();
                        relationRule.addCommonRule(commonRule);
                        commonRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
                        commonRule.setTargetSchema("supplier");
                        commonRule.setTargetEnable(false);
                        commonRule.setTargetWidowSingleEdit(false);
                        commonRule.setTargetHidden(null);
                        commonRule.setTargetText("");
                        commonRule.setTargetSelectId("");
                    }
                }
            }
        }
    }

    private void buildRelationRule(Map<String, Object> detail, RelationRule relationRule) {
        // 重要性
        Integer important = (Integer) detail.get("important");
        // 紧急度
        Integer urgency = (Integer) detail.get("urgency");
        // 是否编辑 Y：可编辑，N：不可编辑
        boolean isEdit = "Y".equalsIgnoreCase((String) detail.get("is_edit"));
        CommonRule importantRule = new CommonRule();
        relationRule.addCommonRule(importantRule);
        importantRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
        importantRule.setTargetSchema("important");
        importantRule.setTargetHidden(false);
        importantRule.setTargetEnable(isEdit);
        if (important != null) {
            importantRule.setTargetSelectId(important.toString());
        } else {
            importantRule.setTargetSelectId("");
            importantRule.setTargetHidden(true);
        }

        CommonRule urgencyRule = new CommonRule();
        relationRule.addCommonRule(urgencyRule);
        urgencyRule.setCondition(CommonRuleCondition.CONDITION_OPTION_SELECT.getType());
        urgencyRule.setTargetSchema("urgency");
        urgencyRule.setTargetHidden(false);
        urgencyRule.setTargetEnable(isEdit);
        if (urgency != null) {
            urgencyRule.setTargetSelectId(urgency.toString());
        } else {
            urgencyRule.setTargetSelectId("");
            urgencyRule.setTargetHidden(true);
        }
    }

    /**
     * 往rawData里传入parameter
     *
     * @param rawData
     * @param submitParams
     */
    private void handleRawData(Map<String, Object> rawData, List<ActionSubmitParam> submitParams) {
        if (submitParams == null || submitParams.isEmpty()) {
            return;
        }
        Map<String, Object> parameter = new HashMap<>();
        if (rawData.get("parameter") != null) {
            parameter = (Map<String, Object>) rawData.get("parameter");
        }
        rawData.put("parameter", parameter);
        Map<String, Object> finalParameter = parameter;
        submitParams.forEach(submitParam -> {
            String type = submitParam.getType();
            //把按钮单选组件、普通单选组件、开窗单选组件的已选值放入rawData
            if (ButtonSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)
                    || InputSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                String selectId =
                        (String) this.componentParamAnalyzerFactory
                                .get(submitParam.getType()).analyzeSubmitParam(submitParam.getParams());
                finalParameter.put(submitParam.getSchema(), selectId);
            } else if (InputWindowSingleSelect.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                InputWindowSingleSelect inputWindowSingleSelect = (InputWindowSingleSelect) submitParam.getParams();
                if (inputWindowSingleSelect.getDetail() != null) {
                    Map<String, Object> detail = inputWindowSingleSelect.getDetail();
                    finalParameter.putAll(detail);
                    //以下，先这样吧，web端获取提交获取到的参数名不一样
                    if (detail.get("source_no") != null) {
                        finalParameter.put("question_source_no", detail.get("source_no"));
                    }
                    if (detail.get("classification_no") != null) {
                        finalParameter.put("question_classification_no", detail.get("classification_no"));
                    }
                    if (detail.get("source_id") != null) {
                        finalParameter.put("question_source_oid", detail.get("source_id"));
                    }
                    if (detail.get("classification_id") != null) {
                        finalParameter.put("question_classification_oid", detail.get("classification_id"));
                    }
                }
            } else if (InputCascade.COMPONENT_TYPE.equals(type)) {
                // 除外回报 获取人员列表走此逻辑，其它模块暂不确定是否需要此逻辑
                List<Map<String, Object>> maps = (ArrayList<Map<String, Object>>) submitParam.getParams();
                if (!CollectionUtils.isEmpty(maps)) {
                    for (Map<String, Object> map : maps) {
                        InputCascadeData inputCascadeData = JsonUtil.objectToJavaObject(map, InputCascadeData.class);
                        finalParameter.put(inputCascadeData.getSchema(), inputCascadeData.getId());
                    }
                }
            }
        });
    }


    /**
     * 获取可发起项目（左侧弹窗选择页面接口）
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/launchable/project/list", method = RequestMethod.POST)
    public ApiResponse<Map> getNimLoginInfo(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String locale = (String) params.get("locale");
        String tenantId = (String) params.get("tenantId");

        Boolean useMockData = AppContext.getUseMockData();
        if (useMockData) {
            String data = FileUtil.readText(
                    "static/appstore-use/launchable-project-list.json");
            if (null != data && !data.isEmpty()) {
                Map mockData = JsonUtil.jsonStringToObject(data, Map.class);
                return ApiResponse.buildOK().setData(mockData);
            } else {
                return ApiResponse.buildError(
                                "Launchable project list mock data is null or empty, " + "please check it out!")
                        .setData(null);
            }
        }

        List<LaunchableProject> accessibleLaunchableProjectList = this.projectService.getLaunchableProjectList(iamUserToken, tenantId, locale);
        Map<String, Object> data = new HashMap<>(4);
        data.put("title", LocaleUtil.getMobileTextByKey(locale, "选择应用"));
        if (CollectionUtils.isEmpty(accessibleLaunchableProjectList)) {
            data.put("noDataPrompt", LocaleUtil.getMobileTextByKey(locale, "暂无应用可选"));
            data.put("optionList", Collections.emptyList());
            return ApiResponse.buildOK().setData(data);
        }

        // FIXME 以后要改造成Button对象结构，内置action属性
        List<Map> mapList = accessibleLaunchableProjectList.stream()
                .map(project -> {
                    Map map = new HashMap();

                    // 发起项目设计器跳转需要的信息
                    if (BooleanUtils.isTrue(project.getIsDesigner())) {
                        Action action = new Action();
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                        action.setJumpPageTitle(project.getName());
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("project_introduce", project.getDesc());
                        rawData.put("project_name", project.getName());
                        rawData.put("dataId", project.getCreateSuffix());
                        action.setRawData(rawData);
                        map.put("action", action);
                    } else {
                        if ("scan_freightage_start".equalsIgnoreCase(project.getCode())) {
                            Map<String, Object> rawData = new HashMap<>(2);
                            rawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_ASN_CODE);
                            Action action = new Action();
                            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.toString());
                            action.setJumpPageTitle(project.getName());
                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            action.setDataId(project.getCreateSuffix());
                            rawData.put("action", action);
                            Action scanAction = new Action();
                            scanAction.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                            scanAction.setRawData(rawData);
                            map.put("action", scanAction);
                        } else {
                            map.put("jumpPageId", PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE);
                            map.put("jumpPageTitle", project.getName());
                        }
                    }

                    map.put("name", project.getName());
                    map.put("dataId", project.getCreateSuffix());
                    return map;
                }).collect(Collectors.toList());
        data.put("optionList", mapList);
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * demo 体验 AD账号登录
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/adLogin", method = RequestMethod.GET)
    public ApiResponse<DigiwhaleLoginResponse> adLogin(HttpServletRequest request) throws Exception {
        String iamDeviceId = request.getHeader("digi-middleware-device-id");
        if (Objects.isNull(iamDeviceId)) {
            iamDeviceId = (String) getIamDeviceId(request).getData();
        }
        String locale = request.getParameter("locale");
        String decryptUserName = request.getParameter("username");
        String encryptUserName;
        String decryptPwd = request.getParameter("password");
        String version = request.getParameter("version");
        String deviceID = request.getParameter("deviceID");
        String tenantId = request.getParameter("tenantId");
        String clientAgent = CLIENT_AGENT_MOBILE + "-" + version + "-" + deviceID;
        //解密账密
        try {
            encryptUserName = AESUtil.decrypt(SECRET_KEY, decryptUserName);
        } catch (Exception e) {
            encryptUserName = decryptUserName;
        }
        //AD登录（目前以用户名带@digiwin.com来硬编码判断）
        if (!encryptUserName.contains(LOGIN_TYPE_AD_SUFFIX_ONE)) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "请使用AD账号登录"));
        }
        //服务端加密公钥
        String encryptPublicKey = getEncryptPublicKey();
        LoginQueryDTO queryDTO = this.handleLoginEncrypt(decryptUserName, decryptPwd);
        String passwordHash = getEncryptPwd(queryDTO.getPassword(), encryptPublicKey);
        ResponseEntity<DigiwhaleLoginResponse> responseEntity = this.digiwinIamProxyService
                .userLoginByAD(queryDTO.getUsername(), encryptPublicKey, passwordHash, locale, tenantId, clientAgent, request, iamDeviceId);
        if (null == responseEntity) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "登录失败"));
        }
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            String errorMsg = Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getErrorDescription).orElse("");
            errorMsg = StringUtil.isNullOrEmpty(errorMsg) ? localeService.getLanguageValue(locale, "登录失败") : errorMsg;
            return ApiResponse.buildError(errorMsg);
        }
        // 登录后判断租户ID是否存在，不存在直接返回登录失败 https://athena-devops-zentao.digiwincloud.com.cn/bug-view-142048.html
        if (org.apache.commons.lang3.StringUtils.isBlank(Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getTenantId).orElse(""))) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "企业信息不全"));
        }
        EocPerson eocPersonInfo = digiwinEocProxyService.getEocInfo(responseEntity.getBody().getIamAuth().getUserId(), responseEntity.getBody().getIamAuth().getToken());
        responseEntity.getBody().setEoc(eocPersonInfo);

        return ApiResponse.buildOK().setData(responseEntity.getBody());
    }

    /**
     * 处理登录用户名和密码加密
     *
     * @param username
     * @param password
     * @return
     */
    private LoginQueryDTO handleLoginEncrypt(String username, String password) {
        LoginQueryDTO queryDTO = new LoginQueryDTO();
        //解密账密
        try {
            queryDTO.setUsername(AESUtil.decrypt(SECRET_KEY, username));
            queryDTO.setPassword(AESUtil.decrypt(SECRET_KEY, password));
        } catch (Exception e) {
            log.error("Decrypt username and pwd failed!!! See the stacktrace below......");
            queryDTO.setUsername(username);
            queryDTO.setPassword(password);
            return queryDTO;
        }
        return queryDTO;
    }

    /**
     * nana第三方平台登录校验
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/nanaLoginInDigiwhale", method = RequestMethod.GET)
    public ApiResponse<DigiwhaleLoginResponse> nanaLoginInDigiwhale(HttpServletRequest request, HttpServletResponse
            response) throws Exception {
        String locale = request.getParameter("locale");
        String iamUserToken = request.getParameter("iamUserToken");
        String userId = request.getParameter("userId");
        //当前渠道（line,wechat....）
        String channel = request.getParameter("channel");
        //是否解绑操作标识字段
        String unbind = request.getParameter("unbind");
        String verifyUserId = request.getParameter("verifyUserId");
        String tenantId = request.getParameter("tenantId");
        //先判断当前line是否已经绑定过帐号
        ResponseEntity<DigiwhaleLoginResponse> loginInternalResult = digiwinIamProxyService.loginInternal("");
        String token = loginInternalResult.getBody().getToken();
        Map<String, String> queryGlobalParams = new HashMap();
        queryGlobalParams.put("verifyUserId", verifyUserId);
        queryGlobalParams.put("appId", "Athena");
        queryGlobalParams.put("account", channel);
        JSONObject queryGlobalResult = digiwinIamProxyService.queryGlobalLine(token, queryGlobalParams);
        if (Objects.isNull(queryGlobalResult)) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "Line帐号不允许绑定多个鼎捷云帐号"));
        }
        if (StringUtils.isBlank(unbind)) {
            //判断当前是否为解绑确认操作登录，若非解绑操作则直接进行登录验证
            DigiwhaleLoginResponse data;
            ApiResponse<DigiwhaleLoginResponse> digiwhaleLoginResponseApiResponse;
            if (Objects.equals(LOGIN_TYPE_ONCE, request.getParameter("loginType"))) {
                ApiResponse<DigiwhaleLoginResponse> lineOnceResult = lineOnceLogin(request, token);
                return lineOnceResult;
            } else if (Objects.equals(LOGIN_TYPE_PROXY, request.getParameter("loginType"))) {
                //代理登录
                digiwhaleLoginResponseApiResponse = loginByProxy(request);
                data = digiwhaleLoginResponseApiResponse.getData();
            } else {
                //普通登录
                digiwhaleLoginResponseApiResponse = loginInDigiwhale(request, response);
                data = digiwhaleLoginResponseApiResponse.getData();
                if (Objects.isNull(data)) {
                    //当前用户不在某租户下禁止登陆
                    return ApiResponse.buildError(digiwhaleLoginResponseApiResponse.getMsg());
                }
                if (Objects.isNull(data.getTenantId())) {
                    //租户信息不存在，直接绑定会有问题
                    return ApiResponse.buildError(localeService.getLanguageValue(locale, "租户信息不存在"));

                }
                if (Boolean.TRUE.equals(data.getNeedVerificationCode())) {
                    //若需要二次验证则直接返回结果
                    return digiwhaleLoginResponseApiResponse;
                }
            }
            JSONObject userInfo = this.digiwinIamProxyService.getUserInfo(data.getToken(), data.getUserId());
            if (Objects.nonNull(userInfo)) {
                JSONArray userMappings = userInfo.getJSONArray("userMappings");
                for (Object o : userMappings) {
                    JSONObject userMapping = (JSONObject) JSON.toJSON(o);
                    if (StringUtils.isNotBlank(userMapping.getString("account")) && userMapping.getString("account").equals(channel)
                            && "Athena".equals(userMapping.getString("providerId"))) {
                        if (!isBindUser(queryGlobalResult, data.getUserId())) {
                            //判断用户是否存在对应的绑定信息
                            if (userMapping.getString("verifyUserId").equals(verifyUserId)) {
                                //绑定信息一致则直接返回
                                return digiwhaleLoginResponseApiResponse;
                            } else {
                                //绑定信息不一致则需要弹出是否确认解绑弹窗信息
                                data.setNeedConfirmUnbind(true);
                                return digiwhaleLoginResponseApiResponse;
                            }
                        } else {
                            return ApiResponse.buildError(localeService.getLanguageValue(locale, "当前Line用户已绑定过鼎捷云账号,请解绑后继续操作"));
                        }
                    }
                }
                //不存在绑定信息，则直接进行绑定操作
                if (!isBindUser(queryGlobalResult, data.getUserId())) {
                    this.digiwinIamProxyService.importThirdplatform(channel, verifyUserId, data.getUserId(), "", data.getTenantId());
                } else {
                    return ApiResponse.buildError(localeService.getLanguageValue(locale, "当前Line用户已绑定过鼎捷云账号,请解绑后继续操作"));
                }
                return digiwhaleLoginResponseApiResponse;
            }
        } else {
            //判断当前是否为解绑确认操作登录，若为解绑操作则先进行解绑操作
            if (StringUtils.isBlank(iamUserToken) || StringUtils.isBlank(userId)) {
                return ApiResponse.buildError(localeService.getLanguageValue(locale, "登录失败"));
            }
            JSONObject userInfo = this.digiwinIamProxyService.getUserInfo(iamUserToken, userId);
            if (Objects.nonNull(userInfo)) {
                EocPerson eocInfo = digiwinEocProxyService.getEocInfo(userInfo.getString("id"), iamUserToken);
                userInfo.put("eoc", eocInfo);
                DigiwinIamTokenRefreshTenant refreshTenantResult = this.digiwinIamProxyService.tokenRefreshTenant(tenantId, "", iamUserToken);
                userInfo.put("iamAuth", refreshTenantResult.getAuthoredUser());
                JSONArray userMappings = userInfo.getJSONArray("userMappings");
                for (Object o : userMappings) {
                    JSONObject userMapping = (JSONObject) JSON.toJSON(o);
                    if (StringUtils.isNotBlank(userMapping.getString("account")) && userMapping.getString("account").equals(channel)
                            && "Athena".equals(userMapping.getString("providerId"))) {
                        if (!isBindUser(queryGlobalResult, userId)) {
                            //判断用户是否存在对应的绑定信息
                            if (userMapping.getString("verifyUserId").equals(verifyUserId)) {
                                //绑定信息一致则直接返回
                                return ApiResponse.buildOK().setData(userInfo);
                            } else {
                                //绑定信息不一致则直接解绑,解绑的token是需要解绑用户所在租户的token
                                DigiwinIamTokenRefreshTenant unbindTenantResult = this.digiwinIamProxyService.tokenRefreshTenant(userMapping.getString("tenantId"), "", iamUserToken);
                                this.digiwinIamProxyService.deleteBundle(userId, unbindTenantResult.getUserToken(), userMapping.getString("verifyUserId"));
                                //解绑后通过mqtt强制登出
                                sendToMqtt(userMapping.getString("verifyUserId"));
                            }
                        } else {
                            return ApiResponse.buildError(localeService.getLanguageValue(locale, "当前Line用户已绑定过鼎捷云账号,请解绑后继续操作"));
                        }
                    }
                }
            }
            if (!isBindUser(queryGlobalResult, userId)) {
                this.digiwinIamProxyService.importThirdplatform(channel, verifyUserId, userId, "", tenantId);
            } else {
                return ApiResponse.buildError(localeService.getLanguageValue(locale, "当前Line用户已绑定过鼎捷云账号,请解绑后继续操作"));
            }

            return ApiResponse.buildOK().setData(userInfo);
        }
        return ApiResponse.buildError(localeService.getLanguageValue(locale, "登录失败"));
    }

    /**
     * 是否已经绑定过鼎捷云帐号
     *
     * @param queryGlobalResult
     * @param userId
     * @return
     */
    private Boolean isBindUser(JSONObject queryGlobalResult, String userId) {
        Object data = queryGlobalResult.get("data");
        if (Objects.isNull(data)) {
            return false;
        } else {
            JSONObject userMapping = (JSONObject) JSON.toJSON(data);
            if (Objects.equals(userMapping.getString("userId"), userId)) {
                return false;
            } else {
                return true;
            }
        }
    }

    /**
     * Athena登入过旧平台oauth校验
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/loginInDigiwhale", method = RequestMethod.GET)
    public ApiResponse<DigiwhaleLoginResponse> loginInDigiwhale(HttpServletRequest request, HttpServletResponse
            response) throws Exception {
        String iamDeviceId = request.getHeader("digi-middleware-device-id");
        if (Objects.isNull(iamDeviceId)) {
            iamDeviceId = (String) getIamDeviceId(request).getData();
        }
        String locale = request.getParameter("locale");
        String loginType = request.getParameter("loginType");
        //企业用户开启验证还是走，普通账号登录
        if (LOGIN_TYPE_FIRM_ACCOUNT.equals(loginType) && StringUtils.isNotBlank(request.getParameter("identityType")) && StringUtils.isNotBlank(request.getParameter("verificationCode"))) {
            loginType = LOGIN_TYPE_ACCOUNT;
        }
        //企业用户登录，租户Id不能输入汉字
        String tenantId = request.getParameter("tenantId");
        if (!StringUtils.isEmpty(tenantId) && LOGIN_TYPE_FIRM_ACCOUNT.equals(loginType)) {
            Pattern p = Pattern.compile("^[^\\u4e00-\\u9fa5]*$");
            Matcher m = p.matcher(tenantId);
            if (BooleanUtils.isFalse(m.matches())) {
                return ApiResponse.buildError(localeService.getLanguageValue(locale, "租户ID错误"));
            }
        }

        String decryptUserName = request.getParameter("username");
        String decryptParamPwd = request.getParameter("password");
        String version = request.getParameter("version");
        String deviceID = request.getParameter("deviceID");

        // 新增登录功能（界面）来源，以及体验角色id
        String from = request.getParameter("from");
        String expRoleId = request.getParameter("expRoleId");

        //boolean useDigiWhaleLogin = config.getUseDigiWhaleLogin() == null ? true : config.getUseDigiWhaleLogin();
        ResponseEntity<DigiwhaleLoginResponse> responseEntity = null;
        //服务端加密公钥
        String encryptPublicKey = getEncryptPublicKey();
        String clientAgent = CLIENT_AGENT_MOBILE + "-" + version + "-" + deviceID;
        //手机验证码登录
        if (LOGIN_TYPE_MOBILE.equals(loginType)) {
            boolean isRegister = this.digiwinIamProxyService.mobileIsRegister(decryptUserName, locale);
            //已经注册过了，则直接登录
            if (isRegister) {
                if (Objects.equals(AppEnvDeployAreaEnum.CN.toString(), AppContext.getEnvDeployArea())) {
                    // 大陆区逻辑
                    if (Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())
                            && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())
                            && Objects.equals(decryptUserName.trim(), "15021455596")
                            && Objects.equals(decryptParamPwd.trim(), "123456")) {
                        // apple 上架审核固定账号密码
                        String userId = "qcuser001";
                        String password = "qcuser001";
                        responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                                encryptPublicKey, userId, getEncryptPwd(password, encryptPublicKey),
                                locale, tenantId, clientAgent, request, iamDeviceId);
                    } else if (Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())
                            && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())
                            && Objects.equals(decryptUserName.trim(), "15021455596")
                            && Objects.equals(decryptParamPwd.trim(), "123456")) {
                        // apple 上架审核固定账号密码
                        String userId = "demohhb123";
                        String password = "Demo1234";
                        responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                                encryptPublicKey, userId, getEncryptPwd(password, encryptPublicKey),
                                locale, tenantId, clientAgent, request, iamDeviceId);
                    } else if (Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())
                            && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())
                            && Objects.equals(decryptUserName.trim(), "15021455596")
                            && Objects.equals(decryptParamPwd.trim(), "123456")) {
                        // apple 上架审核固定账号密码
                        String userId = "metis001";
                        String password = "Metis0001";
                        responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                                encryptPublicKey, userId, getEncryptPwd(password, encryptPublicKey),
                                locale, tenantId, clientAgent, request, iamDeviceId);
                    } else {
                        // 在大陆区，注册过的手机可以直接用验证码登录
                        responseEntity = this.digiwinIamProxyService.userLoginByVerificationCode(decryptUserName, decryptParamPwd, locale, iamDeviceId, clientAgent);
                    }
                } else if (Objects.equals(AppEnvDeployAreaEnum.TW.toString(), AppContext.getEnvDeployArea())) {
                    // 台湾区逻辑
                    if (Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())
                            && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())
                            && Objects.equals(decryptUserName.trim(), "0987082178")
                            && Objects.equals(decryptParamPwd.trim(), "123456")) {
                        // apple 上架审核固定账号密码
                        String userId = "lingxiang202401@gmail.com";
                        String password = "Digiwin2024";
                        responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                                encryptPublicKey, userId, getEncryptPwd(password, encryptPublicKey),
                                locale, tenantId, clientAgent, request, iamDeviceId);
                    } else if (Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())
                            && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())
                            && Objects.equals(decryptUserName.trim(), "0987082178")
                            && Objects.equals(decryptParamPwd.trim(), "123456")) {
                        // apple 上架审核固定账号密码
                        String userId = "demohhb";
                        String password = "Demohhb123";
                        responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                                encryptPublicKey, userId, getEncryptPwd(password, encryptPublicKey),
                                locale, tenantId, clientAgent, request, iamDeviceId);
                    } else if (Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())
                            && Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())
                            && Objects.equals(decryptUserName.trim(), "0987082178")
                            && Objects.equals(decryptParamPwd.trim(), "123456")) {
                        // apple 上架审核固定账号密码
                        String userId = "metis001";
                        String password = "Metis0001";
                        responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                                encryptPublicKey, userId, getEncryptPwd(password, encryptPublicKey),
                                locale, tenantId, clientAgent, request, iamDeviceId);
                    } else {
                        // 台湾区，注册过的手机可以直接用验证码登录
                        responseEntity = this.digiwinIamProxyService.userLoginByVerificationCode(decryptUserName, decryptParamPwd, locale, iamDeviceId, clientAgent);
                    }
                } else {
                    // 非大陆区，非台湾区的环境，暂时支持验证码登录
                    responseEntity = null;
                }
            } else {
                responseEntity = this.digiwinIamProxyService.userRegisterByMobileOrEmail(decryptUserName, decryptParamPwd, locale, clientAgent);
            }
            // 新增对登录来源的特殊处理
            if (responseEntity != null && responseEntity.getStatusCode().is2xxSuccessful() && Objects.equals(from, LoginFromEnum.EXPERIENCE.getValue())) {

                // 体验模式：体验账号登录下，获取娜娜配置
                Mock mock = null;
                String mockId = request.getHeader(MockInterceptor.RECORD_MOCK_ID);
                if (org.springframework.util.StringUtils.hasLength(mockId) && ExperienceRoleIdEnum.ATHENA_MOCK.getValue().equals(expRoleId.trim())) {
                    mock = mockService.selectByMockId(mockId, null);
                    if (mock != null) {
                        if (!EnableEnum.YES.getValue().equals(mock.getEnableNana())) {
                            mock = null;
                        }
                    }
                }
                DigiwhaleLoginResponse loginResponse = responseEntity.getBody();
                this.loginService.handleUserByVerificationCodeInExperience(decryptUserName,
                        decryptParamPwd, locale, clientAgent, expRoleId, loginResponse, mock, iamDeviceId);

                if (mock != null) {
                    // 体验模式：租户ID替换成体验账号录制的租户ID
                    // 查询mock数据
                    String responseBody = digiwinExperienceProxyService.gainMockDataOne(new OuterMockData()
                            .setMockId(mockId).setUrl(MockInterceptor.LOGIN_URI)
                            .setPayload("{\"dataId\":\"\",\"requestId\":\"\",\"tenantId\":\"\",\"pageId\":\"\",\"locale\":\"\"}")
                            .setMethod("GET"));
                    if (responseBody != null) {
                        ApiResponse<DigiwhaleLoginResponse> apiResponse = JsonUtil.jsonStringToObject(responseBody, new TypeReference<ApiResponse<DigiwhaleLoginResponse>>() {
                        });
                        DigiwhaleLoginResponse mockBody = apiResponse.getData();
                        if (mockBody != null) {
                            DigiwhaleLoginResponse body = responseEntity.getBody();
                            if (body != null) {
                                body.setTenantId(mockBody.getTenantId());
                                body.setTenantSid(mockBody.getTenantSid());
                                body.setTenantName(mockBody.getTenantName());
                                body.setDefaultTenantSid(mockBody.getDefaultTenantSid());

                                IamAuth iamAuth = body.getIamAuth();
                                if (iamAuth != null) {
                                    iamAuth.setTenantId(mockBody.getTenantId());
                                    iamAuth.setTenantSid(mockBody.getTenantSid());
                                    iamAuth.setTenantName(mockBody.getTenantName());
                                }
                            }
                        }
                    }
                }
            }
        } else if (LOGIN_TYPE_FIRM_ACCOUNT.equals(loginType)) {
            //企业用户账号登录
            LoginQueryDTO queryDTO = this.handleLoginEncrypt(decryptUserName, decryptParamPwd);
            responseEntity = this.digiwinIamProxyService.firmAccountLogin(
                    encryptPublicKey, queryDTO.getUsername(), getEncryptPwd(queryDTO.getPassword(), encryptPublicKey),
                    locale, tenantId, clientAgent, request, iamDeviceId);
        } else {
            //AD登录（目前以用户名带@digiwin.com和digiwin.biz来硬编码判断）
            LoginQueryDTO queryDTO = this.handleLoginEncrypt(decryptUserName, decryptParamPwd);
            if (queryDTO.getUsername().contains(LOGIN_TYPE_AD_SUFFIX_ONE) || queryDTO.getUsername().contains(LOGIN_TYPE_AD_SUFFIX_TWO)) {
                String passwordHash = getEncryptPwd(queryDTO.getPassword(), encryptPublicKey);
                responseEntity = this.digiwinIamProxyService
                        .userLoginByAD(queryDTO.getUsername(), encryptPublicKey, passwordHash, locale, tenantId, clientAgent, request, iamDeviceId);
            } else if (LOGIN_TYPE_ACCOUNT.equals(loginType)) {
                //普通账号登录
                String passwordHash = getEncryptPwd(queryDTO.getPassword(), encryptPublicKey);
                responseEntity = this.digiwinIamProxyService.userLoginByEncodePassword(
                        encryptPublicKey, queryDTO.getUsername(), passwordHash,
                        locale, tenantId, clientAgent, request, iamDeviceId);
            } else if (CARD_ONE.equalsIgnoreCase(loginType) || CARD_TWO.equalsIgnoreCase(loginType)) {
                //刷卡登录
                String pwd = getEncryptPwd(queryDTO.getUsername(), encryptPublicKey);
                responseEntity = this.digiwinIamProxyService.userLoginByCard(pwd, encryptPublicKey, locale, tenantId, clientAgent, loginType, iamDeviceId);
            }

        }
        if (null == responseEntity) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "登录失败"));
        }
        if (!responseEntity.getStatusCode().is2xxSuccessful() || org.springframework.util.StringUtils.hasLength(responseEntity.getBody().getErrorDescription())) {
            String errorMsg = Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getErrorDescription).orElse("");
            errorMsg = StringUtil.isNullOrEmpty(errorMsg) ? localeService.getLanguageValue(locale, "登录失败") : localeService.getLanguageValue(locale, errorMsg);
            return ApiResponse.buildError(errorMsg);
        }
        //若需要二次验证则直接返回结果
        if (responseEntity.getStatusCode().is2xxSuccessful() && Boolean.TRUE.equals(responseEntity.getBody().getNeedVerificationCode())) {
            return ApiResponse.buildOK().setData(responseEntity.getBody());
        }
        DigiwhaleLoginResponse body = responseEntity.getBody();
        String token = body.getToken();
        if (StringUtil.isNullOrEmpty(token) && body.getIamAuth() != null) {
            token = body.getIamAuth().getToken();
        }
        // 登录后判断租户ID是否存在，不存在直接返回登录失败 https://athena-devops-zentao.digiwincloud.com.cn/bug-view-142048.html
        if (org.apache.commons.lang3.StringUtils.isBlank(body.getTenantId())) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "企业信息不全"));
        }
        if (!LOGIN_TYPE_MOBILE.equals(loginType) && !CARD_ONE.equals(loginType) && !CARD_TWO.equals(loginType)) {
            PasswordChange passwordChange = digiwinIamProxyService.checkUserPasswordChange(locale, token);
            passwordChange.setTitle(passwordChange.getPwChangeNotification());
            passwordChange.setContent(localeService.getLanguageValue(locale, "为保障您的账号安全，建议您修改密码"));
            passwordChange.setCancelMsg(localeService.getLanguageValue(locale, "暂不修改"));
            passwordChange.setEnsureMsg(localeService.getLanguageValue(locale, "立即修改"));
            body.setPasswordChange(passwordChange);
        }

        EocPerson eocInfo = digiwinEocProxyService.getEocInfo(body.getIamAuth().getUserId(), body.getIamAuth().getToken());
        body.setEoc(eocInfo);
        return ApiResponse.buildOK().setData(body);
    }

    /**
     * 判读路径是否携带需要验证的参数
     *
     * @param request
     * @return
     */
    private boolean isHasCode(HttpServletRequest request) {
        if (!org.springframework.util.ObjectUtils.isEmpty(request)) {
            //账密输入错误五次以上需要传入二维码相关的信息
            if (org.springframework.util.StringUtils.hasText(request.getParameter("code")) && org.springframework.util.StringUtils.hasText(request.getParameter("value"))) {
                return true;
            }
            //开启二次验证登录需要携带这些参数
            if (org.springframework.util.StringUtils.hasText(request.getParameter("identityType")) && org.springframework.util.StringUtils.hasText(request.getParameter("verificationCode"))) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断APP是否需要更新
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/upgrade/update", method = RequestMethod.GET)
    public ApiResponse<MReturnValidate> upgradeApp(HttpServletRequest request) {
        String oldQueryString = request.getQueryString();
        String locale = request.getParameter("locale");
        Map<String, String> queryStringMap = com.digiwin.mobile.mobileuibot.common.string.StringUtil.parseQueryString(oldQueryString);
        getAppUpdateCode(queryStringMap);
        queryStringMap.put("sVersion", "1");
        String newQueryString = com.digiwin.mobile.mobileuibot.common.string.StringUtil.rebuildQueryStringFromMap(queryStringMap);
        String result = null;
        if (!TestController.specialHandleSwitch()) {
            result = digiwhaleProxyServie.upgradeUpdate(newQueryString);
        } else {
            result = "{\"errorCode\":0,\"content\":{\"updateStrategy\":\"0\",\"md5\":\"\"}}";
        }
        MReturnValidate mReturnValidate = null;
        if (StrUtil.isNotBlank(result)) {
            mReturnValidate = JsonUtil.jsonStringToObject(result, MReturnValidate.class);
            if (!Objects.isNull(mReturnValidate.getContent())) {
                mReturnValidate.getContent().setMessage(localeService.getLanguageValue(locale, mReturnValidate.getContent().getMessage()));
            } else {
                ValidateResult validateResult = new ValidateResult();
                validateResult.setMessage(localeService.getLanguageValue(locale, "找不到包名所对应的版本号"));
                mReturnValidate.setContent(validateResult);
            }
        }
        return ApiResponse.buildOK().setData(mReturnValidate);
    }

    private void getAppUpdateCode(Map<String, String> queryStringMap) {
        if (Objects.equals(CN_PROD_PACKAGE_NAME, queryStringMap.get("packageName"))) {
            queryStringMap.put("app", "ATN_CN");
        } else if (Objects.equals(TW_PROD_PACKAGE_NAME, queryStringMap.get("packageName"))) {
            queryStringMap.put("app", "ATN_TW");
        } else if (Objects.equals(DEV_PACKAGE_NAME, queryStringMap.get("packageName"))) {
            queryStringMap.put("app", "ATN_TEST");
        } else {
            queryStringMap.put("app", "ATN");
        }
        // 湖州敏捷数据特殊处理：若判断是湖州的环境，则将APP代号更改为ATN_NANA，用于区别于原来迭代包的代号：ATN
        if (Objects.equals(AppContext.getBaseUrl(), "https://athenamobile-hz-test.digiwincloud.com.cn:443/")) {
            queryStringMap.put("app", "ATN_NANA");
        }
    }

    /**
     * 获取移动平台的person信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/person/getPersonByUserId", method = RequestMethod.GET)
    public ApiResponse<MPersonCard> getPersonByUserId(HttpServletRequest request) {
        String queryString = URLDecoder.decode(request.getQueryString());
        //boolean useDigiWhaleLogin = config.getUseDigiWhaleLogin() == null ? true : config.getUseDigiWhaleLogin();
        //默认去鼎捷移动老平台获取personCard数据
        MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId(queryString);
        // 授权登录场景下 第一次获取pid为null，导致登录失败，第二次登录才能获取到。故提供随机数据
        if (null == personCard) {
            personCard = new MPersonCard();
        }
        if (StringUtils.isEmpty(personCard.getpID())) {
            //这里为了兼容工作坊随机给了数据，实际情况下不会走这个else
            personCard.setpID(UUIDUtil.getUuid());
            personCard.setpName("randomName");
        }
        return ApiResponse.buildOK().setData(personCard);
    }


    /**
     * 鼎捷云账号/企业用户都用此接口
     * 更新用户名密码
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/update/password", method = RequestMethod.POST)
    public ApiResponse<Boolean> updataPassword(HttpServletRequest request) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String id = (String) params.get("userId");
        String oldPassword = (String) params.get("oldPassword");
        String newPassword = (String) params.get("newPassword");
        String encryptUserName;
        String encryptOldParamPwd;
        String encryptNewParamPwd;
        //解密账密
        try {
            encryptUserName = AESUtil.decrypt(SECRET_KEY, id);
            encryptOldParamPwd = AESUtil.decrypt(SECRET_KEY, oldPassword);
            encryptNewParamPwd = AESUtil.decrypt(SECRET_KEY, newPassword);
        } catch (Exception e) {
            encryptUserName = id;
            encryptOldParamPwd = oldPassword;
            encryptNewParamPwd = newPassword;
        }
        Map<String, Object> parameters = new HashMap<>(3);
        parameters.put("id", encryptUserName);
        parameters.put("oldPassword", DigestUtil.getDigestedStringForDwIamLoginByAes(encryptOldParamPwd));
        parameters.put("newPassword", DigestUtil.getDigestedStringForDwIamLoginByAes(encryptNewParamPwd));
        Boolean b = digiwinIamProxyService.updatePassword(iamUserToken, parameters);
        return b ? ApiResponse.buildOK().setData(b) : ApiResponse.buildError("Password modification failed");
    }

    /**
     * 延长暂不修改密码
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/renewal/password", method = RequestMethod.POST)
    public ApiResponse<Boolean> renewalPassword(HttpServletRequest request) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        return ApiResponse.buildOK().setData(digiwinIamProxyService.renewalPassword(iamUserToken));
    }

    /**
     * 代理模式登录,代理人支持手机/邮箱/id+密码登录，并且输入被代理的租户授权码
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/login/proxy/users", method = RequestMethod.GET)
    public ApiResponse<DigiwhaleLoginResponse> userLoginGetProxyUsers(HttpServletRequest request) throws Exception {
        String locale = request.getParameter("locale");
        String agentAuthorizationCode = request.getParameter("agentAuthorizationCode");
        String decryptUserName = request.getParameter("username");
        String decryptParamPwd = request.getParameter("password");
        String version = request.getParameter("version");
        String deviceID = request.getParameter("deviceID");

        String clientAgent = CLIENT_AGENT_MOBILE + "-" + version + "-" + deviceID;
        String encryptUserName;
        String encryptParamPwd;
        //解密账密
        try {
            encryptUserName = AESUtil.decrypt(SECRET_KEY, decryptUserName);
            encryptParamPwd = AESUtil.decrypt(SECRET_KEY, decryptParamPwd);
        } catch (Exception e) {
            log.error("Decrypt username and pwd failed!!! See the stacktrace below......");
            e.printStackTrace();
            encryptUserName = decryptUserName;
            encryptParamPwd = decryptParamPwd;
        }
        String encryptPublicKey = getEncryptPublicKey();
        String passwordHash = getEncryptPwd(encryptParamPwd, encryptPublicKey);
        ResponseEntity<DigiwhaleLoginResponse> responseEntity = this.digiwinIamProxyService
                .userLoginGetProxyUsers(encryptUserName, encryptPublicKey, passwordHash, locale, agentAuthorizationCode, clientAgent);
        if (null == responseEntity) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "登录失败"));
        }
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            String errorMsg = Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getMessage).orElse("");
            errorMsg = StringUtil.isNullOrEmpty(errorMsg) ? localeService.getLanguageValue(locale, "登录失败") : errorMsg;
            return ApiResponse.buildError(errorMsg);
        }
        // 登录后判断租户ID是否存在，不存在直接返回登录失败 https://athena-devops-zentao.digiwincloud.com.cn/bug-view-142048.html
        if (org.apache.commons.lang3.StringUtils.isBlank(Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getTenantId).orElse(""))) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "企业信息不全"));
        }
        return ApiResponse.buildOK().setData(responseEntity.getBody());
    }

    /**
     * 代理模式登录，根据代理token以及代理用户信息登录
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/login/proxy", method = RequestMethod.GET)
    public ApiResponse<DigiwhaleLoginResponse> loginByProxy(HttpServletRequest request) throws Exception {
        String iamDeviceId = request.getHeader("digi-middleware-device-id");
        if (Objects.isNull(iamDeviceId)) {
            iamDeviceId = (String) getIamDeviceId(request).getData();
        }
        String locale = request.getParameter("locale");
        String agentToken = request.getParameter("agentToken");
        String decryptUserName = request.getParameter("username");
        String version = request.getParameter("version");
        String deviceID = request.getParameter("deviceID");

        String clientAgent = CLIENT_AGENT_MOBILE + "-" + version + "-" + deviceID;
        String encryptUserName;
        //解密账密
        try {
            encryptUserName = AESUtil.decrypt(SECRET_KEY, decryptUserName);
        } catch (Exception e) {
            log.error("Decrypt username and pwd failed!!! See the stacktrace below......");
            e.printStackTrace();
            encryptUserName = decryptUserName;
        }
        ResponseEntity<DigiwhaleLoginResponse> responseEntity = this.digiwinIamProxyService
                .userLoginByProxy(AESUtils.aesEncrypt(encryptUserName, AESUtils.AESKEY), agentToken, locale, clientAgent, iamDeviceId);
        if (null == responseEntity) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "登录失败"));
        }
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            String errorMsg = Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getMessage).orElse("");
            errorMsg = StringUtil.isNullOrEmpty(errorMsg) ? localeService.getLanguageValue(locale, "登录失败") : errorMsg;
            return ApiResponse.buildError(errorMsg);
        }
        // 登录后判断租户ID是否存在，不存在直接返回登录失败 https://athena-devops-zentao.digiwincloud.com.cn/bug-view-142048.html
        if (org.apache.commons.lang3.StringUtils.isBlank(Optional.ofNullable(responseEntity.getBody()).map(DigiwhaleLoginResponse::getTenantId).orElse(""))) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "企业信息不全"));
        }
        EocPerson eocPersonInfo = digiwinEocProxyService.getEocInfo(responseEntity.getBody().getIamAuth().getUserId(), responseEntity.getBody().getIamAuth().getToken());
        responseEntity.getBody().setEoc(eocPersonInfo);

        return ApiResponse.buildOK().setData(responseEntity.getBody());
    }

    /**
     * 根据服务端公钥加密客户端公钥
     *
     * @return
     * @throws Exception
     */
    private String getEncryptPublicKey() throws Exception {
        // 获取服务端公钥
        String serverPublicKey = digiwinIamProxyService.doGetPublicKey();
        if (StringUtils.isEmpty(serverPublicKey)) {
            log.error("未拿到互联的公钥。。。。");
        } else {
            log.error("拿到互联公钥为：" + serverPublicKey);
        }
        // 根据服务端公钥加密客户端公钥
        return RSAUtils.encryptByPublicKey(RSAUtils.CLIENT_PUBLIC_KEY, serverPublicKey);
    }

    /**
     * RSA+AES加密密码
     *
     * @param userName
     * @param encryptPublicKey 加密后的公钥
     * @return
     * @throws Exception
     */
    private String getEncryptPwd(String userName, String encryptPublicKey) throws Exception {
        // 获取加密后的AES的key值
        String aesPrivateKey = digiwinIamProxyService.doGetAesKey(encryptPublicKey);
        // 根据客户端私钥解密 加密的aes的key值
        String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64(aesPrivateKey), RSAUtils.CLIENT_PRIVATE_KEY));
        // 拿解密后的AES的key值对密码进行aes加密
        return AESUtils.aesEncryptByBase64(userName, aesKey);
    }

    /**
     * 登出接口
     *
     * @param request
     * @param response
     * @return
     */
    @PostMapping("/logout")
    public ApiResponse logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String userId = (String) params.get("userId");
        String deviceId = (String) params.get("deviceId");
        String fcmToken = (String) params.get("fcmToken");
        fcmService.deleteFcmMobileUser(userId, deviceId, fcmToken);
        digiwinIamProxyService.logout(iamUserToken);
        return ApiResponse.buildOK();
    }

    /**
     * 获取手机验证码
     *
     * @param request
     * @param response
     * @return
     * @throws IOException
     */
    @CrossOrigin(origins = "*")
    @RequestMapping(value = "/getVerificationCode", method = RequestMethod.POST)
    public ApiResponse getVerificationCode(HttpServletRequest request, HttpServletResponse response) throws
            IOException {
        /**
         * 获取手机号后做 步操作
         * 1.首先校验手机号是否被注册过
         * 2.1 注册过，则直接发送登录验证码
         * 2.2 没注册过，则直接发送注册验证码
         */
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String phoneNumber = (String) params.get("phoneNumber");
        String locale = (String) params.get("locale");
        Boolean isRegister = digiwinIamProxyService.mobileIsRegister(phoneNumber, locale);
        DigiwinEmcResponse emcResponse = null;
        if (isRegister) {
            emcResponse = digiwinEmcProxyService.getVerificationCode(locale, phoneNumber, EmcVerificationCodeSceneEnum.VERIFICATIONCODELOGIN.getValue());
        } else {
            emcResponse = digiwinEmcProxyService.getVerificationCode(locale, phoneNumber, EmcVerificationCodeSceneEnum.REGISTER.getValue());
        }
        if (null == emcResponse) {
            return ApiResponse.buildError(this.localeService.getLanguageValue(locale, "EMC服务暂无法访问，请稍后重试"));
        } else {
            if (emcResponse.getSuccess()) {
                return ApiResponse.buildOK();
            } else {
                return ApiResponse.buildError(emcResponse.getMessage());
            }
        }
    }


    /**
     * 发送邮件或者短信
     * 0：邮箱，1：短信
     *
     * @param apiRequest
     * @return
     */
    @PostMapping(value = "/sendEmailOrPhoneCode")
    public ApiResponse sendEmailOrPhoneCode(@RequestBody ApiRequest apiRequest) {
        if (!apiRequest.getRawData().containsKey("data") || !apiRequest.getRawData().containsKey("type")) {
            return ApiResponse.buildError("缺少相应的参数");
        }
        String data = apiRequest.getRawData().getString("data");
        Integer type = Integer.valueOf(apiRequest.getRawData().get("type").toString());
        Boolean flag = digiwinEmcProxyService.sendEmailOrPhoneCode(apiRequest.getIamUserToken(), type, data);
        if (flag) {
            return ApiResponse.buildOK();
        }
        return ApiResponse.buildError();
    }

    /**
     * ocr卡片识别接口
     *
     * @param request
     * @param response
     * @return
     * @throws IOException
     */
    @RequestMapping(path = "/ocr/identification", method = RequestMethod.POST)
    public ApiResponse<OcrCardResponse> identification(HttpServletRequest request,
                                                       HttpServletResponse response, ApiUploadAttachment apiAttachment) throws IOException {

        String type = request.getParameter("type");
        String locale = apiAttachment.getLocale();
        String uploaderName = request.getParameter("uploaderName");
        OcrCardResponse ocrCardResponse = new OcrCardResponse();
        Map<String, Object> result = fileService.uploadFile(apiAttachment, 0);
        result.put("uploaderName", uploaderName);
        if (ERROR_CODE.equals(result.get("code"))) {
            log.error("上传图片失败" + result.get("message"));
            return ApiResponse.buildError((String) result.get("message"));
        } else if (SUCCESS_CODE.equals(result.get("code"))) {
            ocrCardResponse.setFile(JsonUtil.objectToJavaObject(result, File.class));
        }
        ocrCardResponse.setType(type);
        if (CARD_IDENTIFICATION_IDCARD.equals(type)) {
            List<OcrData> ocrDataList = ocrService.getIDCardByOcr("1", ImageUtil.encodeImage(apiAttachment.getFile().getBytes()));
            if (ocrDataList != null && ocrDataList.size() > 0) {
                ocrCardResponse.setDataList(ocrDataList);
                return ApiResponse.buildOK().setData(ocrCardResponse);
            }
        } else if (CARD_IDENTIFICATION_BANKCARD.equals(type)) {
            List<OcrData> ocrDataList = ocrService.getBankCardByOcr(ImageUtil.encodeImage(apiAttachment.getFile().getBytes()));
            if (ocrDataList != null && ocrDataList.size() > 0) {
                ocrCardResponse.setDataList(ocrDataList);
                return ApiResponse.buildOK().setData(ocrCardResponse);
            }
        } else {
            return ApiResponse.buildError(LocaleUtil.getMobileTextByKey(locale, "当前卡片暂不支持识别！"));
        }
        return ApiResponse.buildError();
    }

    /**
     * 判断是否有购买某个模组（暂时用来判断是否可以使用智能搜索）
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(path = "/moduleEnable", method = RequestMethod.POST)
    public ApiResponse<Boolean> moduleEnable(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String tenantId = (String) params.get("tenantId");
        String userId = (String) params.get("userId");
        String iamUserToken = (String) params.get("iamUserToken");
        String moduleId = (String) params.get("moduleId");
        String goodsCode = (String) params.get("goodsCode");
        //是否能够使用某个模组
        Boolean moduleEnable = digiwinCacProxyService.useModuleByTenantIdAndUserId(tenantId, userId,
                goodsCode, moduleId, iamUserToken);
        return ApiResponse.buildOK().setData(moduleEnable);
    }

    /**
     * 获取用户eocId
     *
     * @param request
     * @return
     * @throws IOException
     */
    @PostMapping("/user/eocId")
    public ApiResponse<Map> getEocId(HttpServletRequest request) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String userId = (String) params.get("userId");
        String iamUserToken = (String) params.get("iamUserToken");
        String eocId = "";
        if (useMockData || modelTypeShow) {
            // 指定返回psm02演示账号的eocId
            eocId = "psm02-01";
        } else {
            eocId = digiwinEocProxyService.getEocId(iamUserToken, userId);
        }
        Map result = new HashMap(1);
        if (StringUtils.isEmpty(eocId)) {
            eocId = "";
        }
        result.put("eocId", eocId);
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 行事历回报任务提交接口
     */
    @RequestMapping(value = "/action/Execute", method = RequestMethod.POST)
    public ApiResponse<Boolean> actionExecute(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) params.get("locale");
        String iamUserToken = (String) params.get("iamUserToken");
        Map<String, Object> bodyString = (Map<String, Object>) params.get("bodyString");
        String tenantId = String.valueOf(params.get("tenantId"));
        return ApiResponse.buildOK().setData(digiwinAtdmProxyService.actionExecute(locale, iamUserToken, bodyString, tenantId));
    }

    /**
     * 空余产能--表格获取近一周和一个月的产能
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/get/spareCapacity", method = RequestMethod.POST)
    public ApiResponse getspareCapacity(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) params.get("locale");
        String dateId = (String) params.get("id");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = (String) params.get("tenantId");
        List<String> itemInfo = (List<String>) params.get("item_info");
        String pageId = (String) params.get("pageId");

        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (useMockData || modelTypeShow) {
            return ApiResponse.buildOK().setData(this.doMockDataSpareCapacity(dateId, locale));
        } else {
            PageSetting pageSetting = pageSettingService.findById(pageId);
            UiBotModel uiBotModel = pageSetting.getPageModel();
            List<Map<String, Object>> humanResourceLoadList = digiwinEspProxyService.getHumanResourceLoadByDateId(itemInfo, dateId, tenantId, locale, iamUserToken);
            for (UiBotLayout uiBotLayout : uiBotModel.getLayout()) {
                if (CustomGroup.COMPONENT_TYPE.equals(uiBotLayout.getType())) {
                    UiBotModel uiBotModel1 = JSONObject.parseObject(
                            JSONObject.toJSONString(uiBotModel.getPageData().get(uiBotLayout.getSchema())), UiBotModel.class);
                    for (UiBotLayout uiBotLayout1 : uiBotModel1.getLayout()) {
                        if (Table.COMPONENT_TYPE.equals(uiBotLayout1.getType())) {
                            return ApiResponse.buildOK().setData(Table.create(uiBotLayout1, uiBotModel1.getPageData(), humanResourceLoadList, locale, dateId));
                        }
                    }
                }
            }
        }
        return ApiResponse.buildOK();
    }

    /**
     * 工时回报/支援-人员上线数据接口
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/workingHourReport/peopleOnline", method = RequestMethod.POST)
    public ApiResponse<Action> peopleOnline(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        Map<String, Object> requestSubmitRawData = apiRequestSubmit.getRawData();
        // 构建请求参数
        Map<String, Object> requestParams = this.buildRequestParams(apiRequestSubmit, "wo_op_report_data", true);

        Action<Map<String, Object>> action = new Action<>();
        Map<String, Object> response = digiwinAtdmProxyService.peopleOnline(locale, iamUserToken, requestParams, tenantId);
        // 1.除外回报时间重叠;2.工时回报时间重叠;3.已上线未下线;4.自动下线询问
        String errorType = (String) response.get("error_type");
        String errorMsg = (String) response.get("error_msg");
        if (StringUtils.isEmpty(errorType)) {
            if (StringUtils.isEmpty(errorMsg)) {
                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "人员上线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));
                if (String.valueOf(requestSubmitRawData.get("pageId")).contains("HOUR_REPORT_LIST")) {
                    action.setType(ActionTypeEnum.REFRESH.getValue());
                }
                if (String.valueOf(requestSubmitRawData.get("pageId")).contains("HOUR_REPORT_DETAIL")) {
                    action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                }
                if (MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.name().equals(requestSubmitRawData.get("pageId"))) {
                    action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
                }
                return ApiResponse.buildOK().setData(action);
            } else {
                action = new Action<>();
                action.setConfirmPop(ConfirmPop.create(errorMsg, true));
                action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
                return ApiResponse.buildOK().setData(action);
            }
        }
        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) response.get("wo_op_report_data");
        handleWorkHourAction(woOpReportData, action, errorType, errorMsg, locale);
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 构建人员上下线 请求入参
     *
     * @param apiRequestSubmit
     * @param online           true:上线  false:下线
     * @return
     */
    private Map<String, Object> buildRequestParams(ApiRequestSubmit apiRequestSubmit, String dataKey,
                                                   boolean online) {
        Map<String, Object> requestParams = apiRequestSubmit.getRawData();
        Map<String, Object> parameter = (Map<String, Object>) requestParams.get("parameter");
        String pageId = String.valueOf(requestParams.get("pageId"));
        String previousPageId = String.valueOf(requestParams.get("previousPageId"));
        List<ActionSubmitParam> submitParams = apiRequestSubmit.getSubmitParams();
        // 获取工时回报 机制参数值
        String limitSameTimeReport =
                this.getMechanismParamValue(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                        apiRequestSubmit.getLocale(), KnowledgeMapsConstant.APC_LIMIT_SAME_TIME_REPORT);
        String exceptReportSystemCorrect =
                this.getMechanismParamValue(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                        apiRequestSubmit.getLocale(), KnowledgeMapsConstant.APC_EXCEPT_REPORT_SYSTEM_CORRECT);

        List<Map<String, Object>> dataValueList = (List<Map<String, Object>>) parameter.get(dataKey);
        for (Map<String, Object> dataValue : dataValueList) {
            // 备注字段更新
            if (!CollectionUtils.isEmpty(apiRequestSubmit.getSubmitParams())) {
                handleDataDetail(apiRequestSubmit.getSubmitParams(), dataValue);
            }
            List<Map<String, Object>> woOpReportWorkHoursDetailList = (List<Map<String, Object>>) MapUtil.getOrDefault(dataValue, "wo_op_report_work_hours_detail", Collections.emptyList());

            dataValue.put("except_work_hours_system_auto_correct", exceptReportSystemCorrect);
            dataValue.put("limit_same_time_report_work_hours", limitSameTimeReport);
            if (online) {
                if (MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST.name().equals(pageId)
                        || MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST.name().equals(previousPageId)) {
                    // 1.手动工时回报;2.侦测自动下线;3.手动除外回报;4.手动工时创建;5.手动补登回报;6.手动工时调整;7.工时支援;8.合并工时
                    dataValue.put("source_operation", "1");
                }
                if (MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST.name().equals(pageId)
                        || MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST.name().equals(previousPageId)) {
                    dataValue.put("source_operation", "7");
                }
                dataValue.put("check_in_datetime", DateTimeUtil.getTodayTimeUseDefaultPattern());
            } else {
                if (MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST.name().equals(pageId)) {
                    // 1.手动工时回报;2.侦测自动下线;3.手动除外回报;4.手动工时创建;5.手动补登回报;6.手动工时调整;7.工时支援;8.合并工时
                    woOpReportWorkHoursDetailList.forEach(e -> e.put("source_operation", "1"));
                }
                if (MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST.name().equals(pageId)) {
                    woOpReportWorkHoursDetailList.forEach(e -> e.put("source_operation", "7"));
                }
            }
            if (!CollectionUtils.isEmpty(submitParams)) {
                submitParams.forEach(a -> {
                    if (ObjectUtils.isNotEmpty(a) && (StringUtils.isNotBlank(a.getType()) && ObjectUtils.isNotEmpty(a.getParams()))) {
                        if (SingleSelectList.COMPONENT_TYPE.equalsIgnoreCase(a.getType())) {
                            SingleSelectList singleSelectList = JsonUtil.objectToJavaObject(a.getParams(), new TypeReference<SingleSelectList>() {
                            });
                            if (StringUtils.isNotBlank(singleSelectList.getText())) {
                                dataValue.put("report_qty", Integer.valueOf(singleSelectList.getText()));
                            }
                        }
                    }
                });
            }

            // 下线，备注信息还需要放在wo_op_report_work_hours_detail里，否则备注更新不成功
            woOpReportWorkHoursDetailList.forEach(e -> e.put("remark", dataValue.get("remark")));
        }
        parameter.put(dataKey, dataValueList);
        requestParams.put("parameter", parameter);
        return requestParams;
    }

    private String getMechanismParamValue(String iamUserToken, String tenantId, String locale, String
            variableName) {
        Map<String, Object> mechanismParamValueMap = digiwinKnowledgeMapsProxyService
                .getMechanismParamValue(iamUserToken, tenantId, locale, variableName);
        if (null == mechanismParamValueMap) {
            return "";
        }
        return com.digiwin.mobile.mobileuibot.common.string.StringUtil.valueOf(mechanismParamValueMap.get(variableName));
    }

    /**
     * 工时回报-取消上线数据接口
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/workingHourReport/cancelOnline", method = RequestMethod.POST)
    public ApiResponse<String> cancelOnline(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) apiRequest.get("locale");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String tenantId = String.valueOf(apiRequest.get("tenantId"));

        Map<String, Object> requestParams = (Map<String, Object>) apiRequest.get("rawData");
        Map<String, Object> parameter = (Map<String, Object>) MapUtil.getOrDefault(requestParams, "parameter", Collections.emptyMap());
        List<Map<String, Object>> woOpReportDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(parameter, "wo_op_report_data", Collections.emptyList());

        // 取消时候清空备注
        woOpReportDataList.forEach(e -> e.put("remark", ""));

        boolean hasCancelOnline = digiwinAtdmProxyService.cancelOnline(locale, iamUserToken, requestParams, tenantId);
        StringBuilder toastMsg = new StringBuilder();
        toastMsg.append(this.localeService.getLanguageValue(locale, "取消上线"));
        if (hasCancelOnline) {
            toastMsg.append(this.localeService.getLanguageValue(locale, "成功"));
        } else {
            toastMsg.append(this.localeService.getLanguageValue(locale, "失败"));
        }
        Action action = new Action();
        action.setToastMsg(toastMsg.toString());
        action.setType(ActionTypeEnum.REFRESH.getValue());

        return ApiResponse.buildOK().setData(action);

    }

    /**
     * 工时回报/支援-人员下线数据接口
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/workingHourReport/peopleOffline", method = RequestMethod.POST)
    public ApiResponse<String> peopleOffline(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        ApiRawData apiRawData = apiRequestSubmit.getRawData();

        // 构建请求参数
        Map<String, Object> requestParams = this.buildRequestParams(apiRequestSubmit, "wo_op_report_info", false);

        Action<Map<String, Object>> action = new Action<>();
        Map<String, Object> response = this.digiwinAtdmProxyService.peopleOffline(locale, iamUserToken, requestParams, tenantId);
        // 1.除外回报时间重叠;2.工时回报时间重叠;3.已上线未下线;4.自动下线询问
        String errorType = (String) response.get("error_type");
        String errorMsg = (String) response.get("error_msg");
        if (StringUtils.isEmpty(errorType)) {
            if (StringUtils.isEmpty(errorMsg)) {
                // 为true的时候再执行任务中心提交
                ApiRequestSubmit submitRequest = JsonUtil.objectToJavaObject(requestParams.get("submitRequest"), ApiRequestSubmit.class);
                this.actionService.submit(submitRequest);

                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "人员下线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));

                Integer actionType = ActionTypeEnum.REFRESH.getValue();
                if (!Objects.isNull(apiRawData)) {
                    if (!Objects.isNull(apiRawData.get("isProcess")) && (Boolean) apiRawData.get("isProcess")) {
                        if ((Boolean) apiRawData.get("isProcess")) {
                            actionType = ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue();
                        }
                    } else {
                        if (!Objects.isNull(apiRawData.get("pageId"))) {
                            action.setRefreshPageId((String) apiRawData.get("pageId"));
                        }
                    }
                }
                action.setType(actionType);
                return ApiResponse.buildOK().setData(action);
            } else {
                action = new Action<>();
                action.setConfirmPop(ConfirmPop.create(errorMsg, true));
                action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
                return ApiResponse.buildOK().setData(action);
            }
        }
        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) response.get("wo_op_report_info");
        handleWorkHourAction(woOpReportData, action, errorType, errorMsg, locale);
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 获取所有行事历和对应行事历成员
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/calendar/getAllTeamMember", method = RequestMethod.POST)
    public ApiResponse<Map<String, Object>> getAllTeamMember(HttpServletRequest request) throws Exception {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) apiRequest.get("locale");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String userId = (String) apiRequest.get("userId");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, String> params = new HashMap<>(2);
        params.put("userId", userId);
        params.put("tenantId", tenantId);
        //这里可能存在脏数据情况，目前改表主键来防止脏数据
        PersonalConfiguration personalConfiguration = personalConfigurationService.getByMap(params);
        if (personalConfiguration == null) {
            personalConfiguration = new PersonalConfiguration();
            if (ObjectUtil.isNotEmpty(apiRequest.get("showCompleted"))) {
                personalConfiguration.setShowCompleted((Boolean) apiRequest.get("showCompleted"));
            } else {
                personalConfiguration.setShowCompleted(false);
            }
            personalConfiguration.setShowFactory(false);
            personalConfiguration.setUserId(userId);
            personalConfiguration.setTenantId(tenantId);
        }
        List<DigiwinAtmcCalendar> digiwinAtmcCalendars = this.digiwinAtmcProxyService.
                queryAllTeamMember(iamUserToken, locale);
        for (DigiwinAtmcCalendar digiwinAtmcCalendar : digiwinAtmcCalendars) {
            if (digiwinAtmcCalendar.getMembers() != null) {
                digiwinAtmcCalendar.setMemberSize(digiwinAtmcCalendar.getMembers().size());
            } else {
                digiwinAtmcCalendar.setMemberSize(0);
            }

        }
        Map<String, Object> data = new HashMap<>(2);
        data.put("personalConfiguration", personalConfiguration);
        data.put("allTeamMember", digiwinAtmcCalendars);
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * 获取指定行事历成员的所有任务
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/calendar/getTeamMemberBacklog", method = RequestMethod.POST)
    public ApiResponse<List<TaskSummary>> getTeamMemberBacklog(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) apiRequest.get("locale");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String tenantId = (String) apiRequest.get("tenantId");
        String teamId = (String) apiRequest.get("teamId");
        String teamName = (String) apiRequest.get("teamName");
        String clientId = (String) apiRequest.get("clientId");
        Boolean myCalender = (Boolean) apiRequest.get("myCalender");
        Boolean isAll = (Boolean) apiRequest.get("isAll");
        List<String> userIds = (List<String>) apiRequest.get("userIds");
        String currentUserId = (String) apiRequest.get("currentUserId");
        /**
         * 行事历请求页面 行事历任务列表增加时间范围查询
         */
        String startDate = (String) apiRequest.get("startDate");
        String endDate = (String) apiRequest.get("endDate");
        PersonalConfiguration personalConfiguration = JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(apiRequest.get("personalConfiguration")), PersonalConfiguration.class);
        if (StringUtils.isBlank(personalConfiguration.getTenantId())) {
            personalConfiguration.setTenantId(tenantId);
        }

        personalConfigurationService.insertOrUpdate(personalConfiguration);
        List<DigiwinAtmcBacklog> digiwinAtmcBacklogs = digiwinAtmcProxyService
                .getTeamMemberWorkItemList(clientId, iamUserToken, teamId, locale, startDate, endDate);
        List<DigiwinAtmcBacklog> newDigiwinAtmcBacklogs = new ArrayList<>(digiwinAtmcBacklogs.size());
        boolean isMyCalender = false;
        //我的行事历默认显示全部，其他团队行事历由选项决定
        if (!isAll) {
            for (DigiwinAtmcBacklog digiwinAtmcBacklog : digiwinAtmcBacklogs) {
                if (userIds.contains(digiwinAtmcBacklog.getOwnerUserId())) {
                    digiwinAtmcBacklog.setCalenderTeamName(teamName);
                    newDigiwinAtmcBacklogs.add(digiwinAtmcBacklog);
                }
            }
        } else {
            if (myCalender) {
                isMyCalender = true;
                newDigiwinAtmcBacklogs = digiwinAtmcBacklogs;
            } else {
                for (DigiwinAtmcBacklog digiwinAtmcBacklog : digiwinAtmcBacklogs) {
                    if (taskFilterService.isCanlderTaskByDigiwinAtmcBacklog(digiwinAtmcBacklog)) {
                        digiwinAtmcBacklog.setCalenderTeamName(teamName);
                        newDigiwinAtmcBacklogs.add(digiwinAtmcBacklog);
                    }
                }
            }
        }


        // 按endTime升序排序，方便App端直接渲染界面
        newDigiwinAtmcBacklogs.sort((o1, o2) -> {
            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern(o1.getEndTime());
            LocalDateTime o2EndTime = DateTimeUtil.parseUseDefaultPattern(o2.getEndTime());
            if (o1EndTime.isBefore(o2EndTime)) {
                return -1;
            } else if (o1EndTime.isEqual(o2EndTime)) {
                return 0;
            } else {
                return 1;
            }
        });

        String tenantVersion = activityFilterService.tenantVersion(iamUserToken, tenantId, locale);
        List<PageTaskRelation> pageTaskRelationList =
                activityFilterService.listAthenaOfPageTaskRelations(tenantId, tenantVersion);

        // 获取CustomTaskConfig相关文档数据
        List<CustomTaskConfig> customTaskConfigList = customTaskConfigService.listCustomTaskConfig();

        // FIXME 两重循环应该有优化空间，后续再考虑看看
        boolean finalIsMyCalender = isMyCalender;
        List<TaskSummary> taskSummaries = newDigiwinAtmcBacklogs.stream().map(digiwinAtmcBacklog -> {
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                    pageTaskRelationList.stream().filter(
                                    pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                            digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId()))
                            .findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                            pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                    digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory()))
                    .findFirst();
            String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                    optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                    (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");

            return TaskSummary.create(locale, iamUserToken,
                    digiwinAtmcBacklog, jumpPageId, customTaskConfigList, finalIsMyCalender, currentUserId, false, localeService);
        }).collect(Collectors.toList());

        return ApiResponse.buildOK().setData(taskSummaries);
    }

    /**
     * 进度回报-进度提交数据接口
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/projectScheduleReport/projectScheduleSubmin", method = RequestMethod.POST)
    public ApiResponse<String> projectScheduleSubmin(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) apiRequest.get("locale");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String tenantId = String.valueOf(apiRequest.get("tenantId"));

        Map<String, Object> requestParams = (Map<String, Object>) apiRequest.get("rawData");

        DigiwinAthenaApiResponse<JSONObject> apiResponse = digiwinAtdmProxyService.projectScheduleSubmin(locale, iamUserToken, requestParams, tenantId);
        boolean hasProjectScheduleSubmin = apiResponse.getStatus() == HttpStatus.OK.value();
        String str = "";
        if (hasProjectScheduleSubmin) {
            //为true的时候在执行提交
            ApiRequestSubmit submitRequest = JsonUtil.objectToJavaObject(requestParams.get("submitRequest"), ApiRequestSubmit.class);
            this.actionService.submit(submitRequest);
            str = LocaleUtil.getMobileTextByKey(locale, "进度提交") + LocaleUtil.getMobileTextByKey(locale, "成功");
        } else {
            str = LocaleUtil.getMobileTextByKey(locale, "进度提交") + LocaleUtil.getMobileTextByKey(locale, "失败");
        }

        return ApiResponse.buildOK().setData(str);

    }

    /**
     * 获取弹窗单选数据
     *
     * @param requestData
     * @param request
     * @return
     */
    @RequestMapping(value = "/get/inputSingleSelectOptions", method = RequestMethod.POST)
    public ApiResponse<List<SingleSelectListOption>> getInputSingleSelectOptions(
            @RequestBody SingleSelectListRequestData requestData, HttpServletRequest request) {
        List<DigiwinEspEnumerateResponse> datas = digiwinEspProxyService.getEnumerateInfo(requestData.getIamUserToken(), requestData.getTenantId(),
                requestData.getLocale(), requestData.getSchema());
        if (datas != null && datas.size() > 0) {
            List<SingleSelectListOption> singleSelectListOptions = new ArrayList<>(datas.size());
            for (DigiwinEspEnumerateResponse data : datas) {
                singleSelectListOptions.add(SingleSelectListOption.create(data.getEnumerateName(),
                        data.getEnumerateName(), true));
            }
            return ApiResponse.buildOK().setData(singleSelectListOptions);
        } else {
            return ApiResponse.buildOK().setData(Collections.emptyList());
        }
    }

    /**
     * 异常原因开窗单选
     *
     * @param requestData
     * @return
     */
    @RequestMapping(value = "/abnormalReport/abnormalReasonlist", method = RequestMethod.POST)
    public ApiResponse<InputWindowSingleResponseData> getAbnormalReasonlist(
            @RequestBody InputWindowSingleRequestData requestData, HttpServletRequest request) {
        String locale = requestData.getLocale();
        String userToken = requestData.getIamUserToken();
        Map<String, Object> rawData = requestData.getRawData();
        Map<String, Object> queryActionParameter = (Map<String, Object>) rawData.get("queryActionParameter");
        Map<String, Object> actionShowParameter = new HashMap<>();
        if (CollectionUtils.isEmpty(queryActionParameter)) {
            actionShowParameter.put("dataSourceSet", rawData.get("dataSourceSet"));
            actionShowParameter.put("executeContext", rawData.get("executeContext"));
            actionShowParameter.put("parameter", rawData.get("parameter"));
        } else {
            Map<String, Object> getActionShowParameter = digiwinPcUiBotProxyService.getActionShowParameter(
                    locale,
                    userToken,
                    queryActionParameter);

            actionShowParameter.putAll(getActionShowParameter);
            actionShowParameter.put("executeContext", rawData.get("executeContext"));
            actionShowParameter.put("parameter", queryActionParameter.get("paras"));
        }

        actionShowParameter.put("useHasNext", false);
        actionShowParameter.put("multipleSelect", false);
        actionShowParameter.put("selectedFirstRow", false);
        actionShowParameter.put("queryTagSuffix", "DIALOG");
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.actionShow(locale,
                userToken,
                JsonUtil.javaObjectToJsonString(actionShowParameter));

        // 找到实际明细数据的layout
        Optional<UiBotLayout> optPcDataLayout = pcUiBotModel.getLayout()
                .stream()
                .filter(l -> l.getId() != null && l.getId().equalsIgnoreCase(l.getSchema()))
                .findFirst();
        UiBotLayout pcDataLayout = optPcDataLayout.orElse(new UiBotLayout());
        String schema = pcDataLayout.getSchema();
        List<Map<String, Object>> abnormalReasonInfoList =
                (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(abnormalReasonInfoList, "pagedata." + schema + " cannot be null");
        // 分解出明细数据行的字段列表
        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition
                .decomposeTableColumnDefinitions(tableColumnDefinitionList);
        List<InputWindowSingleItem> itemList = new ArrayList<>();
        for (Map<String, Object> abnormalReasonInfoMap : abnormalReasonInfoList) {
            InputWindowSingleItem item = new InputWindowSingleItem();
            item.setTitle(String.valueOf(abnormalReasonInfoMap.get("abnormal_reason_name")));
            item.setSubtitle(String.valueOf(abnormalReasonInfoMap.get("abnormal_reason_no")));
            item.setShowImage(false);
            Map<String, Object> detail = new HashMap<>(2);
            detail.put("abnormal_reason_no", abnormalReasonInfoMap.get("abnormal_reason_no"));
            detail.put("abnormal_reason_name", abnormalReasonInfoMap.get("abnormal_reason_name"));
            item.setId(String.valueOf(abnormalReasonInfoMap.get("abnormal_reason_no")));
            item.setDetail(detail);
            itemList.add(item);
        }

        InputWindowSingleResponseData responseData = new InputWindowSingleResponseData();
        if (itemList.isEmpty()) {
            return ApiResponse.buildOK().setData(InputWindowSingleResponseData.empty());
        }

        responseData.setSearchType(InputWindowSingleSelectSearchTypeEnum.FRONTEND_SEARCH.getType());
        responseData.setList(itemList);
        responseData.setTotal(itemList.size());

        return ApiResponse.buildOK().setData(responseData);
    }

    private Table doMockDataSpareCapacity(String dateId, String locale) {
        try {
            Thread.sleep(1000L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        if (dateId.equals("0")) {
            data = FileUtil.readText("static/appstore-use/table_week.json");
        } else {
            data = FileUtil.readText("static/appstore-use/table_month.json");
        }
        Table table = JsonUtil.jsonStringToObject(data, Table.class);
        return table;
    }

    /**
     * 获取三方应用授权码
     *
     * @param request
     * @return
     * @throws IOException
     */
    @PostMapping(value = "/authorize/code/get")
    public ApiResponse<String> getAuthorizeCode(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String appId = String.valueOf(apiRequest.get("appId"));
        String callbackUrl = String.valueOf(apiRequest.get("callbackUrl"));
        String code = digiwinIamProxyService.getAuthorizeCode(iamUserToken, appId, callbackUrl);
        return ApiResponse.buildOK().setData(code);
    }

    /**
     * 判断当前人员是否为主管
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/isDeptDirector", method = RequestMethod.POST)
    public ApiResponse<Boolean> isDeptDirector(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String userId = (String) apiRequest.get("userId");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        Boolean isDeptDirector = digiwinEocProxyService.isDeptDirector(userId, iamUserToken);
        return ApiResponse.buildOK().setData(isDeptDirector);
    }

    /**
     * 获取团队分组信息
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/team/group/data/get", method = RequestMethod.POST)
    public ApiResponse<Map<String, Object>> getTeamGroupData(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String type = (String) apiRequest.get("type");
        String locale = (String) apiRequest.get("locale");
        Map<String, Object> data = new HashMap<>(1);
        List<DigiwinAtmcGroupType> groupTypes = new ArrayList<>(2);
        DigiwinAtmcGroupType teamGroupType = new DigiwinAtmcGroupType();
        teamGroupType.setGroupTypeId("teamMember");
        teamGroupType.setGroupTypeName(localeService.getLanguageValue(locale, "按团队成员分组"));
        groupTypes.add(teamGroupType);

        DigiwinAtmcGroupType codeGroupType = new DigiwinAtmcGroupType();
        codeGroupType.setGroupTypeId("code");
        if (TYPE_PROJECT.equalsIgnoreCase(type)) {
            codeGroupType.setGroupTypeName(localeService.getLanguageValue(locale, "按项目类型分组"));
        } else {
            codeGroupType.setGroupTypeName(localeService.getLanguageValue(locale, "按任务类型分组"));
        }
        groupTypes.add(codeGroupType);

        data.put("groupTypeList", groupTypes);
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * 获取团队任务/项目的数据
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/team/data/get", method = RequestMethod.POST)
    public ApiResponse<Map<String, Object>> getTeamData(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        /**
         * 分组类型
         */
        String groupType = (String) apiRequest.get("groupType");
        /**
         * 类型：项目、任务
         */
        String type = (String) apiRequest.get("type");
        Map<String, Object> data = new HashMap<>(3);
        data.put("groupType", groupType);
        data.put("type", type);
        Integer total = 0;
        if (TYPE_PROJECT.equalsIgnoreCase(type)) {
            List<DigiwinAtmcProjectGroup> projectGroups = digiwinAtmcProxyService.
                    getDepartProjectGroup(iamUserToken, tenantId, locale, groupType);
            for (DigiwinAtmcProjectGroup projectGroup : projectGroups) {
                Action action = new Action();
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TEAM_PROJECT.toString());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                Map<String, Object> rawData = new HashMap<>(4);
                rawData.put("groupType", groupType);
                rawData.put("type", type);
                rawData.put("userId", projectGroup.getUserId());
                rawData.put("projectDefCode", projectGroup.getProjectDefCode());

                TeamTitle teamTitle = new TeamTitle();
                teamTitle.setAbnormal(projectGroup.getAbnormalNum() != 0);
                List<TeamTitleDetail> detail = new ArrayList<>(3);
                if ("teamMember".equalsIgnoreCase(groupType)) {
                    teamTitle.setTitle(projectGroup.getUserName());
                } else {
                    teamTitle.setTitle(projectGroup.getProjectDefName());
                }
                TeamTitleDetail abnormalDetail = new TeamTitleDetail();
                abnormalDetail.setAbnormal(projectGroup.getAbnormalNum() != 0);
                abnormalDetail.setName(localeService.getLanguageValue(locale, "逾期/异常"));
                abnormalDetail.setNumber(projectGroup.getAbnormalNum());
                detail.add(abnormalDetail);

                TeamTitleDetail normalDetail = new TeamTitleDetail();
                normalDetail.setAbnormal(false);
                normalDetail.setName(localeService.getLanguageValue(locale, "正常进行"));
                normalDetail.setNumber(projectGroup.getNormalNum());
                detail.add(normalDetail);

                teamTitle.setDetail(detail);
                rawData.put("teamTitle", teamTitle);

                action.setRawData(rawData);
                projectGroup.setAction(action);
                total += projectGroup.getAbnormalNum();
                total += projectGroup.getNormalNum();
            }
            data.put("data", projectGroups);
            data.put("total", total);
            return ApiResponse.buildOK().setData(data);
        } else if (TYPE_BACKLOG.equalsIgnoreCase(type)) {
            List<DigiwinAtmcBacklogGroup> backlogGroups = digiwinAtmcProxyService.
                    getDepartBacklogGroup(iamUserToken, tenantId, locale, groupType);
            for (DigiwinAtmcBacklogGroup backlogGroup : backlogGroups) {
                Action action = new Action();
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_TEAM_TASK.toString());
                action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                Map<String, Object> rawData = new HashMap<>(4);
                rawData.put("groupType", groupType);
                rawData.put("type", type);
                rawData.put("userId", backlogGroup.getUserId());
                rawData.put("taskDefCode", backlogGroup.getTaskDefCode());
                TeamTitle teamTitle = new TeamTitle();
                teamTitle.setAbnormal(backlogGroup.getOverdueNum() != 0);
                List<TeamTitleDetail> detail = new ArrayList<>(3);
                if ("teamMember".equalsIgnoreCase(groupType)) {
                    teamTitle.setTitle(backlogGroup.getUserName());
                } else {
                    teamTitle.setTitle(backlogGroup.getTaskDefName());
                }
                TeamTitleDetail abnormalDetail = new TeamTitleDetail();
                abnormalDetail.setAbnormal(backlogGroup.getOverdueNum() != 0);
                abnormalDetail.setName(localeService.getLanguageValue(locale, "逾期任务"));
                abnormalDetail.setNumber(backlogGroup.getOverdueNum());
                detail.add(abnormalDetail);

                TeamTitleDetail todayDetail = new TeamTitleDetail();
                todayDetail.setAbnormal(false);
                todayDetail.setName(localeService.getLanguageValue(locale, "今日任务"));
                todayDetail.setNumber(backlogGroup.getTodayNum());
                detail.add(todayDetail);

                TeamTitleDetail advancedDetail = new TeamTitleDetail();
                advancedDetail.setAbnormal(false);
                advancedDetail.setName(localeService.getLanguageValue(locale, "以后任务"));
                advancedDetail.setNumber(backlogGroup.getAdvancedNum());
                detail.add(advancedDetail);

                teamTitle.setDetail(detail);
                rawData.put("teamTitle", teamTitle);
                action.setRawData(rawData);
                backlogGroup.setAction(action);
                total += backlogGroup.getAdvancedNum();
                total += backlogGroup.getOverdueNum();
                total += backlogGroup.getTodayNum();
            }
            data.put("data", backlogGroups);
            data.put("total", total);
            return ApiResponse.buildOK().setData(data);
        }
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * 获取ABI报表的常用条件
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/get/abi/commonCondition", method = RequestMethod.POST)
    public ApiResponse getAbiCommonCondition(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        String activityCode = (String) apiRequest.get("dataId");
        //查询web端常用条件
        List<Map<String, Object>> commonConditions = digiwinAtmcProxyService.
                conditionQueryInBi(iamUserToken, tenantId, locale, activityCode);
        if (CollectionUtils.isEmpty(commonConditions)) {
            return ApiResponse.buildOK();
        }
        CommonConditions conditions = new CommonConditions();
        UiBotAction uiBotAction = JsonUtil.objectToJavaObject(((Map) apiRequest.get("rawData")).get("action"), UiBotAction.class);
        String conditionId = (String) ((Map) apiRequest.get("rawData")).get("conditionId");
        conditions.getRawData().put("activityCode", activityCode);
        conditions.getRawData().put("action", uiBotAction);
        conditions.setTitle(localeService.getLanguageValue(locale, "常用条件"));
        List<Button> conditionList = conditions.getConditions();
        for (Map<String, Object> commonCodition : commonConditions) {
            Button condition = new Button();
            String conditionName = (String) commonCodition.get("conditionName");
            condition.setName(conditionName);
            condition.setShowNum(false);
            Map<String, Object> conditionValue = (Map<String, Object>) commonCodition.get("conditionValue");
            String schema = (String) conditionValue.get("UIBOT__schema");
            String id = String.valueOf(commonCodition.get("id"));
            condition.setId(id);
            if (conditionId != null && conditionId.equals(id)) {
                condition.setSelected(true);
            } else {
                condition.setSelected(false);
            }
            Map<String, Object> data = (Map<String, Object>) conditionValue.get(schema);
            condition.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());

            Map<String, Object> params = new HashMap<>(2);
            params.put("action", uiBotAction);
            Map<String, Object> value = new HashMap<>(1);
            List<Map<String, Object>> datas = new ArrayList<>(1);
            datas.add(data);
            value.put(schema, datas);
            params.put("data", value);
            String hashCode = digiwinAtmcProxyService.getAbiDataCache(iamUserToken, tenantId, locale, params);

            Action action = new Action();
            Map<String, Object> rawData = new HashMap<>(7);
            rawData.put("useCommon", true);
            rawData.put("data", data);
            rawData.put(SELECT_TAG, hashCode);
            rawData.put(ABI_STATEMENT_RESID, conditionValue.get(ABI_STATEMENT_RESID));
            rawData.put("deleteData", commonCodition);
            rawData.put("conditionId", id);
            rawData.put("conditionName", conditionName);
            action.setRawData(rawData);
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ABI_REPORT_DETAIL.toString());
            action.setJumpPageTitle("");
            action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
            condition.setAction(action);
            conditionList.add(condition);
        }
        Collections.sort(conditionList, (c1, c2) -> {
            return Integer.valueOf(c2.getId()) - Integer.valueOf(c1.getId());
        });
        return ApiResponse.buildOK().setData(conditions);
    }

    @RequestMapping(value = "/delete/abi/commonCondition", method = RequestMethod.POST)
    public ApiResponse deleteAbiCommonCondition(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Boolean deleteAll = (Boolean) apiRequest.get("isDeleteAll");
        Map<String, Object> rawData = (Map<String, Object>) apiRequest.get("rawData");
        Boolean deleteSuccess = false;
        Map<String, Object> returnData = new HashMap<>(2);
        if (deleteAll) {
            String activityCode = (String) rawData.get("activityCode");
            List<Map<String, Object>> commonConditions = digiwinAtmcProxyService.
                    conditionQueryInBi(iamUserToken, tenantId, locale, activityCode);
            for (Map<String, Object> commonCondition : commonConditions) {
                deleteSuccess = digiwinAtmcProxyService.deleteAbiCondition(iamUserToken, tenantId, locale, commonCondition);
                if (!deleteSuccess) {
                    returnData.put("isSuccess", deleteSuccess);
                    returnData.put("totalMessage", commonCondition.get("conditionName") + localeService.getLanguageValue(locale, "删除失败，请稍后重试~"));
                    return ApiResponse.buildOK().setData(returnData);
                }
            }
        } else {
            Map<String, Object> deleteData = (Map<String, Object>) rawData.get("deleteData");
            deleteSuccess = digiwinAtmcProxyService.deleteAbiCondition(iamUserToken, tenantId, locale, deleteData);
        }
        returnData.put("isSuccess", deleteSuccess);
        if (deleteSuccess) {
            returnData.put("totalMessage", localeService.getLanguageValue(locale, "删除成功"));
            return ApiResponse.buildOK().setData(returnData);
        } else {
            returnData.put("totalMessage", localeService.getLanguageValue(locale, "删除失败，请稍后重试~"));
            return ApiResponse.buildOK().setData(returnData);
        }

    }

    /**
     * 选择查阅方式（底部弹窗选择页面接口）
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/choice/view/list", method = RequestMethod.POST)
    public ApiResponse<Map> choiceViewList(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) params.get("locale");
        String dataId = String.valueOf(params.get("dataId"));
        Map<String, Object> rawData = (Map<String, Object>) params.get("rawData");

        Map<String, Object> data = new HashMap<>(4);
        data.put("title", localeService.getLanguageValue(locale, "选择查阅方式"));

        List<Button> list = new ArrayList<>();
        Button stateButton = new Button();
        stateButton.setName(localeService.getLanguageValue(locale, "依状态查阅"));
        stateButton.setSubName(localeService.getLanguageValue(locale, "依状态查阅"));
        // dataId 没值默认依状态查
        stateButton.setSelected(StringUtils.isBlank(dataId) || "STATE_VIEW".equalsIgnoreCase(dataId));
        Action<Map<String, Object>> stateAction = new Action<>();
        stateAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        stateAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_STATE.name());
        stateAction.setJumpPageTitle(localeService.getLanguageValue(locale, "人员状况"));
        stateAction.setDataId("STATE_VIEW");
        stateAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
        stateAction.setRawData(rawData);
        stateButton.setAction(stateAction);
        list.add(stateButton);
        Button groupButton = new Button();
        groupButton.setName(localeService.getLanguageValue(locale, "依组别查阅"));
        groupButton.setSubName(localeService.getLanguageValue(locale, "依组别查阅"));
        groupButton.setSelected("GROUP_VIEW".equalsIgnoreCase(dataId));
        Action<Map<String, Object>> groupAction = new Action<>();
        groupAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        groupAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_STATE.name());
        groupAction.setJumpPageTitle(localeService.getLanguageValue(locale, "人员状况"));
        groupAction.setDataId("GROUP_VIEW");
        groupAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
        groupAction.setRawData(rawData);
        groupButton.setAction(groupAction);
        list.add(groupButton);
        data.put("optionList", list);
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * 获取在途宝省市区数据
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/get/arealist", method = RequestMethod.POST)
    public ApiResponse<List<ZtbArea>> getAreaList(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String parentId = (String) apiRequest.get("parent_id");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        List<ZtbArea> areaList = digiwinEspProxyService.getAreaList(iamUserToken, tenantId, locale, parentId);
        if (CollectionUtils.isEmpty(areaList)) {
            return ApiResponse.buildOK().setData(Collections.emptyList());
        } else {
            return ApiResponse.buildOK().setData(areaList);
        }
    }

    /**
     * 删除用户地址
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/delete/user/address", method = RequestMethod.POST)
    public ApiResponse<String> deleteUserAddress(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        String addressId = (String) apiRequest.get("id");
        digiwinEspProxyService.deleteUserAddress(
                iamUserToken, tenantId, locale, addressId);
        return ApiResponse.buildOK().setData(localeService.getLanguageValue(locale, "删除成功"));
    }

    /**
     * 保存用户地址
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/save/user/address", method = RequestMethod.POST)
    public ApiResponse<String> saveUserAddress(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        String addressId = (String) apiRequest.get("id");
        Boolean isSuccess;
        StringBuffer completeAddress = new StringBuffer();
        completeAddress.append(apiRequest.get("province")).append(" ").append(apiRequest.get("city")).
                append(" ").append(apiRequest.get("area")).append(apiRequest.get("detailAddress"));
        Map<String, Object> rawData = new HashMap<>(6);
        rawData.put("area_id", getAreaId((String) apiRequest.get("province"), (String) apiRequest.get("city"), (String) apiRequest.get("area"), apiRequest));
        rawData.put("complete_address", completeAddress);
        rawData.put("detail_address", apiRequest.get("detailAddress"));
        rawData.put("user_name", apiRequest.get("name"));
        rawData.put("user_phone", apiRequest.get("mobile"));
        rawData.put("ad_code", apiRequest.get("adCode"));
        if (StringUtils.isEmpty(addressId)) {
            digiwinEspProxyService.createUserAddress(iamUserToken, tenantId, locale, rawData);
            return ApiResponse.buildOK().setData(localeService.getLanguageValue(locale, "创建成功"));
        } else {
            rawData.put("address_id", addressId);
            digiwinEspProxyService.updateUserAddress(iamUserToken, tenantId, locale, rawData);
            return ApiResponse.buildOK().setData(localeService.getLanguageValue(locale, "更新成功"));
        }
    }


    /**
     * 获取在途宝的用户地址
     */
    @RequestMapping(value = "/get/user/address", method = RequestMethod.POST)
    public ApiResponse<Address> getUserAddress(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        String addressId = (String) apiRequest.get("id");
        if (StringUtils.isEmpty(addressId)) {
            return ApiResponse.buildOK().setData(new Address());
        } else {
            ZtbUserAddress ztbUserAddress = JsonUtil.objectToJavaObject(digiwinEspProxyService.getUserAddress(iamUserToken, tenantId, locale,
                    addressId), ZtbUserAddress.class);

            return ApiResponse.buildOK().setData(buildAddress(ztbUserAddress));
        }
    }

    /**
     * 在途宝用户地址簿列表页数据
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/get/user/address/list", method = RequestMethod.POST)
    public ApiResponse<List<Address>> getUserAddressList(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, Object> rawData = new HashMap<>(2);
        rawData.put("page_no", "1");
        rawData.put("page_size", "9999");

        List<ZtbUserAddress> ztbUserAddressList = digiwinEspProxyService.getuserAddressList(iamUserToken,
                tenantId, locale, rawData);
        if (CollectionUtils.isEmpty(ztbUserAddressList)) {
            return ApiResponse.buildOK().setData(Collections.emptyList());
        }
        List<Address> addresses = new ArrayList<>(ztbUserAddressList.size());
        for (ZtbUserAddress userAddress : ztbUserAddressList) {
            addresses.add(buildAddress(userAddress));
        }
        return ApiResponse.buildOK().setData(addresses);
    }


    private String getAreaId(String provice, String city, String area, Map apiRequest) {
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        List<ZtbArea> proviceAreaList = digiwinEspProxyService.getAreaList(iamUserToken, tenantId, locale, "0");
        for (ZtbArea proviceArea : proviceAreaList) {
            if (proviceArea.getName().contains(provice)) {
                List<ZtbArea> cityAreaList = digiwinEspProxyService.getAreaList(iamUserToken, tenantId, locale, proviceArea.getId());
                if (cityAreaList != null && cityAreaList.size() > 1) {
                    for (ZtbArea cityArea : cityAreaList) {
                        if (cityArea.getName().contains(city)) {
                            List<ZtbArea> areaList = digiwinEspProxyService.getAreaList(iamUserToken, tenantId, locale, cityArea.getId());
                            for (ZtbArea ztbArea : areaList) {
                                if (ztbArea.getName().contains(area)) {
                                    return ztbArea.getId();
                                }
                            }
                        }
                    }
                } else if (cityAreaList != null && !CollectionUtils.isEmpty(cityAreaList)) {
                    List<ZtbArea> areaList = digiwinEspProxyService.getAreaList(iamUserToken, tenantId, locale, cityAreaList.get(0).getId());
                    for (ZtbArea ztbArea : areaList) {
                        if (ztbArea.getName().contains(area)) {
                            return ztbArea.getId();
                        }
                    }
                }

            }
        }
        return "";
    }

    private Address buildAddress(ZtbUserAddress userAddress) {
        Address address = new Address();
        address.setId(userAddress.getAddressId());
        address.setCompleteAddress(userAddress.getCompleteAddress());
        address.setAddress(userAddress.getDetailAddress());
        address.setMobile(userAddress.getUserPhone());
        address.setName(userAddress.getUserName());
        address.setUserId(userAddress.getUserId());
        address.setAreaId(userAddress.getAreaId());
        address.setCity(userAddress.getCity());
        address.setProvince(userAddress.getProvince());
        address.setArea(userAddress.getArea());
        address.setAdCode(userAddress.getAdCode());
        return address;
    }

    /**
     * 更换货运单车辆
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/update/carMessage", method = RequestMethod.POST)
    public ApiResponse<Boolean> ztbAnalySisCode(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, Object> params = new HashMap<>(5);
        params.put("license_plate_no", apiRequest.get("license_plate_no"));
        params.put("vehicle_type", apiRequest.get("vehicle_type"));
        params.put("vehicle_length", apiRequest.get("vehicle_length"));
        params.put("task_no", apiRequest.get("task_no"));
        params.put("transport_no", apiRequest.get("transport_no"));

        return ApiResponse.buildOK().setData(digiwinEspProxyService.changeTaskTransportVehicle(iamUserToken, tenantId, locale, params));
    }

    /**
     * 完成装车
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/car/loading/submit", method = RequestMethod.POST)
    public ApiResponse<Action> carLoadingSubmit(HttpServletRequest request) throws IOException {
        Map apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, Object> rawData = (Map<String, Object>) apiRequest.get("rawData");
        List<Card> cards = ModuleUtils.listMapToListObject((List<?>) apiRequest.get("cargo_information"), Card.class);
        List<Map<String, Object>> oldCargoInformation = (List<Map<String, Object>>) rawData.get("cargo_infomation");
        List<Map<String, Object>> cargoInformation = new ArrayList<>(cards.size());
        for (Card card : cards) {
            Map<String, Object> detail = card.getDetail();
            for (Map<String, Object> info : oldCargoInformation) {
                if (info.get("item_no").equals(detail.get("item_no"))) {
//                    info.put("item_qty", card.getAdderSubstracter().getNumber());
                    info.put("item_qty", info.get("item_qty"));
                    info.remove("un_loading_qty");
                    cargoInformation.add(info);
                    break;
                }
            }
        }
        Map<String, Object> params = new HashMap<>(6);
        params.putAll(rawData);
        params.put("cargo_information", cargoInformation);
        Action action = new Action();
        Map<String, Object> taskParams = digiwinEspProxyService.submitTaskTransportLoading(iamUserToken, tenantId, locale, params);
        Boolean submited = (Boolean) taskParams.get("is_submit_task");
        Boolean isFinshed = (Boolean) taskParams.get("is_finish_loading");
        if (submited) {
            List<HashMap<String, Object>> deliveryList = (List<HashMap<String, Object>>) ((Map) rawData.get("data")).get("delivery_detail");
            if (!CollectionUtils.isEmpty(deliveryList)) {
                deliveryList.forEach(delivery -> {
                    delivery.put("transport_no", rawData.get("transport_no"));
                    delivery.put("submited", true);
                });
            }
            DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                    this.digiwinAtmcProxyService.actionSubmit(locale,
                            iamUserToken, tenantId, rawData);
            if (null != atmcSubmitResult.getRequestData()) {
                if (isFinshed) {
                    action.setDataId((String) rawData.get("taskId"));
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK.toString());
                    action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                    Map<String, Object> rawDatas = new HashMap<>(2);
                    rawDatas.put("plan_arrival_date", rawData.get("plan_arrival_date"));
                    rawDatas.put("isSubmit", true);
                    action.setRawData(rawDatas);
                } else {
                    action.setDataId((String) rawData.get("taskId"));
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK.toString());
                    action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                    Map<String, Object> rawDatas = new HashMap<>(2);
                    rawDatas.put("isSubmit", true);
                    action.setRawData(rawDatas);
                }
            } else {
                action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                action.setToastMsg(atmcSubmitResult.getErrorMessage());
            }
        } else {
            if (isFinshed) {
                List<HashMap<String, Object>> deliveryList = (List<HashMap<String, Object>>) ((Map) rawData.get("data")).get("delivery_detail");
                if (!CollectionUtils.isEmpty(deliveryList)) {
                    deliveryList.forEach(delivery -> {
                        delivery.put("transport_no", rawData.get("transport_no"));
                        delivery.put("submited", false);
                    });
                }
                DigiwinAtmcBacklogSubmitResult atmcSubmitResult =
                        this.digiwinAtmcProxyService.actionSubmit(locale,
                                iamUserToken, tenantId, rawData);

                action.setDataId((String) rawData.get("taskId"));
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK.toString());
                action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                Map<String, Object> rawDatas = new HashMap<>(2);
                rawDatas.put("plan_arrival_date", rawData.get("plan_arrival_date"));
                rawDatas.put("isSubmit", true);
                action.setRawData(rawDatas);
            } else {
                action.setDataId((String) rawData.get("taskId"));
                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ZTB_SHIPPING_TASK.toString());
                action.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                Map<String, Object> rawDatas = new HashMap<>(2);
                rawDatas.put("isSubmit", true);
                action.setRawData(rawDatas);
            }
        }
        action.setSuccessMsg(localeService.getLanguageValue(locale, "装车成功"));
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 获取在途宝的用户地址
     */
    @RequestMapping(value = "/get/delivery/unlaoding/list", method = RequestMethod.POST)
    public ApiResponse getDeliveryUnloadingList(HttpServletRequest request) throws IOException {
        Map<String, Object> apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        String task_no = StrUtil.toString(apiRequest.get("task_no"));
        Map<String, Object> buttonRawData = (Map<String, Object>) apiRequest.get("rawData");
        List<ZtbCargoUnloading> deliveryUnloadingList = digiwinEspProxyService.getDeliveryUnloadingList(iamUserToken,
                tenantId, locale, task_no);
        if (CollectionUtils.isEmpty(deliveryUnloadingList)) {
            return ApiResponse.buildOK().setData(new ZtbUnloadingItemList());
        } else {
            ZtbUnloadingItemList unloadingItemList = new ZtbUnloadingItemList();
            unloadingItemList.setStyleType("SPLIT_LINE");
            unloadingItemList.setPageable(false);
            unloadingItemList.setSearch(true);
            unloadingItemList.setSearchType(2);
            unloadingItemList.setDataUrl("");
            unloadingItemList.setChoice("MULTIPLE_CHOICE");
            HashMap<String, Object> rawData = new HashMap<>();
            rawData.put("task_no", task_no);
            rawData.put("loadCar", false);
            unloadingItemList.setRawData(rawData);
            Action action = new Action();
            action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/car/loading/submit");
            action.setRawData(buttonRawData);
            unloadingItemList.setAction(action);
            List<ZtbUnloadingItemList.DataList> dataList = new ArrayList<>();
            for (ZtbCargoUnloading item : deliveryUnloadingList) {
                ZtbUnloadingItemList.DataList data = new ZtbUnloadingItemList.DataList();
                ZtbUnloadingItemList.DataList.Detail detail = new ZtbUnloadingItemList.DataList.Detail();
                detail.setItem_no(item.getItemNo());
                detail.setItem_name(item.getItemName());
                detail.setItem_spec(item.getItemSpec());
                detail.setItem_qty(item.getUnLoadingQty());
                detail.setUn_loading_qty(item.getUnLoadingQty());
                detail.setUnit_no(item.getUnitNo());
                detail.setUnit_name(item.getUnitName());
                data.setDetail(detail);
                List<ZtbUnloadingItemList.DataList.Content> contentList = new ArrayList<>();
                ZtbUnloadingItemList.DataList.Content content1 = new ZtbUnloadingItemList.DataList.Content();
                content1.setLabel("应发数量");
                content1.setValue(item.getUnLoadingQty() + "    " + item.getUnitNo());
                content1.setValueStyleType(1);
                content1.setSchema("un_loading_qty");

                contentList.add(content1);
                ZtbUnloadingItemList.DataList.Content content2 = new ZtbUnloadingItemList.DataList.Content();
                content2.setLabel("装车数量");
                content2.setValue(item.getItemQty());
//                content2.setValue(item.getUnLoadingQty());
                content2.setValueStyleType(1);
                content2.setSchema("item_qty");
                contentList.add(content2);
//                ZtbUnloadingItemList.DataList.Content content3 = new ZtbUnloadingItemList.DataList.Content();
//                content3.setLabel("单位");
//                content3.setValue(item.getUnitNo());
//                content3.setValueStyleType(1);
//                content3.setSchema("unit_no");
//                contentList.add(content3);
                ZtbUnloadingItemList.DataList.Content content4 = new ZtbUnloadingItemList.DataList.Content();
                content4.setLabel("标签数量");
                content4.setValue("0");
                content4.setValueStyleType(1);
                content4.setSchema("barcode_num");
                contentList.add(content4);
                data.setContent(contentList);
                data.setButtonList(new ArrayList<>());
                data.setCmptUuid(UUIDUtil.getUuid());
                data.setTitle(item.getItemNo() + "-" + item.getItemName());
                data.setDataId(item.getItemNo());
                data.setAdderSubstracter(null);
                data.setCanEdit(true);
                Map<String, Object> rawData1 = new HashMap<>();
                rawData1.put("item_no", item.getItemNo());
                rawData1.put("item_name", item.getItemName());
                rawData1.put("un_loading_qty", item.getUnLoadingQty());
                rawData1.put("item_qty", item.getItemQty());
//                rawData1.put("item_qty", item.getUnLoadingQty());
                rawData1.put("unit_no", item.getUnitNo());
                rawData1.put("can_edit_qty", true);
                rawData1.put("barcode_num", "0");
                data.setRawData(rawData1);
                dataList.add(data);
            }
            unloadingItemList.setDataList(dataList);
            return ApiResponse.buildOK().setData(unloadingItemList);
        }
    }

    /**
     * 校验运单是否已到达
     */
    @RequestMapping(value = "/transport/arrival/valid", method = RequestMethod.POST)
    public ApiResponse<Address> validTransportArrival(HttpServletRequest request) throws IOException {
        Map<String, Object> apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, Object> buttonRawData = (Map<String, Object>) apiRequest.get("rawData");
        String transport_no = StrUtil.toString(buttonRawData.get("transport_no"));
        Map<String, Object> parameter = digiwinEspProxyService.validTransportArrival(iamUserToken,
                tenantId, locale, transport_no);
        return ApiResponse.buildOK().setData(parameter);
    }

    /**
     * 校验运单是否已到达
     */
    @RequestMapping(value = "/transport/receive/get", method = RequestMethod.POST)
    public ApiResponse<Address> getTransportReceive(HttpServletRequest request) throws IOException {
        Map<String, Object> apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, Object> buttonRawData = (Map<String, Object>) apiRequest.get("rawData");
        String transport_no = StrUtil.toString(buttonRawData.get("transport_no"));

        List<Map<String, Object>> parameter = digiwinEspProxyService.getTransportReceive(iamUserToken,
                tenantId, locale, transport_no);
        return ApiResponse.buildOK().setData(parameter);
    }

    /**
     * 合并工时-人员上线数据接口
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/mergeWorkingHour/peopleOnline", method = RequestMethod.POST)
    public ApiResponse<Action> mergeWorkingHourOnline(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        Map<String, Object> requestParams = buildMergeWorkHourRequest(apiRequestSubmit, "wo_op_report_data", true, false);

        Action<Map<String, Object>> action = new Action<>();
        Map<String, Object> response = digiwinAtdmProxyService.peopleOnline(locale, iamUserToken, requestParams, tenantId);
        // 1.除外回报时间重叠;2.时间重叠;3.已上线未下线;4.自动下线询问
        String errorType = (String) response.get("error_type");
        String errorMsg = (String) response.get("error_msg");
        if (StringUtils.isEmpty(errorType) && StringUtils.isEmpty(errorMsg)) {
            Map<String, Object> requestRawData = apiRequestSubmit.getRawData();
            if (MapUtils.getBooleanValue(requestRawData, "isRemarkAction")) {
                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "备注上线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
                action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST.toString());
            } else {
                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "人员上线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));
                action.setType(ActionTypeEnum.REFRESH.getValue());
                action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST.toString());
            }
            return ApiResponse.buildOK().setData(action);
        }
        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) response.get("wo_op_report_data");
        String toastMsg = LocaleUtil.getMobileTextByKey(locale, "人员上线")
                + LocaleUtil.getMobileTextByKey(locale, "失败");

        // 结构体返回与工时回报一致，展示与其一致
        action = buildMergeWorkHourAction(woOpReportData, errorType, errorMsg, toastMsg, locale);
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 合并工时-取消上线数据接口
     *
     * @param apiRequestSubmit
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/mergeWorkingHour/cancelOnline", method = RequestMethod.POST)
    public ApiResponse<String> mergeWorkingHourCancelOnline(@RequestBody ApiRequestSubmit apiRequestSubmit) throws IOException {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();

        Map<String, Object> requestParams = buildMergeWorkHourRequest(apiRequestSubmit, "wo_op_report_data", false, false);

        boolean hasCancelOnline = digiwinAtdmProxyService.cancelOnline(locale, iamUserToken, requestParams, tenantId);
        StringBuilder toastMsg = new StringBuilder();
        toastMsg.append(this.localeService.getLanguageValue(locale, "取消上线"));
        if (hasCancelOnline) {
            toastMsg.append(this.localeService.getLanguageValue(locale, "成功"));
        } else {
            toastMsg.append(this.localeService.getLanguageValue(locale, "失败"));
        }
        Action action = new Action();
        action.setToastMsg(toastMsg.toString());
        action.setType(ActionTypeEnum.REFRESH.getValue());
        action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST.toString());

        return ApiResponse.buildOK().setData(action);

    }

    /**
     * 合并工时-人员下线数据接口
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/mergeWorkingHour/peopleOffline", method = RequestMethod.POST)
    public ApiResponse<String> mergeWorkingHourOffline(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();

        Map<String, Object> requestParams = buildMergeWorkHourRequest(apiRequestSubmit, "wo_op_report_info", false, true);

        Action<Map<String, Object>> action = new Action<>();
        Map<String, Object> response = this.digiwinAtdmProxyService.peopleOffline(locale, iamUserToken, requestParams, tenantId);
        // 1.时间重叠;2.时间重叠;3.已上线未下线;4.自动下线询问
        String errorType = (String) response.get("error_type");
        String errorMsg = (String) response.get("error_msg");
        if (StringUtils.isEmpty(errorType) && StringUtils.isEmpty(errorMsg)) {
            Map<String, Object> requestRawData = apiRequestSubmit.getRawData();
            if (MapUtils.getBooleanValue(requestRawData, "isRemarkAction")) {
                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "备注下线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
                action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST.toString());
            } else {
                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "人员下线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));
                action.setType(ActionTypeEnum.REFRESH.getValue());
                action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST.toString());
            }
            return ApiResponse.buildOK().setData(action);
        }
        List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) response.get("wo_op_report_info");
        String toastMsg = LocaleUtil.getMobileTextByKey(locale, "人员下线")
                + LocaleUtil.getMobileTextByKey(locale, "失败");

        // 结构体返回与工时回报一致，展示与其一致
        action = buildMergeWorkHourAction(woOpReportData, errorType, errorMsg, toastMsg, locale);
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 人员状况-人员取消上线数据接口
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/personelState/cancelOnline", method = RequestMethod.POST)
    public ApiResponse<String> personelStateCancelOnline(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        Map<String, Object> requestRawData = apiRequestSubmit.getRawData();

        // true：合并工时，false：工时支援/合并工时
        boolean isMerge = BooleanUtils.isTrue((Boolean) MapUtil.getOrDefault(requestRawData, "isMerge", false));
        List<Map<String, Object>> woOpReportWorkHoursList = JsonUtil.objectToJavaObject(requestRawData.get("woOpReportInfoList"), new TypeReference<List<Map<String, Object>>>() {
        });
        if (CollectionUtils.isEmpty(woOpReportWorkHoursList)) {
            return ApiResponse.buildOK();
        }

        Action<Map<String, Object>> action = new Action<>();
        if (isMerge) {
            List<Map<String, Object>> selectCardList = new ArrayList<>();
            woOpReportWorkHoursList.forEach(woOpReportWorkHours -> {
                Map<String, Object> rawDataMap = new HashMap<>();
                rawDataMap.put("dataDetail", woOpReportWorkHours);

                Map<String, Object> selectCardMap = new HashMap<>();
                selectCardMap.put("rawData", rawDataMap);
                selectCardList.add(selectCardMap);
            });
            apiRequestSubmit.getRawData().put("selectCardList", selectCardList);
            Map<String, Object> requestParams = this.buildMergeWorkHourRequest(apiRequestSubmit, "wo_op_report_data", false, false);
            boolean hasCancelOnline = digiwinAtdmProxyService.cancelOnline(locale, iamUserToken, requestParams, tenantId);
            StringBuilder toastMsg = new StringBuilder();
            toastMsg.append(this.localeService.getLanguageValue(locale, "取消上线"));
            if (hasCancelOnline) {
                toastMsg.append(this.localeService.getLanguageValue(locale, "成功"));
            } else {
                toastMsg.append(this.localeService.getLanguageValue(locale, "失败"));
            }
            action.setToastMsg(toastMsg.toString());
        } else {
            woOpReportWorkHoursList.forEach(woOpReportWorkHours -> {
                woOpReportWorkHours.put("is_check_in", true);

                // 工时支援需要增加这两个参数
                if ("7".equals(woOpReportWorkHours.get("source_operation"))) {
                    woOpReportWorkHours.put("is_merge_report", true);
                    woOpReportWorkHours.put("whether_support", true);
                }
            });

            Map<String, Object> requestParams = new HashMap<>();
            requestParams.put("wo_op_report_data", woOpReportWorkHoursList);
            apiRequestSubmit.getRawData().put("parameter", requestParams);
            boolean hasCancelOnline = digiwinAtdmProxyService.cancelOnline(locale, iamUserToken, apiRequestSubmit.getRawData(), tenantId);
            StringBuilder toastMsg = new StringBuilder();
            toastMsg.append(this.localeService.getLanguageValue(locale, "取消上线"));
            if (hasCancelOnline) {
                toastMsg.append(this.localeService.getLanguageValue(locale, "成功"));
            } else {
                toastMsg.append(this.localeService.getLanguageValue(locale, "失败"));
            }
            action.setToastMsg(toastMsg.toString());
        }
        action.setType(ActionTypeEnum.REFRESH.getValue());
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 人员状况-人员下线数据接口
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/personelState/peopleOffline", method = RequestMethod.POST)
    public ApiResponse<Action<Map<String, Object>>> personelStateOffline(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();
        Map<String, Object> requestRawData = apiRequestSubmit.getRawData();

        // true：合并工时，false：工时支援/合并工时
        boolean isMerge = BooleanUtils.isTrue((Boolean) MapUtil.getOrDefault(requestRawData, "isMerge", false));
        List<Map<String, Object>> woOpReportWorkHoursList = JsonUtil.objectToJavaObject(requestRawData.get("woOpReportInfoList"), new TypeReference<List<Map<String, Object>>>() {
        });
        if (CollectionUtils.isEmpty(woOpReportWorkHoursList)) {
            return ApiResponse.buildOK();
        }

        Action<Map<String, Object>> action = new Action<>();
        if (isMerge) {
            List<Map<String, Object>> selectCardList = new ArrayList<>();
            woOpReportWorkHoursList.forEach(woOpReportWorkHours -> {
                Map<String, Object> rawDataMap = new HashMap<>();
                rawDataMap.put("dataDetail", woOpReportWorkHours);

                Map<String, Object> selectCardMap = new HashMap<>();
                selectCardMap.put("rawData", rawDataMap);
                selectCardList.add(selectCardMap);
            });
            apiRequestSubmit.getRawData().put("selectCardList", selectCardList);
            Map<String, Object> requestParams = buildMergeWorkHourRequest(apiRequestSubmit, "wo_op_report_info", false, true);
            Map<String, Object> response = this.digiwinAtdmProxyService.peopleOffline(locale, iamUserToken, requestParams, tenantId);
            // 1.时间重叠;2.时间重叠;3.已上线未下线;4.自动下线询问
            String errorType = (String) response.get("error_type");
            String errorMsg = (String) response.get("error_msg");
            if (StringUtils.isEmpty(errorType) && StringUtils.isEmpty(errorMsg)) {
                action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "人员下线")
                        + LocaleUtil.getMobileTextByKey(locale, "成功"));
                action.setType(ActionTypeEnum.REFRESH.getValue());
                return ApiResponse.buildOK().setData(action);
            }
            List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) response.get("wo_op_report_info");
            String toastMsg = LocaleUtil.getMobileTextByKey(locale, "人员下线")
                    + LocaleUtil.getMobileTextByKey(locale, "失败");

            // 结构体返回与工时回报一致，展示与其一致
            action = buildMergeWorkHourAction(woOpReportData, errorType, errorMsg, toastMsg, locale);
        } else {
            woOpReportWorkHoursList.forEach(woOpReportWorkHours -> {
                woOpReportWorkHours.put("is_check_in", true);
                // 工时支援需要增加这两个参数
                if ("7".equals(woOpReportWorkHours.get("source_operation"))) {
                    woOpReportWorkHours.put("is_merge_report", true);
                    woOpReportWorkHours.put("whether_support", true);
                }
                Map<String, Object> woOpReportWorkHoursDetailItem = JsonUtil.objectToJavaObject(woOpReportWorkHours, new TypeReference<Map<String, Object>>() {
                });
                woOpReportWorkHours.put("wo_op_report_work_hours_detail", Collections.singletonList(woOpReportWorkHoursDetailItem));

                woOpReportWorkHours.put("isEnter", false);
                woOpReportWorkHours.put("isWorkHourOffline", true);
                woOpReportWorkHours.put("isWorkHourToAbnormalTask", false);
                woOpReportWorkHours.put("process_category", "2");
            });

            Map<String, Object> parameterMap = new HashMap<>();
            parameterMap.put("wo_op_report_info", woOpReportWorkHoursList);
            apiRequestSubmit.getRawData().put("parameter", parameterMap);
            Map<String, Object> requestParams = this.buildRequestParams(apiRequestSubmit, "wo_op_report_info", false);
            Map<String, Object> response = digiwinAtdmProxyService.peopleOffline(locale, iamUserToken, requestParams, tenantId);

            // 1.除外回报时间重叠;2.工时回报时间重叠;3.已上线未下线;4.自动下线询问
            String errorType = (String) response.get("error_type");
            String errorMsg = (String) response.get("error_msg");
            if (StringUtils.isEmpty(errorType)) {
                if (StringUtils.isEmpty(errorMsg)) {
                    action.setToastMsg(LocaleUtil.getMobileTextByKey(locale, "人员下线")
                            + LocaleUtil.getMobileTextByKey(locale, "成功"));
                    action.setType(ActionTypeEnum.REFRESH.getValue());
                    return ApiResponse.buildOK().setData(action);
                } else {
                    action = new Action<>();
                    action.setConfirmPop(ConfirmPop.create(errorMsg, true));
                    action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
                    return ApiResponse.buildOK().setData(action);
                }
            }
            List<Map<String, Object>> woOpReportData = (List<Map<String, Object>>) response.get("wo_op_report_info");
            handleWorkHourAction(woOpReportData, action, errorType, errorMsg, locale);
        }
        return ApiResponse.buildOK().setData(action);
    }

    private void handleWorkHourAction(List<Map<String, Object>> woOpReportData, Action<Map<String, Object>> action, String errorType, String errorMsg, String locale) {
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BOTTOM_WINDOW_INFO.toString());
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "提交失败，请排除以下状况"));
        Map<String, Object> rawData = new HashMap<>(3);
        action.setRawData(rawData);
        rawData.put("message", errorMsg);
        switch (errorType) {
            case "1":
                // 1.除外回报时间重叠
                rawData.put("type", BottomWindowInfoTypeEnum.EXCEPT_WORK_HOURS_OVERLAP_DATA.name());
                rawData.put(BottomWindowInfoTypeEnum.EXCEPT_WORK_HOURS_OVERLAP_DATA.name(), woOpReportData.get(0).get("except_report_data"));
                break;
            case "2":
                // 2.工时回报时间重叠
                rawData.put("type", BottomWindowInfoTypeEnum.WORK_HOURS_OVERLAP_DATA.name());
                rawData.put(BottomWindowInfoTypeEnum.WORK_HOURS_OVERLAP_DATA.name(), woOpReportData.get(0).get("work_hours_overlap_data"));
                break;
            case "3":
                // 3.已上线未下线
                rawData.put("type", BottomWindowInfoTypeEnum.CHECK_IN_NOT_CHECK_OUT_DATA.name());
                rawData.put(BottomWindowInfoTypeEnum.CHECK_IN_NOT_CHECK_OUT_DATA.name(), woOpReportData.get(0).get("work_hours_overlap_data"));
                break;
            case "4":
                // 4.选择的制令制程存在合并工时任务时，请在合并工时任务里执行本功能
                action = new Action<>();
                action.setConfirmPop(ConfirmPop.create(errorMsg, true));
                action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
                break;
            default:
                break;
        }
    }

    /**
     * 提交失败错误提示弹框Action
     *
     * @param woOpReportData
     * @param errorType
     * @param errorMsg
     * @param locale
     * @return
     */
    private Action buildMergeWorkHourAction(List<Map<String, Object>> woOpReportData, String errorType, String errorMsg, String toastMsg, String locale) {
        Action<Map<String, Object>> action = new Action<>();
        if (StringUtils.isEmpty(errorType) && StringUtils.isNotEmpty(errorMsg)) {
            action = new Action<>();
            action.setConfirmPop(ConfirmPop.create(errorMsg, true));
            action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
            return action;
        }
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_BOTTOM_WINDOW_INFO.toString());
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "提交失败，请排除以下状况"));
        action.setToastMsg(toastMsg);
        Map<String, Object> rawData = new HashMap<>(3);
        action.setRawData(rawData);
        rawData.put("message", errorMsg);
        switch (errorType) {
            case "1":
                // 1.除外回报时间重叠
                rawData.put("type", BottomWindowInfoTypeEnum.EXCEPT_WORK_HOURS_OVERLAP_DATA.name());
                rawData.put(BottomWindowInfoTypeEnum.EXCEPT_WORK_HOURS_OVERLAP_DATA.name(), woOpReportData.get(0).get("except_report_data"));
                break;
            case "2":
                // 2.工时回报时间重叠
                rawData.put("type", BottomWindowInfoTypeEnum.WORK_HOURS_OVERLAP_DATA.name());
                rawData.put(BottomWindowInfoTypeEnum.WORK_HOURS_OVERLAP_DATA.name(), woOpReportData.get(0).get("work_hours_overlap_data"));
                break;
            case "3":
                // 3.已上线未下线
                rawData.put("type", BottomWindowInfoTypeEnum.CHECK_IN_NOT_CHECK_OUT_DATA.name());
                rawData.put(BottomWindowInfoTypeEnum.CHECK_IN_NOT_CHECK_OUT_DATA.name(), woOpReportData.get(0).get("work_hours_overlap_data"));
                break;
            default:
                break;
        }
        return action;
    }


    private Map<String, Object> buildMergeWorkHourRequest(ApiRequestSubmit apiRequestSubmit, String keyName, boolean isOnline, boolean isBuildDetail) {
        Map<String, Object> requestParams = new HashMap<>();
        Map<String, Object> requestRawData = apiRequestSubmit.getRawData();

        requestParams.put("actionId", requestRawData.get("actionId"));
        requestParams.put("businessUnit", requestRawData.get("businessUnit"));
        requestParams.put("executeContext", requestRawData.get("executeContext"));

        // 获取工时回报 机制参数值
        String limitSameTimeReport =
                this.getMechanismParamValue(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                        apiRequestSubmit.getLocale(), KnowledgeMapsConstant.APC_LIMIT_SAME_TIME_REPORT);
        String exceptReportSystemCorrect =
                this.getMechanismParamValue(apiRequestSubmit.getIamUserToken(), apiRequestSubmit.getTenantId(),
                        apiRequestSubmit.getLocale(), KnowledgeMapsConstant.APC_EXCEPT_REPORT_SYSTEM_CORRECT);

        List<Map<String, Object>> requestDataList = new ArrayList<>();
        List<Map<String, Object>> selectCardList = (List<Map<String, Object>>) requestRawData.get("selectCardList");
        if (!CollectionUtils.isEmpty(selectCardList)) {
            for (Map<String, Object> selectCard : selectCardList) {
                Map<String, Object> selectCardRawData = (Map<String, Object>) selectCard.get("rawData");
                Map<String, Object> dataDetail = (Map<String, Object>) selectCardRawData.get("dataDetail");

                // 备注字段更新
                handleDataDetail(apiRequestSubmit.getSubmitParams(), dataDetail);

                dataDetail.put("except_work_hours_system_auto_correct", exceptReportSystemCorrect);
                dataDetail.put("limit_same_time_report_work_hours", limitSameTimeReport);
                if (isOnline) {
                    //1.手动工时回报;2.侦测自动下线;3.手动除外回报;4.手动工时创建;5.手动补登回报;6.手动工时调整;7.工时支援;8.合并工时
                    dataDetail.put("source_operation", "8");
                    dataDetail.put("check_in_datetime", DateTimeUtil.getTodayTimeUseDefaultPattern());
                } else {
                    dataDetail.put("is_merge_report", true);
                    if (isBuildDetail) {
                        List<Map<String, Object>> woOpReportWorkHoursDetailList = new ArrayList<>();
                        Map<String, Object> woOpReportWorkHoursDetail = new HashMap<>(1);
                        woOpReportWorkHoursDetail.put("sub_op_seq", dataDetail.get("sub_op_seq"));
                        woOpReportWorkHoursDetail.put("sub_op_no", dataDetail.get("sub_op_no"));
                        woOpReportWorkHoursDetail.put("sub_op_name", dataDetail.get("sub_op_name"));
                        woOpReportWorkHoursDetail.put("reporter_no", dataDetail.get("reporter_no"));
                        woOpReportWorkHoursDetail.put("reporter_name", dataDetail.get("reporter_name"));
                        woOpReportWorkHoursDetail.put("labor_hours", dataDetail.get("labor_hours"));
                        woOpReportWorkHoursDetail.put("average_labor_hours", dataDetail.get("average_labor_hours"));
                        woOpReportWorkHoursDetail.put("accumulative_average_labor_hours", dataDetail.get("accumulative_average_labor_hours"));
                        woOpReportWorkHoursDetail.put("check_in_datetime", dataDetail.get("check_in_datetime"));
                        woOpReportWorkHoursDetail.put("source_operation", "8");
                        // 下线，备注信息还需要放在wo_op_report_work_hours_detail里，否则备注更新不成功
                        woOpReportWorkHoursDetail.put("remark", dataDetail.get("remark"));
                        woOpReportWorkHoursDetailList.add(woOpReportWorkHoursDetail);
                        dataDetail.put("wo_op_report_work_hours_detail", woOpReportWorkHoursDetailList);
                    } else {
                        // 取消remark置空
                        dataDetail.put("remark", "");
                    }
                    dataDetail.put("process_category", "2");
                }
                requestDataList.add(dataDetail);
            }
        }

        Map<String, Object> parameter = new HashMap<>();
        parameter.put(keyName, requestDataList);
        requestParams.put("parameter", parameter);
        return requestParams;
    }

    public void handleDataDetail(List<ActionSubmitParam> submitParam, Map<String, Object> dataDetail) {
        if (CollectionUtils.isEmpty(submitParam)) {
            return;
        }

        for (ActionSubmitParam actionSubmitParam : submitParam) {
            switch (actionSubmitParam.getType()) {
                case InputMultiText.COMPONENT_TYPE:
                    // 备注
                    InputMultiText inputMultiText = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), InputMultiText.class);
                    dataDetail.put(actionSubmitParam.getSchema(), inputMultiText.getText());
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 校验运单是否已到达
     */
    @RequestMapping(value = "/transport/msg/close", method = RequestMethod.POST)
    public ApiResponse<Address> closeTransportMsg(HttpServletRequest request) throws IOException {
        Map<String, Object> apiRequest = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) apiRequest.get("iamUserToken");
        String locale = (String) apiRequest.get("locale");
        String tenantId = (String) apiRequest.get("tenantId");
        Map<String, Object> buttonRawData = (Map<String, Object>) apiRequest.get("rawData");
        String transport_no = StrUtil.toString(buttonRawData.get("transport_no"));
        Map<String, Object> params = new HashMap<>();
        params.put("transport_no", transport_no);
        params.put("msg_type", "1");
        DigiwinEspStdData digiwinEspStdData = digiwinEspProxyService.commitDriverMsg(iamUserToken,
                tenantId, locale, params, null);
        if (!"0".equals(digiwinEspStdData.getExecution().getCode())) {
            return ApiResponse.buildError("transport.driver.msg.process 返回 code " + digiwinEspStdData.getExecution().getCode() + ":" + digiwinEspStdData.getExecution().getDescription());
        }
        return ApiResponse.buildOK();
    }

    @RequestMapping(value = "/get/breadCrumb/data", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> getBreadCrumbNodeData(@RequestBody ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        Map<String, Object> rawData = apiRequest.getRawData();
        BreadCrumb parentBreadCrumb = null;
        Boolean hasButton = true;
        Boolean isRecipe = (Boolean) rawData.get("is_recipe");
        Boolean isSubmit = false;
        if (rawData.get("isSubmit") != null) {
            isSubmit = (Boolean) rawData.get("isSubmit");
        }
        int processNo = 0;
        String reportNo = (String) rawData.get("report_no");
        if (rawData.get("hasButton") != null) {
            hasButton = (Boolean) rawData.get("hasButton");
        }
        if (!org.springframework.util.StringUtils.hasLength(reportNo) && hasButton) {
            return ApiResponse.buildOK().setData(UiBotModel.emptyUibotModel(locale));
        }
        if (rawData.get("nodeNo") != null) {
            processNo = (int) rawData.get("nodeNo");
        }
        int crumbLength = 1;
        if (rawData.get("crumbLength") != null) {
            crumbLength = (int) rawData.get("crumbLength");
        } else {
            if (apiRequest.getCrumbLength() != null) {
                crumbLength = apiRequest.getCrumbLength();
            }
        }
        String breadName = (String) rawData.get("breadName");
        Map<String, Object> newParameter = (Map<String, Object>) rawData.get("newParameter");
        Map<String, Object> executeContext = (Map<String, Object>) rawData.get("executeContext");
        Map<String, Object> businessUnit = new HashMap<>();
        if (!CollectionUtils.isEmpty(executeContext)) {
            businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        }
        if (crumbLength > 0 && rawData.get("currentCrumb") != null) {
            parentBreadCrumb =
                    JsonUtil.objectToJavaObject(rawData.get("currentCrumb"), BreadCrumb.class);
            Map<String, Object> parentRawData;
            String title;
            if (parentBreadCrumb.getData().size() < crumbLength) {
                parentRawData = parentBreadCrumb.getData().get(parentBreadCrumb.getData().size() - 1).getRawData();
                title = parentBreadCrumb.getData().get(parentBreadCrumb.getData().size() - 1).getTitle();
            } else {
                parentRawData = parentBreadCrumb.getData().get(crumbLength - 1).getRawData();
                title = parentBreadCrumb.getData().get(crumbLength - 1).getTitle();
            }
            if (parentRawData.get("breadName") == null && parentRawData.get("currentCrumb") != null) {
                parentBreadCrumb =
                        JsonUtil.objectToJavaObject(parentRawData.get("currentCrumb"), BreadCrumb.class);
                parentRawData = parentBreadCrumb.getData().get(crumbLength - 1).getRawData();
            }
            if (rawData.get("is_recipe") == null && parentRawData.get("is_recipe") != null) {
                isRecipe = (Boolean) parentRawData.get("is_recipe");
            }
            if (isSubmit && org.springframework.util.StringUtils.hasLength(title)) {
                breadName = title;
            }
            if (rawData.get("newParameter") == null) {
                newParameter = (Map<String, Object>) parentRawData.get("newParameter");
                if (rawData.get("currentNewParameter_" + crumbLength) != null) {
                    newParameter = (Map<String, Object>) rawData.get("currentNewParameter_" + crumbLength);
                } else {
                    Map<String, Object> findNew = parentBreadCrumb.searchCurrentNewParameter(parentBreadCrumb, crumbLength, newParameter);
                    if (!CollectionUtils.isEmpty(findNew)) {
                        newParameter = findNew;
                    }
                }

            }
            for (int i = crumbLength - 1; i < parentBreadCrumb.getData().size(); i++) {
                parentBreadCrumb.getData().remove(i);
            }
            if (rawData.get("executeContext") == null) {
                executeContext = (Map<String, Object>) parentRawData.get("executeContext");
            }
            businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        }
        if (isRecipe == null) {
            if (rawData.get("breadRecipt") != null) {
                isRecipe = (Boolean) rawData.get("breadRecipt");
            } else {
                if (breadName.contains(localeService.getLanguageValue(locale, "材料"))) {
                    isRecipe = false;
                } else {
                    isRecipe = true;
                }
            }
        }

        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("bm.opsc.trial.production.complete.get",
                newParameter, executeContext, businessUnit);

        List<Map<String, Object>> opDatas = digiwinAtdmProxyService.tbdsDataQueryByActionId(locale, iamUserToken,
                JsonUtil.javaObjectToJsonString(request), tenantId);
        if (CollectionUtils.isEmpty(opDatas)) {
            return ApiResponse.buildOK().setData(UiBotModel.emptyUibotModel(locale));
        } else {
            PageSetting pageSetting = pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP.toString());
            UiBotModel uiBotModel = pageSetting.getPageModel();
            List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
            UiBotPageData pageData = uiBotModel.getPageData();
            Map<String, Object> opData = opDatas.get(0);
            List<UiBotLayout> newUibotlayouts = new ArrayList<>(3);
            Map<String, Object> commonRawData = uiBotModel.getCommonRawData();
            rawData.put("pageId", apiRequest.getPageId());
            for (UiBotLayout layout : uiBotLayouts) {
                String schema = layout.getSchema();
                switch (layout.getType()) {
                    case ProcessNode.COMPONENT_TYPE:
                        if (isRecipe) {
                            newUibotlayouts.add(layout);
                            ProcessNode processNode = JsonUtil.objectToJavaObject(pageData.get(schema), ProcessNode.class);
                            pageData.put(schema, ProcessNode.create(uiBotModel, processNode, opDatas,
                                    localeService, locale, digiwinAtdmProxyService,
                                    apiRequest, hasButton, processNo, digiwinEspProxyService, reportNo));
                        }
                        break;
                    case BreadCrumb.COMPONENT_TYPE:
                        newUibotlayouts.add(layout);
                        rawData.remove("currentCrumb");
                        BreadCrumb breadCrumb = new BreadCrumb();
                        if (parentBreadCrumb != null && !CollectionUtils.isEmpty(parentBreadCrumb.getData())) {
                            breadCrumb.getData().addAll(parentBreadCrumb.getData());
                        }
                        rawData.put("is_recipe", isRecipe);
                        breadCrumb.getData().add(new BreadCrumbNode(breadName,
                                rawData, "", "/mobile/v1/proxy/get/breadCrumb/data"));
                        uiBotModel.getCommonRawData().put("currentCrumb", breadCrumb);
                        pageData.put(schema, breadCrumb);
                        break;
                    case CustomGroup.COMPONENT_TYPE:
                        if (!isRecipe) {
                            newUibotlayouts.add(layout);
                            CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                            customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_OUTSIDE_THE_TITLE_GROUP.getValue());
                            customGroup.setName(localeService.getLanguageValue(locale, customGroup.getName()));
                            List<Map<String, Object>> itemList = (List<Map<String, Object>>) opData.get(schema);
                            uiBotModel.buildCommonRawData(commonRawData, opData, uiBotModel);
                            commonRawData.put("trial_op_report_item_list", itemList);
                            customGroup.buildTbdsItemList(customGroup, locale, localeService, itemList,
                                    rawData, digiwinAtdmProxyService, apiRequest, hasButton,
                                    false, false);
                            pageData.put(schema, customGroup);
                        }
                        break;
                    default:
                        break;
                }
            }
            uiBotModel.setLayout(newUibotlayouts);
            uiBotModel.getCommonRawData().put("hasButton", hasButton);
            if (rawData.get("report_no") != null) {
                uiBotModel.getCommonRawData().put("report_no", rawData.get("report_no"));
                uiBotModel.getCommonRawData().put("executeContext", executeContext);
                uiBotModel.getCommonRawData().put("currentNewParameter_" + crumbLength, newParameter);
            }
            return ApiResponse.buildOK().setData(uiBotModel);
        }
    }

    @RequestMapping(value = "/get/project/breadCrumb/data", method = RequestMethod.POST)
    public ApiResponse<UiBotModel> getProjectBreadCrumbNodeData(@RequestBody ApiRequest apiRequest) {
        PageSetting pageSetting = pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_NEXT_LEVEL_PROJECT_LIST.toString());
        return ApiResponse.buildOK().setData(projectDetailBuildProjectNextLevelListStrategy.buildModel(pageSetting, apiRequest));
    }

    /**
     * 对账周报-通知请款和进度回报提交
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/reconciliationProgress/submit", method = RequestMethod.POST)
    public ApiResponse<String> reconciliationProgressSubmit(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        String locale = apiRequestSubmit.getLocale();
        String iamUserToken = apiRequestSubmit.getIamUserToken();
        String tenantId = apiRequestSubmit.getTenantId();

        Map<String, Object> requestRawData = apiRequestSubmit.getRawData();
        Map<String, Object> requestParam = builAacrAppArProgressdParam(apiRequestSubmit, locale);
        List<Map<String, Object>> arProgressInfoList = digiwinEspProxyService.createAacrAppArProgress(iamUserToken, tenantId, locale, requestParam);
        Action action = new Action<>();
        action.setRefreshDataId(String.valueOf(requestRawData.get("refreshDataId")));
        if (CollectionUtils.isEmpty(arProgressInfoList)) {
            action.setToastMsg(localeService.getLanguageValue(locale, "提交成功"));
            action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
        } else {
            Optional errorMsgOpt = Optional.ofNullable(arProgressInfoList.get(0)).map(e -> e.get("error_msg"));
            if (!errorMsgOpt.isPresent() || StringUtils.isEmpty((String) errorMsgOpt.get())) {
                action.setToastMsg(localeService.getLanguageValue(locale, "提交成功"));
                action.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
                action.setRefreshPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL.toString());
            } else {
                action = new Action<>();
                action.setConfirmPop(ConfirmPop.create((String) errorMsgOpt.get(), true));
                action.setType(ActionTypeEnum.SHOW_CONFIRM_POP.getValue());
            }
        }
        return ApiResponse.buildOK().setData(action);
    }

    /**
     * 对账周报-通知请款和进度回报提交请求参数构建
     *
     * @param apiRequestSubmit
     * @param locale
     * @return
     */
    private Map<String, Object> builAacrAppArProgressdParam(ApiRequestSubmit apiRequestSubmit, String locale) {
        Map<String, Object> requestRawData = apiRequestSubmit.getRawData();
        Map<String, Object> arData = (Map<String, Object>) requestRawData.get("ar_data");
        Map<String, Object> requestParams = new HashMap<>();
        requestParams.put("ar_no", arData.get("ar_no"));
        String buttonType = (String) requestRawData.get("buttonType");
        List<ActionSubmitParam> submitParamList = apiRequestSubmit.getSubmitParams();
        if ("noticePay".equals(buttonType)) {
            handleNoticePay(locale, submitParamList, requestParams);
        } else {
            handleProgress(submitParamList, requestParams);
            requestParams.put("process_hours", arData.get("process_hours"));
            requestParams.put("local_curr_price", arData.get("local_curr_price"));
        }
        requestParams.put("doc_type", arData.get("doc_type"));
        requestParams.put("report_date", DateTimeUtil.getTodayTimeUseDefaultPattern());
        requestParams.put("progress_reporter_no", apiRequestSubmit.getUserId());
        MPersonCard personCard = digiwhaleProxyServie.getPersonByUserId("userId=" + apiRequestSubmit.getUserId());
        if (!Objects.isNull(personCard)) {
            requestParams.put("progress_reporter_name", personCard.getpName());
        }
        requestParams.put("update_source", "7");
        requestParams.put("eoc_company_id", arData.get("eoc_company_id"));
        requestParams.put("accepted_date", getDate(arData.get("accepted_date")));
        requestParams.put("ar_date", getDate(arData.get("ar_date")));
        requestParams.put("plan_complete_set_date", getDate(arData.get("plan_complete_set_date")));
        requestParams.put("reply_date", getDate(arData.get("reply_date")));
        requestParams.put("receivable_date", getDate(arData.get("receivable_date")));

        Map<String, Object> requestMap = new HashMap<>();
        JSONArray array = new JSONArray();
        array.add(requestParams);
        requestMap.put("ar_progress", array);
        return requestMap;
    }

    /**
     * 账务小精灵：
     * 处理进度回报提交参数
     *
     * @param submitParamList
     * @param requestParams
     * @author yanfeng
     */
    private static void handleProgress(List<ActionSubmitParam> submitParamList, Map<String, Object> requestParams) {
        if (!CollectionUtils.isEmpty(submitParamList)) {
            Map<String, Object> paramMap = null;
            for (ActionSubmitParam actionSubmitParam : submitParamList) {
                if (actionSubmitParam.getSchema().equals("handle_desc")) {
                    paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                    if (!Objects.isNull(paramMap.get("text")) && StringUtils.isNotEmpty((String) paramMap.get("text"))) {
                        requestParams.put("reason_code_name", paramMap.get("text"));
                    }
                }
                if (actionSubmitParam.getSchema().equals("internal_instructions")) {
                    paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                    if (!Objects.isNull(paramMap.get("text")) || StringUtils.isNotEmpty((String) paramMap.get("text"))) {
                        requestParams.put("reason_info", paramMap.get("text"));
                    }
                }
                if (actionSubmitParam.getSchema().equals("expected_account_date")) {
                    InputCalendar inputCalendar = (InputCalendar) actionSubmitParam.getParams();
                    String reportDate = inputCalendar.getInputText();
                    if (StringUtils.isNotEmpty(reportDate)) {
                        reportDate = reportDate.replace(".", "-");
                    }
                    requestParams.put("plan_close_date", reportDate);
                }
                if (actionSubmitParam.getSchema().equals("reason_code")) {
                    paramMap = JsonUtil.objectToJavaObject(actionSubmitParam.getParams(), Map.class);
                    requestParams.put("reason_code", paramMap.get("title"));
                }
            }
        }
    }

    /**
     * 账务小精灵：
     * 处理通知請款提交入参
     *
     * @param locale
     * @param submitParamList
     * @param requestParams
     * @author yanfeng
     */
    private void handleNoticePay(String locale, List<ActionSubmitParam> submitParamList, Map<String, Object> requestParams) {
        for (ActionSubmitParam actionSubmitParam : submitParamList) {
            String schema = actionSubmitParam.getSchema();
            Object paramObj = actionSubmitParam.getParams();
            switch (actionSubmitParam.getType()) {
                case InputNumeric.COMPONENT_TYPE:
                    InputNumeric inputNumeric = (InputNumeric) paramObj;
                    if ("process_hours".equalsIgnoreCase(schema)) {
                        requestParams.put("process_hours", inputNumeric.getText());
                    } else if ("local_curr_price".equalsIgnoreCase(schema)) {
                        requestParams.put("local_curr_price", inputNumeric.getText());
                    }
                    break;
                case InputSingleText.COMPONENT_TYPE:
                    InputSingleText inputSingleText = (InputSingleText) paramObj;
                    requestParams.put("customer_name", inputSingleText.getText());
                    break;
                case InputMultiText.COMPONENT_TYPE:
                    InputMultiText inputMultiText = (InputMultiText) paramObj;
                    requestParams.put("remark", inputMultiText.getText());
                    break;
            }

        }
        requestParams.put("reason_code", localeService.getLanguageValue(locale, "D01-本月可开立发票"));
        requestParams.put("plan_close_date", DateTimeUtil.getTodayUseDefaultPattern());
        requestParams.put("reason_code_name", localeService.getLanguageValue(locale, "业务确认本月开立发票"));
        requestParams.put("reason_info", localeService.getLanguageValue(locale, "业务确认本月开立发票"));
    }

    private String getDate(Object dateStr) {
        String date = DateTimeUtil.getTodayUseDefaultPattern();
        if (Objects.isNull(dateStr) || StringUtils.isEmpty((String) dateStr)) {
            return date;
        }
        return (String) dateStr;
    }

    @RequestMapping(value = "/build/fcmToken", method = RequestMethod.POST)
    public ApiResponse buildFcmToken(@RequestBody FcmMobileUserVo fcmMobileUser) {
        return ApiResponse.buildOK().setData(fcmService.addFcmMobileUser(fcmMobileUser));
    }

    /**
     * 测试直流交换机消息
     *
     * @return
     */
    @GetMapping("/sendDirectMessage")
    public void sendDirectFireBaseMessage(HttpServletRequest request) {
        try {
            String rawRequestData = RequestParameterUtil.getPostData(request, false, "UTF-8");
            log.debug("sendDirectFireBaseMessage接收到的http body数据是.. .{}", rawRequestData);
            Map<String, Object> map = JsonUtil.jsonStringToObject(rawRequestData, new TypeReference<Map<String, Object>>() {
            });
            if (!AppEnvDeployAreaEnum.CN.name().equalsIgnoreCase(config.getEnvDeployArea())) {
                digiwhaleProxyServie.pushDigiwinMessage(String.valueOf(map.get("access_token")), map);
            } else {
                Map<String, Object> rootMap = JsonUtil.objectToJavaObject(map.get("std_data"), new TypeReference<Map<String, Object>>() {
                });
                Map<String, Object> requestMap = JsonUtil.objectToJavaObject(rootMap.get("parameter"), new TypeReference<Map<String, Object>>() {
                });
                Notification notification = ConvertDataUtils.ConvertDataUtil(requestMap);
                List<String> fcmUserTokenList = null;
                if (org.apache.commons.lang3.StringUtils.isNotBlank(notification.getUserId())) {
                    fcmUserTokenList = fcmService.getFcmUserTokenList(Collections.singletonList(notification.getUserId()), notification.getTenantId());
                }
                if (!CollectionUtils.isEmpty(notification.getUserIds())) {
                    fcmUserTokenList = fcmService.getFcmUserTokenList(notification.getUserIds(), notification.getTenantId());
                }
                notification.setFireBaseTokenList(fcmUserTokenList);
                pushService.sendMobileDirectMessage(notification);
            }
        } catch (IOException e) {
            log.error("sendDirectFireBaseMessage error:{}", e.getMessage(), e);
        }
    }

    @GetMapping("/sendTopicMessage")
    public String sendTopicMessage() {
        String messageData = "test topic message, hello!";
        pushService.sendTopicMessage(messageData);
        return "ok";
    }

    @GetMapping("/sendFanoutMessage")
    public String sendFanoutMessage() {
        String messageData = "test fanout message, hello!";
        pushService.sendFanoutMessage(messageData);
        return "ok";
    }

    @PostMapping("/getGptAi")
    public ApiResponse<GptAiResultDTO> getGptAi(@RequestBody ApiRequest apiRequest) {

        GptAiResultDTO gptAiResultDTO = new GptAiResultDTO();

        // 判断是否台湾还是大陆 区  true是台湾区，false大陆区
        Boolean isTw = AppContext.checkEnvDeployAreaTwProd();
        String iamUserToken = apiRequest.getIamUserToken();
        // 通过CAC查询商品购买情况
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        if (ObjectUtils.isEmpty(analyzedToken)) {
            return ApiResponse.buildOK("暂无数据");
        }
        List<DigiwinCacCurrentUserApp> applicationAuthorityList = this.digiwinCacProxyService.findAuthorizationsCurrentUserApp(apiRequest.getUserId(),
                iamUserToken);
        if (CollectionUtils.isEmpty(applicationAuthorityList)) {
            gptAiResultDTO.setType(GptAiTypeEnum.OTHER.name());
            gptAiResultDTO.setGptAiModelList(new ArrayList<>());
            return ApiResponse.buildOK().setData(gptAiResultDTO);
        }
        List<GptAiModel> gptAiList = gptAiService.findAll(apiRequest.getLocale());

        Iterator<DigiwinCacCurrentUserApp> iterator = applicationAuthorityList.iterator();
        while (iterator.hasNext()) {
            DigiwinCacCurrentUserApp item = iterator.next();
            gptAiList.forEach(gptAiModel -> {
                if (item.getId().equals(gptAiModel.getCode()) && DateTimeUtil.isAfterNowDatetime(item.getExpiredTime())) {
                    gptAiModel.setSwitchShow(true);
                    gptAiModel.setSwitchClick(true);
                    gptAiModel.setSwitchBuy(true);
                    gptAiModel.setSwitchOpen(true);
                    gptAiModel.setToastMessage(null);
                    iterator.remove();
                }
            });
        }
        gptAiResultDTO.setGptAiModelList(gptAiList);
        //如有其他应用权限，返回其他类型，展示首页
        if (!CollectionUtils.isEmpty(applicationAuthorityList)) {
            //只有一条时过滤掉默认应用：Athena
            if (applicationAuthorityList.size() == 1
                    && applicationAuthorityList.stream().anyMatch(item -> "Athena".equalsIgnoreCase(item.getId()))) {
                handleAssistantAuthority(gptAiList, gptAiResultDTO);
                return ApiResponse.buildOK().setData(gptAiResultDTO);
            }

            gptAiResultDTO.setType(GptAiTypeEnum.OTHER.name());
            return ApiResponse.buildOK().setData(gptAiResultDTO);
        }
        handleAssistantAuthority(gptAiList, gptAiResultDTO);

        return ApiResponse.buildOK().setData(gptAiResultDTO);
    }

    private static void handleAssistantAuthority(List<GptAiModel> gptAiList, GptAiResultDTO gptAiResultDTO) {
        List<GptAiModel> collect = gptAiList.stream().filter(gptAiModel -> BooleanUtils.isTrue(gptAiModel.getSwitchBuy())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            gptAiResultDTO.setType(GptAiTypeEnum.OTHER.name());
        }
        if (collect.size() > 1) {
            gptAiResultDTO.setType(GptAiTypeEnum.MULTIPLE_ASSISTANTS.name());
        }
        if (collect.size() == 1) {
            gptAiResultDTO.setType(GptAiTypeEnum.ONLY_ASSISTANT.name());
        }
    }

    @PostMapping("/insertOrUpdateGptAi")
    public ApiResponse<GptAiModel> insertOrUpdateGptAi(@RequestBody GptAiModel aiModel) {
        return ApiResponse.buildOK().setData(gptAiService.insertOrUpdateGptAi(aiModel));
    }

    /**
     * 班组派工-用于当前制程和子制程的班组，场域，区域更新
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/apcTeamDispatcher/save", method = RequestMethod.POST)
    public ApiResponse<Action> apcTeamDispatcherSave(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        Map<String, Object> rawData = apiRequestSubmit.getRawData();
        List<ActionSubmitParam> submitParam = apiRequestSubmit.getSubmitParams().stream().filter(e -> InputWindowMultiSelect.COMPONENT_TYPE.equals(e.getType())
                || SingleSelectList.COMPONENT_TYPE.equals(e.getType())).collect(Collectors.toList());

        List<Map<String, Object>> dataList = (List<Map<String, Object>>) MapUtil.getOrDefault(rawData, "dataList", Collections.emptyList());
        Map<String, Object> data = (Map<String, Object>) MapUtil.getOrDefault(rawData, "data", Collections.emptyMap());

        List<Map<String, Object>> workingDayPlanDispatchInfoList = handleWorkingDayPlanDispatchInfoList(apiRequestSubmit);
        uiBotModelBuildApcTeamDispatchDetailStrategy.handleProcessRelationShip(apiRequestSubmit, dataList, data, workingDayPlanDispatchInfoList, true);

        Action<Map<String, Object>> action = new Action<>();
        action.setDataId(MapUtils.getString(rawData, "dataId"));

        boolean isMainProcess = MapUtils.getBooleanValue(data, "isMainProcess");
        if (isMainProcess) {
            Map<String, Object> returnRawData = new HashMap<>();
            returnRawData.put("submitParam", submitParam);
            returnRawData.put("dataIds", data.get("subProcessDataIds"));
            action.setRawData(returnRawData);
        }
        action.setType(ActionTypeEnum.BACK_AND_TRANSFER_DATA_TO_PREFIX.getValue());
        return ApiResponse.buildOK().setData(action);
    }

    private List<Map<String, Object>> handleWorkingDayPlanDispatchInfoList(ApiRequestSubmit apiRequestSubmit) {
        // 获取工单下的所有制程
        List<Map<String, Object>> workingDayPlanDispatchInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(apiRequestSubmit.getRawData(), "workingDayPlanDispatchInfoList", Collections.emptyList());

        String opNoAndOpSeq = "op_no_op_seq";
        String areaNoList = "";
        for (ActionSubmitParam actionSubmitParamItem : apiRequestSubmit.getSubmitParams()) {
            switch (actionSubmitParamItem.getType()) {
                case Field.COMPONENT_TYPE:
                    if ("op_no".equalsIgnoreCase(actionSubmitParamItem.getSchema()) || "op_seq".equalsIgnoreCase(actionSubmitParamItem.getSchema())) {
                        Field field = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), Field.class);
                        opNoAndOpSeq = opNoAndOpSeq.replace(actionSubmitParamItem.getSchema(), field.getText());
                    }
                    break;
                case InputWindowMultiSelect.COMPONENT_TYPE:
                    // 区域
                    InputWindowMultiSelect inputWindowMultiSelect = JsonUtil.objectToJavaObject(actionSubmitParamItem.getParams(), InputWindowMultiSelect.class);
                    if (ObjectUtils.isNotEmpty(inputWindowMultiSelect)) {
                        areaNoList = inputWindowMultiSelect.getSelectDetailList().stream().map(e -> {
                            Map<String, Object> selectDetailItem = (Map<String, Object>) e;
                            return MapUtils.getString(selectDetailItem, "area_no");
                        }).collect(Collectors.joining(";"));
                    }
                    break;
            }
        }

        String finalOpNoAndOpSeq = opNoAndOpSeq;
        String finalAreaNoList = areaNoList;
        workingDayPlanDispatchInfoList.forEach(e -> {
            String opNoAndOpSeqStr = MapUtils.getString(e, "op_no") + "_" + MapUtils.getString(e, "op_seq");
            if (Objects.equals(opNoAndOpSeqStr, finalOpNoAndOpSeq)) {
                e.put("area_no", finalAreaNoList);
            }
        });
        return workingDayPlanDispatchInfoList;
    }

    @RequestMapping(value = "/buildDetectionDataDetail/autoJudgmentProcess", method = RequestMethod.POST)
    public ApiResponse<String> buildDetectionDataDetailAutoJudgmentProcess(@RequestBody Map<String, Object> param) {
        List<String> inspectionResults = Collections.emptyList();
        try {
            Map<String, Object> dataMap = (Map<String, Object>) MapUtil.getOrDefault(param, "data", Collections.emptyMap());
            inspectionResults = taskDetailBuildDetectionDataDetailStrategy.autoJudgmentProcess(dataMap);
        } catch (Exception e) {
            log.error("ProxyController[buildDetectionDataDetailAutoJudgmentProcess] error: ", e);
        }
        Map<String, Object> map = new HashMap<>();
        map.put("inspection_result_list", inspectionResults);
        return ApiResponse.buildOK().setData(map);
    }

    /**
     * 按钮跳转的中转方法，一般前端保存使用
     *
     * @param apiRequestSubmit
     * @return
     */
    @RequestMapping(value = "/handleAction", method = RequestMethod.POST)
    public ApiResponse<Action> handleAction(@RequestBody ApiRequestSubmit apiRequestSubmit) {
        Map<String, Object> apiRawDataMap = apiRequestSubmit.getRawData().getInnerMap();

        // 代为报工执行人清单保存按钮点击
        if (BooleanUtils.isTrue((Boolean) MapUtil.getOrDefault(apiRawDataMap, "isReplaceReportExecutorSave", false))) {
            return ApiResponse.buildOK().setData(taskDetailBuildReplaceReportTaskDetailStrategy.handleSaveAction(apiRequestSubmit));
        }
        return ApiResponse.buildOK();
    }

    @RequestMapping("/get/report/data")
    public ApiResponse<List<BriefingExpressData>> getReportData(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> params = new HashMap<>(3);
        params.put("currentPage", apiRequest.getPageNum());
        params.put("pageSize", 10);
        if (apiRequest.getUnRead() != null) {
            params.put("isRead", !apiRequest.getUnRead());
        }
        List<DigiwinAdtReportData> reportDatas = digiwinAdtProxyService.getReportDataList(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params);
        List<BriefingExpressData> datas = new ArrayList<>(8);
        if (!CollectionUtils.isEmpty(reportDatas)) {
            for (DigiwinAdtReportData reportData : reportDatas) {
                BriefingExpressData data = new BriefingExpressData();
                data.setContent(reportData.getTitle());
                data.setAction(Action.createExpressButton(reportData));
                data.setStatus(reportData.getStatus());
                data.setUnRead(reportData.getReadCount() == 0);
                datas.add(data);
            }
        }
        Map<String, Object> data = new HashMap<>(1);
        data.put("datas", datas);
        return ApiResponse.buildOK().setData(data);
    }

    /**
     * 表格获取下钻的数据
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping("/get/drill/data")
    public ApiResponse<Table> getDrillData(HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String locale = (String) params.get("locale");
        String iamUserToken = (String) params.get("iamUserToken");
        ApiRawData rawData = (ApiRawData) params.get("rawData");
        UiBotModel uiBotModel = digiwinPcUiBotProxyService.actionShow(locale, iamUserToken,
                JsonUtil.javaObjectToJsonString(rawData));
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout layout : uiBotLayouts) {
            if (PcLayoutEnum.ATHENA_TABLE.getValue().equals(layout.getType())) {
                return ApiResponse.buildOK().setData(ModuleUtils.buildTable(layout, pageData,
                        uiBotModel.getExecuteContext(), locale, false));
            }
        }
        return ApiResponse.buildOK();
    }

    /**
     * 通知平台：用户元数据设置语言
     *
     * @param userToken
     * @param userSid
     * @param locale
     * @return
     */
    @PostMapping("/userMetadataUserLanguage")
    public ApiResponse<Void> getDrillDataDetail(@RequestParam("userToken") String userToken
            , @RequestParam("userSid") String userSid, @RequestParam("locale") String locale) {
        try {
            this.digiwinIamProxyService.userMetadataUserLanguage(userToken, userSid, locale);
            return ApiResponse.buildOK();
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
    }

    /**
     * 获取用户喜好语言别
     *
     * @param userToken
     * @param userSid
     * @param userID
     * @return
     */
    @PostMapping("/getUserMetadataUserLanguage")
    public ApiResponse<Void> getUserMetadataUserLanguage(@RequestParam("userToken") String userToken
            , @RequestParam("userSid") String userSid, @RequestParam("userID") String userID) {
        try {
            ResponseEntity<Object> responseEntity = this.digiwinIamProxyService.getUserMetadataUserLanguage(userToken, userSid, userID);
            HashMap body = (HashMap) responseEntity.getBody();
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return ApiResponse.buildOK().setData(body.get("data"));
            } else {
                return ApiResponse.buildError((String) body.get("msg"));
            }
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
    }

    /**
     * 获取iam人员信息
     *
     * @param iamUserToken
     * @return
     */
    @GetMapping("/getIamUserInfo")
    public ApiResponse<DigiwinIamAnalyzedToken> getIamUserInfo(@RequestParam("iamUserToken") String iamUserToken) {
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        return ApiResponse.buildOK().setData(analyzedToken);
    }

    /**
     * 更新三方待办任务卡已读状态
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("/updateTripartiteTodoStatus")
    public ApiResponse<DigiwinIamAnalyzedToken> updateTripartiteTodo(@RequestBody ApiRequest apiRequest) {
        Boolean read = this.semcProxyService.toRead(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), Integer.valueOf(apiRequest.getDataId()));
        return ApiResponse.buildOK().setData(read);
    }

    /**
     * 获取待办(每刻)跳转的url
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("/getTodoListUrl")
    public ApiResponse<DigiwinIamAnalyzedToken> getTodoListUrl(@RequestBody ApiRequest apiRequest) {
        String toDoMobileUrl = this.semcProxyService.getTodoListUrl(apiRequest.getIamUserToken(), Integer.valueOf(apiRequest.getDataId()));
        return ApiResponse.buildOK().setData(toDoMobileUrl);
    }

    /**
     * 获取第三方应用免登授权码
     *
     * @param
     * @return
     */
    @GetMapping("/getAuthCode")
    public ApiResponse<String> getAuthCode(@RequestParam("iamUserToken") String iamUserToken, @RequestParam("appId") String appId) {
        return ApiResponse.buildOK().setData(this.digiwinIamProxyService.getAuthCode(iamUserToken, appId));
    }

    /**
     * 前端传递参数，后端构建组件DSL
     * 案例：1、表单联动单身，获取cardList渲染后的dsl数据
     * 2、各种后端构建组件DSL
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("/getCardListDslData")
    public ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> buildComponentDsl(@RequestBody ApiRequestComponent apiRequest) {
        return renderService.buildComponentDsl(apiRequest);
    }


    /**
     * 通用方法
     * 前端传递参数，后端构建组件DSL
     * 案例：1、表单联动单身，获取cardList渲染后的dsl数据
     * 2、各种后端构建组件DSL
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("/build/component")
    public ApiResponse<BaseMobileComponentWrapper<BaseMobileComponent>> buildComponent(@RequestBody ApiRequestComponent apiRequest) {
        return renderService.buildComponentDsl(apiRequest);
    }

    /**
     * V2-列表组件数据【分页、搜索、筛选、排序】查询接口
     *
     * @param query
     * @return
     */
    @PostMapping("/component/data/query")
    public ApiResponse<ComponentDataQueryResult> componentDataQuery(@RequestBody ApiRequestComponentDataQuery query) {
        return uiBotComponentDataQueryService.componentDataQuery(query);
    }

    @GetMapping("/getPlatformApiConfig")
    public ApiResponse getPlatformApiConfig() {
        return ApiResponse.buildOK().setData(ApiConverUtils.convert(JsonUtil.objectToJavaObject(AppContext.getApiUrlSetting(), DigiwinApiUrlSetting.class)));
    }

    /**
     * 保存用户卡片过滤条件
     */
    @PostMapping("/saveUserCardListFilter")
    public ApiResponse saveUserCardListFilter(@RequestBody ApiRequest apiRequest) {
        uiBotServiceImpl.handleUserCardListFilter(apiRequest);
        return ApiResponse.buildOK();
    }

    /**
     * 记录用户失败次数及是否冻结
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("/loginFailure")
    public ApiResponse loginFailure(@RequestBody ApiRequest apiRequest) {
        JSONObject result = digiwinIamProxyService.loginFailure(apiRequest.getUserId());
        return ApiResponse.buildOK().setData(result);
    }

    /**
     * 获取校验图片
     *
     * @param apiRequest
     * @return
     */
    @PostMapping("/getImage")
    public ApiResponse getImage(@RequestBody ApiRequest apiRequest) {
        JSONObject result = digiwinIamProxyService.getImage(apiRequest.getUserId());
        return ApiResponse.buildOK().setData(result);
    }


    /**
     * 批量将消息标记为已读
     *
     * @return
     */
    @RequestMapping(value = "/batch/message/readAll", method = RequestMethod.POST)
    public ApiResponse readAll(@RequestBody ProxyMessageReadRequest readRequest) {
        try {
            return ApiResponse.buildOK().setData(digiwinAimProxyService.readAll(readRequest.getLocale(), readRequest.getIamUserToken()));
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
    }

    /**
     * 请求设备唯一标识
     */
    @RequestMapping(value = "/device/id", method = RequestMethod.GET)
    public ApiResponse getIamDeviceId(HttpServletRequest request) {
        try {
            //设备ID
            String deviceId = request.getHeader("deviceid");
            //设备类型
            String deviceType = request.getHeader("devicetype");
            return ApiResponse.buildOK().setData(digiwinIamProxyService.getIamDeviceId(deviceId, deviceType));
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
    }

    /**
     * token过期
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/analyze/token", method = RequestMethod.POST)
    public ApiResponse analyzeToekn(HttpServletRequest request) {
        String iamUserToken = request.getHeader("digi-middleware-auth-user");
        DigiwinIamAnalyzedToken analyzedToken =
                this.digiwinIamProxyService.tokenAnalyze(iamUserToken);
        return ApiResponse.buildOK().setData(analyzedToken);
    }

    /**
     * 获取eoc信息
     */
    @GetMapping(value = "/eoc/info")
    public ApiResponse<EocPerson> userLoginGetProxyUsers(@RequestParam String userId, @RequestParam String iamUserToken) throws Exception {
        EocPerson eocInfo = digiwinEocProxyService.getEocInfo(userId, iamUserToken);
        return ApiResponse.buildOK().setData(eocInfo);
    }

    /**
     * 开兄弟详情接口
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/getDetailPage", method = RequestMethod.POST)
    public ApiResponse<List<TabItemCardDetailPage>> getDetailPage(@RequestBody ApiRequest request) {
        ApiRawData rawData = request.getRawData();
        PcUiBotExecuteContext pcUiBotExecuteContext = JsonUtil.objectToJavaObject(rawData.get("executeContext"), PcUiBotExecuteContext.class);
        String mainDataSourceName = pcUiBotExecuteContext.getMainDataSourceName();
        Map<String, Map<String, Object>> pageLayoutInfo = (Map<String, Map<String, Object>>) rawData.get("pageLayoutInfo");
        Map<String, Object> pageLayoutMap;
        if (ObjectUtils.isEmpty(rawData.get("rawDetailPage"))) {
            //按钮的兄弟详情
            String jumpPageId = (String) rawData.get("jumpPageId");
            pageLayoutMap = pageLayoutInfo.get(jumpPageId);
        } else {
            //详情的兄弟详情
            Card.DesignerRawCard.DetailPage rawDetailPage = JsonUtil.objectToJavaObject(rawData.get("rawDetailPage"), Card.DesignerRawCard.DetailPage.class);
            pageLayoutMap = pageLayoutInfo.get(rawDetailPage.getPageId());
        }
        DataSource dataSource = JsonUtil.objectToJavaObject(pageLayoutMap.get("dataSource"), DataSource.class);
        List<TabItemCardDetailPage> detailPageList;
        String nodePath = (String) pageLayoutMap.get("nodePath");
        Map<String, Object> sourceData;
        if (Objects.equals(mainDataSourceName, dataSource.getActionName())) {
            sourceData = (Map<String, Object>) rawData.get("data");
        } else {
            ComponentContext cmptContext = JsonUtil.objectToJavaObject(request, ComponentContext.class);
            sourceData = uiBotMultipleDataSourceService.buildCmptMultipleDataSourceData(cmptContext, pcUiBotExecuteContext, dataSource, null);
        }
        detailPageList = buildTabItemCardDetailPageList(sourceData, rawData, pcUiBotExecuteContext, nodePath, pageLayoutInfo);
        Map<String, List<TabItemCardDetailPage>> map = new HashMap<>();
        map.put("detailPageList", detailPageList);
        return ApiResponse.buildOK().setData(map);
    }

    /**
     * 构建detaliPageList
     *
     * @param sourceData
     * @param rawData
     * @param pcUiBotExecuteContext
     * @return
     */
    private List<TabItemCardDetailPage> buildTabItemCardDetailPageList(Map<String, Object> sourceData, ApiRawData rawData, PcUiBotExecuteContext pcUiBotExecuteContext, String nodePath, Map<String, Map<String, Object>> pageLayoutInfo) {
        Object dataByPathAndSchema = UiBotDesignerRenderService.getDataByPathAndSchema(sourceData, nodePath, nodePath);
        List<TabItemCardDetailPage> detailPageList = new ArrayList<>();
        //构建detailPageList
        Card.DesignerRawCard.DetailPage rawDetailPage = JsonUtil.objectToJavaObject(rawData.get("rawDetailPage"), Card.DesignerRawCard.DetailPage.class);
        ComponentContext cmptContext = ComponentContext.createEmpty();
        cmptContext.setCommonRawDataParentType(CommonRawDataParentType.ALONE_BUTTON.getValue());
        cmptContext.setPageLayoutInfo(pageLayoutInfo);
        pcUiBotExecuteContext.setOpenDetailPage(true);
        Card.DesignerRawCard designerRawCard = new Card.DesignerRawCard();
        if (ObjectUtils.isEmpty(rawDetailPage)) {
            rawDetailPage = new Card.DesignerRawCard.DetailPage();
            rawDetailPage.setPageId((String) rawData.get("jumpPageId"));
        }
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setAllRawMap((HashMap) rawData.get("allRawMap"));
        mobilePageRawData.setRawDataType(rawData.getString("rawDataType"));
        mobilePageRawData.setExtendedFields((HashMap) rawData.get("baseEntryExtendedFields"));
        mobilePageRawData.setSourceCategory(rawData.getString("sourceCategory"));
        mobilePageRawData.setDataKeys((List) rawData.get("dataKeys"));
        mobilePageRawData.setComponentId(rawData.getString("componentId"));
        designerRawCard.setDetailPage(rawDetailPage);
        if (dataByPathAndSchema instanceof List) {
            List<Map<String, Object>> dataList = (List<Map<String, Object>>) dataByPathAndSchema;
            if (!dataList.isEmpty()) {
                for (Map<String, Object> data : dataList) {
                    TabItemCardDetailPage tabItemCardDetailPage = Card.buildDetailPage(designerRawCard, data, UUIDUtil.getUuid(), pcUiBotExecuteContext, mobilePageRawData, cmptContext);
                    detailPageList.add(tabItemCardDetailPage);
                }
            } else {
                TabItemCardDetailPage tabItemCardDetailPage = Card.buildDetailPage(designerRawCard, null, UUIDUtil.getUuid(), pcUiBotExecuteContext, mobilePageRawData, cmptContext);
                detailPageList.add(tabItemCardDetailPage);
            }
        } else {
            //构造空的兄弟组件
            TabItemCardDetailPage tabItemCardDetailPage = Card.buildDetailPage(designerRawCard, null, UUIDUtil.getUuid(), pcUiBotExecuteContext, mobilePageRawData, cmptContext);
            detailPageList.add(tabItemCardDetailPage);
        }
        return detailPageList;
    }

    /**
     * 获取阿里智能语音交互的token
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/getAliToken", method = RequestMethod.POST)
    public ApiResponse getAliAkIdAndSecret(HttpServletRequest request) throws IOException {
        try {
            AccessToken accessToken = new AccessToken(config.getAkId(),
                    config.getAkSecret());
            accessToken.apply();
            String token = accessToken.getToken();
            long expireTime = accessToken.getExpireTime();
            Map<String, Object> tokenMap = new HashMap<>();
            tokenMap.put("token", token);
            tokenMap.put("expireTime", expireTime);
            return ApiResponse.buildOK().setData(tokenMap);
        } catch (Exception e) {
            return ApiResponse.buildError().setData(e.getMessage());
        }

    }

    /**
     * 导出字段开窗接口
     *
     * @param apiRequest
     * @return
     */
    @RequestMapping(value = "/operation/getWindowField", method = RequestMethod.POST)
    public ApiResponse getWindowField(@RequestBody ApiRequestOperationExport apiRequest) {
        Map<String, Object> rawData = apiRequest.getRawData();
        String actionId = (String) rawData.get("actionId");
        String target = (String) rawData.get("target");
        List searchInfo = apiRequest.getSearchInfo();
        OperationWindowField operationWindowField = new OperationWindowField();
        if (searchInfo.size() == 0) {
            //说明是全选，需要去rawdata去拿数据
            Map data = (Map<String, Object>) rawData.get("data");
            Object o = data.get(target);
            if (o instanceof List) {
                operationWindowField.setTotalNum(((List<?>) o).size());
            }
        } else {
            operationWindowField.setTotalNum(searchInfo.size());
        }
        if (target.endsWith("_mobile")) {
            target = target.replace("_mobile", "");
        }
        Map<String, Object> executeContext = (Map<String, Object>) rawData.get("executeContext");
        List<PcUiBotMetadataField> fieldList = new ArrayList<>();
        try {
            PcUiBotApiMetadata metadata = queryActionCreateService.getMetadata(JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class), actionId);
            if (Objects.isNull(metadata)) {
                return ApiResponse.buildOK();
            }
            List<PcUiBotMetadataField> responseFields = metadata.getResponseFields();
            for (PcUiBotMetadataField pcUiBotMetadataField : responseFields) {
                if (pcUiBotMetadataField.getSubFields() != null) {
                    fieldList = pcUiBotMetadataField.getSubFields();
                    break;
                }
            }
            if (Objects.isNull(fieldList)) {
                return ApiResponse.buildOK();
            }
            Iterator<PcUiBotMetadataField> iterator = fieldList.iterator();
            while (iterator.hasNext()) {
                PcUiBotMetadataField obj = iterator.next();
                if (Objects.equals("object", obj.getDataType())) {
                    iterator.remove();
                }
            }
        } catch (Exception e) {
            return ApiResponse.buildError().setData(e.getMessage());
        }
        operationWindowField.setSelectFields(fieldList);
        return ApiResponse.buildOK().setData(operationWindowField);
    }


    /**
     * 全部导出/部分导出接口
     *
     * @param apiRequest
     * @return
     */
    @RequestMapping(value = "/operation/export", method = RequestMethod.POST)
    public ApiResponse operationExport(@RequestBody ApiRequestOperationExport apiRequest) throws InterruptedException {
        Map<String, Object> rawData = apiRequest.getRawData();
        String actionId = (String) rawData.get("actionId");
        String target = (String) rawData.get("target");
        if (target.endsWith("_mobile")) {
            target = target.replace("_mobile", "");
        }
        String code = (String) rawData.get("tmActivityId");
        String name = (String) rawData.get("tmActivityName");
        String category = (String) rawData.get("category");
        //构造导出的实体类
        OperationExport.ActionInfo actionInfo = new OperationExport.ActionInfo();
        OperationExport operationExport = new OperationExport();
        actionInfo.setActionId(actionId);
        actionInfo.setTargetField(target);
        actionInfo.setName(name);
        actionInfo.setCategory(category);
        actionInfo.setActionParas(new HashMap<>());
        actionInfo.setCode(code);
        actionInfo.setFileName(apiRequest.getFileName());
        operationExport.setActionInfo(actionInfo);
        HashMap<String, Object> fied = new HashMap<>();
        List<String> selectField = apiRequest.getSelectField();
        fied.put(target, selectField);
        actionInfo.setSelectField(fied);
        List searchInfo = apiRequest.getSearchInfo();
        List<OperationSearchCriteria> searchInfoList = new ArrayList<>();
        if (searchInfo.size() > 0) {
            //searchInfo不为空，则为全部导出，并构造查询字段
            ApiResponse windowField = getWindowField(apiRequest);
            List<PcUiBotMetadataField> dataList = ((OperationWindowField) windowField.getData()).getSelectFields();
            List<String> dataKeyList = new ArrayList();
            for (PcUiBotMetadataField data : dataList) {
                if (Objects.equals("true", data.getDataKey())) {
                    dataKeyList.add(data.getName());
                }
            }
            //构造atdm的searchInfo参数
            if (dataKeyList.size() == 1) {
                //单列主键
                for (Object search : searchInfo) {
                    Map card = (Map) search;
                    OperationSearchCriteria operationSearchCriteria = new OperationSearchCriteria();
                    operationSearchCriteria.setSearch_field(dataKeyList.get(0));
                    operationSearchCriteria.setSearch_value(getSearchInfo(card, dataKeyList.get(0)));
                    operationSearchCriteria.setSearch_operator("equal");
                    operationSearchCriteria.setLogic("OR");
                    operationSearchCriteria.setBracket(null);
                    searchInfoList.add(operationSearchCriteria);
                }
                OperationSearchCriteria operationSearchCriteria = searchInfoList.get(searchInfoList.size() - 1);
                operationSearchCriteria.setLogic(null);
            } else {
                //TODO 联合主键暂时不支持
                return ApiResponse.buildError().setData(localeService.getLanguageValue(apiRequest.getLocale(), "联合主键的数据源暂时不支持"));
            }
        }
        int i = 0;
        for (OperationSearchCriteria search : searchInfoList) {
            i++;
            search.setOrder(i);
        }
        operationExport.setSearchInfo(searchInfoList);
        //调用atdm的导出接口
        Boolean export = digiwinAtdmProxyService.operationExport(apiRequest.getIamUserToken(), apiRequest.getLocale(), operationExport);
        if (!export) {
            return ApiResponse.buildError().setData(localeService.getLanguageValue(apiRequest.getLocale(), "导出失败"));
        }
        //查询导出记录，拿最新的一笔数据
        Map<String, Integer> queryMap = new HashMap<>();
        queryMap.put("getRecordsNum", 5);
        queryMap.put("type", 0);
        List<OperationExportFile> operationExportFiles = digiwinAtdmProxyService.queryExportRecords(apiRequest.getIamUserToken(), apiRequest.getLocale(), queryMap);
        if (Objects.isNull(operationExportFiles)) {
            return ApiResponse.buildError().setData(localeService.getLanguageValue(apiRequest.getLocale(), "导出失败"));
        }
        if (operationExportFiles.isEmpty()) {
            return ApiResponse.buildError().setData(localeService.getLanguageValue(apiRequest.getLocale(), "暂无数据"));
        }
        OperationExportFile operationExportFile = operationExportFiles.get(0);
        String masterId = operationExportFile.getMasterId();
        //根据masterId调用atdm的下载接口
        Map<String, String> masterMap = new HashMap<>();
        masterMap.put("masterId", masterId);
        int maxRetries = 300;
        ByteArrayResource byteArrayResource = null;
        for (int attempt = 1; attempt <= maxRetries; attempt++) {
            byteArrayResource = digiwinAtdmProxyService.downloadExportFile(apiRequest.getIamUserToken(), apiRequest.getLocale(), masterMap);
            if (!Objects.isNull(byteArrayResource)) {
                break;
            }
            Thread.sleep(1000);
        }
        if (Objects.isNull(byteArrayResource)) {
            return ApiResponse.buildError().setData(localeService.getLanguageValue(apiRequest.getLocale(), "当前下载文件不存在"));
        }
        String file = Base64.encodeBase64String(byteArrayResource.getByteArray());
        Map<String, Object> responseMap = new HashMap<>();
        responseMap.put("fileName", operationExportFile.getFileName());
        responseMap.put("fileData", file);
        return ApiResponse.buildOK().setData(responseMap);
    }

    /**
     * 下载模板接口
     *
     * @param apiRequest
     * @return
     */
    @RequestMapping(value = "/operation/download", method = RequestMethod.POST)
    public ApiResponse<Map> operationDownload(@RequestBody ApiRequest apiRequest) {
        Map<String, Object> rawData = apiRequest.getRawData();
        String actionId = (String) rawData.get("actionId");
        String target = (String) rawData.get("target");
        String name = (String) rawData.get("tmActivityName");
        if (target.endsWith("_mobile")) {
            target = target.replace("_mobile", "");
        }
        Map<String, Object> executeContext = (Map<String, Object>) rawData.get("executeContext");
        //获取主表必填字段，过滤子表
        List<String> requiredFields = getRequestFields(JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class), actionId, target);
        try {
            //构造下载模板请求参数
            OperationDownload operationDownload = new OperationDownload();
            OperationDownload.ActionInfo actionInfo = new OperationDownload.ActionInfo();
            actionInfo.setTargetField(target);
            operationDownload.setActionInfo(actionInfo);
            operationDownload.setFileName(name);
            operationDownload.setRequiredFields(requiredFields);
            //调atdm导出,atdm返回的是二进制数组，转成baase64给前端
            ByteArrayResource byteArrayResource = digiwinAtdmProxyService.downloadTemplate(apiRequest.getIamUserToken(), apiRequest.getLocale(), operationDownload, actionId);
            if (Objects.isNull(byteArrayResource)) {
                return ApiResponse.buildError().setData(localeService.getLanguageValue(apiRequest.getLocale(), "当前下载文件不存在"));
            }
            String file = Base64.encodeBase64String(byteArrayResource.getByteArray());
            Map<String, Object> responseMap = new HashMap<>();
            responseMap.put("fileName", name);
            responseMap.put("fileData", file);
            return ApiResponse.buildOK().setData(responseMap);
        } catch (Exception e) {
            return ApiResponse.buildError(e.getMessage());
        }
    }

    /**
     * 导入接口
     *
     * @param files
     * @param rawData
     * @param locale
     * @param iamUserToken
     * @return
     * @throws IOException
     * @throws InterruptedException
     */
    @RequestMapping(value = "/operation/import", method = RequestMethod.POST)
    public ApiResponse<Map> operationImport(@RequestParam("files") List<MultipartFile> files,
                                            @RequestParam("rawData") String rawData,
                                            @RequestParam("locale") String locale,
                                            @RequestParam("iamUserToken") String iamUserToken) throws IOException, InterruptedException {
        Map data = JsonUtil.jsonStringToObject(rawData, Map.class);
        String actionId = (String) data.get("actionId");
        String target = (String) data.get("target");
        String tmActivityId = (String) data.get("tmActivityId");
        if (target.endsWith("_mobile")) {
            target = target.replace("_mobile", "");
        }
        if (Objects.isNull(files)) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "缺少上传文件"));
        }
        // 构建MultipartEntity--formData格式提交
        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("activityId", tmActivityId);
        requestMap.put("actionId", actionId);
        OperationDownload.ActionInfo actionInfo = new OperationDownload.ActionInfo();
        actionInfo.setTargetField(target);
        requestMap.put("actionInfo", JsonUtil.javaObjectToJsonString(actionInfo));
        Map<String, Object> executeContext = (Map<String, Object>) data.get("executeContext");
        //获取主表必填字段，过滤子表
        List<String> requiredFields = getRequestFields(JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class), actionId, target);
        String required = requiredFields.isEmpty() ? "" : String.join(",", requiredFields);
        requestMap.put("requiredFields", required);
        //开始导入
        ResponseEntity<Object> importReuslt = digiwinAtdmProxyService.operationImport(iamUserToken, locale, files, requestMap);
        if (!importReuslt.getStatusCode().is2xxSuccessful()) {
            DigiwinAthenaApiResponse body = (DigiwinAthenaApiResponse) importReuslt.getBody();
            return ApiResponse.buildError().setData(localeService.getLanguageValue(locale, body.getErrorMessage()));
        }
        //查询所有导入记录，汇总信息
        List<OperationImportFile> operationImportFiles = null;
        //是否导入完成
        Boolean isImport = false;
        //重试机制
        int maxRetries = 300;
        for (int attempt = 1; attempt <= maxRetries; attempt++) {
            operationImportFiles = digiwinAtdmProxyService.getImportRecords(iamUserToken, locale);
            if (!CollectionUtils.isEmpty(operationImportFiles)) {
                for (int i = 0; i < files.size(); i++) {
                    if (i >= operationImportFiles.size()) {
                        break;
                    }
                    OperationImportFile operationImportFile = operationImportFiles.get(i);
                    if (!Objects.equals(0, operationImportFile.getProcessingNum())) {
                        isImport = false;
                        break;
                    }
                    isImport = true;
                }
            }
            if (isImport) {
                break;
            }
            Thread.sleep(1000);
        }
        int errorNum = 0;//失败数量
        int successNum = 0;//成功数量
        if (!CollectionUtils.isEmpty(operationImportFiles)) {
            for (int j = 0; j < files.size(); j++) {
                if (j >= operationImportFiles.size()) {
                    break;
                }
                OperationImportFile operationImportFile = operationImportFiles.get(j);
                errorNum = errorNum + operationImportFile.getFailedNum() + operationImportFile.getErrorNum();
                successNum = successNum + operationImportFile.getSucceededNum();
            }
        }
        OperationImportCount operationImportCount = new OperationImportCount();
        operationImportCount.setSucceedNum(successNum);
        operationImportCount.setErrorNum(errorNum);
        operationImportCount.setTotalNum(successNum + errorNum);
        return ApiResponse.buildOK().setData(operationImportCount);
    }


    /**
     * 获取create必填字段
     *
     * @param pcUiBotExecuteContext
     * @param actionId
     * @param target
     * @return
     */
    public List<String> getRequestFields(PcUiBotExecuteContext pcUiBotExecuteContext, String actionId, String target) {
        try {
            List<PcUiBotMetadataField> fieldList = new ArrayList<>();
            List<String> requiredFields = new ArrayList<>();
            PcUiBotApiMetadata metadata = queryActionCreateService.getMetadata(pcUiBotExecuteContext, actionId);
            if (Objects.isNull(metadata)) {
                return Collections.emptyList();
            }
            List<PcUiBotMetadataField> responseFields = metadata.getRequestFields();
            for (PcUiBotMetadataField pcUiBotMetadataField : responseFields) {
                if (pcUiBotMetadataField.getSubFields() != null) {
                    fieldList = pcUiBotMetadataField.getSubFields();
                    break;
                }
            }
            Iterator<PcUiBotMetadataField> iterator = fieldList.iterator();
            while (iterator.hasNext()) {
                PcUiBotMetadataField obj = iterator.next();
                if (Objects.equals("object", obj.getDataType())) {
                    iterator.remove();
                }
                if (Objects.equals(true, obj.isRequired())) {
                    requiredFields.add(obj.getName());
                }
            }
            return requiredFields;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Object> getSearchInfo(Map data, String dateKey) {
        List<Object> searchResult = new ArrayList<>();
        Map<String, Object> rawData = (HashMap) ((HashMap) data.get("params")).get("rawData");
        searchResult.add(rawData.get(dateKey));
        return searchResult;
    }

    /**
     * 获取指定任务的调试信息
     */
    @PostMapping(value = "/debugger/task/{workitemId}")
    public ApiResponse<List<List<DigiwinAtmcTaskDebugger>>> getTaskDebugger(@PathVariable("workitemId") Long workitemId,
                                                                            @RequestBody ApiRequest apiRequest) {
        return ApiResponse.buildOK().setData(digiwinAtmcProxyService.getTaskDebugger(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), workitemId));
    }

    /**
     * 用于nanaH5的登出
     *
     * @param request
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/thirdPartLogout", method = RequestMethod.POST)
    public ApiResponse thirdPartLogout(HttpServletRequest request) throws IOException {
        Map<String, Object> params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String userId = (String) params.get("userId");
        String verifyUserId = (String) params.get("verifyUserId");
        String account = (String) params.get("account");
        //查询三方账号绑定的鼎捷帐号，如果鼎捷帐号和当前登出的帐号一致才会登出
        ResponseEntity<DigiwhaleLoginResponse> loginInternalResult = digiwinIamProxyService.loginInternal("");
        String token = loginInternalResult.getBody().getToken();
        Map<String, String> queryGlobalParams = new HashMap();
        queryGlobalParams.put("verifyUserId", verifyUserId);
        queryGlobalParams.put("appId", "Athena");
        queryGlobalParams.put("account", account);
        JSONObject queryGlobalResult = digiwinIamProxyService.queryGlobalLine(token, queryGlobalParams);
        if (Objects.isNull(queryGlobalResult)) {
            //一个Line绑定了多个鼎捷帐号
            return ApiResponse.buildError();
        }
        Object data = queryGlobalResult.get("data");
        if (Objects.isNull(data)) {
            //一个Line未绑定鼎捷帐号
            return ApiResponse.buildError();
        }
        JSONObject userMapping = (JSONObject) JSON.toJSON(data);
        if (userId.equals(userMapping.getString("userId"))) {
            DigiwinIamTokenRefreshTenant unbindTenantResult = this.digiwinIamProxyService.tokenRefreshTenant(userMapping.getString("tenantId"), "", iamUserToken);
            Map<String, Object> userInfo = new HashMap<>();
            userInfo.put("userId", userId);
            userInfo.put("identityId", "Athena");
            userInfo.put("verifyUserId", verifyUserId);
            userInfo.put("account", account);
            digiwinIamProxyService.deleteUserMapping(unbindTenantResult.getUserToken(), userInfo);
            digiwinIamProxyService.logout(unbindTenantResult.getUserToken());
            digiwinIamProxyService.logout(iamUserToken);
            return ApiResponse.buildOK();
        } else {
            return ApiResponse.buildError();
        }

    }

    /**
     * 用于line一键登录
     *
     * @param request
     * @return
     */
    public ApiResponse<DigiwhaleLoginResponse> lineOnceLogin(HttpServletRequest request, String token) throws Exception {
        //一键登陆中userName为邮箱
        String userName = request.getParameter("username");
        if (Objects.isNull(userName)) {
            return ApiResponse.buildError();
        }
        userName = AESUtil.decrypt(SECRET_KEY, userName);
        String expRoleId = request.getParameter("expRoleId");
        String verifyUserId = request.getParameter("verifyUserId");
        String tenantId = getLineTenantId(request, expRoleId);
        if (ObjectUtils.isEmpty(tenantId)) {
            return ApiResponse.buildError();
        }
        //通过邮箱查询用户信息(line登录有白名单，可以跨租户查询,token为集成帐号token)
        Map<String, String> userParams = new HashMap<>();
        userParams.put("email", userName);
        userParams.put("tenantId", tenantId);
        DigiwinIamResult userInfoByEmail = digiwinIamProxyService.getUserInfoByEmail(token, userParams);
        ApiResponse<DigiwhaleLoginResponse> lineUserInfo = handleUserMailResult(request, userInfoByEmail, verifyUserId, userName, tenantId, token);
        return lineUserInfo;
    }

    public ApiResponse<DigiwhaleLoginResponse> handleUserMailResult(HttpServletRequest request,
                                                                    DigiwinIamResult digiwinIamResult, String verifyUserId, String userName,
                                                                    String lineTenantId, String token) throws Exception {
        Integer code = digiwinIamResult.getCode();
        ApiResponse<DigiwhaleLoginResponse> lineUserInfo;
        if (Objects.equals(200, code)) {
            Map<String, String> data = (Map) digiwinIamResult.getData();
            //三方一键登录以及绑定
            lineUserInfo = getLineUserInfo(verifyUserId, request, lineTenantId, String.valueOf(data.get("id")), token);
        } else if (Objects.equals(21200, code)) {
            //用户不存在
            // 1.需要先注册,注册的时候userId就是line邮箱
            Map<String, Object> registerParams = new HashMap<>();
            registerParams.put("Id", userName);
            registerParams.put("name", userName);
            registerParams.put("email", userName);
            registerParams.put("agreeAgreement", true);
            //注册的密码默认是用户Id
            String passwordHash = SecureAESUtil.aesEncryptInIamRegister("Digiwin666");
            registerParams.put("passwordHash", passwordHash);
            ResponseEntity<JSONObject> responseEntity = digiwinIamProxyService.registerIamUser("", registerParams);
            //新增提示信息
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                JSONObject body = responseEntity.getBody();
                return ApiResponse.buildError().setData(body.getString("message"));
            }
            Map<String, String> joinTenantParams = new HashMap<>();
            joinTenantParams.put("userId", userName);
            joinTenantParams.put("tenantId", lineTenantId);
            joinTenantParams.put("appId", "Athena");
            DigiwinIamResult joinResult = digiwinIamProxyService.userAddJoinTenantCustom("", joinTenantParams);
            if (Objects.isNull(joinResult)) {
                return ApiResponse.buildError();
            }
            //2.三方一键登录以及绑定
            lineUserInfo = getLineUserInfo(verifyUserId, request, lineTenantId, userName, token);
        } else if (Objects.equals(21201, code)) {
            //用户存在但是没加租户
            //1.加入租户并授权应用
            //通过邮箱查询用户id
            Map<String, String> userParams = new HashMap<>();
            userParams.put("email", userName);
            userParams.put("tenantId", "");
            DigiwinIamResult userInfoByEmail = digiwinIamProxyService.getUserInfoByEmail(token, userParams);
            Map<String, String> data = (Map) userInfoByEmail.getData();
            Map<String, String> joinTenantParams = new HashMap<>();
            joinTenantParams.put("userId", data.get("id"));
            joinTenantParams.put("tenantId", lineTenantId);
            joinTenantParams.put("appId", "Athena");
            DigiwinIamResult joinResult = digiwinIamProxyService.userAddJoinTenantCustom("", joinTenantParams);
            if (Objects.isNull(joinResult)) {
                return ApiResponse.buildError();
            }
            //2.三方一键登录以及绑定
            lineUserInfo = getLineUserInfo(verifyUserId, request, lineTenantId, data.get("id"), token);
        } else {
            lineUserInfo = new ApiResponse<>("-1", "error");
        }
        return lineUserInfo;
    }


    /**
     * 获取line下娜娜的体验Id
     *
     * @param request
     * @param expRoleId
     * @return
     */
    private String getLineTenantId(HttpServletRequest request, String expRoleId) {
        // 体验模式：体验账号登录下，获取娜娜配置
        Mock mock = getMock(request, expRoleId);
        String tenantId = "";
        if (mock != null) {
            // mock集成娜娜功能场景
            tenantId = mock.getNanaTenantId();
        } else {
            // 依据雅典娜平台的地址，决定目标租户id
            String athenaMuiUrl = AppContext.getApiUrlSetting().getMuiUrl().trim();
            if (Objects.equals("https://athena-paas.digiwincloud.com.cn", athenaMuiUrl)) {
                // paas区
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                }
            } else if (Objects.equals("https://athena-test.digiwincloud.com.cn", athenaMuiUrl)) {
                // 华为测试区
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                }
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    tenantId = "erp2nanatrmdemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                    tenantId = "0000011111";
                }
            } else if (Objects.equals("https://athena.digiwincloud.com.cn", athenaMuiUrl)) {
                // 华为正式区 无需求不处理
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                }
            } else if (Objects.equals("https://athena-test.digiwincloud.com", athenaMuiUrl)) {
                // 微软测试区
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "DigiwinGptDemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    tenantId = "erp2nanatrmdemo";
                }
            } else if (Objects.equals("https://athena.digiwincloud.com", athenaMuiUrl)) {
                // 微软正式区
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "agiledemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_TRAVEL.getValue())) {
                    tenantId = "erp2nanatrmdemo";
                } else if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_ASAAA.getValue())) {
                    tenantId = "athena";
                }
            } else if (Objects.equals("https://athena-hz-test.digiwincloud.com.cn", athenaMuiUrl)) {
                // 湖州环境
                if (Objects.equals(expRoleId.trim(), ExperienceRoleIdEnum.NANA_DATA_ASSISTANT_CXO.getValue())) {
                    tenantId = "AthenaHZdemoE";
                }
            } else {
                // TODO 未来定制或其他特殊情况
            }
        }
        return tenantId;
    }

    /**
     * 用于line 一键登陆后的绑定逻辑
     */

    private ApiResponse<DigiwhaleLoginResponse> getLineUserInfo(String verifyUserId, HttpServletRequest request,
                                                                String lineTenantId, String userId, String token) throws Exception {
        String locale = request.getParameter("locale");
        Map<String, String> queryGlobalParams = new HashMap();
        queryGlobalParams.put("verifyUserId", verifyUserId);
        queryGlobalParams.put("appId", "Athena");
        queryGlobalParams.put("account", "line");
        JSONObject queryGlobalResult = digiwinIamProxyService.queryGlobalLine(token, queryGlobalParams);
        if (Objects.isNull(queryGlobalResult)) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "一键登录失败，Line帐号不允许绑定多个鼎捷云帐号"));
        }
        if (isBindUser(queryGlobalResult, userId)) {
            return ApiResponse.buildError(localeService.getLanguageValue(locale, "一键登录失败，当前Line用户已绑定过鼎捷云账号,请解绑后继续操作"));
        }
        //绑定
        digiwinIamProxyService.importThirdplatform("line", verifyUserId, userId, "", lineTenantId);
        ThirdPartyLoginFreeQueryDTO queryDTO = new ThirdPartyLoginFreeQueryDTO();
        String unionId = AESUtils.aesEncrypt(verifyUserId, SsoController.THIRD_PARTY_SSO_SECRET_KEY);
        queryDTO.setUnionid(unionId);
        queryDTO.setUserId(userId);//鼎捷的id
        queryDTO.setType("line");
        queryDTO.setAppId("Athena");
        queryDTO.setTenantId(lineTenantId);
        DigiwhaleLoginResponse iamUserInfo = digiwinIamProxyService.identityOauthTokenGrantAccess(queryDTO);
        String version = request.getParameter("version");
        String deviceID = request.getParameter("deviceID");
        String clientAgent = CLIENT_AGENT_MOBILE + "-" + version + "-" + deviceID;
        String expRoleId = request.getParameter("expRoleId");
        Mock mock = getMock(request, expRoleId);
        String iamDeviceId = request.getHeader("digi-middleware-device-id");
        loginService.handleUserByVerificationCodeInExperience(userId, null, request.getParameter("locale"),
                clientAgent, expRoleId, iamUserInfo, mock, iamDeviceId);
        //設置EOC信息
        EocPerson eocInfo = digiwinEocProxyService.getEocInfo(iamUserInfo.getIamAuth().getUserId(), iamUserInfo.getIamAuth().getToken());
        iamUserInfo.setEoc(eocInfo);
        return ApiResponse.buildOK().setData(iamUserInfo);
    }

    /**
     * 获得Mock的方法抽出来
     *
     * @param request
     * @return
     */
    public Mock getMock(HttpServletRequest request, String expRoleId) {
        //获取mock
        Mock mock = null;
        String mockId = request.getHeader(MockInterceptor.RECORD_MOCK_ID);
        if (org.springframework.util.StringUtils.hasLength(mockId) && ExperienceRoleIdEnum.ATHENA_MOCK.getValue().equals(expRoleId.trim())) {
            mock = mockService.selectByMockId(mockId, null);
            if (mock != null) {
                if (!EnableEnum.YES.getValue().equals(mock.getEnableNana())) {
                    mock = null;
                }
            }
        }
        return mock;
    }

    public void sendToMqtt(String verifyUserId) {
        JSONObject jsonObject = new JSONObject();
        //mqtt需要传送的信息
        jsonObject.put("verifyUserId", verifyUserId);
        String payload = jsonObject.toJSONString();
        mqttService.sendMQTTMessage(MQ_LINE_LOGOUT_DEFAULT_TOPIC, payload);

    }
}
