package com.digiwin.mobile.mobileuibot.proxy;

import com.digiwin.mobile.mobileuibot.api.ApiResponse;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.request.RequestParameterUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.*;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.TableUiBotParser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 项目-设计变更-相关接口
 *
 * @author zhangjj
 * @date 2021/12/1 0001 10:51
 */
@RestController
@RequestMapping("/mobile/v1/proxy")
public class StandardProjectController {

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    /**
     * 获取设计变更每个进度下详情信息
     *
     * @param projectId
     * @param request
     * @return
     * @throws IOException
     */
    @PostMapping("/project/standard/progress/detail")
    public ApiResponse<Map> getProgressDetail(@RequestParam String projectId,
                                              @RequestParam String tmTaskId,
                                              HttpServletRequest request) throws IOException {
        Map params = RequestParameterUtil.getPostDataMap(request, false, "UTF-8");
        String iamUserToken = (String) params.get("iamUserToken");
        String tenantId = (String) params.get("tenantId");
        String locale = (String) params.get("locale");
        String progressId = (String) params.get("progressId");
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow) {
            String data = FileUtil.readText("static/appstore-use/project-standard-progress-show-" + progressId + ".json");
            Map<String, Object> map = JsonUtil.jsonStringToObject(data, Map.class);
            List<Map<String, Object>> content = new ArrayList<>();
            content.add(map);
            return ApiResponse.buildOK().setData(content);
        }
        List<Map<String, Object>> sortList =
                digiwinPcUiBotProxyService.getProjectDetailByProjectId(locale, iamUserToken, tenantId,
                        projectId, tmTaskId, progressId);
        TabsComponent tabsComponent = new TabsComponent();
        List<Map<String, Object>> content = new ArrayList<>();
        Map<String, Object> tabsMap = new HashMap<>();
        tabsMap.put("area", "body");
        tabsMap.put("componentType", TabsComponent.COMPONENT_TYPE);
        tabsMap.put("data", tabsComponent);
        content.add(tabsMap);
        if (sortList == null || sortList.size() == 0) {
            return ApiResponse.buildOK().setData(content);
        }
        for (Map<String, Object> map : sortList) {
            TabItem tabItem = new TabItem();
            tabsComponent.add(tabItem);
            String tabName = (String) map.get("queryTitle");
            if (!StringUtils.hasLength(tabName)) {
                //标准项目只有一个tab时，有可能没有tab标题，这里默认设置名称为"全部"
                tabName = LocaleUtil.getMobileTextByKey(locale, "全部");
            }
            tabItem.setName(tabName);
            List<TabItemCard> cardList = new ArrayList<>();
            tabItem.setContent(cardList);
            UiBotModel uiBotModel =
                    digiwinPcUiBotProxyService.actionShow(locale, iamUserToken, JsonUtil.javaObjectToJsonString(map));
            List<UiBotLayout> layoutList = uiBotModel.getLayout();
            if (layoutList == null || layoutList.size() == 0) {
                continue;
            }
            List<UiBotLayout> orderLayoutList = layoutList.stream().filter(UiBotLayout::isTypeOfGroupOrder).collect(Collectors.toList());
            List<UiBotLayout> tableLayoutList = layoutList.stream().filter(UiBotLayout::isTypeOfTable).collect(Collectors.toList());
            if (orderLayoutList.size() > 0) {
                //有状态的
                Map<String, Integer> overdueMap = new HashMap<>();
                //逾期项数
                overdueMap.put("overdueNum", 0);
                //最大逾期
                overdueMap.put("overdueDays", 0);
                List<List<ParseFieldData>> fieldDataListList = TableUiBotParser.parseTableUiBotData(orderLayoutList.get(0), uiBotModel.getPageData());
                if (fieldDataListList != null) {
                    List<Map<String, Object>> dataList = (List<Map<String, Object>>) uiBotModel.getPageData().get(orderLayoutList.get(0).getSchema());
                    for (int i = 0; i < fieldDataListList.size(); i++) {
                        List<ParseFieldData> fieldDataList = fieldDataListList.get(i);
                        TabItemCard itemCard = orderMap2TabItemCard(fieldDataList, overdueMap, locale, projectId);
                        //在途宝-运输在途物流详情
                        if (dataList.get(i).get("logistics_detail") != null) {
                            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
                            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ZTB_PROJECT_LOGISTICS.toString());
                            Map<String, Object> rawData = new HashMap<>();
                            rawData.put("data", dataList.get(i).get("logistics_detail"));
                            detailPage.setRawData(rawData);
                            itemCard.setDetailPage(detailPage);
                        }
                        cardList.add(itemCard);
                    }
//                    for (List<ParseFieldData> fieldDataList : fieldDataListList) {
//                        TabItemCard itemCard = orderMap2TabItemCard(fieldDataList, overdueMap, locale, projectId);
//                        cardList.add(itemCard);
//                    }
                }

                int overdueDays = overdueMap.get("overdueDays");
                int overdueNum = overdueMap.get("overdueNum");
                if (overdueNum > 0) {
                    tabItem.setDesc(String.format(LocaleUtil.getMobileTextByKey(locale, "逾期详情"), overdueNum, overdueDays));
                }
                continue;
            }
            if (tableLayoutList.size() > 0) {
                //无状态的
                List<List<ParseFieldData>> fieldDataListList = TableUiBotParser.parseTableUiBotData(tableLayoutList.get(0), uiBotModel.getPageData());
                if (fieldDataListList != null) {
                    for (List<ParseFieldData> fieldDataList : fieldDataListList) {
                        TabItemCard itemCard = tableMap2TabItemCard(fieldDataList, locale, projectId);
                        cardList.add(itemCard);
                    }
                }

            }
        }
        return ApiResponse.buildOK().setData(content);
    }

    private TabItemCard tableMap2TabItemCard(List<ParseFieldData> fieldDataList, String locale, String projectId) {
//        Map<String, ParseFieldData> dataMap = fieldData2Map(fieldDataList);
        TabItemCard card = new TabItemCard();
        List<TabItemCardContent> cardContentList = new ArrayList<>();
        card.setContent(cardContentList);
        for (ParseFieldData fieldData : fieldDataList) {
            if (cardContentList.size() == 3) {
                break;
            }
            TabItemCardContent cardContent = convertTabItemCardContent(fieldData, locale, projectId);
            if (cardContent != null) {
                cardContentList.add(cardContent);
            }
        }
        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
        detailPage.setDataId("");
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("data", fieldDataList);
        detailPage.setRawData(rawData);
        card.setDetailPage(detailPage);
        return card;
    }

    private TabItemCardContent convertTabItemCardContent(ParseFieldData fieldData, String locale, String projectId) {
        if (fieldData == null || fieldData.getData() == null) {
            return null;
        }
        TabItemCardContent tabItemCardContent = new TabItemCardContent();
        tabItemCardContent.setLabel(fieldData.getLabel());
        tabItemCardContent.setLabelStyleType(2);
        tabItemCardContent.setValueStyleType(1);
        AtomicReference<Object> value = new AtomicReference<>(fieldData.getData());
        if (fieldData.getOptions() != null) {
            fieldData.getOptions().forEach(uiBotTableColumnEditorOption -> {
                if (value.get().equals(uiBotTableColumnEditorOption.getValue())) {
                    value.set(uiBotTableColumnEditorOption.getTitle());
                }
            });
        }
        if ("SIGN_OFF_PROGRESS".equalsIgnoreCase(fieldData.getType())) {
            //签核状态
            Map valueMap = (Map) value.get();
            String approve = valueMap.get("approve").toString();
            switch (approve) {
                case "3":
                    tabItemCardContent.setValue(LocaleUtil.getMobileTextByKey(locale, "已签核"));
                    break;
                default:
                    tabItemCardContent.setValue(LocaleUtil.getMobileTextByKey(locale, "签核中"));
                    break;
            }
            Action action = new Action();
            action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
            action.setJumpPageTitle(fieldData.getLabel());
            action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString());
            action.setDataId(projectId);
            action.setRawData(valueMap);
            tabItemCardContent.setAction(action);
        } else {
            String valueStr = value.get().toString();
            if (!StringUtils.hasLength(valueStr)) {
                valueStr = "-";
            }
            tabItemCardContent.setValue(valueStr);
        }
        return tabItemCardContent;
    }


    private TabItemCard orderMap2TabItemCard(List<ParseFieldData> fieldDataList, Map<String, Integer> overdueMap, String locale, String projectId) {
        Map<String, ParseFieldData> dataMap = fieldData2Map(fieldDataList);
        TabItemCard card = new TabItemCard();
        if (dataMap.get("activity__performerName") != null) {
            BaseMobileComponentPerson person = new BaseMobileComponentPerson();
            String name = (String) dataMap.get("activity__performerName").getData();
            person.setName(StringUtils.hasLength(name) ? name : "-");
            card.setPerson(person);
        }
        List<TabItemCardContent> cardContentList = new ArrayList<>();
        card.setContent(cardContentList);
        //任务进展状态
        if (dataMap.get("activity__backLog__data") != null) {
            TabItemCardContent statusCardContent = calculateTaskStatus(dataMap.get("activity__backLog__data"), overdueMap, locale);
            cardContentList.add(statusCardContent);
        }
        //计划完成日期
        if (dataMap.get("activity__planEndTime") != null) {
            TabItemCardContent activityPlanEndTimeCardContent = convertTabItemCardContent(dataMap.get("activity__planEndTime"), locale, projectId);
            if (activityPlanEndTimeCardContent != null) {
                cardContentList.add(activityPlanEndTimeCardContent);
            }
        }
        //签核状态
        if (dataMap.get("activity__approval__state") != null) {
            TabItemCardContent approvalStateCardContent = convertTabItemCardContent(dataMap.get("activity__approval__state"), locale, projectId);
            if (approvalStateCardContent != null) {
                cardContentList.add(approvalStateCardContent);
            }
        }
        //每个条目展示3个字段，不够按顺序补充
        for (ParseFieldData fieldData : fieldDataList) {
            if (cardContentList.size() == 4) {
                break;
            }
            if ("activity__performerName".equalsIgnoreCase(fieldData.getSchema())
                    || "activity__backLog__data".equalsIgnoreCase(fieldData.getSchema())
                    || "activity__planEndTime".equalsIgnoreCase(fieldData.getSchema())
                    || "activity__approval__state".equalsIgnoreCase(fieldData.getSchema())) {
                continue;
            }
            TabItemCardContent tabItemCardContent = convertTabItemCardContent(fieldData, locale, projectId);
            if (tabItemCardContent != null) {
                cardContentList.add(tabItemCardContent);
            }
        }
        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
        detailPage.setDataId(projectId);
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("data", fieldDataList);
        detailPage.setRawData(rawData);
        card.setDetailPage(detailPage);
        return card;
    }

    private Map<String, ParseFieldData> fieldData2Map(List<ParseFieldData> fieldDataList) {
        Map<String, ParseFieldData> map = new HashMap<>();
        if (fieldDataList == null) {
            return map;
        }
        fieldDataList.stream().forEach(fieldData -> map.put(fieldData.getSchema(), fieldData));
        return map;
    }

    /**
     * 计算任务状态
     *
     * @param fieldData
     * @param overdueMap
     * @return
     */
    public TabItemCardContent calculateTaskStatus(ParseFieldData fieldData, Map<String, Integer> overdueMap, String locale) {
        Map<String, Object> dataMap = (Map<String, Object>) fieldData.getData();
        if (dataMap == null) {
            TabItemCardContent statusCardContent = new TabItemCardContent();
            statusCardContent.setLabel(fieldData.getLabel());
            statusCardContent.setLabelStyleType(2);
            statusCardContent.setValue("-");
            return statusCardContent;
        }
        //计划完成时间
        String planEndTime = (String) dataMap.get("planEndTime");
        //是否关闭（完成）
        Boolean close = (Boolean) dataMap.get("closed");
        //实际完成日期
        String endTime = (String) dataMap.get("endTime");

        TabItemCardContent statusCardContent = new TabItemCardContent();
        statusCardContent.setLabel(fieldData.getLabel());
        statusCardContent.setLabelStyleType(2);
        if (close) {
            //已完成--正常完成、逾时完成
            if (DateTimeUtil.compareTime(endTime, planEndTime)) {
                //实际完成日期早于计划完成日期--正常完成
                statusCardContent.setValue(LocaleUtil.getMobileTextByKey(locale, "已完成"));
                statusCardContent.setType("DONE");
            } else {
                //实际完成日期晚于计划完成日期--逾时完成
                //逾期天数
                int days = DateTimeUtil.getDateTimePeriod(planEndTime, endTime);
                statusCardContent.setValue(String.format(LocaleUtil.getMobileTextByKey(locale, "逾期后完成"), days));
                statusCardContent.setType("OVERDUE_DONE");
            }
        } else {
            //未完成
            if (!DateTimeUtil.isBeforeNowDateTime(planEndTime)) {
                //未到计划完成日期--正在进行
                statusCardContent.setValue(LocaleUtil.getMobileTextByKey(locale, "正在进行"));
                statusCardContent.setType("LOADING");
            } else {
                //已到计划完成日期--逾时xx天
                int overdueNum = overdueMap.get("overdueNum");
                int overdueDays = overdueMap.get("overdueDays");
                overdueNum++;
                overdueMap.put("overdueNum", overdueNum);
                int days = DateTimeUtil.getDateTimePeriod(planEndTime, DateTimeUtil.getTodayTimeUseDefaultPattern());
                if (days > overdueDays) {
                    overdueDays = days;
                    overdueMap.put("overdueDays", overdueDays);
                }
                statusCardContent.setValue(String.format(LocaleUtil.getMobileTextByKey(locale, "逾期天数"), days));
                statusCardContent.setType("OVERDUE");
            }
        }
        return statusCardContent;
    }
}
