package com.digiwin.mobile.mobileuibot.proxy.aam.service;

import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentDetail;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentMessage;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentResponse;

import java.util.List;

/**
 * 鼎捷aam系统代理服务
 *
 * @author zhangjj
 * @date 2021/6/17 0017 10:10
 */
public interface DigiwinAamProxyService {

    String API_PREFIX = "/api/aam/v1";

    /**
     * 上传文件
     *
     * @param attachmentMessage 附件信息
     * @param userToken         互联userToken
     * @return
     */
    AttachmentResponse uploadFile(AttachmentMessage attachmentMessage, String userToken);

    /**
     * 删除文件
     *
     * @param fileId     文件id
     * @param categoryId 目录id
     * @param category   目录名称
     * @param userToken  互联userToken
     * @return
     */
    boolean deleteFile(String fileId, String categoryId, String category, String userToken);

    /**
     * 获取文件
     *
     * @param categoryList
     * @param rowDataKeyList
     * @param taskId
     * @param tenantId
     * @param userToken
     * @return
     */
    List<AttachmentDetail> attachment(List<String> categoryList, List<String> rowDataKeyList,
                                      String taskId, String tenantId, String userToken);
}
