package com.digiwin.mobile.mobileuibot.proxy.aam.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentDetail;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentMessage;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentResponse;
import com.digiwin.mobile.mobileuibot.proxy.aam.service.DigiwinAamProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhangjj
 * @date 2021/6/17 0017 10:11
 */
@Service
public class DigiwinAamProxyServiceImpl implements DigiwinAamProxyService {

    @Autowired
    HttpService httpService;


    @Override
    public AttachmentResponse uploadFile(AttachmentMessage attachmentMessage, String userToken) {
        String url = AppContext.getApiUrlSetting().getAamUrl() + API_PREFIX + "/uploadAttachment";
        ResponseEntity<AttachmentResponse> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken),
                        JsonUtil.javaObjectToJsonString(attachmentMessage), AttachmentResponse.class);
        return responseEntity.getBody();
    }

    @Override
    public boolean deleteFile(String fileId, String categoryId, String category, String userToken) {
        String url = AppContext.getApiUrlSetting().getAamUrl() + API_PREFIX + "/deleteAttachment";
        Map<String, String> bodyMap = new HashMap<>();
        bodyMap.put("id", fileId);
        bodyMap.put("categoryId", categoryId);
        bodyMap.put("category", category);
        ResponseEntity<AttachmentResponse> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken),
                        JsonUtil.javaObjectToJsonString(bodyMap), AttachmentResponse.class);
        if (responseEntity.getBody().getStatus() == 200) {
            return true;
        }
        return false;
    }

    @Override
    public List<AttachmentDetail> attachment(List<String> categoryList, List<String> rowDataKeyList, String taskId, String tenantId, String userToken) {
        String url = AppContext.getApiUrlSetting().getAamUrl() + API_PREFIX + "/attachment";
        Map<String, Object> bodyMap = new HashMap<>();
        bodyMap.put("categoryList", categoryList);
        bodyMap.put("rowDataKeyList", rowDataKeyList);
        bodyMap.put("taskId", taskId);
        bodyMap.put("tenantId", tenantId);
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<AttachmentDetail>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<AttachmentDetail>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<AttachmentDetail>>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(userToken),
                        JsonUtil.javaObjectToJsonString(bodyMap), responseType);
        if (responseEntity.getBody().getStatus() == 200) {
            return responseEntity.getBody().getResponse();
        }
        return Collections.emptyList();
    }
}
