package com.digiwin.mobile.mobileuibot.proxy.ade.impl;

import com.digiwin.mobile.mobileuibot.aiassistant.model.request.DataCollectionGroupQueryDTO;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.ade.DigiwinAdeProxyService;
import com.digiwin.mobile.mobileuibot.proxy.ade.model.AdeDataCollectionGroupListResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author yanfeng
 * @date 2024/12/25
 */
@Slf4j
@Service("digiwinAdeProxyServiceImpl")
public class DigiwinAdeProxyServiceImpl implements DigiwinAdeProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public AdeDataCollectionGroupListResult queryDataCollectionGroup(DataCollectionGroupQueryDTO request) {
        String url = AppContext.getApiUrlSetting().getAdeUrl() +
                "/restful/standard/AgileDataEngine/instant/queryDataCollectGroupConfig";
        // 构建请求参数
        Map<String, Object> params = new HashMap<>(1);
        Map<String, Object> map = new HashMap<>(4);
        map.put("groupId", request.getGroupId());
        map.put("type", request.getType());
        map.put("groupValue", request.getGroupValue());
        map.put("asaCode", request.getAsaCode());
        params.put("config", map);

        ParameterizedTypeReference<DigiwinAthenaApiResponse<AdeDataCollectionGroupListResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AdeDataCollectionGroupListResult>>() {
                };
        try {
            ResponseEntity<DigiwinAthenaApiResponse<AdeDataCollectionGroupListResult>> responseEntity =
                    this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()),
                            JsonUtil.javaObjectToJsonString(params),
                            responseType);

            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                DigiwinAthenaApiResponse<AdeDataCollectionGroupListResult> responseBody = responseEntity.getBody();
                return (responseBody != null && responseBody.getResponse() != null) ? responseBody.getResponse() : null;
            } else {
                log.error("数据收藏分组,queryDataCollectionGroup异常,入参:{}, 响应:{}", JsonUtil.javaObjectToJsonString(request), JsonUtil.javaObjectToJsonString(responseEntity));
                return null;
            }
        } catch (Exception e) {
            log.error("数据收藏分组,queryDataCollectionGroup发生异常: {}", e.getMessage(), e);
            return null;
        }
    }

}