package com.digiwin.mobile.mobileuibot.proxy.adq;

import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AgileDataAdqApplicationFunctionPermissionResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AnalysisConfigData;

/**
 * <p>功能描述：鼎捷雅典娜ADE服务调用类</p>
 *
 * @author yanfeng
 * @date 2024/12/25
 */
public interface AgileDataAdqProxyService {

    String API_PREFIX = "/restful/service";

    /**
     * 需求286790:查询应用功能权限(如：ppt生成等)
     *
     * @param apiRequest
     * @return
     */
    AgileDataAdqApplicationFunctionPermissionResultDTO queryApplicationFunctionPermission(AgileDataApiRequest apiRequest);

    /**
     * 查询分析总结配置类列表
     * @param apiRequest
     * @return
     */
    AnalysisConfigData getAnalysisConfigDataList(AgileDataApiRequest apiRequest);

}