package com.digiwin.mobile.mobileuibot.proxy.adq.dto;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 需求286790:功能权限管控返回信息类
 * @date 2025/9/11
 * @author yanfeng
 */
@Data
public class AgileDataAdqApplicationFunctionPermissionResultDTO {

    /**
     * metric/dataset
     */
    private String method;

    /**
     * 设计器设计助理勾选的功能模块(比如ppt生成)
     * 如果有返回，则代表可见可用
     * 如果没有返回，则代表不可见不可用
     * 旗舰版对应关系：
     * [
     *         {
     *             "name": "归因分析",
     *             "id": "attribution-analysis",//模组id
     *             "lang":{}
     *         },
     *         {
     *             "id": "generate-ppt",
     *             "name": "数据PPT生成",
     *             "lang":{}
     *         },
     *         {
     *             "name": "数据看板生成",
     *             "id": "generate-dashboard",
     *             "lang":{}
     *         },
     *        {
     *             "name": "智能分析师",
     *             "id": "intelligent-analyst",
     *             "lang":{}
     *         }
     * ]
     */
    private List<String> functionModules;

    //功能模块文案信息
    private Map<Object, AgileDataAdqApplicationModuleFunctionInfoResultDTO> moduleInfo;


}