package com.digiwin.mobile.mobileuibot.proxy.adq.impl;

import com.digiwin.mobile.mobileuibot.agileData.constant.AgileDataConstant;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adq.AgileDataAdqProxyService;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AgileDataAdqApplicationFunctionPermissionResultDTO;
import com.digiwin.mobile.mobileuibot.proxy.adq.dto.AnalysisConfigData;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @date 2025/9/11
 * @author yanfeng
 */
@Slf4j
@Service
public class AgileDataAdqProxyServiceImpl implements AgileDataAdqProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public AgileDataAdqApplicationFunctionPermissionResultDTO queryApplicationFunctionPermission(AgileDataApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + AgileDataAdqProxyService.API_PREFIX
                + "/knowledgegraph/tenant/queryApplicationFunctionPermission?appCode=" + apiRequest.getAppCode();
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataAdqApplicationFunctionPermissionResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataAdqApplicationFunctionPermissionResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AgileDataAdqApplicationFunctionPermissionResultDTO>> responseEntity;
        try {
            responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, apiRequest.getLocale(),
                    apiRequest.getIamUserToken(), apiRequest.getTenantId()), responseType);
            log.info("queryApplicationFunctionPermission接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    apiRequest.getAppCode(),
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());

            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("queryApplicationFunctionPermission接口调用失败, url:{} \n request:{}, \n error:{}", url, apiRequest.getAppCode(), e.getMessage());
        }
        return null;
    }

    @Override
    public AnalysisConfigData getAnalysisConfigDataList(AgileDataApiRequest apiRequest) {
        String url = AppContext.getApiUrlSetting().getAgileDataQueryUrl() + AgileDataAdqProxyService.API_PREFIX
                + "/agiledataquery/dataConfig/info";
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AnalysisConfigData>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AnalysisConfigData>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AnalysisConfigData>> responseEntity;
        Map<String, Object> body = new HashMap<>();
        body.put("appCode", apiRequest.getAppCode());
        body.put("tenantId", apiRequest.getTenantId());
        try {
            responseEntity = this.httpService.doPost(url,
                    new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, apiRequest.getLocale(),
                            apiRequest.getIamUserToken(), apiRequest.getTenantId()),
                    JsonUtil.javaObjectToJsonString(body), responseType);

            log.info("getAnalysisConfigData接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(body),
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());

            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return new AnalysisConfigData();
            }
            if (null != responseEntity.getBody() && responseEntity.getBody().getResponse() != null) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("getAnalysisConfigData接口调用失败, url:{} \n request:{}, \n error:{}", url,
                    JsonUtil.javaObjectToJsonString(body), e.getMessage());
        }
        return new AnalysisConfigData();
    }
}