package com.digiwin.mobile.mobileuibot.proxy.adt.dto;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class AdtFileDTO {

    /**
     * 消息ID
     */
    private Long messageId;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 消息状态
     * 0.未执行1.已执行
     */
    private Integer messageStatus;

    /**
     * 问句主题
     */
    private String messageTopic;

    /**
     * ppt信息
     */
    private List<AgileDataFileGenerateDTO> pptInfo;

    /**
     * 规划问句集合
     */
    private List<AgileDataFileQuestionDTO> questionInfo;

    @Data
    public static class AgileDataFileQuestionDTO {
        /**
         * 规划问句ID
         */
        private Long questionId;

        /**
         * 分析规划问句
         */
        private String question;

        /**
         * 分析问句标题
         */
        private String title;

        /**
         * 是否锁定
         */
        private Boolean lock;

        /**
         * 问句分析状态
         * 0.成功1.失败2.解析中
         */
        private Integer analyzeStatus;

        /**
         * 分析结果
         */
        private AgileDataFileAnalyzeDTO analyzeResult;

        /**
         * 数据集集合
         */
        private List<String> datasetIds;

        /**
         * 快照ID
         */
        private String snapshotId;

        /**
         * 数据总结
         */
        private String summarizeData;
    }

    @Data
    public static class AgileDataFileAnalyzeDTO {
        /**
         * 问句分析推理
         */
        private Map<String, Object> questionAnalysic;

        /**
         * 字段校验
         */
        private Map<String, Object> schemasCheck;

        /**
         * 构建解题思路
         */
        private Map<String, Object> questionWay;

        /**
         * 解题要素识别
         */
        private Map<String, Object> stepAnasisly;
    }

    @Data
    public static class AgileDataFileGenerateDTO {
        /**
         * pptId
         */
        private Long pptId;

        /**
         * 生成状态
         * 0.成功 1.失败 2.生成中
         */
        private String generateStatus;

        /**
         * pptUrl
         */
        private String pptUrl;
    }


}