package com.digiwin.mobile.mobileuibot.proxy.adt.model;

import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：敏捷数据返回的用户反馈对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinAdtUserFeedback
 * @Author: zaregoto
 * @Date: 2024/1/30 10:57
 */
@Data
public class DigiwinAdtUserFeedback implements Serializable {
    private static final long serialVersionUID = -5665885120196035814L;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 用户反馈操作类型
     *
     * @see com.digiwin.mobile.mobileuibot.feedback.AiChatFeedbackTypeEnum
     */
    private Integer feedbackType;

    /**
     * 反馈的终端：webplatform表示web端，mobileplatform表示app端
     */
    private String terminal;

    /**
     * 引擎生成的流水号
     */
    private Long generateSerialNo;

    /**
     * 快照ID（如果有）
     */
    private String snapshotId;

    /**
     * 用户提问
     */
    private String question;

    /**
     * 用户选择的反馈项文字字符串。多个以半角逗号分隔。
     * 示例：回答不准确，不稳定，报错
     */
    private String backContent;

    /**
     * 用户选择的反馈项id字符串。多个以半角逗号分隔。
     * 示例：1，2，3
     */
    private String checkOpinions;

    /**
     * 用户手工录入的反馈意见文字。
     * 示例：的确没用，数据有错误的
     */
    private String answerOpinion;

    /**
     * 反馈意见创建时间。如2024-01-27 15:08:07
     */
    private String createTime;

    /**
     * 反馈意见更新时间。如2024-01-27 15:08:07
     */
    private String modifyTime;
}