package com.digiwin.mobile.mobileuibot.proxy.adt.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 敏捷数据：数据看板查询结果入参
 *
 * @author yanfeng
 * @date 2024/6/28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProcessMessageRequest implements Serializable {

    private static final long serialVersionUID = -4582183603999819065L;

    @NotBlank(message = "用户Token不能为空")
    private String iamUserToken;

    private MsgExt msgExt;

    private MsgBody msgBody;


    @Data
    public static class MsgExt {

        /**
         * 主键
         */
        private String questionId;

        /**
         * 问句
         */
        private String question;

        /**
         * 用户名
         */
        private String userName;

        /**
         * 场景code
         */
        private String sceneCode;

        /**
         * 用户id
         */
        private String userId;

        /**
         * 指标id列表
         */
        private List<String> metricIdList;

        /**
         * 数据集id列表
         */
        private List<String> datasetIdList;
    }

    @Data
    public static class MsgBody {

        /**
         * 同上面question 问句
         */
        private String text;

    }

}