package com.digiwin.mobile.mobileuibot.proxy.adt.service;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.*;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.*;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AdtTablePreviewDataRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacApplicationAuthorizationInformation;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜快照服务调用类</p>
 *
 * @author wuyang
 */
public interface DigiwinAdtProxyService {

    String API_PREFIX = "/api/ai";

    /**
     * 获取快照Id列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<DigiwinAdtReportData> getReportDataList(String iamUserToken, String tenantId, String locale,
                                                 Map<String, Object> params);

    /**
     * 发送用户反馈操作（点赞/点踩）
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<Boolean> sendUserFeedback(String iamUserToken, String tenantId, String locale,
                                                       Map<String, Object> params);

    /**
     * 取消用户原有反馈
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<Boolean> cancelUserFeedback(String iamUserToken, String tenantId, String locale,
                                                         Map<String, Object> params);

    /**
     * 发送用户反馈意见
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<Boolean> userAnswerFeedback(String iamUserToken, String tenantId, String locale,
                                                         Map<String, Object> params);

    /**
     * 根据敏捷数据引擎生成的id，批量查询用户反馈
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param generateSerialNoList
     * @return
     */
    DigiwinAthenaApiResponse<List<DigiwinAdtUserFeedback>> getUserFeedback(String iamUserToken, String tenantId,
                                                                           String locale, List<Long> generateSerialNoList);

    /**
     * 敏捷数据快照异常时的上报接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    DigiwinAthenaApiResponse<Boolean> saveAbnormal(String iamUserToken, String tenantId, String locale,
                                                   Map<String, Object> params);

    /**
     * 敏捷数据: 根据快照id获取场景code
     *
     * @param iamUserToken
     * @param snapshotId
     * @return
     */
    String getSceneCode(String iamUserToken, String snapshotId);

    /**
     * 敏捷数据:获取数据面板结果(快照Id等信息)
     *
     * @param request
     * @return DigiwinAdtReportData
     * @author yanfeng
     */
    DigiwinAdtProcessMessage processMessage(ProcessMessageRequest request);

    /**
     * 敏捷数据:获取当前用户指定应用的授权信息(流量阈值，流量使用情况)
     *
     * @param request
     * @return DigiwinAdtReportData
     * @author yanfeng
     */
    DigiwinCacApplicationAuthorizationInformation queryCalculateCacByConfig(ApiRequest request);

    /**
     * 敏捷数据:保存用户关闭流量阈值提醒
     *
     * @param request
     * @return
     */
    Boolean saveUserCloseTrafficThresholdAlert(AgileDataCalculateConfigRequest request);

    /**
     * 敏捷数据:获取当前用户指定应用的是否开通了按次计费
     *
     * @param request
     * @return
     * @author yanfeng
     */
    DigiwinAdtTenantApplicationBilling getTenantApplicationIsBilling(ApiRequest request);

    /**
     * 敏捷数据:lite版文件推送处理接口
     *
     * @param token
     * @param tenantId
     * @param fileUrl
     * @param ifCommonFlag
     * @author yanfeng
     * @Link <a href="http://athena-devops-doclever.digiwincloud.com.cn/html/web/controller/share/share.html#66d54d203c6685000bd4751c">...</a>
     */
    DigiwinAdtSubmitLiteProcessMessageResult submitLiteProcessMessage(String token, String tenantId, String fileUrl, Boolean ifCommonFlag);

    /**
     * 敏捷数据:发生娜娜消息
     *
     * @param queryDTO
     */
    void sendLiteNanaMessage(AgileDataLiteUploadFileQueryDTO queryDTO);

    /**
     * 敏捷数据:获取第三方敏数订阅数据
     *
     * @param request
     * @return
     */
    DigiwinAdtThirdPartyAgileData getThirdPartyAgileData(ApiRequest request);

    /**
     * 敏捷数据:获取数据集列表
     *
     * @param request
     * @return
     */
    DigiwinAdtDataTableListRes getTableList(AgileDataApiRequest request);

    /**
     * 敏捷数据:获取数据集预览
     *
     * @param request
     * @return
     */
    DigiwinAdtTablePreviewDataRes getTablePreviewData(AdtTablePreviewDataRequest request);

    /**
     * 根据快照Id获取解决步骤
     *
     * @param request
     * @return
     */
    Map<String, Object> getSolutionStepBySnapshotId(AgileDataApiRequest request);

    /**
     * 根据快照Id获取可转换图表列表（历史数据使用）
     *
     * @param request
     * @return
     */
    List<String> getTransList(AgileDataApiRequest request);

    /**
     * 获取敏捷数据版本
     *
     * @param request
     * @return version 版本 V1/V2; 是否为敏捷数据应用 isAgileDataApp
     */
    Map<String, Object> getAgileVersion(AgileDataApiRequest request);

    /**
     * 数据集1.0和指标-数据总结
     * (数据集2.0走流式)
     * @param request
     * @return
     */
    DigiwinAdtDataSummarize getAgileDataSummarize(AgileDataApiRequest request);

    /**
     * 重新生成分析规划
     *
     * @param queryDTO
     * @return AdtPptResultDTO
     */
    AdtPptResultDTO regenerateQuestion(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 生成PPT
     *
     * @param queryDTO
     * @return AdtGeneratePptResultDTO
     */
    AdtGeneratePptResultDTO generatePPT(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 执行解析
     *
     * @param queryDTO
     */
    void executionParsing(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * auto分析师生成分析报告
     *
     * @param queryDTO
     * @return
     */
    AgileDataAutoDataResultDTO generateAutoAnalystReport(AgileDataAutoDataQueryDTO queryDTO);

    /**
     * auto分析师下载报告
     *
     * @param queryDTO
     * @return
     */
    AgileDataAutoDataDownLoadDTO autoDataDownLoad(AgileDataAutoDataQueryDTO queryDTO);
}