package com.digiwin.mobile.mobileuibot.proxy.adt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.agileData.constant.AgileDataConstant;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.file.dto.AgileDataLiteUploadFileQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.DigiwinAdtResponse;
import com.digiwin.mobile.mobileuibot.proxy.adt.dto.*;
import com.digiwin.mobile.mobileuibot.proxy.adt.model.*;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AdtTablePreviewDataRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.AgileDataCalculateConfigRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.request.ProcessMessageRequest;
import com.digiwin.mobile.mobileuibot.proxy.adt.service.DigiwinAdtProxyService;
import com.digiwin.mobile.mobileuibot.proxy.cac.model.DigiwinCacApplicationAuthorizationInformation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author wuyang
 */
@Slf4j
@Service("digiwinAdtProxyService")
public class DigiwinAdtProxyServiceImpl implements DigiwinAdtProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public List<DigiwinAdtReportData> getReportDataList(String iamUserToken, String tenantId, String locale,
                                                        Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/report/getData/list";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAdtReportData>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAdtReportData>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAdtReportData>>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform",
                        locale, iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(params), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity.getBody().getResponse();
        }
        return Collections.emptyList();
    }

    @Override
    public DigiwinAthenaApiResponse<Boolean> sendUserFeedback(String iamUserToken, String tenantId, String locale,
                                                              Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileDataFeedback/user/feedback";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public DigiwinAthenaApiResponse<Boolean> cancelUserFeedback(String iamUserToken, String tenantId, String locale,
                                                                Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileDataFeedback/user/cancel";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public DigiwinAthenaApiResponse<Boolean> userAnswerFeedback(String iamUserToken, String tenantId, String locale,
                                                                Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileDataFeedback/user/answerBack";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public DigiwinAthenaApiResponse<List<DigiwinAdtUserFeedback>> getUserFeedback(String iamUserToken, String tenantId,
                                                                                  String locale, List<Long> generateSerialNoList) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileDataFeedback/user/getFeedback";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAdtUserFeedback>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<DigiwinAdtUserFeedback>>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<List<DigiwinAdtUserFeedback>>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(generateSerialNoList), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public DigiwinAthenaApiResponse<Boolean> saveAbnormal(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileDataAbnormal/saveAbnormal";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<Boolean>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<Boolean>> responseEntity =
                this.httpService.doPost(url,
                        new AthenaBasicHttpRequestHead("mobileplatform", locale, iamUserToken, tenantId),
                        JsonUtil.javaObjectToJsonString(params), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public String getSceneCode(String iamUserToken, String snapshotId) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/report/getAamData/" + snapshotId;
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
            JSONObject response = responseEntity.getBody().getResponse();
            return String.valueOf(response.get("sceneCode"));
        } else {
            log.error("数据订阅,getSceneCode异常:{}", snapshotId);
        }
        return null;
    }

    @Override
    public DigiwinAdtProcessMessage processMessage(ProcessMessageRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/dataPanel/processMessage";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAdtResponse<DigiwinAdtProcessMessage>> responseType =
                new ParameterizedTypeReference<DigiwinAdtResponse<DigiwinAdtProcessMessage>>() {
                };
        ResponseEntity<DigiwinAdtResponse<DigiwinAdtProcessMessage>> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(request.getIamUserToken()), JsonUtil.javaObjectToJsonString(request), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("processMessage接口调用r失败, url:{} \n request:{} \n responseEntity:{}", url, JsonUtil.javaObjectToJsonString(request), JsonUtil.javaObjectToJsonString(responseEntity));
        }
        if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public DigiwinCacApplicationAuthorizationInformation queryCalculateCacByConfig(ApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/calculate/config/queryCacByConfig";
        ResponseEntity<DigiwinAdtResponse> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale()
                , request.getIamUserToken(), request.getTenantId()), DigiwinAdtResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("敏捷数据:获取当前用户指定应用的授权信息(流量阈值，流量使用情况),queryCalculateCacByConfig异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
        }
        if (ObjectUtils.isNotEmpty(responseEntity.getBody())) {
            return JsonUtil.objectToJavaObject(responseEntity.getBody().getResponse(), DigiwinCacApplicationAuthorizationInformation.class);
        }
        return null;
    }

    @Override
    public Boolean saveUserCloseTrafficThresholdAlert(AgileDataCalculateConfigRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/calculate/config/insert";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("tenantId", request.getTenantId());
        params.put("userId", request.getUserId());
        params.put("messageId", request.getMessageId());
        params.put("calculateType", request.getCalculateType());
        params.put("type", request.getType());
        ResponseEntity<DigiwinAdtResponse> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale()
                , request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), DigiwinAdtResponse.class);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("敏捷数据:保存用户关闭流量阈值提醒设置,saveUserCloseTrafficThresholdAlert异常:{}", JsonUtil.javaObjectToJsonString(responseEntity));
            return false;
        }
        return true;
    }

    @Override
    public DigiwinAdtTenantApplicationBilling getTenantApplicationIsBilling(ApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/calculate/getIsBilling";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtTenantApplicationBilling>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtTenantApplicationBilling>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAdtTenantApplicationBilling>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", request.getLocale()
                        , request.getIamUserToken(), request.getTenantId()), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            log.error("getTenantApplicationIsBilling接口调用失败, url:{} \n request:{} \n responseEntity:{}", url, JsonUtil.javaObjectToJsonString(request), JsonUtil.javaObjectToJsonString(responseEntity));
        }
        if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public DigiwinAdtSubmitLiteProcessMessageResult submitLiteProcessMessage(String token, String tenantId, String fileUrl, Boolean ifCommonFlag) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/lite/processMessage";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("url", fileUrl);
        params.put("ifCommonFlag", ifCommonFlag);
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtSubmitLiteProcessMessageResult>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtSubmitLiteProcessMessageResult>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAdtSubmitLiteProcessMessageResult>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("", ""
                    , token, tenantId), JsonUtil.javaObjectToJsonString(params), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("adtSubmitLiteProcessMessage接口调用失败, url:{} \n fileUrl:{} \n responseEntity:{} \n token:{} \n tenantId:{}", url, fileUrl, JsonUtil.javaObjectToJsonString(responseEntity), token, tenantId);
            }
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
        } catch (Exception e) {
            log.error("adtSubmitLiteProcessMessage接口调用异常, url:{} \n fileUrl:{} \n token:{} \n tenantId:{} \n error:{}", url, fileUrl, token, tenantId, e.getMessage());
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public void sendLiteNanaMessage(AgileDataLiteUploadFileQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/lite/sendNanaMessage";
        HashMap<String, Object> map = new HashMap<>(1);
        map.put("msgBody", queryDTO);
        try {
            this.httpService.doPost(url, new AthenaBasicHttpRequestHead(queryDTO.getToken()), JsonUtil.javaObjectToJsonString(map), void.class);
        } catch (Exception e) {
            log.error("sendLiteNanaMessage接口调用失败, url:{} \n  responseEntity:{}", url, JsonUtil.javaObjectToJsonString(queryDTO));
        }
    }

    @Override
    public DigiwinAdtThirdPartyAgileData getThirdPartyAgileData(ApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/getThirdPartyAgileData/" + request.getDataId();
        try {
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtThirdPartyAgileData>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtThirdPartyAgileData>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<DigiwinAdtThirdPartyAgileData>> responseEntity =
                    this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                    return null;
                }
                return responseEntity.getBody().getResponse();
            } else {
                log.error("数据订阅失败,入参:{}", JsonUtil.javaObjectToJsonString(request));
            }
        } catch (Exception e) {
            log.error("getThirdPartyAgileData接口调用异常:{}", e.getMessage(), e);
        }
        return null;
    }

    @Override
    public DigiwinAdtDataTableListRes getTableList(AgileDataApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/v2/table/getTableList";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("appCode", request.getAppCode());
        params.put("lang", request.getLocale());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtDataTableListRes>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtDataTableListRes>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAdtDataTableListRes>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale()
                    , request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("adtTableList接口调用失败, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            }
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
        } catch (Exception e) {
            log.error("adtTableList接口调用异常, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public DigiwinAdtTablePreviewDataRes getTablePreviewData(AdtTablePreviewDataRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/v2/table/getTablePreviewData";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("appCode", request.getAppCode());
        params.put("lang", request.getLocale());
        params.put("tableId", request.getTableId());
        params.put("dataset", request.getDataset());
        params.put("productVersion", request.getProductVersion());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtTablePreviewDataRes>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtTablePreviewDataRes>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAdtTablePreviewDataRes>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale()
                    , request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("adtTablePreviewData接口调用失败, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            }
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
        } catch (Exception e) {
            log.error("adtTablePreviewData接口调用异常, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String, Object> getSolutionStepBySnapshotId(AgileDataApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agile/report/getSolutionStep/" + request.getDataId();
        try {
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                    this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                    return Collections.emptyMap();
                }
                return responseEntity.getBody().getResponse();
            } else {
                log.error("根据快照Id获取解决步骤失败,入参:{}", JsonUtil.javaObjectToJsonString(request));
            }
        } catch (Exception e) {
            log.error("getSolutionStepBySnapshotId接口调用异常:{}", e.getMessage(), e);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<String> getTransList(AgileDataApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/trans/getTransList";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("snapshotId", request.getDataId());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<String>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<String>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<String>>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale()
                    , request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getTransList接口调用失败, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            }
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return Collections.emptyList();
            }
        } catch (Exception e) {
            log.error("getTransList接口调用异常, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            return Collections.emptyList();
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public Map<String, Object> getAgileVersion(AgileDataApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/getAppVersion/" + request.getAppCode();
        try {
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<Map<String, Object>>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<Map<String, Object>>> responseEntity =
                    this.httpService.doGet(url, new AthenaBasicHttpRequestHead("", request.getLocale(), request.getIamUserToken(), request.getTenantId()), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                    return Collections.emptyMap();
                }
                return responseEntity.getBody().getResponse();
            } else {
                log.error("getAgileVersion失败,入参:{}", JsonUtil.javaObjectToJsonString(request));
            }
        } catch (Exception e) {
            log.error("getAgileVersion接口调用异常:{}", e.getMessage(), e);
        }
        return Collections.emptyMap();
    }

    @Override
    public DigiwinAdtDataSummarize getAgileDataSummarize(AgileDataApiRequest request) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/snapData/getAgileDataSummarize";
        HashMap<Object, Object> params = new HashMap<>();
        params.put("snapshotId", request.getDataId());
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtDataSummarize>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<DigiwinAdtDataSummarize>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<DigiwinAdtDataSummarize>> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead("mobileplatform", request.getLocale()
                    , request.getIamUserToken(), request.getTenantId()), JsonUtil.javaObjectToJsonString(params), responseType);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.error("getAgileDataSummarize接口调用失败, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            }
            if (null == responseEntity.getBody() || ObjectUtils.isEmpty(responseEntity.getBody().getResponse())) {
                return null;
            }
        } catch (Exception e) {
            log.error("getAgileDataSummarize接口调用异常, url:{} \n request:{}", url, JsonUtil.javaObjectToJsonString(request));
            return null;
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public AdtPptResultDTO regenerateQuestion(AgileDataEchoPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/anasisly/getAnasislyQuestion";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AdtPptResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AdtPptResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AdtPptResultDTO>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("getPPTAnalyze接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("getPPTAnalyze接口调用失败, url:{} \n request:{}, \n error:{}", url, body, e.getMessage());
        }
        return null;
    }

    @Override
    public AdtGeneratePptResultDTO generatePPT(AgileDataEchoPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/anasisly/generateAgileDataFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AdtGeneratePptResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AdtGeneratePptResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AdtGeneratePptResultDTO>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("generatePPT接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("generatePPT接口调用失败, url:{} \n request:{}, \n error:{}", url, body, e.getMessage());
        }
        return null;
    }

    @Override
    public void executionParsing(AgileDataEchoPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/v2/chat/ppt";
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            ResponseEntity<Void> response = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, void.class);
            log.info("executionParsing接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{} ",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(response));
        } catch (Exception e) {
            log.error("executionParsing接口调用失败, url:{} \n request:{}, \n error:{}", url, body, e.getMessage());
        }
    }

    @Override
    public AgileDataAutoDataResultDTO generateAutoAnalystReport(AgileDataAutoDataQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/autoData/generateReport";
        HashMap<String, Object> map = new HashMap<>();
        map.put("messageId", queryDTO.getMessageId());

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataAutoDataResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataAutoDataResultDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AgileDataAutoDataResultDTO>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(map);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("generateAutoAnalystReport接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("generateAutoAnalystReport接口调用失败, url:{} \n request:{}, \n error:{}", url, body, e.getMessage());
        }
        return null;
    }

    @Override
    public AgileDataAutoDataDownLoadDTO autoDataDownLoad(AgileDataAutoDataQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAdtUrl() + DigiwinAdtProxyService.API_PREFIX
                + "/agileData/autoData/getDownLoadUrl";
        HashMap<String, Object> map = new HashMap<>();
        map.put("messageId", queryDTO.getMessageId());
        map.put("downLoadType", queryDTO.getDownLoadType());

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataAutoDataDownLoadDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<AgileDataAutoDataDownLoadDTO>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<AgileDataAutoDataDownLoadDTO>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(map);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getIamUserToken(), queryDTO.getTenantId()), body, responseType);
            log.info("autoDataDownLoad接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    ObjectUtils.isEmpty(responseEntity.getBody()) ? TraceIdUtil.get() : responseEntity.getBody().getTraceId());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody().getResponse();
            }
        } catch (Exception e) {
            log.error("autoDataDownLoad接口调用失败, url:{} \n request:{}, \n error:{}", url, body, e.getMessage());
        }
        return null;
    }

}