package com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * 查询敏捷数据问题排查提效数据列表 Result DTO
 *
 * @author yanfeng
 * @date 2024/11/14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class EchoMetricCheckMongoDataResultDTO {

    private Long messageId;

    private String createTime;

    private List<Tabs> tabs;


    @Data
    public static class Tabs {
        private String tabTile;

        private int tabId;

        private boolean hasTreeList;

        private List<AreaInfo> areas;

        private List<Map<String, Object>> selectList;

        @Data
        public static class AreaInfo {
            private int type;

            private String title;

            private String display;

            private boolean isCollapse;

            private List<ValueInfo> values;

            private Map<String, Object> selectValue;

            @Data
            public static class ValueInfo {

                private String value;

                private String valueType;

                private boolean isCopy;

            }
        }
    }

}