package com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt;

import com.digiwin.mobile.mobileuibot.api.AgileDataApiRequest;
import lombok.Data;

import java.util.List;

@Data
public class EchoAgileDataFileDTO extends AgileDataApiRequest {

    /**
     * 消息ID
     */
    private Long messageId;

    /**
     * 消息状态
     */
    private Integer messageStatus;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 问句主题
     */
    private String messageTopic;

    /**
     * 生成ppt信息
     */
    private List<PptInfo> pptInfo;

    /**
     * 规划问句集合
     */
    private List<EchoAgileDataFileQuestionDTO> questionInfo;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 创建日期
     */
    private String createTime;

    /**
     * 创建日期
     */
    private String updateTime;

    @Data
    private static class PptInfo {
        /**
         * pptId
         */
        private Long pptId;

        /**
         * 生成状态
         * 0.成功 1.失败 2.生成中
         */
        private String generateStatus;

        /**
         * pptUrl
         */
        private String pptUrl;

        private String pptDocId;

        private String pptName;

        private String createDate;

        private String expireDate;

        private String pptPageSize;
    }

}