package com.digiwin.mobile.mobileuibot.proxy.agiledataecho.service;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataEchoPptQueryDTO;
import com.digiwin.mobile.mobileuibot.proxy.agiledataecho.model.ppt.EchoAgileDataFileDTO;

/**
 * <p>功能描述：敏捷问数Echo服务调用类：ppt生成需求专用</p>
 *
 * @author wuyang
 */
public interface DigiwinAgileDataEchoProxyPptService {

    String API_PREFIX = "/api/ai/v1/file/";

    /**
     * PPT分析规划问句查询
     *
     * @param queryDTO
     * @return
     */
    EchoAgileDataFileDTO getAgileDataFile(AgileDataEchoPptQueryDTO queryDTO);

    /**
     * 保存分析规划信息
     * @param queryDTO
     * @return
     */
    Boolean saveAgileDataFile(EchoAgileDataFileDTO queryDTO);

    /**
     * 更新分析规划信息
     * @param queryDTO
     * @return
     */
    Boolean updateAgileDataFile(EchoAgileDataFileDTO queryDTO);

    /**
     * 删除分析规划信息
     * @param queryDTO
     * @return
     */
    Boolean deleteAgileDataFile(AgileDataEchoPptQueryDTO queryDTO);
}